/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.base.evalfile;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMCacheUtil;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AffairActionOperateEnum;
import com.kingdee.eas.hr.base.EmpLaborRelationCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptEmpLaborRelationUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.bizmanage.DealState;
import com.kingdee.shr.base.bizmanage.HRBizDefineTypeEnum;
import com.kingdee.shr.base.bizmanage.IPersonBURelaConfirm;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmCollection;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmFactory;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmInfo;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import com.kingdee.shr.perfweb.app.base.bizmanage.PerfwebBizManageMsgManageBaseImpl;
import com.kingdee.shr.perfweb.app.base.evalfile.AbstractPerfFileControllerBean;
import com.kingdee.shr.perfweb.app.base.evalfile.IPerfFile;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileAssignTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileCollection;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileFactory;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileInfo;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileStateEnum;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.bizmanage.utils.GetBizManageEntityUtils;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PerfPersonBURelaConfirmUtils;
import com.kingdee.shr.perfweb.utils.PerfDateUtils;
import com.kingdee.shr.perfweb.utils.PerfWorkFlowUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PerfFileControllerBean
extends AbstractPerfFileControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.base.evalfile.PerfFileControllerBean");
    private static final String LEFFDT = "2199-12-31";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PerfFileInfo perfFileInfo = (PerfFileInfo)model;
        IPerfFile iPerfFile = PerfFileFactory.getLocalInstance(ctx);
        String person = this.dealPersonId(perfFileInfo);
        String position = this.dealPositionId(perfFileInfo);
        String hrOrgUnit = this.dealHrOrgUnitId(perfFileInfo);
        String adminOrgUnit = this.dealAdminOrgUnitId(perfFileInfo);
        if (null != person && null != position && null != hrOrgUnit && adminOrgUnit != null && perfFileInfo.getEmpPosOrgRelation() != null) {
            this.setPerfFileDefaultValueWhenNull(ctx, perfFileInfo);
            if (!iPerfFile.existsForCreate(perfFileInfo)) {
                if (1 == perfFileInfo.getAssignType().getValue()) {
                    if (!this.isSupplementBillPerfFile(ctx, perfFileInfo)) {
                        EmpPosOrgRelationInfo relationInfo = this.getEmpPosOrgRelationInfoByPerfFile(ctx, perfFileInfo);
                        if (relationInfo != null && relationInfo.getLEFFDT().getTime() > System.currentTimeMillis()) {
                            this.disablePerfFileForSamePersonAndAsignType(ctx, perfFileInfo);
                        } else {
                            perfFileInfo.setState(PerfFileStateEnum.DISABLE);
                        }
                    } else {
                        this.dealSupplementBillPerfFile(ctx, perfFileInfo);
                    }
                }
                this.updatePartTimePositionEmployeeType(ctx, perfFileInfo);
                return super._addnew(ctx, (IObjectValue)perfFileInfo);
            }
            return null;
        }
        logger.error("\u3010PERFWEB\u3011-create perffile error,person or position or hrOrgUnit or adminOrgUnit or empPosOrg is null");
        return null;
    }

    private EmpPosOrgRelationInfo getEmpPosOrgRelationInfoByPerfFile(Context ctx, PerfFileInfo perfFileInfo) throws BOSException {
        String empPosOrgId = perfFileInfo.getEmpPosOrgRelation().getId().toString();
        EmpPosOrgRelationCollection empPosOrgs = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection("where id = '" + empPosOrgId + "'");
        if (empPosOrgs != null && !empPosOrgId.isEmpty()) {
            EmpPosOrgRelationInfo relationInfo = empPosOrgs.get(0);
            return relationInfo;
        }
        return null;
    }

    private void setPerfFileDefaultValueWhenNull(Context ctx, PerfFileInfo perfFileInfo) {
        if (perfFileInfo.getEmployeeType() == null) {
            String person = null;
            if (perfFileInfo.getPerson() != null) {
                person = perfFileInfo.getPerson().getId().toString();
            } else if (null != perfFileInfo.get("person")) {
                person = perfFileInfo.get("person").toString();
            }
            if (!StringUtils.isEmpty((String)person)) {
                PersonInfo personInfo = GetBizManageEntityUtils.getPersonInfoBySic(ctx, person);
                perfFileInfo.put("employeeType", personInfo.getEmployeeType().getId().toString());
            }
        }
        if (perfFileInfo.getLEFFTime() == null) {
            Timestamp leftTime = new Timestamp(PerfDateUtils.strToDate(LEFFDT).getTime());
            perfFileInfo.setLEFFTime(leftTime);
        }
        if (perfFileInfo.getState() == null) {
            perfFileInfo.setState(PerfFileStateEnum.ENABLE);
        }
    }

    private boolean isSupplementBillPerfFile(Context ctx, PerfFileInfo perfFileInfo) throws BOSException, EASBizException {
        boolean isSupplementBill = false;
        if (!StringUtils.isEmpty((String)perfFileInfo.getComfirmMsgId())) {
            isSupplementBill = PersonBURelaConfirmFactory.getLocalInstance((Context)ctx).exists("where id ='" + perfFileInfo.getComfirmMsgId() + "' and isSupplementBill = 1");
        }
        return isSupplementBill;
    }

    protected void dealSupplementBillPerfFile(Context ctx, PerfFileInfo perfFileInfo) throws BOSException, EASBizException {
        perfFileInfo.setState(PerfFileStateEnum.DISABLE);
        String empPosOrgId = perfFileInfo.getEmpPosOrgRelation().getId().toString();
        EmpPosOrgRelationInfo empPosOrgRelationInfo = this.getEmpPosOrgRelationInfoByPerfFile(ctx, perfFileInfo);
        if (empPosOrgRelationInfo != null && !empPosOrgId.isEmpty()) {
            this.updateEmployeeTypeAfterSupplementBill(ctx, perfFileInfo, empPosOrgRelationInfo);
            EmpPosOrgRelationCollection nextEmpPosOrgs = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection("where parent.id = '" + empPosOrgId + "'");
            if (nextEmpPosOrgs != null && !nextEmpPosOrgs.isEmpty()) {
                EmpPosOrgRelationInfo nextEmpPosInfo = nextEmpPosOrgs.get(0);
                this.updateAOBOPositionAfterSupplementBill(ctx, perfFileInfo, nextEmpPosInfo);
            }
        }
    }

    private String dealPersonId(PerfFileInfo perfFileInfo) {
        String person = null;
        if (perfFileInfo.getPerson() != null) {
            person = perfFileInfo.getPerson().getId().toString();
        } else if (null != perfFileInfo.get("person")) {
            person = perfFileInfo.get("person").toString();
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)person));
            perfFileInfo.setPerson(personInfo);
        }
        return person;
    }

    private String dealPositionId(PerfFileInfo perfFileInfo) {
        String position = null;
        if (perfFileInfo.getPosition() != null) {
            position = perfFileInfo.getPosition().getId().toString();
        } else if (null != perfFileInfo.get("position")) {
            position = perfFileInfo.get("position").toString();
            PositionInfo positionInfo = new PositionInfo();
            positionInfo.setId(BOSUuid.read((String)position));
            perfFileInfo.setPosition(positionInfo);
        }
        return position;
    }

    private String dealHrOrgUnitId(PerfFileInfo perfFileInfo) {
        String hrOrgUnit = null;
        if (perfFileInfo.getHrOrgUnit() != null) {
            hrOrgUnit = perfFileInfo.getHrOrgUnit().getId().toString();
        } else if (null != perfFileInfo.get("hrOrgUnit")) {
            hrOrgUnit = perfFileInfo.get("hrOrgUnit").toString();
            HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
            hrOrgUnitInfo.setId(BOSUuid.read((String)hrOrgUnit));
            perfFileInfo.setHrOrgUnit(hrOrgUnitInfo);
        }
        return hrOrgUnit;
    }

    private String dealAdminOrgUnitId(PerfFileInfo perfFileInfo) {
        String adminOrgUnit = null;
        if (perfFileInfo.getAdminOrgUnit() != null) {
            adminOrgUnit = perfFileInfo.getAdminOrgUnit().getId().toString();
        } else if (null != perfFileInfo.get("adminOrgUnit")) {
            adminOrgUnit = perfFileInfo.get("adminOrgUnit").toString();
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)adminOrgUnit));
            perfFileInfo.setAdminOrgUnit(adminOrgUnitInfo);
        }
        return adminOrgUnit;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updatePartTimePositionEmployeeType(ctx, (PerfFileInfo)model);
        super._update(ctx, pk, model);
    }

    private void updateAOBOPositionAfterSupplementBill(Context ctx, PerfFileInfo perfFileInfo, EmpPosOrgRelationInfo empPosOrgRelationInfo) throws BOSException, EASBizException {
        if (perfFileInfo == null) {
            return;
        }
        String person = perfFileInfo.getPerson().getId().toString();
        String empPosOrgId = empPosOrgRelationInfo.getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)person));
        filter.getFilterItems().add(new FilterItemInfo("empPosOrgRelation.id", (Object)empPosOrgId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        PerfFileCollection partFiles = this.getPerfFileCollection(ctx, evi);
        if (partFiles != null && !partFiles.isEmpty()) {
            CoreBaseCollection colls = new CoreBaseCollection();
            Iterator it = partFiles.iterator();
            while (it.hasNext()) {
                PerfFileInfo parfFileInfo = (PerfFileInfo)it.next();
                parfFileInfo.setHrOrgUnit(perfFileInfo.getHrOrgUnit());
                parfFileInfo.setAdminOrgUnit(perfFileInfo.getAdminOrgUnit());
                parfFileInfo.setPosition(perfFileInfo.getPosition());
                colls.add((CoreBaseInfo)parfFileInfo);
            }
            this.update(ctx, colls);
        }
    }

    private void updateEmployeeTypeAfterSupplementBill(Context ctx, PerfFileInfo perfFileInfo, EmpPosOrgRelationInfo empPosOrgRelationInfo) throws BOSException, EASBizException {
        if (perfFileInfo == null) {
            return;
        }
        String person = perfFileInfo.getPerson().getId().toString();
        EmpLaborRelationInfo info = SHREmpOptEmpLaborRelationUtil.getPersonCurrentEmpLaborRelationInfo((Context)ctx, (String)person);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)person, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("empPosOrgRelation.EFFDT", (Object)empPosOrgRelationInfo.getEFFDT(), CompareType.GREATER_EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        PerfFileCollection partFiles = this.getPerfFileCollection(ctx, evi);
        if (partFiles != null && !partFiles.isEmpty()) {
            CoreBaseCollection colls = new CoreBaseCollection();
            Iterator it = partFiles.iterator();
            while (it.hasNext()) {
                PerfFileInfo parfFileInfo = (PerfFileInfo)it.next();
                parfFileInfo.setEmployeeType(info.getLaborRelationState());
                colls.add((CoreBaseInfo)parfFileInfo);
            }
            this.update(ctx, colls);
        }
    }

    private void updatePartTimePositionEmployeeType(Context ctx, PerfFileInfo perfFileInfo) throws BOSException, EASBizException {
        if (perfFileInfo == null) {
            return;
        }
        int assignType = (Integer)perfFileInfo.get("assignType");
        if (0 == assignType) {
            return;
        }
        String person = perfFileInfo.getPerson().getId().toString();
        EmpLaborRelationInfo info = SHREmpOptEmpLaborRelationUtil.getPersonCurrentEmpLaborRelationInfo((Context)ctx, (String)person);
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)person, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EFFTIME", (Object)curDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("LEFFTIME", (Object)curDate, CompareType.GREATER_EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        PerfFileCollection partFiles = this.getPerfFileCollection(ctx, evi);
        if (partFiles != null && !partFiles.isEmpty()) {
            CoreBaseCollection colls = new CoreBaseCollection();
            Iterator it = partFiles.iterator();
            while (it.hasNext()) {
                PerfFileInfo parfFileInfo = (PerfFileInfo)it.next();
                parfFileInfo.setEmployeeType(info.getLaborRelationState());
                colls.add((CoreBaseInfo)parfFileInfo);
            }
            this.update(ctx, colls);
        }
    }

    private void disablePerfFileByCurrent(Context ctx, PerfFileInfo perfFileInfo) throws BOSException, EASBizException {
        String person = (String)perfFileInfo.get("person");
        if (person == null) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PERSONINFOREQUIRED);
        }
        String position = (String)perfFileInfo.get("position");
        if (StringUtils.isEmpty((String)position)) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.POSITIONREQUIRED);
        }
        String hrOrgUnit = (String)perfFileInfo.get("hrOrgUnit");
        if (StringUtils.isEmpty((String)hrOrgUnit)) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.HRORGREQUIRED);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)person, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)hrOrgUnit, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        if (PerfFileAssignTypeEnum.MAIN.equals((Object)perfFileInfo.getAssignType())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("assignType", (Object)1, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("position", (Object)position, CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        IPerfFile iPerfFile = PerfFileFactory.getLocalInstance(ctx);
        PerfFileCollection perfFileCollection = iPerfFile.getPerfFileCollection(evi);
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        for (int i = 0; i < perfFileCollection.size(); ++i) {
            PerfFileInfo perfFile = perfFileCollection.get(i);
            perfFile.setState(PerfFileStateEnum.DISABLE);
            perfFile.setLEFFTime(new Timestamp(System.currentTimeMillis()));
            coreBaseCollection.add((CoreBaseInfo)perfFile);
        }
        iPerfFile.save(coreBaseCollection);
    }

    private void disablePerfFileForSamePersonAndAsignType(Context ctx, PerfFileInfo perfFileInfo) throws BOSException, EASBizException {
        String person = null;
        String hrOrgUnit = null;
        String positionId = null;
        if (perfFileInfo.getPerson() != null) {
            person = perfFileInfo.getPerson().getId().toString();
        } else if (null != perfFileInfo.get("person")) {
            person = perfFileInfo.get("person").toString();
        }
        if (perfFileInfo.getHrOrgUnit() != null) {
            hrOrgUnit = perfFileInfo.getHrOrgUnit().getId().toString();
        } else if (null != perfFileInfo.get("hrOrgUnit")) {
            hrOrgUnit = perfFileInfo.get("hrOrgUnit").toString();
        }
        if (perfFileInfo.getPosition() != null) {
            positionId = perfFileInfo.getPosition().getId().toString();
        } else if (null != perfFileInfo.get("position")) {
            positionId = perfFileInfo.get("position").toString();
        }
        if (person == null) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PERSONINFOREQUIRED);
        }
        PerfFileCollection perfFileCollection = this.getMainPerfFilesExcludeCurrent(ctx, perfFileInfo);
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        if (perfFileCollection != null && !perfFileCollection.isEmpty()) {
            for (int i = 0; i < perfFileCollection.size(); ++i) {
                PerfFileInfo perfFile = perfFileCollection.get(i);
                AdminOrgUnitInfo adminOrgUnitInfo = perfFile.getAdminOrgUnit();
                PositionInfo positionInfo = perfFile.getPosition();
                if (adminOrgUnitInfo == null || adminOrgUnitInfo.getId() == null || positionInfo == null || positionInfo.getId() == null || positionInfo.getAdminOrgUnit() == null || positionInfo.getAdminOrgUnit().getId() == null || !adminOrgUnitInfo.getId().toString().equals(positionInfo.getAdminOrgUnit().getId().toString())) continue;
                perfFile.setState(PerfFileStateEnum.DISABLE);
                perfFile.setLEFFTime(new Timestamp(System.currentTimeMillis()));
                coreBaseCollection.add((CoreBaseInfo)perfFile);
            }
            this.save(ctx, coreBaseCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK[] _addnewBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        Connection cn = null;
        try {
            IObjectPK[] objectPKArray;
            cn = this.getConnection(ctx);
            IORMappingDAO dao = this.getDAO(ctx, cn);
            Iterator objectIter = colls.iterator();
            HashSet<String> persons = new HashSet<String>();
            while (objectIter.hasNext()) {
                IObjectValue value = (IObjectValue)objectIter.next();
                dao.addNewBatch(value);
                PerfFileInfo perfFileInfo = (PerfFileInfo)value;
                if (perfFileInfo.get("person") == null) {
                    throw new SHRPerfWebBizException(SHRPerfWebBizException.PERSONINFOREQUIRED);
                }
                persons.add((String)perfFileInfo.get("person"));
                this.disablePerfFileByCurrent(ctx, perfFileInfo);
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person", persons, CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PersonCollection personCollection = iPerson.getPersonCollection(evi);
            HashMap<String, EmployeeTypeInfo> employTypeMap = new HashMap<String, EmployeeTypeInfo>();
            if (personCollection != null && personCollection.size() > 0) {
                for (int i = 0; i > personCollection.size(); ++i) {
                    PersonInfo personInfo = personCollection.get(i);
                    employTypeMap.put(personInfo.getId().toString(), personInfo.getEmployeeType());
                }
            }
            while (objectIter.hasNext()) {
                IObjectValue value = (IObjectValue)objectIter.next();
                PerfFileInfo perfFileInfo = (PerfFileInfo)value;
                perfFileInfo.setEmployeeType((EmployeeTypeInfo)employTypeMap.get(perfFileInfo.get("person")));
                dao.addNewBatch((IObjectValue)perfFileInfo);
            }
            IObjectPK[] iObjectPKArray = objectPKArray = dao.executeBatchWithReturn();
            return iObjectPKArray;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
            if (this.needCache(ctx)) {
                ORMCacheUtil.getInstance().removeInfosByBosType(ctx, this.getBOSType());
            }
        }
    }

    @Override
    protected void _enable(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PerfFileInfo perfFileInfo = (PerfFileInfo)model;
        if (PerfFileStateEnum.ENABLE.equals((Object)perfFileInfo.getState())) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PERFFILEENABLED);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)perfFileInfo.getPerson().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)perfFileInfo.getHrOrgUnit().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)PerfFileStateEnum.ENABLE, CompareType.EQUALS));
        if (PerfFileAssignTypeEnum.MAIN.equals((Object)perfFileInfo.getAssignType())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("assignType", (Object)1, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("position", (Object)perfFileInfo.getPosition().getId().toString(), CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        PerfFileCollection coll = this.getPerfFileCollection(ctx, evi);
        if (coll != null && coll.size() > 0) {
            if (PerfFileAssignTypeEnum.MAIN.equals((Object)perfFileInfo.getAssignType())) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.MAINPOSPERFFILEEXISTENABLEERR);
            }
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PERFFILEEXISTENABLEERR);
        }
        this.doState(ctx, perfFileInfo, PerfFileStateEnum.ENABLE);
    }

    @Override
    protected void _disable(Context ctx, String billId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        PerfFileInfo model = this.getPerfFileInfo(ctx, (IObjectPK)pk);
        this.doState(ctx, model, PerfFileStateEnum.DISABLE);
        model.setState(PerfFileStateEnum.DISABLE);
    }

    @Override
    @Deprecated
    protected void _disable(Context ctx, String personId, String hrOrgUnitId, String positionId, int assignType) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)personId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)hrOrgUnitId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("position", (Object)positionId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("assignType", (Object)assignType, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("adminOrgUnit.id"));
        selectors.add(new SelectorItemInfo("position.id"));
        selectors.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        evi.setSelector(selectors);
        PerfFileCollection coll = this.getPerfFileCollection(ctx, evi);
        if (coll != null && coll.size() > 0) {
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            Timestamp now = new Timestamp(System.currentTimeMillis());
            for (int i = 0; i < coll.size(); ++i) {
                PerfFileInfo info = coll.get(i);
                AdminOrgUnitInfo adminOrgUnitInfo = info.getAdminOrgUnit();
                PositionInfo positionInfo = info.getPosition();
                if (adminOrgUnitInfo == null || adminOrgUnitInfo.getId() == null || positionInfo == null || positionInfo.getId() == null || positionInfo.getAdminOrgUnit() == null || positionInfo.getAdminOrgUnit().getId() == null || !adminOrgUnitInfo.getId().toString().equals(positionInfo.getAdminOrgUnit().getId().toString())) continue;
                info.setState(PerfFileStateEnum.DISABLE);
                info.setLEFFTime(now);
                coreBaseCollection.add((CoreBaseInfo)info);
            }
            this.updateBatchData(ctx, coreBaseCollection);
        }
    }

    @Override
    public void disableAllPerfFileByPersonId(Context ctx, String personId) {
        try {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)personId, CompareType.EQUALS));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            PerfFileCollection coll = this.getPerfFileCollection(ctx, evi);
            EmpLaborRelationCollection empLaborRelationColls = EmpLaborRelationFactory.getLocalInstance((Context)ctx).getEmpLaborRelationCollection("select laborRelationState.id where person.id='" + personId + "' order by LEFFDT desc");
            EmployeeTypeInfo employeeTypeInfo = null;
            if (empLaborRelationColls != null && !empLaborRelationColls.isEmpty()) {
                employeeTypeInfo = empLaborRelationColls.get(0).getLaborRelationState();
            }
            if (coll != null && coll.size() > 0) {
                CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                Timestamp now = new Timestamp(System.currentTimeMillis());
                PerfFileInfo mainPosPerfFileInfo = null;
                for (int i = 0; i < coll.size(); ++i) {
                    PerfFileInfo info = coll.get(i);
                    info.setState(PerfFileStateEnum.DISABLE);
                    info.setLEFFTime(now);
                    if (employeeTypeInfo != null) {
                        info.setEmployeeType(employeeTypeInfo);
                    }
                    coreBaseCollection.add((CoreBaseInfo)info);
                    if (!PerfFileAssignTypeEnum.MAIN.equals((Object)info.getAssignType()) || mainPosPerfFileInfo != null) continue;
                    mainPosPerfFileInfo = info;
                }
                this.updateBatchData(ctx, coreBaseCollection);
                this.updatePartTimePositionEmployeeType(ctx, mainPosPerfFileInfo);
            }
        }
        catch (BOSException e) {
            logger.error("disable files err", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("disable files err", (Throwable)e);
        }
    }

    private void doState(Context ctx, PerfFileInfo model, PerfFileStateEnum state) throws BOSException, EASBizException {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Timestamp leftTime = new Timestamp(PerfDateUtils.strToDate(LEFFDT).getTime());
        if (null == model) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PERFFILENOTEXIST);
        }
        if (PerfFileStateEnum.DISABLE.equals((Object)state) && PerfFileStateEnum.DISABLE.equals((Object)model.getState())) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PERFFILEDISABLED);
        }
        if (PerfFileStateEnum.ENABLE.equals((Object)state) && PerfFileStateEnum.ENABLE.equals((Object)model.getState())) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PERFFILEENABLED);
        }
        if (PerfFileStateEnum.ENABLE.equals((Object)state)) {
            model.setEFFTime(now);
            model.setLEFFTime(leftTime);
        } else {
            model.setLEFFTime(now);
        }
        model.setState(state);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(model.getId().toString()), model);
    }

    @Override
    protected String _disableByConfirm(Context ctx, IObjectValue confirmInfo) throws BOSException, EASBizException {
        String disableFileId = null;
        PersonBURelaConfirmInfo confirm = (PersonBURelaConfirmInfo)confirmInfo;
        PerfFileCollection perfFileCollection = PerfFileFactory.getLocalInstance(ctx).getCollByTRMTConfirm(confirm);
        if (perfFileCollection != null && perfFileCollection.size() > 0) {
            PerfFileInfo perfFileInfo = perfFileCollection.get(0);
            if (!confirm.getId().toString().equals(perfFileInfo.getComfirmMsgId())) {
                disableFileId = perfFileInfo.getId().toString();
                PerfPersonBURelaConfirmUtils.diablePerfFileByConfirmInfo(ctx, perfFileInfo, confirm);
            }
        }
        return disableFileId;
    }

    @Override
    protected IObjectCollection _getCollByTRMTConfirm(Context ctx, IObjectValue confirmInfo) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("adminOrgUnit.id"));
        selectors.add(new SelectorItemInfo("position.id"));
        selectors.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        evi.setSelector(selectors);
        FilterInfo filterInfo = new FilterInfo();
        PersonBURelaConfirmInfo confirm = (PersonBURelaConfirmInfo)confirmInfo;
        EmpPosOrgRelationInfo posOrgRelationInfo = null;
        if (confirm.getOldEmpOrgRelation() != null) {
            posOrgRelationInfo = confirm.getOldEmpOrgRelation();
        } else if (AffairActionOperateEnum.partTimeTerminate.equals((Object)confirm.getAffairActionOperate()) || AffairActionOperateEnum.partTimeSuspendTerminae.equals((Object)confirm.getAffairActionOperate()) || HRBizDefineTypeEnum.ENROLLADJUST.equals((Object)confirm.getBizDefineType())) {
            posOrgRelationInfo = confirm.getNewEmpOrgRelation();
        }
        if (posOrgRelationInfo == null || confirm.getDefaultHrOrgUnit() == null) {
            return null;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("empPosOrgRelation", (Object)posOrgRelationInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        this.setTRMTConfirmFilter(ctx, confirm, filterInfo);
        evi.setFilter(filterInfo);
        return this.getPerfFileCollection(ctx, evi);
    }

    @Override
    protected IObjectCollection _getMainPerfFilesExcludeCurrent(Context ctx, IObjectValue perfFile) throws BOSException, EASBizException {
        PerfFileInfo perfFileInfo = (PerfFileInfo)perfFile;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)perfFileInfo.getPerson().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)perfFileInfo.getHrOrgUnit().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("assignType", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("empPosOrgRelation.id", (Object)perfFileInfo.getEmpPosOrgRelation().getId().toString(), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        this.setMainPerfFilesExcludeCurrentFilter(ctx, perfFileInfo, filterInfo);
        evi.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("adminOrgUnit.id"));
        selectors.add(new SelectorItemInfo("position.id"));
        selectors.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        evi.setSelector(selectors);
        return this.getPerfFileCollection(ctx, evi);
    }

    private FilterInfo createDefaultExistsFilter(Context ctx, PerfFileInfo perfFileInfo) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)perfFileInfo.getPerson().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("position.id", (Object)perfFileInfo.getPosition().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)perfFileInfo.getHrOrgUnit().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("assignType", (Object)perfFileInfo.getAssignType()));
        filterInfo.getFilterItems().add(new FilterItemInfo("empPosOrgRelation.id", (Object)perfFileInfo.getEmpPosOrgRelation().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)perfFileInfo.getAdminOrgUnit().getId().toString()));
        return filterInfo;
    }

    @Override
    protected boolean _existsForCreate(Context ctx, IObjectValue perFile) throws BOSException, EASBizException {
        PerfFileInfo perfFileInfo = (PerfFileInfo)perFile;
        FilterInfo filterInfo = this.createDefaultExistsFilter(ctx, perfFileInfo);
        this.setExistsForCreateFilter(ctx, perfFileInfo, filterInfo);
        return this.exists(ctx, filterInfo);
    }

    @Override
    protected Map _enableLastPerfFile(Context ctx, Set perfFileIds, Set hrRangeSet) throws BOSException, EASBizException {
        HashMap<String, Serializable> returnMap = new HashMap<String, Serializable>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        filterInfo.getFilterItems().add(new FilterItemInfo("empPosOrgRelation.LEFFDT", (Object)now, CompareType.LESS));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)hrRangeSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        if (!CollectionUtils.isEmpty((Collection)perfFileIds)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)perfFileIds, CompareType.INCLUDE));
        }
        evi.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("person.name");
        sic.add("person.number");
        sic.add("position.name");
        evi.setSelector(sic);
        SelectorItemCollection updateSic = new SelectorItemCollection();
        updateSic.add("state");
        updateSic.add("lastUpdateTime");
        updateSic.add("lastUpdateUser");
        UserInfo currentUser = GetEntityInfoUtils.getUserInfo(ctx);
        int pageSize = 2000;
        int disableCount = 0;
        ArrayList<String> disableList = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)perfFileIds)) {
            int totalCount = this.getCount(ctx, evi);
            SorterItemCollection sortColl = new SorterItemCollection();
            SorterItemInfo sortInfo = new SorterItemInfo();
            sortInfo.setSortType(SortType.ASCEND);
            sortInfo.setPropertyName("id");
            sortColl.add(sortInfo);
            evi.setSorter(sortColl);
            int totalPage = totalCount / pageSize + 1;
            for (int i = 0; i < totalPage; ++i) {
                List pageList = this.getPagingList(ctx, evi, i * pageSize, Math.min((i + 1) * pageSize, totalCount));
                CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                for (int k = 0; k < pageList.size(); ++k) {
                    PerfFileInfo perfFileInfo = (PerfFileInfo)pageList.get(k);
                    perfFileInfo.setState(PerfFileStateEnum.DISABLE);
                    perfFileInfo.setLastUpdateUser(currentUser);
                    perfFileInfo.setLastUpdateTime(now);
                    coreBaseCollection.add((CoreBaseInfo)perfFileInfo);
                    ++disableCount;
                    disableList.add(perfFileInfo.getPerson().getName() + "##" + perfFileInfo.getPerson().getNumber() + "##" + perfFileInfo.getPosition().getName());
                }
                this.updatePartialBatchData(ctx, (IObjectCollection)coreBaseCollection, updateSic);
            }
        } else {
            PerfFileCollection disPerfFileCollection = this.getPerfFileCollection(ctx, evi);
            if (disPerfFileCollection != null && disPerfFileCollection.size() > 0) {
                CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                for (int i = 0; i < disPerfFileCollection.size(); ++i) {
                    PerfFileInfo perfFileInfo = disPerfFileCollection.get(i);
                    perfFileInfo.setState(PerfFileStateEnum.DISABLE);
                    perfFileInfo.setLastUpdateUser(currentUser);
                    perfFileInfo.setLastUpdateTime(now);
                    coreBaseCollection.add((CoreBaseInfo)perfFileInfo);
                    ++disableCount;
                    disableList.add(perfFileInfo.getPerson().getName() + "##" + perfFileInfo.getPerson().getNumber() + "##" + perfFileInfo.getPosition().getName());
                }
                this.updatePartialBatchData(ctx, (IObjectCollection)coreBaseCollection, updateSic);
            }
        }
        returnMap.put("disableCount", Integer.valueOf(disableCount));
        returnMap.put("disableList", disableList);
        EntityViewInfo evi1 = new EntityViewInfo();
        FilterInfo filterInfo1 = new FilterInfo();
        Timestamp now1 = new Timestamp(System.currentTimeMillis());
        filterInfo1.getFilterItems().add(new FilterItemInfo("empPosOrgRelation.EFFDT", (Object)now1, CompareType.LESS));
        filterInfo1.getFilterItems().add(new FilterItemInfo("empPosOrgRelation.LEFFDT", (Object)now1, CompareType.GREATER));
        filterInfo1.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)hrRangeSet, CompareType.INCLUDE));
        HashSet<Integer> stateSet = new HashSet<Integer>();
        stateSet.add(0);
        stateSet.add(2);
        filterInfo1.getFilterItems().add(new FilterItemInfo("state", stateSet, CompareType.INCLUDE));
        if (!CollectionUtils.isEmpty((Collection)perfFileIds)) {
            filterInfo1.getFilterItems().add(new FilterItemInfo("id", (Object)perfFileIds, CompareType.INCLUDE));
        }
        evi1.setFilter(filterInfo1);
        evi1.setSelector(sic);
        int enableCount = 0;
        ArrayList<String> enableList = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)perfFileIds)) {
            int totalCount = this.getCount(ctx, evi1);
            SorterItemCollection sortColl = new SorterItemCollection();
            SorterItemInfo sortInfo = new SorterItemInfo();
            sortInfo.setSortType(SortType.ASCEND);
            sortInfo.setPropertyName("id");
            sortColl.add(sortInfo);
            evi1.setSorter(sortColl);
            int totalPage = totalCount / pageSize + 1;
            for (int i = 0; i < totalPage; ++i) {
                List pageList = this.getPagingList(ctx, evi1, i * pageSize, Math.min((i + 1) * pageSize, totalCount));
                CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                for (int k = 0; k < pageList.size(); ++k) {
                    PerfFileInfo perfFileInfo = (PerfFileInfo)pageList.get(k);
                    perfFileInfo.setState(PerfFileStateEnum.ENABLE);
                    perfFileInfo.setLastUpdateUser(currentUser);
                    perfFileInfo.setLastUpdateTime(now);
                    coreBaseCollection.add((CoreBaseInfo)perfFileInfo);
                    ++enableCount;
                    enableList.add(perfFileInfo.getPerson().getName() + "##" + perfFileInfo.getPerson().getNumber() + "##" + perfFileInfo.getPosition().getName());
                }
                this.updatePartialBatchData(ctx, (IObjectCollection)coreBaseCollection, updateSic);
            }
        } else {
            PerfFileCollection enPerfFileCollection = this.getPerfFileCollection(ctx, evi1);
            if (enPerfFileCollection != null && enPerfFileCollection.size() > 0) {
                CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                for (int i = 0; i < enPerfFileCollection.size(); ++i) {
                    PerfFileInfo perfFileInfo = enPerfFileCollection.get(i);
                    perfFileInfo.setState(PerfFileStateEnum.ENABLE);
                    perfFileInfo.setLastUpdateUser(currentUser);
                    perfFileInfo.setLastUpdateTime(now);
                    coreBaseCollection.add((CoreBaseInfo)perfFileInfo);
                    ++enableCount;
                    enableList.add(perfFileInfo.getPerson().getName() + "##" + perfFileInfo.getPerson().getNumber() + "##" + perfFileInfo.getPosition().getName());
                }
                this.updatePartialBatchData(ctx, (IObjectCollection)coreBaseCollection, updateSic);
            }
        }
        returnMap.put("enableCount", Integer.valueOf(enableCount));
        returnMap.put("enableList", enableList);
        returnMap.put("totalUpdateCount", Integer.valueOf(disableCount + enableCount));
        return returnMap;
    }

    @Override
    protected void _createNewFile(Context ctx, Map empPosOrgRelationDataMap) throws BOSException, EASBizException {
        if (CollectionUtils.isEmpty((Map)empPosOrgRelationDataMap)) {
            logger.error("createNewFile error, current data is null");
            return;
        }
        Set<String> allEmpIds = empPosOrgRelationDataMap.keySet().stream().collect(Collectors.toSet());
        this.createNewFileByBizManageType(ctx, "yLpA1Yug2k2H1OL2GTWGhGWJ1dE=", allEmpIds, empPosOrgRelationDataMap);
        if (!CollectionUtils.isEmpty(allEmpIds)) {
            this.createNewFileByBizManageType(ctx, "SGuJm3nXW0GshQfKRXenomWJ1dE=", allEmpIds, empPosOrgRelationDataMap);
        }
    }

    private void createNewFileByBizManageType(Context ctx, String bizManageType, Set<String> allEmpIds, Map empPosOrgRelationDataMap) throws BOSException, EASBizException {
        IPersonBURelaConfirm iPersonBURelaConfirm = PersonBURelaConfirmFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo confirmFilter = new FilterInfo();
        FilterItemCollection filterItems = confirmFilter.getFilterItems();
        filterItems.add(new FilterItemInfo("newEmpOrgRelation.id", allEmpIds, CompareType.INCLUDE));
        filterItems.add(new FilterItemInfo("bizManageType", (Object)bizManageType, CompareType.EQUALS));
        HashSet<Integer> affairActionOperateSet = new HashSet<Integer>();
        affairActionOperateSet.add(10);
        affairActionOperateSet.add(60);
        affairActionOperateSet.add(30);
        affairActionOperateSet.add(9);
        filterItems.add(new FilterItemInfo("affairActionOperate", affairActionOperateSet, CompareType.INCLUDE));
        evi.setFilter(confirmFilter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("defaultHrOrgUnit");
        sic.add("newHrOrgUnit");
        sic.add("changeDate");
        sic.add("bizDefineType");
        sic.add("person.employeeType.id");
        sic.add("newEmpOrgRelation.*");
        sic.add("newEmpOrgRelation.laborRelation.laborRelationState.id");
        sic.add("newEmpOrgRelation.person.id");
        sic.add("newEmpOrgRelation.person.number");
        sic.add("newEmpOrgRelation.person.name");
        sic.add("oldEmpOrgRelation");
        evi.setSelector(sic);
        PersonBURelaConfirmCollection personBURelaConfirmCollection = iPersonBURelaConfirm.getPersonBURelaConfirmCollection(evi);
        if (personBURelaConfirmCollection != null && personBURelaConfirmCollection.size() > 0) {
            HashSet<String> oldEmpOrgRelationIds = new HashSet<String>();
            HashMap<String, PersonBURelaConfirmInfo> newPersonConfirmMap = new HashMap<String, PersonBURelaConfirmInfo>();
            CoreBaseCollection personConfirmColl = new CoreBaseCollection();
            HashSet<String> personIds = new HashSet<String>(personBURelaConfirmCollection.size());
            HashMap<String, String> personIdAndNameMap = new HashMap<String, String>(personBURelaConfirmCollection.size());
            for (int i = 0; i < personBURelaConfirmCollection.size(); ++i) {
                PersonBURelaConfirmInfo personBURelaConfirmInfo = personBURelaConfirmCollection.get(i);
                allEmpIds.remove(personBURelaConfirmInfo.getNewEmpOrgRelation().getId().toString());
                personBURelaConfirmInfo.setIsAlreadyDeal(true);
                personBURelaConfirmInfo.setConfirmState(DealState.confirmed);
                personConfirmColl.add((CoreBaseInfo)personBURelaConfirmInfo);
                if (personBURelaConfirmInfo.getOldEmpOrgRelation() != null && personBURelaConfirmInfo.getOldEmpOrgRelation().getId() != null && !StringUtils.isEmpty((String)personBURelaConfirmInfo.getOldEmpOrgRelation().getId().toString())) {
                    oldEmpOrgRelationIds.add(personBURelaConfirmInfo.getOldEmpOrgRelation().getId().toString());
                }
                newPersonConfirmMap.put(personBURelaConfirmInfo.getNewEmpOrgRelation().getId().toString(), personBURelaConfirmInfo);
                personIds.add(personBURelaConfirmInfo.getNewEmpOrgRelation().getPerson().getId().toString());
                personIdAndNameMap.put(personBURelaConfirmInfo.getNewEmpOrgRelation().getPerson().getId().toString(), personBURelaConfirmInfo.getNewEmpOrgRelation().getPerson().getName());
            }
            EntityViewInfo perFileEvi = new EntityViewInfo();
            FilterInfo perfFileFilter = new FilterInfo();
            perfFileFilter.getFilterItems().add(new FilterItemInfo("empPosOrgRelation", oldEmpOrgRelationIds, CompareType.INCLUDE));
            perfFileFilter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
            perFileEvi.setFilter(perfFileFilter);
            PerfFileCollection waitDisableColl = this.getPerfFileCollection(ctx, perFileEvi);
            if (waitDisableColl != null && waitDisableColl.size() > 0) {
                CoreBaseCollection baseCollection = new CoreBaseCollection();
                Timestamp now = new Timestamp(System.currentTimeMillis());
                UserInfo currentUser = GetEntityInfoUtils.getUserInfo(ctx);
                for (int i = 0; i < waitDisableColl.size(); ++i) {
                    PerfFileInfo perfFileInfo = waitDisableColl.get(i);
                    perfFileInfo.setState(PerfFileStateEnum.DISABLE);
                    perfFileInfo.setLastUpdateTime(now);
                    perfFileInfo.setLastUpdateUser(currentUser);
                    baseCollection.add((CoreBaseInfo)perfFileInfo);
                }
                SelectorItemCollection updateSic = new SelectorItemCollection();
                updateSic.add("state");
                updateSic.add("lastUpdateTime");
                updateSic.add("lastUpdateUser");
                this.updatePartialBatchData(ctx, (IObjectCollection)baseCollection, updateSic);
            }
            this.dealPerfFile(ctx, newPersonConfirmMap, empPosOrgRelationDataMap);
            SelectorItemCollection personConfirmSic = new SelectorItemCollection();
            personConfirmSic.add("isAlreadyDeal");
            personConfirmSic.add("confirmState");
            personConfirmSic.add("lastUpdateTime");
            personConfirmSic.add("lastUpdateUser");
            PersonBURelaConfirmFactory.getLocalInstance((Context)ctx).updatePartialBatchData((IObjectCollection)personConfirmColl, personConfirmSic);
            try {
                Map<String, Map<String, Set<String>>> personToSonPersonsMap;
                if (!CollectionUtils.isEmpty(personIds) && !CollectionUtils.isEmpty(personToSonPersonsMap = PerfWorkFlowUtils.getPersonByParentPersonId(ctx, personIds))) {
                    for (Map.Entry<String, Map<String, Set<String>>> entry : personToSonPersonsMap.entrySet()) {
                        PerfwebBizManageMsgManageBaseImpl.dealEvaObjectSuperior(ctx, entry, personIdAndNameMap);
                    }
                }
            }
            catch (Exception e) {
                logger.error("dealEvaObjectSuperior error ", (Throwable)e);
            }
        }
    }

    private void dealPerfFile(Context ctx, Map<String, PersonBURelaConfirmInfo> newPersonConfirmMap, Map empPosOrgRelationDataMap) throws BOSException, EASBizException {
        Set<String> newEmpIds = newPersonConfirmMap.keySet();
        EntityViewInfo perFileEvi = new EntityViewInfo();
        FilterInfo perfFileFilter = new FilterInfo();
        perfFileFilter.clearExtendedProperties();
        perfFileFilter.getFilterItems().add(new FilterItemInfo("empPosOrgRelation", newEmpIds, CompareType.INCLUDE));
        perFileEvi.setFilter(perfFileFilter);
        SelectorItemCollection perfFileSic = new SelectorItemCollection();
        perfFileSic.add("empPosOrgRelation.id");
        perFileEvi.setSelector(perfFileSic);
        PerfFileCollection existColl = this.getPerfFileCollection(ctx, perFileEvi);
        if (existColl != null && existColl.size() > 0) {
            for (int i = 0; i < existColl.size(); ++i) {
                newEmpIds.remove(existColl.get(i).getEmpPosOrgRelation().getId().toString());
            }
        }
        if (!CollectionUtils.isEmpty(newEmpIds)) {
            String[] idArr;
            String personIdAndHrOrgId;
            CoreBaseCollection perfFileColl = new CoreBaseCollection();
            Timestamp leftTime = new Timestamp(PerfDateUtils.strToDate(LEFFDT).getTime());
            HashSet<String> mainSet = new HashSet<String>();
            HashSet<String> partTimeSet = new HashSet<String>();
            Timestamp now = new Timestamp(System.currentTimeMillis());
            UserInfo currentUser = GetEntityInfoUtils.getUserInfo(ctx);
            for (String newEmpId : newEmpIds) {
                PerfFileInfo perfFileInfo = new PerfFileInfo();
                PersonBURelaConfirmInfo personBURelaConfirmInfo = newPersonConfirmMap.get(newEmpId);
                EmpPosOrgRelationInfo newEmpOrgRelation = personBURelaConfirmInfo.getNewEmpOrgRelation();
                perfFileInfo.setEmpPosOrgRelation(newEmpOrgRelation);
                perfFileInfo.setAutoDeal(false);
                perfFileInfo.setBizDefineType(personBURelaConfirmInfo.getBizDefineType());
                perfFileInfo.setAssignType(PerfFileAssignTypeEnum.getEnum(newEmpOrgRelation.getAssignType().getValue()));
                perfFileInfo.setPerson(newEmpOrgRelation.getPerson());
                perfFileInfo.setNumber(newEmpOrgRelation.getPerson().getNumber());
                perfFileInfo.setName(newEmpOrgRelation.getPerson().getName());
                perfFileInfo.setHrOrgUnit(newEmpOrgRelation.getHrOrgUnit());
                perfFileInfo.setPosition(newEmpOrgRelation.getPosition());
                perfFileInfo.setAdminOrgUnit(newEmpOrgRelation.getAdminOrg());
                perfFileInfo.setComfirmMsgId(personBURelaConfirmInfo.getId().toString());
                EmpLaborRelationInfo empLaborRelationInfo = newEmpOrgRelation.getLaborRelation();
                if (empLaborRelationInfo == null) {
                    perfFileInfo.setEmployeeType(personBURelaConfirmInfo.getPerson().getEmployeeType());
                } else {
                    perfFileInfo.setEmployeeType(empLaborRelationInfo.getLaborRelationState());
                }
                perfFileInfo.setChangeDate(personBURelaConfirmInfo.getChangeDate());
                PersonBURelationInfo personBURelationInfo = PerfPersonBURelaConfirmUtils.getPerfPersonBURelationByConfirmMsgId(ctx, personBURelaConfirmInfo.getId().toString());
                if (personBURelationInfo != null) {
                    perfFileInfo.setPersonBURelation(personBURelationInfo);
                    perfFileInfo.setUseDefault(personBURelationInfo.isUseDefault());
                } else {
                    PerfFileControllerBean.setPerfFileUseDefault(personBURelaConfirmInfo, perfFileInfo);
                }
                perfFileInfo.setEFFTime(new Timestamp(newEmpOrgRelation.getEFFDT().getTime()));
                perfFileInfo.setLEFFTime(leftTime);
                if (new Date().getTime() > newEmpOrgRelation.getLEFFDT().getTime()) {
                    perfFileInfo.setState(PerfFileStateEnum.DISABLE);
                } else {
                    perfFileInfo.setState(PerfFileStateEnum.ENABLE);
                    if (1 == perfFileInfo.getAssignType().getValue()) {
                        mainSet.add(perfFileInfo.getPerson().getId().toString() + "##" + perfFileInfo.getHrOrgUnit().getId().toString());
                    } else {
                        partTimeSet.add(perfFileInfo.getPerson().getId().toString() + "##" + perfFileInfo.getHrOrgUnit().getId().toString());
                    }
                }
                String hrOrgUnitId = (String)empPosOrgRelationDataMap.get(newEmpOrgRelation.getId().toString());
                if (!hrOrgUnitId.equals(perfFileInfo.getHrOrgUnit().getId().toString())) {
                    perfFileInfo.setHrOrgUnit(null);
                    perfFileInfo.put("hrOrgUnit", hrOrgUnitId);
                    perfFileInfo.setUseDefault(false);
                }
                perfFileInfo.setCreateTime(now);
                perfFileInfo.setLastUpdateTime(now);
                perfFileInfo.setCreator(currentUser);
                perfFileInfo.setLastUpdateUser(currentUser);
                perfFileColl.add((CoreBaseInfo)perfFileInfo);
            }
            if (!CollectionUtils.isEmpty(mainSet)) {
                StringBuilder updateMainSql = new StringBuilder(" update t_eva_perffile set fstate = 2 where (");
                ArrayList mainList = new ArrayList(mainSet);
                for (int i = 0; i < mainList.size(); ++i) {
                    personIdAndHrOrgId = (String)mainList.get(i);
                    idArr = personIdAndHrOrgId.split("##");
                    if (idArr.length > 1) {
                        updateMainSql.append("(fpersonId = '").append(idArr[0]).append("' and fhrorgunitId = '").append(idArr[1]).append("')");
                    }
                    if (i >= mainList.size() - 1) continue;
                    updateMainSql.append(" or ");
                }
                updateMainSql.append(") and fassignType = 1 and (fstate = 1 or fstate = 0)");
                DbUtil.execute((Context)ctx, (String)updateMainSql.toString());
            }
            if (!CollectionUtils.isEmpty(partTimeSet)) {
                StringBuilder updatePartTimeSql = new StringBuilder(" update t_eva_perffile set fstate = 2 where ");
                ArrayList partTimeList = new ArrayList(partTimeSet);
                for (int i = 0; i < partTimeList.size(); ++i) {
                    personIdAndHrOrgId = (String)partTimeList.get(i);
                    idArr = personIdAndHrOrgId.split("##");
                    if (idArr.length > 1) {
                        updatePartTimeSql.append("(fpersonId = '").append(idArr[0]).append("' and fhrorgunitId = '").append(idArr[1]).append("')");
                    }
                    if (i >= partTimeList.size() - 1) continue;
                    updatePartTimeSql.append(" or ");
                }
                updatePartTimeSql.append(" and fassignType = 0 and (fstate = 1 or fstate = 0)");
                DbUtil.execute((Context)ctx, (String)updatePartTimeSql.toString());
            }
            this.saveBatchData(ctx, perfFileColl);
        }
    }

    private static void setPerfFileUseDefault(PersonBURelaConfirmInfo confirmInfo, PerfFileInfo fileInfo) {
        HROrgUnitInfo defaultHrOrgUnit = confirmInfo.getDefaultHrOrgUnit();
        HROrgUnitInfo newHrOrgUnit = confirmInfo.getNewHrOrgUnit();
        if (defaultHrOrgUnit != null && newHrOrgUnit != null && newHrOrgUnit.getId().toString().equals(defaultHrOrgUnit.getId().toString())) {
            fileInfo.setUseDefault(true);
        } else {
            fileInfo.setUseDefault(false);
        }
    }
}

