/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.base.perftask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.attachment.SHRAttachmentExtCollection;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.DateUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.shr.perfweb.app.base.perftask.AbstractPerfTaskControllerBean;
import com.kingdee.shr.perfweb.app.base.perftask.IPerfTaskLikes;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskAssignerCollection;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskAssignerFactory;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskAssignerHISCollection;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskAssignerHISFactory;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskAssignerHISInfo;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskAssignerInfo;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskAttachmentHISCollection;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskAttachmentHISFactory;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskAttachmentHISInfo;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskCollection;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskCommentFactory;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskCommentInfo;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskHISCollection;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskHISFactory;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskHISInfo;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskInfo;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskLikesCollection;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskLikesFactory;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskLikesInfo;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskOperateType;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskParticipateCollection;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskParticipateFactory;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskParticipateHISCollection;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskParticipateHISFactory;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskParticipateHISInfo;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskParticipateInfo;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskPriority;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskState;
import com.kingdee.shr.perfweb.app.base.perftask.PerfTaskVisible;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfTaskControllerBean
extends AbstractPerfTaskControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.base.perftask.PerfTaskControllerBean");

    @Override
    protected Map _publish(Context ctx, String ids) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)ids)) {
            return new HashMap();
        }
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (StringUtils.isEmpty((String)personId)) {
            return new HashMap();
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.addAll(Arrays.asList(ids.split(",")));
        PerfTaskCollection taskColls = this.getByIds(ctx, ids);
        if (taskColls != null && !taskColls.isEmpty()) {
            HashMap result = new HashMap();
            CoreBaseCollection colls = new CoreBaseCollection();
            HashSet<String> unvalids = new HashSet<String>();
            HashSet<String> published = new HashSet<String>();
            Iterator it = taskColls.iterator();
            while (it.hasNext()) {
                PerfTaskInfo taskInfo = (PerfTaskInfo)it.next();
                String responserId = taskInfo.getResponser().getId().toString();
                String createPersonId = taskInfo.getPerson().getId().toString();
                if (!createPersonId.equals(personId) && !responserId.equals(personId)) {
                    unvalids.add(taskInfo.getId().toString());
                    continue;
                }
                if (taskInfo.isPublish()) {
                    published.add(taskInfo.getId().toString());
                    continue;
                }
                taskInfo.setPublish(true);
                colls.add((CoreBaseInfo)taskInfo);
            }
            if (!colls.isEmpty()) {
                this.saveBatchData(ctx, colls);
                for (PerfTaskInfo taskInfo : colls) {
                    taskInfo.setOperateType(PerfTaskOperateType.PUBLISH);
                    this.addHisLog(ctx, (IObjectValue)taskInfo);
                }
            }
            if (unvalids.size() > 0) {
                result.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFTASKPUBLISHERR, ctx), unvalids);
                return result;
            }
            if (published.size() > 0) {
                result.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFTASKPUBLISHED, ctx), published);
                return result;
            }
        }
        return new HashMap();
    }

    @Override
    protected Map _deleteTask(Context ctx, String ids) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)ids)) {
            return new HashMap();
        }
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (StringUtils.isEmpty((String)personId)) {
            return new HashMap();
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.addAll(Arrays.asList(ids.split(",")));
        PerfTaskCollection taskColls = this.getByIds(ctx, ids);
        if (taskColls != null && !taskColls.isEmpty()) {
            ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>();
            HashMap result = new HashMap();
            HashSet<String> unvalids = new HashSet<String>();
            Iterator it = taskColls.iterator();
            while (it.hasNext()) {
                PerfTaskInfo taskInfo = (PerfTaskInfo)it.next();
                String responserId = taskInfo.getResponser().getId().toString();
                String createPersonId = taskInfo.getPerson().getId().toString();
                if (!createPersonId.equals(personId) && !responserId.equals(personId)) {
                    unvalids.add(taskInfo.getId().toString());
                    continue;
                }
                pks.add(new ObjectUuidPK(taskInfo.getId()));
            }
            if (!pks.isEmpty()) {
                this.delete(ctx, (IObjectPK[])pks.toArray(new ObjectUuidPK[pks.size()]));
                idSet.removeAll(unvalids);
                FilterInfo delEntryFilter = new FilterInfo();
                delEntryFilter.getFilterItems().add(new FilterItemInfo("task", idSet, CompareType.INCLUDE));
                PerfTaskParticipateFactory.getLocalInstance(ctx).delete(delEntryFilter);
                PerfTaskAssignerFactory.getLocalInstance(ctx).delete(delEntryFilter);
                FilterInfo delTaskFilter = new FilterInfo();
                delTaskFilter.getFilterItems().add(new FilterItemInfo("historyRelateId", idSet, CompareType.INCLUDE));
                PerfTaskHISFactory.getLocalInstance(ctx).delete(delTaskFilter);
                PerfTaskParticipateHISFactory.getLocalInstance(ctx).delete(delEntryFilter);
                PerfTaskAssignerHISFactory.getLocalInstance(ctx).delete(delEntryFilter);
            }
            if (unvalids.size() > 0) {
                result.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFTASKDELETEERR, ctx), unvalids);
                return result;
            }
        }
        return new HashMap();
    }

    @Override
    protected IObjectPK _addHisLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SHRAttachmentExtCollection attachs;
        PerfTaskAssignerCollection assigners;
        String id = model.get("id").toString();
        PerfTaskHISInfo hisInfo = new PerfTaskHISInfo();
        HistoryUtil.cloneInfo((IObjectValue)model, (IObjectValue)hisInfo);
        hisInfo.setHistoryRelateId(BOSUuid.read((String)id));
        hisInfo.setId(null);
        hisInfo.setCreateTime(null);
        hisInfo.setCreator(null);
        hisInfo.setLastUpdateTime(null);
        hisInfo.setLastUpdateUser(null);
        hisInfo.put("participates", null);
        hisInfo.put("assigners", null);
        IObjectPK hisPk = PerfTaskHISFactory.getLocalInstance(ctx).save((CoreBaseInfo)hisInfo);
        String hisId = hisPk.toString();
        PerfTaskParticipateCollection participates = PerfTaskParticipateFactory.getLocalInstance(ctx).getPerfTaskParticipateCollection("where task.id='" + id + "'");
        if (participates != null && !participates.isEmpty()) {
            CoreBaseCollection pcolls = new CoreBaseCollection();
            Iterator it = participates.iterator();
            while (it.hasNext()) {
                PerfTaskParticipateInfo participateInfo = (PerfTaskParticipateInfo)it.next();
                PerfTaskParticipateHISInfo phisInfo = new PerfTaskParticipateHISInfo();
                HistoryUtil.cloneInfo((IObjectValue)participateInfo, (IObjectValue)phisInfo);
                phisInfo.setHistoryRelateId(BOSUuid.read((String)participateInfo.getId().toString()));
                phisInfo.setId(null);
                phisInfo.put("task", hisId);
                pcolls.add((CoreBaseInfo)phisInfo);
            }
            PerfTaskParticipateHISFactory.getLocalInstance(ctx).saveBatchData(pcolls);
        }
        if ((assigners = PerfTaskAssignerFactory.getLocalInstance(ctx).getPerfTaskAssignerCollection("where task.id='" + id + "'")) != null && !assigners.isEmpty()) {
            CoreBaseCollection acolls = new CoreBaseCollection();
            Iterator it = assigners.iterator();
            while (it.hasNext()) {
                PerfTaskAssignerInfo assignerInfo = (PerfTaskAssignerInfo)it.next();
                PerfTaskAssignerHISInfo ahisInfo = new PerfTaskAssignerHISInfo();
                HistoryUtil.cloneInfo((IObjectValue)assignerInfo, (IObjectValue)ahisInfo);
                ahisInfo.setHistoryRelateId(BOSUuid.read((String)assignerInfo.getId().toString()));
                ahisInfo.setId(null);
                ahisInfo.put("task", hisId);
                acolls.add((CoreBaseInfo)ahisInfo);
            }
            PerfTaskAssignerHISFactory.getLocalInstance(ctx).saveBatchData(acolls);
        }
        if ((attachs = SHRAttachmentExtFactory.getLocalInstance((Context)ctx).getSHRAttachmentExtCollection("where boID = '" + id + "'")) != null && !attachs.isEmpty()) {
            CoreBaseCollection colls = new CoreBaseCollection();
            for (SHRAttachmentExtInfo extInfo : attachs) {
                PerfTaskAttachmentHISInfo aInfo = new PerfTaskAttachmentHISInfo();
                aInfo.setTaskHis(hisId);
                aInfo.setTask(id);
                aInfo.setAttachment(extInfo.getAttachment().getId().toString());
                aInfo.setAttachmentExt(extInfo.getId().toString());
                aInfo.setBunding(extInfo.getBunding());
                aInfo.setPropertyName(extInfo.getPropertyName());
                aInfo.setType(extInfo.getType());
                aInfo.setName(extInfo.getName(LocaleUtils.locale_L1), LocaleUtils.locale_L1);
                aInfo.setName(extInfo.getName(LocaleUtils.locale_L2), LocaleUtils.locale_L2);
                aInfo.setName(extInfo.getName(LocaleUtils.locale_L3), LocaleUtils.locale_L3);
                aInfo.setCreateTime(extInfo.getCreateTime());
                aInfo.setCreator(extInfo.getCreator());
                aInfo.setLastUpdateTime(extInfo.getLastUpdateTime());
                aInfo.setLastUpdateUser(extInfo.getLastUpdateUser());
                aInfo.setBoID(extInfo.getBoID());
                colls.add((CoreBaseInfo)aInfo);
            }
            PerfTaskAttachmentHISFactory.getLocalInstance(ctx).saveBatchData(colls);
        }
        return hisPk;
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        model.put("operateType", (Object)PerfTaskOperateType.ADD);
        model.put("publish", (Object)false);
        super._addnew(ctx, pk, model);
        this.addHisLog(ctx, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        model.put("operateType", (Object)PerfTaskOperateType.ADD);
        model.put("publish", (Object)false);
        IObjectPK pk = super._addnew(ctx, model);
        this.addHisLog(ctx, model);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("operateType") == null) {
            model.put("operateType", (Object)PerfTaskOperateType.EDIT);
            super._update(ctx, pk, model);
            this.addHisLog(ctx, model);
        } else {
            super._update(ctx, pk, model);
        }
    }

    @Override
    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        if (model.get("operateType") == null) {
            model.put("operateType", (Object)PerfTaskOperateType.EDIT);
            super._updatePartial(ctx, model, selector);
            this.addHisLog(ctx, model);
        } else {
            super._updatePartial(ctx, model, selector);
        }
    }

    @Override
    protected void _updateBigObject(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
        if (model.get("operateType") == null) {
            model.put("operateType", (Object)PerfTaskOperateType.EDIT);
            this.innerUpdateBigObject(ctx, pk, model);
            try {
                this.addHisLog(ctx, model);
            }
            catch (EASBizException e) {
                logger.error("perfTask_updateBigObject err", (Throwable)e);
            }
        } else {
            this.innerUpdateBigObject(ctx, pk, model);
        }
    }

    @Override
    protected CoreBaseCollection _getHisLog(Context ctx, String id) throws BOSException, EASBizException {
        CoreBaseCollection logs = new CoreBaseCollection();
        String oql = "select creator.name, indicator.name, record.keyItem, person.id, person.name, responser.id, responser.name, participates.person.id, participates.person.name, assigners.person.id,  assigners.person.name, lastUpdateUser.id, lastUpdateUser.name, *  where historyRelateId='" + id + "' order by createTime desc";
        PerfTaskHISCollection taskHis = PerfTaskHISFactory.getLocalInstance(ctx).getPerfTaskHISCollection(oql);
        if (taskHis != null && !taskHis.isEmpty()) {
            int size = taskHis.size();
            String hisInfoText = "";
            for (int count = 0; count < size; ++count) {
                PerfTaskHISInfo hisInfo = taskHis.get(count);
                PerfTaskOperateType operateType = hisInfo.getOperateType();
                if (!PerfTaskOperateType.EDIT.equals((Object)operateType)) {
                    hisInfoText = this.combineHisLog(ctx, hisInfo);
                } else if (count + 1 < size) {
                    PerfTaskHISInfo prevInfo = taskHis.get(count + 1);
                    hisInfoText = this.combineCompareHisLog(ctx, hisInfo, prevInfo);
                }
                hisInfo.put("hisLog", hisInfoText);
                logs.add((CoreBaseInfo)hisInfo);
            }
        }
        return logs;
    }

    @Override
    protected Map _updProgress(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PerfTaskInfo taskInfo = (PerfTaskInfo)model;
        taskInfo.setOperateType(PerfTaskOperateType.UPDPROGRESS);
        SelectorItemCollection selectos = new SelectorItemCollection();
        selectos.add(new SelectorItemInfo("progress"));
        selectos.add(new SelectorItemInfo("state"));
        selectos.add(new SelectorItemInfo("targetValue"));
        selectos.add(new SelectorItemInfo("compleValue"));
        selectos.add(new SelectorItemInfo("unit"));
        selectos.add(new SelectorItemInfo("compleDesc"));
        selectos.add(new SelectorItemInfo("operateType"));
        this.updatePartial(ctx, taskInfo, selectos);
        PerfTaskInfo perfTaskInfo = this.getPerfTaskInfo(ctx, (IObjectPK)new ObjectUuidPK(model.get("id").toString()));
        String hisLogId = this.addHisLog(ctx, (IObjectValue)perfTaskInfo).toString();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("hisLogId", hisLogId);
        return result;
    }

    @Override
    protected Map _getLikes(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        boolean currentLike = false;
        String oql = "select person.id, person.name, createTime where task.id ='" + id + "' order by createTime desc";
        PerfTaskLikesCollection likes = PerfTaskLikesFactory.getLocalInstance(ctx).getPerfTaskLikesCollection(oql);
        if (likes != null && !likes.isEmpty()) {
            HashSet<String> likeNames = new HashSet<String>();
            CoreBaseCollection colls = new CoreBaseCollection();
            Iterator it = likes.iterator();
            while (it.hasNext()) {
                PerfTaskLikesInfo likesInfo = (PerfTaskLikesInfo)it.next();
                likeNames.add(likesInfo.getPerson().getName());
                if (likesInfo.getPerson().getId().toString().equals(personId)) {
                    currentLike = true;
                }
                colls.add((CoreBaseInfo)likesInfo);
            }
            result.put("likePersons", org.apache.commons.lang3.StringUtils.join(likeNames, (String)","));
            result.put("likeCount", likeNames.size());
            result.put("currentLike", currentLike);
            result.put("likeStyle", currentLike ? "likes" : "unlike");
        } else {
            result.put("likePersons", "");
            result.put("likeCount", 0);
            result.put("currentLike", false);
            result.put("likeStyle", "unlike");
        }
        return result;
    }

    @Override
    protected Map _likes(Context ctx, String id) throws BOSException, EASBizException {
        if (this.exists(ctx, (IObjectPK)new ObjectUuidPK(id))) {
            String oql;
            String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
            IPerfTaskLikes iPerfTaskLikes = PerfTaskLikesFactory.getLocalInstance(ctx);
            PerfTaskLikesCollection likes = iPerfTaskLikes.getPerfTaskLikesCollection(oql = "where task.id='" + id + "' and person.id = '" + personId + "'");
            if (likes != null && !likes.isEmpty()) {
                iPerfTaskLikes.delete(oql);
            } else {
                PerfTaskLikesInfo likesInfo = new PerfTaskLikesInfo();
                likesInfo.put("task", id);
                likesInfo.put("person", personId);
                iPerfTaskLikes.save((CoreBaseInfo)likesInfo);
            }
        }
        return this.getLikes(ctx, id);
    }

    @Override
    protected void _comment(Context ctx, String id, String comment) throws BOSException, EASBizException {
        if (this.exists(ctx, (IObjectPK)new ObjectUuidPK(id))) {
            String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
            PerfTaskCommentInfo commentInfo = new PerfTaskCommentInfo();
            commentInfo.put("task", id);
            commentInfo.put("person", personId);
            commentInfo.setComment(comment);
            PerfTaskCommentFactory.getLocalInstance(ctx).save((CoreBaseInfo)commentInfo);
        }
    }

    private String combineHisLog(Context ctx, PerfTaskHISInfo info) throws EASBizException, BOSException {
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectInfo((Context)ctx, (BOSObjectType)info.getBOSType());
        StringBuffer sb = new StringBuffer();
        PerfTaskOperateType operateType = info.getOperateType();
        Locale l = ctx.getLocale();
        if (PerfTaskOperateType.ADD.equals((Object)operateType)) {
            sb.append(this.getPropertyAlias(entityObjectInfo, "person", l)).append(" : ").append(StringUtils.cnulls((String)info.getPerson().getName(l)));
        } else if (PerfTaskOperateType.PUBLISH.equals((Object)operateType)) {
            sb.append(StringUtils.cnulls((String)info.getCreator().getName(l)));
        } else if (PerfTaskOperateType.UPDPROGRESS.equals((Object)operateType)) {
            sb.append(this.getPropertyAlias(entityObjectInfo, "lastUpdateUser", l)).append(" : ").append(StringUtils.cnulls((String)info.getLastUpdateUser().getName(l))).append("<br/>");
            sb.append(this.getPropertyAlias(entityObjectInfo, "state", l)).append(" : ").append(StringUtils.cnulls((String)info.getState().getAlias(l))).append("<br/>");
            sb.append(this.getPropertyAlias(entityObjectInfo, "progress", l)).append(" : ").append(StringUtils.cnulls((String)info.getProgress())).append("%<br/>");
            sb.append(this.getPropertyAlias(entityObjectInfo, "targetValue", l)).append(" : ").append(StringUtils.cnulls((String)info.getTargetValue())).append("<br/>");
            sb.append(this.getPropertyAlias(entityObjectInfo, "compleValue", l)).append(" : ").append(StringUtils.cnulls((String)info.getCompleValue())).append("<br/>");
            sb.append(this.getPropertyAlias(entityObjectInfo, "unit", l)).append(" : ").append(StringUtils.cnulls((String)info.getUnit())).append("<br/>");
            sb.append(this.getPropertyAlias(entityObjectInfo, "compleDesc", l)).append(" : ").append(StringUtils.cnulls((String)info.getCompleDesc()));
            String anames = this.getAttachNames(ctx, info.getId().toString());
            if (!StringUtils.isEmpty((String)anames)) {
                sb.append("<br/>").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ATTACHMENT, ctx)).append(" : ").append(StringUtils.cnulls((String)anames));
            }
        }
        return sb.toString();
    }

    private String combineCompareHisLog(Context ctx, PerfTaskHISInfo info, PerfTaskHISInfo prevInfo) throws EASBizException, BOSException {
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectInfo((Context)ctx, (BOSObjectType)info.getBOSType());
        Map systemFormat = UserNantionalUtil.getSystemSolutionNationalFormat((Context)ctx);
        String datePattern = ((SimpleDateFormat)systemFormat.get("dateFormat")).toPattern();
        Locale l = ctx.getLocale();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getPropertyAlias(entityObjectInfo, "lastUpdateUser", l)).append(" : ").append(StringUtils.cnulls((String)info.getLastUpdateUser().getName(l))).append("<br/>");
        if (!this.compareString(info.getName(l), prevInfo.getName(l))) {
            sb.append(this.getPropertyAlias(entityObjectInfo, "name", l)).append(" : ").append(StringUtils.cnulls((String)prevInfo.getName(l))).append(" \u2192 ").append(StringUtils.cnulls((String)info.getName(l))).append("<br/>");
        }
        if (!this.compareString(info.getDescription(l), prevInfo.getDescription(l))) {
            sb.append(this.getPropertyAlias(entityObjectInfo, "description", l)).append(" : ").append(StringUtils.cnulls((String)prevInfo.getDescription(l))).append(" \u2192 ").append(StringUtils.cnulls((String)info.getDescription(l))).append("<br/>");
        }
        if (this.compareDate(info.getStartDate(), prevInfo.getStartDate())) {
            sb.append(this.getPropertyAlias(entityObjectInfo, "startDate", l)).append(" : ").append(DateUtils.getCustomDateString((Date)prevInfo.getStartDate(), (String)datePattern)).append(" \u2192 ").append(DateUtils.getCustomDateString((Date)info.getStartDate(), (String)datePattern)).append("<br/>");
        }
        if (this.compareDate(info.getEndDate(), prevInfo.getEndDate())) {
            sb.append(this.getPropertyAlias(entityObjectInfo, "endDate", l)).append(" : ").append(DateUtils.getCustomDateString((Date)prevInfo.getEndDate(), (String)datePattern)).append(" \u2192 ").append(DateUtils.getCustomDateString((Date)info.getEndDate(), (String)datePattern)).append("<br/>");
        }
        if (!info.getPriority().equals((Object)prevInfo.getPriority())) {
            PerfTaskPriority curPriority = info.getPriority();
            PerfTaskPriority prevPriority = prevInfo.getPriority();
            sb.append(this.getPropertyAlias(entityObjectInfo, "priority", l)).append(" : ").append(prevPriority == null ? "" : prevPriority.getAlias(l)).append(" \u2192 ").append(curPriority == null ? "" : curPriority.getAlias(l)).append("<br/>");
        }
        if (!info.getState().equals((Object)prevInfo.getState())) {
            PerfTaskState curState = info.getState();
            PerfTaskState prevState = prevInfo.getState();
            sb.append(this.getPropertyAlias(entityObjectInfo, "state", l)).append(" : ").append(prevState == null ? "" : prevState.getAlias(l)).append(" \u2192 ").append(curState == null ? "" : curState.getAlias(l)).append("<br/>");
        }
        if (!this.compareString(info.getProgress(), prevInfo.getProgress())) {
            sb.append(this.getPropertyAlias(entityObjectInfo, "progress", l)).append(" : ").append(StringUtils.cnulls((String)prevInfo.getProgress())).append("% \u2192 ").append(StringUtils.cnulls((String)info.getProgress())).append("% <br/>");
        }
        if (!this.compareString(info.getTargetValue(), prevInfo.getTargetValue())) {
            sb.append(this.getPropertyAlias(entityObjectInfo, "targetValue", l)).append(" : ").append(StringUtils.cnulls((String)prevInfo.getTargetValue())).append(" \u2192 ").append(StringUtils.cnulls((String)info.getTargetValue())).append("<br/>");
        }
        if (!this.compareString(info.getCompleValue(), prevInfo.getCompleValue())) {
            sb.append(this.getPropertyAlias(entityObjectInfo, "compleValue", l)).append(" : ").append(StringUtils.cnulls((String)prevInfo.getCompleValue())).append(" \u2192 ").append(StringUtils.cnulls((String)info.getCompleValue())).append("<br/>");
        }
        if (!this.compareString(info.getUnit(), prevInfo.getUnit())) {
            sb.append(this.getPropertyAlias(entityObjectInfo, "unit", l)).append(" : ").append(StringUtils.cnulls((String)prevInfo.getUnit())).append(" \u2192 ").append(StringUtils.cnulls((String)info.getUnit())).append("<br/>");
        }
        if (!this.compareString(info.getCompleDesc(), prevInfo.getCompleDesc())) {
            sb.append(this.getPropertyAlias(entityObjectInfo, "compleDesc", l)).append(" : ").append(StringUtils.cnulls((String)prevInfo.getCompleDesc())).append(" \u2192 ").append(StringUtils.cnulls((String)info.getCompleDesc())).append("<br/>");
        }
        if (!this.comparePerson(info.getResponser(), prevInfo.getResponser())) {
            PersonInfo curResponser = info.getResponser();
            PersonInfo prevResponser = prevInfo.getResponser();
            sb.append(this.getPropertyAlias(entityObjectInfo, "responser", l)).append(" : ").append(prevResponser == null ? "" : prevResponser.getName(l)).append(" \u2192 ").append(curResponser == null ? "" : curResponser.getName(l)).append("<br/>");
        }
        this.combineCompareParticipates(entityObjectInfo, l, sb, info, prevInfo);
        if (!info.getVisibeType().equals((Object)prevInfo.getVisibeType())) {
            PerfTaskVisible curVisible = info.getVisibeType();
            PerfTaskVisible prevVisible = prevInfo.getVisibeType();
            sb.append(this.getPropertyAlias(entityObjectInfo, "visibeType", l)).append(" : ").append(prevVisible == null ? "" : prevVisible.getAlias(l)).append(" \u2192 ").append(curVisible == null ? "" : curVisible.getAlias(l)).append("<br/>");
        }
        this.combineCompareAssigners(entityObjectInfo, l, sb, info, prevInfo);
        this.combineCompareIndicator(entityObjectInfo, l, sb, info, prevInfo);
        this.combineCompareAttaches(ctx, sb, info, prevInfo);
        if (sb.length() > 5) {
            sb.setLength(sb.length() - 5);
        }
        return sb.toString();
    }

    private boolean compareString(String cur, String prev) {
        if (StringUtils.isEmpty((String)cur)) {
            if (StringUtils.isEmpty((String)prev)) {
                return true;
            }
            return prev.equals(cur);
        }
        return cur.equals(prev);
    }

    private boolean compareDate(Date cur, Date prev) {
        if (cur == null) {
            return prev == null;
        }
        if (prev == null) {
            return false;
        }
        return cur.compareTo(prev) != 0;
    }

    private boolean comparePerson(PersonInfo cur, PersonInfo prev) {
        if (cur == null) {
            return prev == null;
        }
        if (prev == null) {
            return false;
        }
        return this.compareString(cur.getName(), prev.getName());
    }

    private void combineCompareIndicator(EntityObjectInfo entityObjectInfo, Locale l, StringBuffer sb, PerfTaskHISInfo info, PerfTaskHISInfo prevInfo) {
        if (info.getIndicator() != null) {
            String indicatorProperty = this.getPropertyAlias(entityObjectInfo, "indicator", l);
            if (prevInfo.getIndicator() != null) {
                if (!this.compareString(info.getIndicator().getName(l), prevInfo.getIndicator().getName(l))) {
                    sb.append(indicatorProperty).append(" : ").append(prevInfo.getIndicator().getName(l)).append(" \u2192 ").append(info.getIndicator().getName(l)).append("<br/>");
                }
            } else if (prevInfo.getRecord() != null) {
                if (!this.compareString(info.getIndicator().getName(l), prevInfo.getRecord().getKeyItem(l))) {
                    sb.append(indicatorProperty).append(" : ").append(prevInfo.getRecord().getKeyItem(l)).append(" \u2192 ").append(info.getIndicator().getName(l)).append("<br/>");
                }
            } else {
                sb.append(indicatorProperty).append(" : ").append(" \u2192 ").append(info.getIndicator().getName(l)).append("<br/>");
            }
        } else if (info.getRecord() != null) {
            String indicatorProperty = this.getPropertyAlias(entityObjectInfo, "record", l);
            if (prevInfo.getRecord() != null) {
                if (!this.compareString(info.getRecord().getKeyItem(l), prevInfo.getRecord().getKeyItem(l))) {
                    sb.append(indicatorProperty).append(" : ").append(prevInfo.getRecord().getKeyItem(l)).append(" \u2192 ").append(info.getRecord().getKeyItem(l)).append("<br/>");
                }
            } else if (prevInfo.getIndicator() != null) {
                if (!this.compareString(info.getRecord().getKeyItem(l), prevInfo.getIndicator().getName(l))) {
                    sb.append(indicatorProperty).append(" : ").append(prevInfo.getIndicator().getName(l)).append(" \u2192 ").append(info.getRecord().getKeyItem(l)).append("<br/>");
                }
            } else {
                sb.append(indicatorProperty).append(" : ").append(" \u2192 ").append(info.getRecord().getKeyItem(l)).append("<br/>");
            }
        }
    }

    private void combineCompareParticipates(EntityObjectInfo entityObjectInfo, Locale l, StringBuffer sb, PerfTaskHISInfo info, PerfTaskHISInfo prevInfo) {
        String property = this.getPropertyAlias(entityObjectInfo, "participates", l);
        String curNames = "";
        if (info.getParticipates() != null && !info.getParticipates().isEmpty()) {
            curNames = this.getParticipateNames(info.getParticipates(), l);
        }
        if (prevInfo.getParticipates() != null && !prevInfo.getParticipates().isEmpty()) {
            String prevNames = this.getParticipateNames(prevInfo.getParticipates(), l);
            if (!prevNames.equals(curNames)) {
                sb.append(property).append(" : ").append(prevNames).append(" \u2192 ").append(curNames).append("<br/>");
            }
        } else if (!StringUtils.isEmpty((String)curNames)) {
            sb.append(property).append(" : ").append(" \u2192 ").append(curNames).append("<br/>");
        }
    }

    private void combineCompareAssigners(EntityObjectInfo entityObjectInfo, Locale l, StringBuffer sb, PerfTaskHISInfo info, PerfTaskHISInfo prevInfo) {
        String property = this.getPropertyAlias(entityObjectInfo, "assigners", l);
        String curNames = "";
        if (info.getAssigners() != null && !info.getAssigners().isEmpty()) {
            curNames = this.getAssignerNames(info.getAssigners(), l);
        }
        if (prevInfo.getAssigners() != null && !prevInfo.getAssigners().isEmpty()) {
            String prevNames = this.getAssignerNames(prevInfo.getAssigners(), l);
            if (!prevNames.equals(curNames)) {
                sb.append(property).append(" : ").append(prevNames).append(" \u2192 ").append(curNames).append("<br/>");
            }
        } else if (!StringUtils.isEmpty((String)curNames)) {
            sb.append(property).append(" : ").append(" \u2192 ").append(curNames).append("<br/>");
        }
    }

    private void combineCompareAttaches(Context ctx, StringBuffer sb, PerfTaskHISInfo info, PerfTaskHISInfo prevInfo) throws BOSException {
        String pnames;
        String anames = this.getAttachNames(ctx, info.getId().toString());
        if (!this.compareString(anames, pnames = this.getAttachNames(ctx, prevInfo.getId().toString()))) {
            sb.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ATTACHMENT, ctx)).append(" : ").append(StringUtils.cnulls((String)pnames)).append(" \u2192 ").append(StringUtils.cnulls((String)anames)).append("<br/>");
        }
    }

    private String getAttachNames(Context ctx, String taskId) throws BOSException {
        PerfTaskAttachmentHISCollection atts = PerfTaskAttachmentHISFactory.getLocalInstance(ctx).getPerfTaskAttachmentHISCollection("select name where taskHis ='" + taskId + "' order by createTime");
        if (atts != null && !atts.isEmpty()) {
            ArrayList<String> names = new ArrayList<String>();
            Iterator it = atts.iterator();
            while (it.hasNext()) {
                names.add(((PerfTaskAttachmentHISInfo)it.next()).getName(ctx.getLocale()));
            }
            return org.apache.commons.lang3.StringUtils.join(names, (String)",");
        }
        return null;
    }

    private String getParticipateNames(PerfTaskParticipateHISCollection colls, Locale l) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            PerfTaskParticipateHISInfo info = (PerfTaskParticipateHISInfo)it.next();
            names.add(info.getPerson().getName(l));
        }
        return org.apache.commons.lang3.StringUtils.join(names, (String)",");
    }

    private String getAssignerNames(PerfTaskAssignerHISCollection colls, Locale l) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            PerfTaskAssignerHISInfo info = (PerfTaskAssignerHISInfo)it.next();
            names.add(info.getPerson().getName(l));
        }
        return org.apache.commons.lang3.StringUtils.join(names, (String)",");
    }

    private String getPropertyAlias(EntityObjectInfo entityObjectInfo, String property, Locale l) {
        return entityObjectInfo.getPropertyByNameRuntime(property).getAlias(l);
    }

    private PerfTaskCollection getByIds(Context ctx, String ids) throws BOSException, EASBizException {
        return this.getByIdsWithFilter(ctx, ids, new FilterInfo());
    }

    private PerfTaskCollection getByIdsWithFilter(Context ctx, String ids, FilterInfo filterInfo) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        idSet.addAll(Arrays.asList(ids.split(",")));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        return this.getPerfTaskCollection(ctx, evi);
    }

    private PerfTaskInfo getAllEntrysById(Context ctx, String id) throws EASBizException, BOSException {
        String oql = " select participates.id, participates.task.id, participates.person.id,  assingers.id, assingers.task.id, assingers.person.id, *  where id ='" + id + "'";
        return this.getPerfTaskInfo(ctx, oql);
    }
}

