/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.comprehensive;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryControllerBean;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.comprehensive.AbstractPerfSumResultAuditBillControllerBean;
import com.kingdee.shr.perfweb.app.comprehensive.IPerfSumResultAuditBillEntry;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSumResultAuditBillEntryCollection;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSumResultAuditBillEntryFactory;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSumResultAuditBillFactory;
import com.kingdee.shr.perfweb.util.TheThirdMessageUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class PerfSumResultAuditBillControllerBean
extends AbstractPerfSumResultAuditBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.perfweb.app.comprehensive.PerfSumResultAuditBillControllerBean");

    @Override
    protected void _deleteRowEntrys(Context ctx, String ids, String billId) throws BOSException {
        Object[] idArr = ids.split(",");
        HashSet idSet = new HashSet(Arrays.asList((Object[])idArr));
        Object[] billIdArr = billId.split(",");
        HashSet billIdSet = new HashSet(Arrays.asList((Object[])billIdArr));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((CharSequence)ids)) {
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("bill", billIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaResult.id"));
        evi.setSelector(sic);
        PerfSumResultAuditBillEntryCollection entrys = PerfSumResultAuditBillEntryFactory.getLocalInstance(ctx).getPerfSumResultAuditBillEntryCollection(evi);
        int size = entrys.size();
        CoreBaseCollection entryColl = new CoreBaseCollection();
        for (int j = 0; j < size; ++j) {
            EvaResultSummaryInfo evaResultInfo = entrys.get(j).getEvaResult();
            evaResultInfo.setIsCreateAuditBill(YesOrNoEnum.NO);
            entryColl.add((CoreBaseInfo)evaResultInfo);
        }
        try {
            PerfSumResultAuditBillEntryFactory.getLocalInstance(ctx).delete(filter);
            SelectorItemCollection updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("isCreateAuditBill"));
            EvaResultSummaryFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)entryColl, updateSic);
        }
        catch (EASBizException e) {
            logger.error((Object)"EASBizException: ", (Throwable)e);
        }
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        IObjectPK save = super.save(ctx, model);
        this.updateBillIsCreateBillflag(ctx, save.toString());
        return save;
    }

    private void updateBillIsCreateBillflag(Context ctx, String billId) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"update T_EVA_EvaResultSummary set FIsCreateAuditBill = 1 where fid in(select FEvaResultID from  T_PEF_PerfResultAuditBillEntry where FBillID = ?)", (Object[])new Object[]{billId});
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        this.updateBillIsCreateBillflag(ctx, pk.toString());
        return pk;
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        StringBuffer resultIdSb = new StringBuffer();
        IPerfSumResultAuditBillEntry iEvaResultBillEntry = PerfSumResultAuditBillEntryFactory.getLocalInstance(ctx);
        PerfSumResultAuditBillEntryCollection evaResultAuditBillEntryColl = iEvaResultBillEntry.getPerfSumResultAuditBillEntryCollection(" where bill='" + billID.toString() + "'");
        if (!evaResultAuditBillEntryColl.isEmpty()) {
            int entrySize = evaResultAuditBillEntryColl.size();
            for (int i = 0; i < entrySize; ++i) {
                if (i == 0) {
                    resultIdSb.append(evaResultAuditBillEntryColl.get(i).getEvaResult().getId().toString());
                    continue;
                }
                resultIdSb.append(",").append(evaResultAuditBillEntryColl.get(i).getEvaResult().getId().toString());
            }
        }
        EvaResultSummaryControllerBean.getInstance().auditEvaResut(ctx, resultIdSb.toString(), false);
    }

    @Override
    protected List _deleteAuditBill(Context ctx, String billIds) throws BOSException {
        if (!StringUtils.isEmpty((CharSequence)billIds)) {
            ArrayList<String> billIdList = new ArrayList<String>();
            for (String billId : billIds.split(",")) {
                billIdList.add(billId);
            }
            if (!CollectionUtils.isEmpty(billIdList)) {
                String billIdStr = StringUtils.join(billIdList, (String)",");
                this.deleteRowEntrys(ctx, "", billIdStr);
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)billIdStr, CompareType.INCLUDE));
                evi.setFilter(filter);
                try {
                    PerfSumResultAuditBillFactory.getLocalInstance(ctx).delete(filter);
                }
                catch (EASBizException e) {
                    String message = "deleteAuditBill failed,billID:('" + billIds + "')";
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)message, (Throwable)e);
                    }
                    throw new BOSException(e.getMessage());
                }
                return null;
            }
        }
        return null;
    }

    @Override
    protected List _cancelBill(Context ctx, String billIds) throws BOSException {
        if (StringUtils.isNotEmpty((CharSequence)billIds)) {
            try {
                List<String> failedBillIdList = TheThirdMessageUtil.recycleWFAssign(ctx, billIds);
                ArrayList<String> billIdList = new ArrayList<String>();
                for (String billId : billIds.split(",")) {
                    billIdList.add(billId);
                }
                if (!CollectionUtils.isEmpty(failedBillIdList)) {
                    billIdList.removeAll(failedBillIdList);
                }
                if (!CollectionUtils.isEmpty(billIdList)) {
                    String billIdStr = StringUtils.join(billIdList, (String)"','");
                    DbUtil.execute((Context)ctx, (String)("UPDATE T_PEF_PerfSumResultAuditBill SET FBillState=0 WHERE FID in('" + billIdStr + "')"));
                }
                return failedBillIdList;
            }
            catch (Exception e) {
                String message = "recycle the third message failed,billID:('" + billIds + "')";
                if (logger.isDebugEnabled()) {
                    logger.error((Object)message, (Throwable)e);
                }
                throw new BOSException(e.getMessage());
            }
        }
        return null;
    }
}

