/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.bean;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationHisCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationHisFactory;
import com.kingdee.eas.hr.base.IEmpLaborRelationHis;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.notice.IMessageTemplateDefine;
import com.kingdee.shr.perfweb.app.base.notice.MessageTemplateDefineCollection;
import com.kingdee.shr.perfweb.app.base.notice.MessageTemplateDefineFactory;
import com.kingdee.shr.perfweb.app.base.notice.MessageTemplateDefineInfo;
import com.kingdee.shr.perfweb.app.comprehensive.IPerfSummaryPersonEvaObject;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryPersonEvaObjectCollection;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryPersonEvaObjectFactory;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryPersonEvaObjectInfo;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummarySchemeBaseInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.IMultiPerfEvaObject;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.bean.MsgConfigBean;
import com.kingdee.shr.perfweb.bean.ReMsgBean;
import com.kingdee.shr.perfweb.util.PersonLocaleUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import shaded.org.apache.parquet.Strings;

public class MsgBean {
    private static Logger logger = LoggerFactory.getLogger(MsgBean.class);
    private Map<String, ReMsgBean> receiveMap = new HashMap<String, ReMsgBean>();
    private Map<String, Map<String, String>> objVarKV = new HashMap<String, Map<String, String>>();
    private Integer mergeCount = 2;
    private String msgTempId;
    private Set<String> receiveIds = new HashSet<String>();
    private boolean isOrg;
    private boolean isMulti = false;
    private MsgConfigBean config = null;

    public MsgBean(String msgTempId) {
        this.msgTempId = msgTempId;
        this.receiveIds = new HashSet<String>();
        this.isOrg = false;
    }

    public MsgBean(String msgTempId, boolean isOrg) {
        this.msgTempId = msgTempId;
        this.isOrg = isOrg;
    }

    public MsgBean(String msgTempId, boolean isOrg, boolean isMulti) {
        this.msgTempId = msgTempId;
        this.isOrg = isOrg;
        this.isMulti = isMulti;
    }

    public MsgBean(Integer mergeCount, String msgTempId, boolean isOrg) {
        this.mergeCount = mergeCount;
        this.msgTempId = msgTempId;
        this.isOrg = isOrg;
    }

    public MsgBean(Integer mergeCount, String msgTempId, boolean isOrg, MsgConfigBean config) {
        this.mergeCount = mergeCount;
        this.msgTempId = msgTempId;
        this.isOrg = isOrg;
        this.config = config;
    }

    public void add(String obj, String ... receiveKey) {
        this.add(obj, (Map<String, String>)null, (HashMap<String, Object>)null, receiveKey);
    }

    public void add(String obj, HashMap<String, Object> param, String ... receiveKey) {
        this.add(obj, null, param, receiveKey);
    }

    public void add(String obj, Map<String, String> varKV, HashMap<String, Object> param, String ... receiveKey) {
        this.add(obj, varKV, param, this.config, receiveKey);
    }

    public void add(String obj, Map<String, String> varKV, HashMap<String, Object> param, MsgConfigBean config, String ... receiveKey) {
        Set<String> objSet;
        ReMsgBean reMsgBean;
        String key = "";
        if (receiveKey != null) {
            key = Strings.join((String[])receiveKey, (String)"$$");
            this.receiveIds.add(receiveKey[0]);
        }
        if ((reMsgBean = this.receiveMap.get(key)) == null) {
            config = config == null ? this.config : config;
            reMsgBean = new ReMsgBean(config);
        }
        if (CollectionUtils.isEmpty(objSet = reMsgBean.getObjs())) {
            objSet = new HashSet<String>();
        }
        objSet.add(obj);
        reMsgBean.setObjs(objSet);
        if (!CollectionUtils.isEmpty(param)) {
            reMsgBean.putAll(param);
        }
        this.receiveMap.put(key, reMsgBean);
        Map<String, String> varMap = this.objVarKV.get(obj);
        if (CollectionUtils.isEmpty(varMap)) {
            varMap = new HashMap<String, String>();
        }
        if (!CollectionUtils.isEmpty(varKV)) {
            varMap.putAll(varKV);
        }
        this.objVarKV.put(obj, varMap);
    }

    public Collection<ReMsgBean> excute(Context ctx) {
        if (StringUtils.isEmpty((String)this.msgTempId) || CollectionUtils.isEmpty(this.receiveMap.keySet())) {
            return new ArrayList<ReMsgBean>();
        }
        MessageTemplateDefineCollection msgDefColl = MsgBean.getMessageTemplateById(ctx, this.msgTempId);
        this.objVarKV = this.getVar(ctx, this.objVarKV.keySet(), this.objVarKV, this.isOrg, this.isMulti);
        this.mergeVar(ctx, this.mergeCount, this.objVarKV, new String[0]);
        this.setReceiver(ctx);
        this.replaceVar(ctx, msgDefColl);
        this.disposeMessageTemplate(msgDefColl);
        return this.receiveMap.values() == null ? new ArrayList<ReMsgBean>() : new ArrayList<ReMsgBean>(this.receiveMap.values());
    }

    private void disposeMessageTemplate(MessageTemplateDefineCollection msgDefColl) {
        boolean state = false;
        for (int i = 0; i < msgDefColl.size(); ++i) {
            MessageTemplateDefineInfo info = msgDefColl.get(i);
            if (info.getMessageTemplate().getState().getValue() != 2) continue;
            state = true;
        }
        for (String key : this.receiveMap.keySet()) {
            ReMsgBean reMsgBean = this.receiveMap.get(key);
            if (!state) continue;
            MsgConfigBean config = reMsgBean.get("config") != null ? (MsgConfigBean)reMsgBean.get("config") : reMsgBean.getConfig();
            config.setSysType(false);
            config.setEmailType(false);
            config.setSmsType(false);
            config.setYzjType(false);
        }
    }

    private void mergeVar(Context ctx, Integer mergeCount, Map<String, Map<String, String>> var, String ... merageVarName) {
        for (String key : this.receiveMap.keySet()) {
            ReMsgBean value = this.receiveMap.get(key);
            Set<String> objs = value.getObjs();
            if (objs.size() <= 1) continue;
            for (int i = 0; i < merageVarName.length; ++i) {
                this.realMerge(ctx, merageVarName[i], objs, var);
            }
        }
    }

    private void realMerge(Context ctx, String varName, Set<String> objs, Map<String, Map<String, String>> var) {
        ArrayList<String> names = new ArrayList<String>(this.mergeCount);
        int count = 0;
        for (String obj : objs) {
            if (count >= this.mergeCount) continue;
            names.add(var.get(obj).get(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNAME, ctx)));
            ++count;
        }
        String newName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ETCWITHREFIX, ctx, new Object[]{Strings.join(names, (String)"\u3001")});
        for (String obj : objs) {
            var.get(obj).put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNAME, ctx), newName);
        }
    }

    public Map<String, Map<String, String>> getVar(Context ctx, Set<String> objIdSet, Map<String, Map<String, String>> map, boolean isOrg, boolean isMulti) {
        if (isMulti) {
            return this.getMultiVar(ctx, objIdSet, map, isOrg);
        }
        if (this.config != null && this.config.isSumCal()) {
            return this.getSumCalVar(ctx, objIdSet, map, isOrg);
        }
        return this.getVar(ctx, objIdSet, map, isOrg);
    }

    private Map<String, Map<String, String>> getVar(Context ctx, Set<String> objIdSet, Map<String, Map<String, String>> map, boolean isOrg) {
        HashMap<String, Map<String, String>> reMap = new HashMap<String, Map<String, String>>();
        try {
            if (CollectionUtils.isEmpty(objIdSet)) {
                return reMap;
            }
            IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
            IEmpLaborRelationHis iEmpLaborRelationHis = EmpLaborRelationHisFactory.getLocalInstance((Context)ctx);
            String transmitName = "administrator";
            String transmitNumber = "administrator";
            String currentPersonId = HRFilterUtils.getCurrentPersonId((Context)ctx);
            PersonInfo currentPerson = null;
            if (!StringUtils.isEmpty((String)currentPersonId)) {
                PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select name,number where id = '" + currentPersonId + "'");
                if (personCollection != null && personCollection.size() > 0) {
                    currentPerson = personCollection.get(0);
                }
                transmitNumber = currentPerson.getNumber();
            }
            String ksql = "";
            String objIds = "('" + Strings.join(objIdSet, (String)"','") + "')";
            ksql = isOrg ? " select id,period.*,period.perfPlan.name,adminHis.name,adminHis.number,evaluOrgAdmin.*,evaluOrgAdmin.company.name,responsor.person.id  where id in " + objIds : " select id,person.id,person.name,person.number,period.*,period.perfPlan.name,perfFile.position.name,perfFile.adminOrgUnit.name,perfFile.employeeType.name,*  where id in " + objIds;
            PerfEvaObjectCollection evaObjectColl = iPerfEvaObject.getPerfEvaObjectCollection(ksql);
            List langList = BOSConfigUtil.getLanguageMapingList();
            int evaObjSize = evaObjectColl.size();
            for (int i = 0; i < evaObjSize; ++i) {
                String number = "";
                String org = "";
                String enterDate = "";
                String personId = "";
                String orgNumber = "";
                String state = "";
                PerfEvaObjectInfo objectInfo = evaObjectColl.get(i);
                if (isOrg) {
                    orgNumber = objectInfo.getEvaluOrgAdmin().getNumber();
                } else {
                    personId = objectInfo.getPerson().getId().toString();
                    String hisOql = "where person ='" + personId + "'";
                    EmpLaborRelationHisCollection hisCollection = iEmpLaborRelationHis.getEmpLaborRelationHisCollection(hisOql);
                    for (int k = 0; k < hisCollection.size(); ++k) {
                        if (hisCollection.get(k).getLEFFDT() == null || !DateTimeUtils.dayEquals((Date)hisCollection.get(k).getLEFFDT(), (Date)HRUtil.getMaxEndDate()) || hisCollection.get(k).getEnterDate() == null) continue;
                        enterDate = DateTimeUtils.format((Date)hisCollection.get(k).getEnterDate(), (String)"yyyy-MM-dd");
                    }
                    number = objectInfo.getPerson().getNumber();
                }
                String perfPeriod = objectInfo.getPeriod().getName();
                String perfPeriod_start = DateTimeUtils.format((Date)objectInfo.getPeriod().getPStartDate(), (String)"yyyy-MM-dd");
                String perfPeriod_end = DateTimeUtils.format((Date)objectInfo.getPeriod().getPEndDate(), (String)"yyyy-MM-dd");
                String perfPeriodEvaStart = DateTimeUtils.format((Date)objectInfo.getPeriod().getEvaStartDate(), (String)"yyyy-MM-dd");
                String perfPeriodEvaend = DateTimeUtils.format((Date)objectInfo.getPeriod().getEvaEndDate(), (String)"yyyy-MM-dd");
                String representation = "";
                HashMap<String, String> varMap = new HashMap<String, String>();
                for (int i1 = 0; i1 < langList.size(); ++i1) {
                    String lang = (String)((Map)langList.get(i1)).get("lang");
                    Locale locale = null;
                    if ("l1".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l1;
                    } else if ("l2".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l2;
                    } else if ("l3".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l3;
                    }
                    if (locale == null) continue;
                    String perfPlan = objectInfo.getPeriod().getPerfPlan().getName(locale);
                    perfPeriod = objectInfo.getPeriod().getName(locale);
                    if (isOrg) {
                        org = objectInfo.getEvaluOrgAdmin().getCompany().getName(locale);
                        String orgName = objectInfo.getEvaluOrgAdmin().getName(locale);
                        orgName = orgName == null ? objectInfo.getName(locale) : orgName;
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ORG_NUMBER, locale), orgNumber);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ORG_NAME, locale), orgName);
                    } else {
                        String name = objectInfo.getPerson().getName(locale);
                        state = objectInfo.getPerfFile().getEmployeeType().getName(locale);
                        org = objectInfo.getPerfFile().getAdminOrgUnit().getName(locale);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNUMBER, locale), number);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNAME, locale), name);
                        String position = objectInfo.getPerfFile().getPosition().getName(locale);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFPOSITION, locale), position);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ENTRYDATE, locale), enterDate);
                    }
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.AFFILIATEDORG, locale), org);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RELATIONSTATE, locale), state);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPLAN, locale), perfPlan);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPERIOD, locale), perfPeriod);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPERIODSTART, locale), perfPeriod_start);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REPRESENTATIONEND, locale), perfPeriod_end);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPERIODEVASTART, locale), perfPeriodEvaStart);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REPRESENTATIONEVAEND, locale), perfPeriodEvaend);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REPRESENTATION, locale), representation);
                    if (currentPerson != null) {
                        transmitName = currentPerson.getName(locale);
                    }
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TRANSMITNAME, locale), transmitName);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TRANSMITNUMBER, locale), transmitNumber);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DEALTIME, locale), DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    if (map != null && map.get(objectInfo.getId().toString()) != null) {
                        varMap.putAll(map.get(objectInfo.getId().toString()));
                    }
                    reMap.put(objectInfo.getId().toString(), varMap);
                }
            }
        }
        catch (BOSException e) {
            logger.error("[perfweb_MessageTemplateUtils#getVarDataByObjIdArray]MessageTemplate find perfObj information fail!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("[perfweb_MessageTemplateUtils#getVarDataByObjIdArray]MessageTemplate find perfObj information fail!", (Throwable)e);
        }
        return reMap;
    }

    private Map<String, Map<String, String>> getMultiVar(Context ctx, Set<String> objIdSet, Map<String, Map<String, String>> map, boolean isOrg) {
        HashMap<String, Map<String, String>> reMap = new HashMap<String, Map<String, String>>();
        try {
            if (CollectionUtils.isEmpty(objIdSet)) {
                return reMap;
            }
            HashSet<String> newObjIdSet = new HashSet<String>();
            HashMap<String, HashSet<String>> evaObjTaskIdMap = new HashMap<String, HashSet<String>>();
            for (String objId : objIdSet) {
                String[] ids = objId.split("\\$");
                String evaObjId = ids[0];
                newObjIdSet.add(evaObjId);
                if (ids.length <= 1) continue;
                HashSet<String> taskIds = (HashSet<String>)evaObjTaskIdMap.get(evaObjId);
                if (taskIds == null) {
                    taskIds = new HashSet<String>();
                }
                taskIds.add(ids[1]);
                evaObjTaskIdMap.put(evaObjId, taskIds);
            }
            IMultiPerfEvaObject iPerfEvaObject = MultiPerfEvaObjectFactory.getLocalInstance(ctx);
            IEmpLaborRelationHis iEmpLaborRelationHis = EmpLaborRelationHisFactory.getLocalInstance((Context)ctx);
            String transmitName = "administrator";
            String transmitNumber = "administrator";
            String ksql = "";
            String objIds = "('" + Strings.join(newObjIdSet, (String)"','") + "')";
            ksql = isOrg ? " select *,multiPeriod.*,multiPeriod.multiPerfplan.name,adminOrgUnit.*,adminOrgUnit.company.name,leader.person.id  where id in " + objIds : " select *,person.id,person.name,person.number,multiPeriod.*,multiPeriod.multiPerfplan.name,perfFile.position.name,perfFile.adminOrgUnit.name,perfFile.employeeType.name  where id in " + objIds;
            MultiPerfEvaObjectCollection evaObjectColl = iPerfEvaObject.getMultiPerfEvaObjectCollection(ksql);
            List langList = BOSConfigUtil.getLanguageMapingList();
            int evaObjSize = evaObjectColl.size();
            for (int i = 0; i < evaObjSize; ++i) {
                String number = "";
                String org = "";
                String enterDate = "";
                String personId = "";
                String orgNumber = "";
                MultiPerfEvaObjectInfo objectInfo = evaObjectColl.get(i);
                if (isOrg) {
                    orgNumber = objectInfo.getAdminOrgUnit().getNumber();
                } else {
                    personId = objectInfo.getPerson().getId().toString();
                    String hisOql = "where person ='" + personId + "'";
                    EmpLaborRelationHisCollection hisCollection = iEmpLaborRelationHis.getEmpLaborRelationHisCollection(hisOql);
                    for (int k = 0; k < hisCollection.size(); ++k) {
                        if (hisCollection.get(k).getLEFFDT() == null || !DateTimeUtils.dayEquals((Date)hisCollection.get(k).getLEFFDT(), (Date)HRUtil.getMaxEndDate()) || hisCollection.get(k).getEnterDate() == null) continue;
                        enterDate = DateTimeUtils.format((Date)hisCollection.get(k).getEnterDate(), (String)"yyyy-MM-dd");
                    }
                    number = objectInfo.getPerson().getNumber();
                }
                String perfPeriod = objectInfo.getMultiPeriod().getName();
                String perfPeriod_start = DateTimeUtils.format((Date)objectInfo.getMultiPeriod().getPStartDate(), (String)"yyyy-MM-dd");
                String perfPeriod_end = DateTimeUtils.format((Date)objectInfo.getMultiPeriod().getPEndDate(), (String)"yyyy-MM-dd");
                String perfPeriodEvaStart = DateTimeUtils.format((Date)objectInfo.getMultiPeriod().getEvaStartDate(), (String)"yyyy-MM-dd");
                String perfPeriodEvaend = DateTimeUtils.format((Date)objectInfo.getMultiPeriod().getEvaEndDate(), (String)"yyyy-MM-dd");
                String representation = "";
                HashMap<String, String> varMap = new HashMap<String, String>();
                for (int i1 = 0; i1 < langList.size(); ++i1) {
                    String lang = (String)((Map)langList.get(i1)).get("lang");
                    Locale locale = null;
                    if ("l1".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l1;
                    } else if ("l2".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l2;
                    } else if ("l3".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l3;
                    }
                    if (locale == null) continue;
                    String perfPlan = objectInfo.getMultiPeriod().getMultiPerfplan().getName(locale);
                    perfPeriod = objectInfo.getMultiPeriod().getName(locale);
                    if (isOrg) {
                        org = objectInfo.getAdminOrgUnit().getCompany().getName(locale);
                        String orgName = objectInfo.getAdminOrgUnit().getName(locale);
                        orgName = orgName == null ? objectInfo.getName(locale) : orgName;
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ORG_NUMBER, locale), orgNumber);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ORG_NAME, locale), orgName);
                    } else {
                        String name = objectInfo.getPerson().getName(locale);
                        org = objectInfo.getPerfFile().getAdminOrgUnit().getName(locale);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNUMBER, locale), number);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNAME, locale), name);
                        String position = objectInfo.getPerfFile().getPosition().getName(locale);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFPOSITION, locale), position);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ENTRYDATE, locale), enterDate);
                    }
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.AFFILIATEDORG, locale), org);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPLAN, locale), perfPlan);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPERIOD, locale), perfPeriod);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPERIODSTART, locale), perfPeriod_start);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REPRESENTATIONEND, locale), perfPeriod_end);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPERIODEVASTART, locale), perfPeriodEvaStart);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REPRESENTATIONEVAEND, locale), perfPeriodEvaend);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REPRESENTATION, locale), representation);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TRANSMITNAME, locale), transmitName);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TRANSMITNUMBER, locale), transmitNumber);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DEALTIME, locale), DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    String evaObjId = objectInfo.getId().toString();
                    if (evaObjTaskIdMap != null) {
                        Set taskIds = (Set)evaObjTaskIdMap.get(objectInfo.getId().toString());
                        if (taskIds == null) continue;
                        for (String taskId : taskIds) {
                            String key = evaObjId + "$" + taskId;
                            HashMap<String, String> taskVarMap = new HashMap<String, String>();
                            if (map != null && map.get(key) != null) {
                                taskVarMap.putAll(varMap);
                                taskVarMap.putAll(map.get(key));
                            }
                            reMap.put(key, taskVarMap);
                        }
                        continue;
                    }
                    if (map != null && map.get(objectInfo.getId().toString()) != null) {
                        varMap.putAll(map.get(objectInfo.getId().toString()));
                    }
                    reMap.put(evaObjId, varMap);
                }
            }
        }
        catch (BOSException e) {
            logger.error("[perfweb_MessageTemplateUtils#getVarDataByObjIdArray]MessageTemplate find perfObj information fail!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("[perfweb_MessageTemplateUtils#getVarDataByObjIdArray]MessageTemplate find perfObj information fail!", (Throwable)e);
        }
        return reMap;
    }

    public static MessageTemplateDefineCollection getMessageTemplateById(Context ctx, String templateId) {
        MessageTemplateDefineCollection messageTempDefColl = new MessageTemplateDefineCollection();
        if (!StringUtil.isEmptyString((String)templateId)) {
            try {
                IMessageTemplateDefine msgTempDef = MessageTemplateDefineFactory.getLocalInstance(ctx);
                String oql = "select *,messageTemplate.* where messageTemplate='" + templateId + "'";
                messageTempDefColl = msgTempDef.getMessageTemplateDefineCollection(oql);
            }
            catch (BOSException e) {
                logger.error("According to the template id failed to get the message content collection:" + e.getMessage());
            }
        }
        return messageTempDefColl;
    }

    private void replaceVar(Context ctx, MessageTemplateDefineCollection messageTempDefColl) {
        if (messageTempDefColl != null && messageTempDefColl.size() > 0) {
            try {
                int defCollSize = messageTempDefColl.size();
                String sysTitle = "";
                String sysTitle_l1 = "";
                String sysTitle_l2 = "";
                String sysTitle_l3 = "";
                String sysContent = "";
                String sysContent_l1 = "";
                String sysContent_l2 = "";
                String sysContent_l3 = "";
                String emailTitle = "";
                String emailContent = "";
                String yzjContent = "";
                for (int i = 0; i < defCollSize; ++i) {
                    MessageTemplateDefineInfo info = messageTempDefColl.get(i);
                    if (1 != info.getMessageType().getValue()) continue;
                    sysTitle = info.getTemplateTitle();
                    sysTitle_l1 = info.getTemplateTitle(LocaleUtils.locale_en_US);
                    sysTitle_l2 = info.getTemplateTitle(LocaleUtils.locale_zh_CN);
                    sysTitle_l3 = info.getTemplateTitle(LocaleUtils.locale_zh_TW);
                    sysContent = info.getTemplateContent();
                    sysContent_l1 = info.getTemplateContent(LocaleUtils.locale_en_US);
                    sysContent_l2 = info.getTemplateContent(LocaleUtils.locale_zh_CN);
                    sysContent_l3 = info.getTemplateContent(LocaleUtils.locale_zh_TW);
                }
                for (String key : this.receiveMap.keySet()) {
                    ReMsgBean reMsgBean = this.receiveMap.get(key);
                    String obj = reMsgBean.getObjs().iterator().next();
                    Map<String, String> varMap = this.objVarKV.get(obj);
                    reMsgBean.setSysTitle(MsgBean.replaceVar(varMap, sysTitle));
                    reMsgBean.setSysTitle_l1(MsgBean.replaceVar(varMap, sysTitle_l1));
                    reMsgBean.setSysTitle_l2(MsgBean.replaceVar(varMap, sysTitle_l2));
                    reMsgBean.setSysTitle_l3(MsgBean.replaceVar(varMap, sysTitle_l3));
                    reMsgBean.setSysContent(MsgBean.replaceVar(varMap, sysContent));
                    reMsgBean.setSysContent_l1(MsgBean.replaceVar(varMap, sysContent_l1));
                    reMsgBean.setSysContent_l2(MsgBean.replaceVar(varMap, sysContent_l2));
                    reMsgBean.setSysContent_l3(MsgBean.replaceVar(varMap, sysContent_l3));
                    Locale locale = PersonLocaleUtils.getLocalByPersonId(ctx, reMsgBean.getReceiver().getId().toString());
                    logger.error("current local lang is\uff1a " + locale.toString());
                    for (int i = 0; i < defCollSize; ++i) {
                        MessageTemplateDefineInfo info = messageTempDefColl.get(i);
                        if (4 == info.getMessageType().getValue()) {
                            yzjContent = info.getTemplateContent(locale);
                            continue;
                        }
                        if (2 != info.getMessageType().getValue()) continue;
                        emailContent = info.getTemplateContent(locale);
                        emailTitle = info.getTemplateTitle(locale);
                    }
                    reMsgBean.setEmailTitle(MsgBean.replaceVar(varMap, emailTitle));
                    reMsgBean.setEmailContent(MsgBean.replaceVar(varMap, emailContent));
                    reMsgBean.setYzjContent(MsgBean.replaceVar(varMap, yzjContent));
                }
            }
            catch (Exception e) {
                logger.error("[perfweb_MsgBean#replaceVar] MessageTemplate replace varValue file", (Throwable)e);
            }
        }
    }

    public static String replaceVar(Map<String, String> varMap, String content) {
        if (content == null || content.length() == 0 || varMap == null) {
            return content;
        }
        String reg = "\\[\\[.*?\\]\\]";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String varName = matcher.group(0);
            String temp = varMap.get(varName) == null ? "$$" : varMap.get(varName);
            content = content.replace(varName, temp);
        }
        return content;
    }

    public void setMsgTempId(String msgTempId) {
        this.msgTempId = msgTempId;
    }

    private void setReceiver(Context ctx) {
        String receivIdStr = "('" + Strings.join(this.receiveIds, (String)"','") + "')";
        try {
            PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("where id in " + receivIdStr);
            if (personCollection != null) {
                HashMap<String, PersonInfo> personMap = new HashMap<String, PersonInfo>();
                int size = personCollection.size();
                for (int i = 0; i < size; ++i) {
                    personMap.put(personCollection.get(i).getId().toString(), personCollection.get(i));
                }
                for (String key : this.receiveMap.keySet()) {
                    String receiveId = key.split("\\$\\$")[0];
                    ReMsgBean reMsgBean = this.receiveMap.get(key);
                    reMsgBean.setReceiver((PersonInfo)personMap.get(receiveId));
                }
            }
        }
        catch (BOSException e) {
            logger.error("perfweb_MsgBean setReceiver have error!please check!", (Throwable)e);
        }
    }

    public MsgConfigBean getConfig() {
        return this.config;
    }

    public void setConfig(MsgConfigBean config) {
        this.config = config;
    }

    private Map<String, Map<String, String>> getSumCalVar(Context ctx, Set<String> objIdSet, Map<String, Map<String, String>> map, boolean isOrg) {
        HashMap<String, Map<String, String>> reMap = new HashMap<String, Map<String, String>>();
        try {
            if (CollectionUtils.isEmpty(objIdSet)) {
                return reMap;
            }
            IPerfSummaryPersonEvaObject iPerfEvaObject = PerfSummaryPersonEvaObjectFactory.getLocalInstance(ctx);
            IEmpLaborRelationHis iEmpLaborRelationHis = EmpLaborRelationHisFactory.getLocalInstance((Context)ctx);
            String transmitName = "administrator";
            String transmitNumber = "administrator";
            String currentPersonId = HRFilterUtils.getCurrentPersonId((Context)ctx);
            PersonInfo currentPerson = null;
            if (!StringUtils.isEmpty((String)currentPersonId)) {
                PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select name,number where id = '" + currentPersonId + "'");
                if (personCollection != null && personCollection.size() > 0) {
                    currentPerson = personCollection.get(0);
                }
                transmitNumber = currentPerson.getNumber();
            }
            String ksql = "";
            String objIds = "('" + Strings.join(objIdSet, (String)"','") + "')";
            if (isOrg) {
                return reMap;
            }
            ksql = " select id,person.id,person.name,person.number,perfSummarySchemeBase.name,perfSummarySchemeBase.periodStr,perfSummarySchemeBase.appealDays,perfSummarySchemeBase.periodStartDate,perfSummarySchemeBase.periodEndDate,position.name,adminOrgUnit.name  where id in " + objIds;
            PerfSummaryPersonEvaObjectCollection evaObjectColl = iPerfEvaObject.getPerfSummaryPersonEvaObjectCollection(ksql);
            List langList = BOSConfigUtil.getLanguageMapingList();
            int evaObjSize = evaObjectColl.size();
            for (int i = 0; i < evaObjSize; ++i) {
                String number = "";
                String org = "";
                String enterDate = "";
                String personId = "";
                String orgNumber = "";
                String state = "";
                PerfSummaryPersonEvaObjectInfo objectInfo = evaObjectColl.get(i);
                if (isOrg) {
                    orgNumber = "";
                } else {
                    personId = objectInfo.getPerson().getId().toString();
                    String hisOql = "where person ='" + personId + "'";
                    EmpLaborRelationHisCollection hisCollection = iEmpLaborRelationHis.getEmpLaborRelationHisCollection(hisOql);
                    for (int k = 0; k < hisCollection.size(); ++k) {
                        if (hisCollection.get(k).getLEFFDT() == null || !DateTimeUtils.dayEquals((Date)hisCollection.get(k).getLEFFDT(), (Date)HRUtil.getMaxEndDate()) || hisCollection.get(k).getEnterDate() == null) continue;
                        enterDate = DateTimeUtils.format((Date)hisCollection.get(k).getEnterDate(), (String)"yyyy-MM-dd");
                    }
                    number = objectInfo.getPerson().getNumber();
                }
                PerfSummarySchemeBaseInfo perfSummarySchemeBase = objectInfo.getPerfSummarySchemeBase();
                String perfPeriod = perfSummarySchemeBase.getPeriodStr();
                String perfPeriod_start = DateTimeUtils.format((Date)perfSummarySchemeBase.getPeriodStartDate(), (String)"yyyy-MM-dd");
                String perfPeriod_end = DateTimeUtils.format((Date)perfSummarySchemeBase.getPeriodEndDate(), (String)"yyyy-MM-dd");
                String perfPeriodEvaStart = "";
                String perfPeriodEvaend = "";
                String representation = "";
                HashMap<String, String> varMap = new HashMap<String, String>();
                for (int i1 = 0; i1 < langList.size(); ++i1) {
                    String lang = (String)((Map)langList.get(i1)).get("lang");
                    Locale locale = null;
                    if ("l1".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l1;
                    } else if ("l2".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l2;
                    } else if ("l3".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l3;
                    }
                    if (locale == null) continue;
                    String perfPlan = perfSummarySchemeBase.getName(locale);
                    if (isOrg) {
                        org = "";
                        String orgName = "";
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ORG_NUMBER, locale), orgNumber);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ORG_NAME, locale), orgName);
                    } else {
                        String name = objectInfo.getPerson().getName(locale);
                        state = "";
                        org = objectInfo.getAdminOrgUnit().getName(locale);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNUMBER, locale), number);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNAME, locale), name);
                        String position = objectInfo.getPosition().getName(locale);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFPOSITION, locale), position);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ENTRYDATE, locale), enterDate);
                    }
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.AFFILIATEDORG, locale), org);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RELATIONSTATE, locale), state);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPLAN, locale), perfPlan);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPERIOD, locale), perfPeriod);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPERIODSTART, locale), perfPeriod_start);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REPRESENTATIONEND, locale), perfPeriod_end);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPERIODEVASTART, locale), perfPeriodEvaStart);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REPRESENTATIONEVAEND, locale), perfPeriodEvaend);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REPRESENTATION, locale), representation);
                    if (currentPerson != null) {
                        transmitName = currentPerson.getName(locale);
                    }
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TRANSMITNAME, locale), transmitName);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TRANSMITNUMBER, locale), transmitNumber);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DEALTIME, locale), DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    if (map != null && map.get(objectInfo.getId().toString()) != null) {
                        varMap.putAll(map.get(objectInfo.getId().toString()));
                    }
                    reMap.put(objectInfo.getId().toString(), varMap);
                }
            }
        }
        catch (BOSException e) {
            logger.error("[perfweb_MessageTemplateUtils#getSumCalVar]MessageTemplate find perfObj information fail!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("[perfweb_MessageTemplateUtils#getSumCalVar]MessageTemplate find perfObj information fail!", (Throwable)e);
        }
        return reMap;
    }
}

