/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.comprehensive.baseformula;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.exception.SalaryException;
import com.kingdee.shr.validaterule.exception.SalarySimulateException;
import com.kingdee.shr.validaterule.formula.SalaryCalFunction2;
import com.kingdee.shr.validaterule.formula.SalaryCalculator2;
import com.kingdee.shr.validaterule.formula.base.data.ColumnAttributes;
import com.kingdee.shr.validaterule.formula.base.data.DataRow;
import com.kingdee.shr.validaterule.formula.base.data.DataSet;
import com.kingdee.shr.validaterule.formula.base.data.DataTable;
import com.kingdee.shr.validaterule.formula.base.data.DataTypes;
import com.kingdee.shr.validaterule.formula.base.vo.ErrRow;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SumAssessmentSimulateCalculator
extends SalaryCalculator2 {
    private static Logger logger = Logger.getLogger(SumAssessmentSimulateCalculator.class);
    private JSONArray calData;
    private JSONArray simulateResult = new JSONArray();
    private Set<String> calItems = new HashSet<String>();

    protected void initParamter(Context ctx, Map<String, Object> param) throws EASBizException, JSONException {
        this.calData = new JSONArray((String)param.get("calData"));
        this.setMainTableName((String)param.get("mainTable"));
        this.setMainTableAlias((String)param.get("mainTableAlias"));
        this.setCalCategoryNum((String)param.get("calCategoryNum"));
        this.setSchemeID((String)param.get("calSchemeID"));
        this.setCtx(ctx);
        this.setEndDate(new Date());
        this.setMainTableRowFilter((String)param.get("condition"));
        this.setCalFormulas("'" + (String)param.get("formulaId") + "'");
        this.setSimilation(true);
        Object outerData = param.get("outerData");
        if (outerData != null) {
            this.setOuterData(outerData);
        }
    }

    public JSONArray testExecute(Context ctx, Map<String, Object> param) throws Exception {
        this.initParamter(ctx, param);
        this.run();
        Sheet resutSheet = this.getCalResult();
        if (resutSheet != null && resutSheet.getErrDataList() != null && resutSheet.getErrDataList().size() > 0) {
            throw new Exception(((ErrRow)resutSheet.getErrDataList().get(0)).getErrMsg());
        }
        return this.simulateResult;
    }

    protected SalaryCalFunction2 initCalInstance(Map<String, Object> allCnSnMap, BaseFormulaCollection searchCalFormula) throws SalaryException {
        SalaryCalFunction2 calObj = super.initCalInstance(allCnSnMap, searchCalFormula);
        return calObj;
    }

    protected DataSet initCalData(Map<String, String> assTable) throws EASBizException {
        DataSet dataSet = super.initCalData(assTable);
        this.reAssembleCalData(dataSet);
        return dataSet;
    }

    private void reAssembleCalData(DataSet dataSet) throws EASBizException {
        DataTable dataTable = dataSet.getTables(this.getMainTableName());
        ColumnAttributes[] allColumns = dataTable.getAllColumns();
        HashMap<String, Integer> cellIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < allColumns.length; ++i) {
            cellIndexMap.put(allColumns[i].getName().toUpperCase(Locale.ENGLISH), i);
        }
        DataRow[] rows = dataTable.getAllRows();
        for (int i = 0; i < rows.length; ++i) {
            DataRow row = rows[i];
            try {
                for (int k = 0; k < this.calData.length(); ++k) {
                    JSONObject data = this.calData.getJSONObject(k);
                    if (data.has("isCal")) {
                        this.calItems.add(data.getString("fieldSn"));
                    }
                    if (!this.reAssembleItem(row, data, cellIndexMap) && !this.reAssembleVar(row, data, dataTable)) continue;
                }
                continue;
            }
            catch (JSONException e) {
                throw new SalarySimulateException(SalarySimulateException.PARAMPARSE, (Throwable)e);
            }
        }
    }

    private boolean reAssembleItem(DataRow row, JSONObject data, Map<String, Integer> cellIndexMap) throws EASBizException, JSONException {
        if (data.has("fieldSn")) {
            String fieldSn = String.valueOf(data.get("fieldSn"));
            String rowKey = this.getMainTableAlias() + "." + fieldSn;
            Integer rowKeyIndex = cellIndexMap.get(rowKey.toUpperCase(Locale.ENGLISH));
            if (rowKeyIndex != null) {
                if (data.has("isNum") && "N".equals(data.get("isNum"))) {
                    row.setValue(rowKeyIndex.intValue(), (Object)data.getString("value"));
                } else {
                    row.setValue(rowKeyIndex.intValue(), data.getDouble("value"));
                }
                return true;
            }
        }
        return false;
    }

    private boolean reAssembleVar(DataRow row, JSONObject data, DataTable dataTable) throws EASBizException, JSONException {
        if (data.has("varset")) {
            ColumnAttributes columnAttributes = new ColumnAttributes();
            columnAttributes.setIndex(dataTable.columns.size());
            columnAttributes.setName(data.getString("varset"));
            columnAttributes.setVar(true);
            if (data.has("isNum") && "N".equals(data.get("isNum"))) {
                columnAttributes.setType(DataTypes.STRING);
                row.add((Object)data.getString("value"));
            } else {
                columnAttributes.setType(DataTypes.FLOAT);
                row.add((Object)data.getDouble("value"));
            }
            dataTable.columns.add(columnAttributes);
            return true;
        }
        return false;
    }

    protected void handleCalResult(Map<String, Object> allCnSnMap, Sheet result, Map<String, Object> calResult) throws SalaryException {
        for (String calItem : this.calItems) {
            JSONObject node = new JSONObject();
            try {
                node.put("fieldSn", (Object)calItem);
                String key = this.getMainTableName() + "_" + calItem;
                node.put("value", calResult.get(key.toUpperCase(Locale.ENGLISH)));
            }
            catch (JSONException e) {
                throw new SalarySimulateException(SalarySimulateException.PARAMPARSE, (Throwable)e);
            }
            this.simulateResult.put((Object)node);
        }
    }

    protected Map<String, Object> initEditedItems() {
        HashMap<String, Object> EditedItems = new HashMap<String, Object>();
        return EditedItems;
    }
}

