/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.formulaplatform.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.scm.framework.bizflow.util.CollectionUtil;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileAssignTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileInfo;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileStateEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvalplanCycleTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.IEvaResultSummary;
import com.kingdee.shr.perfweb.app.base.evalplan.IIndicatorTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IOrgEvaResultSummary;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodFactory;
import com.kingdee.shr.perfweb.formulaplatform.data.Tools;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.shr.perfweb.utils.PerfDateUtils;
import com.kingdee.shr.perfweb.utils.PerfWorkFlowUtils;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GetHistoryEvaluresutService {
    private static Logger logger = LoggerFactory.getLogger(GetHistoryEvaluresutService.class);
    private Context ctx = Tools.getInstance().getCtx();
    private static final String GET_SCORE = "1";
    private static final String GET_GRADE = "2";
    private static final String MODE_MULTI = "004";
    public static final String LEFT_PARENTHESIS = "(";
    public static final String RIGHT_PARENTHESIS = ")";
    public static final String LEFT_BRACKETS = "[";
    public static final String RIGHT_BRACKETS = "]";
    public static final String LEFT_BRACE = "{";
    public static final String RIGHT_BRACE = "}";
    public static final String COMMA = ",";

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public double getHisEvaluResultScore(Map<String, Object> params, String year, String frequency, String timeOffset, String evaluMode) throws EASBizException, BOSException {
        String score = this.getHisEvaluResultByType(params, year, frequency, timeOffset, evaluMode, GET_SCORE);
        if (!StringUtils.isEmpty((CharSequence)score)) {
            return Double.parseDouble(score);
        }
        return 0.0;
    }

    public String getHisEvaluResultGrade(Map<String, Object> params, String year, String frequency, String timeOffset, String evaluMode) throws EASBizException, BOSException {
        return this.getHisEvaluResultByType(params, year, frequency, timeOffset, evaluMode, GET_GRADE);
    }

    public double getOrgHisEvaluResultScore(Map<String, Object> params, String orgNumber, String year, String frequency, String timeOffset, String evaluMode) throws EASBizException, BOSException {
        String score = this.getOrgHisEvaluResultByType(params, orgNumber, year, frequency, timeOffset, evaluMode, GET_SCORE);
        if (!StringUtils.isEmpty((CharSequence)score)) {
            return Double.parseDouble(score);
        }
        return 0.0;
    }

    public String getOrgHisEvaluResultGrade(Map<String, Object> params, String orgNumber, String year, String frequency, String timeOffset, String evaluMode) throws EASBizException, BOSException {
        return this.getOrgHisEvaluResultByType(params, orgNumber, year, frequency, timeOffset, evaluMode, GET_GRADE);
    }

    public String getHisEvaluResultByType(Map<String, Object> params, String year, String frequency, String timeOffset, String evaluMode, String resultType) throws EASBizException, BOSException {
        String perfFile;
        EvaResultSummaryCollection evaResultColl;
        logger.error("\u3010PERFWEB\u3011--begin invoke getHisEvaluResult ....");
        long start = System.currentTimeMillis();
        String returnValue = "";
        String evaObj = (String)params.get("T_EVA_INDICATORTARGET_FEVAOBJID");
        PerfEvaObjectInfo evaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(this.ctx, evaObj);
        PerfPeriodInfo periodInfo = new PerfPeriodInfo();
        if (evaObjInfo != null && evaObjInfo.getPeriod() != null && evaObjInfo.getPeriod().getId() != null) {
            periodInfo = this.getCurrentPerfperiodInfo(this.ctx, evaObjInfo.getPeriod().getId().toString());
        }
        if ("0".equals(evaluMode)) {
            evaluMode = periodInfo.getPerfRule().getEvaluMode().getNumber();
        }
        Set<String> periodSet = this.getPeriodColl(periodInfo, year, frequency, timeOffset, evaluMode, false);
        String personId = evaObjInfo.getPerson().getId().toString();
        if (!CollectionUtils.isEmpty(periodSet)) {
            FilterInfo filter = new FilterInfo();
            if (MODE_MULTI.equals(evaluMode)) {
                StringBuffer businessIdSb = new StringBuffer("select FID from T_EVA_MultiPerfEvaObject where FPerfFileID='");
                businessIdSb.append(evaObjInfo.getPerfFile().getId().toString()).append("'");
                filter.getFilterItems().add(new FilterItemInfo("multiPeriod", periodSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("businessId", (Object)businessIdSb.toString(), CompareType.INNER));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("period", periodSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("evaObj.perfFile.id", (Object)evaObjInfo.getPerfFile().getId().toString(), CompareType.EQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)HRBillStateEnum.AUDITED.getValue()));
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selector = viewInfo.getSelector();
            selector.add("id");
            selector.add("perfFile.state");
            selector.add("lastSumScore");
            selector.add("lastGradeLevel");
            viewInfo.setFilter(filter);
            IEvaResultSummary iResultSummary = EvaResultSummaryFactory.getLocalInstance(this.ctx);
            EvaResultSummaryCollection evaResultSummaryColl = iResultSummary.getEvaResultSummaryCollection(viewInfo);
            if ((evaResultSummaryColl == null || evaResultSummaryColl.isEmpty()) && PerfFileAssignTypeEnum.MAIN.equals((Object)evaObjInfo.getPerfFile().getAssignType())) {
                filter = new FilterInfo();
                if (MODE_MULTI.equals(evaluMode)) {
                    String oql = "select id, perfFile.state where person.id = '" + personId + "' and perfFile.assignType = 1";
                    MultiPerfEvaObjectCollection colls = MultiPerfEvaObjectFactory.getLocalInstance(this.ctx).getMultiPerfEvaObjectCollection(oql);
                    if (colls != null && colls.size() > 0) {
                        HashSet<String> evaObjIds = new HashSet<String>();
                        Iterator it = colls.iterator();
                        while (it.hasNext()) {
                            MultiPerfEvaObjectInfo multiEvaObj = (MultiPerfEvaObjectInfo)it.next();
                            evaObjIds.add(multiEvaObj.getId().toString());
                        }
                        filter.getFilterItems().add(new FilterItemInfo("multiPeriod", periodSet, CompareType.INCLUDE));
                        filter.getFilterItems().add(new FilterItemInfo("businessId", evaObjIds, CompareType.INCLUDE));
                    }
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("period", periodSet, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("evaObj.perfFile.assignType", (Object)1));
                    filter.getFilterItems().add(new FilterItemInfo("evaObj.person.id", (Object)personId));
                }
                filter.getFilterItems().add(new FilterItemInfo("billState", (Object)HRBillStateEnum.AUDITED.getValue()));
                viewInfo.setFilter(filter);
                evaResultSummaryColl = iResultSummary.getEvaResultSummaryCollection(viewInfo);
            }
            if (null != evaResultSummaryColl && evaResultSummaryColl.size() > 0) {
                EvaResultSummaryInfo resultSummaryInfo = evaResultSummaryColl.get(0);
                if (evaResultSummaryColl.size() > 1) {
                    Iterator it = evaResultSummaryColl.iterator();
                    while (it.hasNext()) {
                        EvaResultSummaryInfo result = (EvaResultSummaryInfo)it.next();
                        PerfFileInfo perfFileInfo = result.getPerfFile();
                        if (perfFileInfo == null || !PerfFileStateEnum.ENABLE.equals((Object)perfFileInfo.getState())) continue;
                        resultSummaryInfo = result;
                    }
                }
                if (resultType.equals(GET_SCORE)) {
                    returnValue = String.valueOf(resultSummaryInfo.get("lastSumScore"));
                } else if (resultType.equals(GET_GRADE)) {
                    returnValue = (String)resultSummaryInfo.get("lastGradeLevel");
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)returnValue) && null != (evaResultColl = this.getManualEntryResult(this.ctx, periodInfo, year, frequency, timeOffset, evaluMode, perfFile = evaObjInfo.getPerfFile().getId().toString(), personId)) && evaResultColl.size() > 0) {
            if (evaResultColl.size() > 1) {
                return "0";
            }
            if (resultType.equals(GET_SCORE)) {
                returnValue = String.valueOf(evaResultColl.get(0).get("lastSumScore"));
            } else if (resultType.equals(GET_GRADE)) {
                returnValue = (String)evaResultColl.get(0).get("lastGradeLevel");
            }
        }
        long end = System.currentTimeMillis();
        logger.error("\u3010PERFWEB\u3011--end invoke getHisEvaluResult ,takes time " + (end - start) + "ms");
        if (null != returnValue) {
            return returnValue.equals("null") ? "" : returnValue;
        }
        return returnValue;
    }

    public String getOrgHisEvaluResultByType(Map<String, Object> params, String orgNumber, String year, String frequency, String timeOffset, String evaluMode, String resultType) throws EASBizException, BOSException {
        AdminOrgUnitInfo parent;
        AdminOrgUnitInfo adminOrgUnitInfo;
        AdminOrgUnitInfo currentAdminOrg;
        logger.error("\u3010PERFWEB\u3011--begin invoke getOrgHisEvaluResultByType ....");
        long start = System.currentTimeMillis();
        String returnValue = "";
        String evaObj = (String)params.get("T_EVA_INDICATORTARGET_FEVAOBJID");
        FilterInfo evaObjFilter = new FilterInfo();
        evaObjFilter.getFilterItems().add(new FilterItemInfo("id", (Object)evaObj, CompareType.EQUALS));
        EntityViewInfo evaObjViewInfo = new EntityViewInfo();
        SelectorItemCollection evaObjSic = evaObjViewInfo.getSelector();
        evaObjSic.add("id");
        evaObjSic.add("period.id");
        evaObjSic.add("evaluOrgAdmin.id");
        evaObjSic.add("perfFile.adminOrgUnit.id");
        evaObjViewInfo.setFilter(evaObjFilter);
        PerfEvaObjectInfo evaObjInfo = null;
        PerfEvaObjectCollection evaObjColl = PerfEvaObjectFactory.getLocalInstance(this.ctx).getPerfEvaObjectCollection(evaObjViewInfo);
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)evaObjColl)) {
            evaObjInfo = evaObjColl.get(0);
        }
        if (evaObjInfo == null) {
            if (logger.isDebugEnabled()) {
                logger.error("[PERFWEB]it is failed to get evaObjInfo");
            }
            return "";
        }
        PerfPeriodInfo periodInfo = new PerfPeriodInfo();
        if (evaObjInfo.getPeriod() != null && evaObjInfo.getPeriod().getId() != null) {
            periodInfo = this.getCurrentPerfperiodInfo(this.ctx, evaObjInfo.getPeriod().getId().toString());
        }
        if ("0".equals(evaluMode)) {
            evaluMode = periodInfo.getPerfRule().getEvaluMode().getNumber();
        }
        if (null == (currentAdminOrg = evaObjInfo.getEvaluOrgAdmin())) {
            currentAdminOrg = evaObjInfo.getPerfFile().getAdminOrgUnit();
        }
        String currentAdminId = currentAdminOrg.getId().toString();
        String superAdminId = "";
        String orgNumberCode = orgNumber;
        IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)this.ctx);
        SelectorItemCollection adminOrgSic = new SelectorItemCollection();
        if ("0".equals(orgNumber) || GET_GRADE.equalsIgnoreCase(orgNumber)) {
            adminOrgSic.add("department.number");
            adminOrgUnitInfo = adminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentAdminId), adminOrgSic);
            if (adminOrgUnitInfo.getDepartment() == null) {
                return returnValue;
            }
            orgNumber = adminOrgUnitInfo.getDepartment().getNumber();
            superAdminId = adminOrgUnitInfo.getDepartment().getId().toString();
        } else if (GET_SCORE.equals(orgNumber)) {
            adminOrgSic.add("department.parent.number");
            adminOrgUnitInfo = adminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentAdminId), adminOrgSic);
            if (adminOrgUnitInfo.getDepartment() == null || adminOrgUnitInfo.getDepartment().getParent() == null) {
                return returnValue;
            }
            parent = adminOrgUnitInfo.getDepartment().getParent();
            orgNumber = parent.getNumber();
            superAdminId = parent.getId().toString();
        } else if ("3".equalsIgnoreCase(orgNumber) || "4".equalsIgnoreCase(orgNumber)) {
            adminOrgSic.add("company.number");
            adminOrgUnitInfo = adminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentAdminId), adminOrgSic);
            if (adminOrgUnitInfo.getCompany() == null) {
                return returnValue;
            }
            orgNumber = adminOrgUnitInfo.getCompany().getNumber();
            superAdminId = adminOrgUnitInfo.getCompany().getId().toString();
        }
        returnValue = this.getEvaSummaryResult(orgNumber, year, frequency, timeOffset, evaluMode, resultType, returnValue, periodInfo);
        while (StringUtils.isEmpty((CharSequence)returnValue) && (GET_GRADE.equals(orgNumberCode) || "4".equals(orgNumberCode))) {
            adminOrgSic = new SelectorItemCollection();
            adminOrgSic.add("parent.number");
            adminOrgUnitInfo = adminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(superAdminId), adminOrgSic);
            parent = adminOrgUnitInfo.getParent();
            if (null == parent) {
                return returnValue;
            }
            orgNumber = parent.getNumber();
            superAdminId = parent.getId().toString();
            returnValue = this.getEvaSummaryResult(orgNumber, year, frequency, timeOffset, evaluMode, resultType, returnValue, periodInfo);
        }
        long end = System.currentTimeMillis();
        logger.error("\u3010PERFWEB\u3011--end invoke getOrgHisEvaluResultByType ,takes time " + (end - start) + "ms");
        return returnValue.equals("null") ? "" : returnValue;
    }

    private String getEvaSummaryResult(String orgNumber, String year, String frequency, String timeOffset, String evaluMode, String resultType, String returnValue, PerfPeriodInfo periodInfo) throws BOSException {
        Set<String> periodSet = this.getPeriodColl(periodInfo, year, frequency, timeOffset, evaluMode, true);
        if (!CollectionUtil.isEmpty(periodSet)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("period", periodSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("adminOrgNumber", (Object)orgNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)HRBillStateEnum.AUDITED.getValue()));
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selector = viewInfo.getSelector();
            selector.add("id");
            selector.add("lastSumScore");
            selector.add("lastGradeLevel");
            viewInfo.setFilter(filter);
            IOrgEvaResultSummary iResultSummary = OrgEvaResultSummaryFactory.getLocalInstance(this.ctx);
            OrgEvaResultSummaryCollection evaResultSummaryColl = iResultSummary.getOrgEvaResultSummaryCollection(viewInfo);
            if (evaResultSummaryColl.size() < 1) {
                evaResultSummaryColl = this.getManualEntryOrgResult(this.ctx, periodInfo, year, frequency, timeOffset, evaluMode, orgNumber);
            }
            if (null != evaResultSummaryColl && evaResultSummaryColl.size() > 0) {
                if (resultType.equals(GET_SCORE)) {
                    returnValue = String.valueOf(evaResultSummaryColl.get(0).get("lastSumScore"));
                } else if (resultType.equals(GET_GRADE)) {
                    returnValue = (String)evaResultSummaryColl.get(0).get("lastGradeLevel");
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)returnValue)) {
            AbstractObjectCollection evaResultSummaryColl;
            if (MODE_MULTI.equals(evaluMode)) {
                evaResultSummaryColl = this.getManualMulti360OrgEntryResult(this.ctx, periodInfo.getYear(), periodInfo.getCycleType().getValue(), year, frequency, timeOffset, evaluMode, orgNumber);
                if (null != evaResultSummaryColl && evaResultSummaryColl.size() > 0) {
                    if (resultType.equals(GET_SCORE)) {
                        returnValue = String.valueOf(evaResultSummaryColl.get(0).get("lastSumScore"));
                    } else if (resultType.equals(GET_GRADE)) {
                        returnValue = (String)evaResultSummaryColl.get(0).get("lastGradeLevel");
                    }
                }
            } else {
                evaResultSummaryColl = this.getManualEntryOrgResult(this.ctx, periodInfo, year, frequency, timeOffset, evaluMode, orgNumber);
                if (null != evaResultSummaryColl && evaResultSummaryColl.size() > 0) {
                    if (resultType.equals(GET_SCORE)) {
                        returnValue = String.valueOf(evaResultSummaryColl.get(0).get("lastSumScore"));
                    } else if (resultType.equals(GET_GRADE)) {
                        returnValue = (String)evaResultSummaryColl.get(0).get("lastGradeLevel");
                    }
                }
            }
        }
        return returnValue;
    }

    public double getTargetHisEvaluResult(Map<String, Object> params, String year, String frequency, String timeOffset, String evaluMode) throws EASBizException, BOSException {
        String score = this.getIndicatorScoreOrGrade(params, year, frequency, timeOffset, evaluMode, "0");
        if (!StringUtils.isEmpty((CharSequence)score)) {
            return Double.valueOf(score);
        }
        return 0.0;
    }

    public String getTargetHisEvaluGrade(Map<String, Object> params, String year, String frequency, String timeOffset, String evaluMode) throws EASBizException, BOSException {
        String grade = this.getIndicatorScoreOrGrade(params, year, frequency, timeOffset, evaluMode, "3");
        return grade;
    }

    protected String getIndicatorScoreOrGrade(Map<String, Object> params, String year, String frequency, String timeOffset, String evaluMode, String calItem) throws BOSException {
        String returnValue = null;
        String evaObj = (String)params.get("T_EVA_INDICATORTARGET_FEVAOBJID");
        String targetId = (String)params.get("T_EVA_INDICATORTARGET_FID");
        PerfEvaObjectInfo evaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(this.ctx, evaObj);
        PerfPeriodInfo periodInfo = new PerfPeriodInfo();
        if (evaObjInfo != null && evaObjInfo.getPeriod() != null && evaObjInfo.getPeriod().getId() != null) {
            periodInfo = this.getCurrentPerfperiodInfo(this.ctx, evaObjInfo.getPeriod().getId().toString());
            this.getCurrentPerfperiodInfo(this.ctx, evaObjInfo.getPeriod().getId().toString());
        }
        IndicatorTargetInfo indicatorTargetInfo = GetEntityInfoUtils.getIndicatorTargetByTarget(this.ctx, targetId);
        if ("0".equals(evaluMode)) {
            evaluMode = periodInfo.getPerfRule().getEvaluMode().getNumber();
        }
        Set<String> periodSet = this.getPeriodColl(periodInfo, year, frequency, timeOffset, evaluMode, false);
        HashSet<Integer> wfset = new HashSet<Integer>(3);
        HashSet<String> evaObjSet = new HashSet<String>(4);
        wfset.add(3);
        wfset.add(4);
        wfset.add(5);
        FilterInfo evaResutFilter = new FilterInfo();
        evaResutFilter.getFilterItems().add(new FilterItemInfo("period", periodSet, CompareType.INCLUDE));
        evaResutFilter.getFilterItems().add(new FilterItemInfo("evaObj.perfFile.id", (Object)evaObjInfo.getPerfFile().getId().toString(), CompareType.EQUALS));
        evaResutFilter.getFilterItems().add(new FilterItemInfo("evaObj.workFlowStatus", wfset, CompareType.INCLUDE));
        evaResutFilter.getFilterItems().add(new FilterItemInfo("billState", (Object)3, CompareType.EQUALS));
        EntityViewInfo evaresultView = new EntityViewInfo();
        SelectorItemCollection evaresultSic = evaresultView.getSelector();
        evaresultSic.add("id");
        evaresultSic.add("evaObj.id");
        evaresultView.setFilter(evaResutFilter);
        EvaResultSummaryCollection evaresultColl = EvaResultSummaryFactory.getLocalInstance(this.ctx).getEvaResultSummaryCollection(evaresultView);
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)evaresultColl)) {
            int erSize = evaresultColl.size();
            for (int i = 0; i < erSize; ++i) {
                evaObjSet.add(evaresultColl.get(i).getEvaObj().getId().toString());
            }
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj", evaObjSet, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("id");
        selector.add("refTarget");
        selector.add("score");
        selector.add("number");
        selector.add("name");
        selector.add("grade");
        viewInfo.setFilter(filter);
        IIndicatorTarget iIndicatorTarget = IndicatorTargetFactory.getLocalInstance(this.ctx);
        IndicatorTargetCollection indicatorColl = iIndicatorTarget.getIndicatorTargetCollection(viewInfo);
        if (null != indicatorColl && indicatorColl.size() > 0) {
            int indiSize = indicatorColl.size();
            boolean hasHistorScore = false;
            String indicatorReftarget = indicatorTargetInfo.getRefTarget();
            String indiTargetNumber = StringUtils.isEmpty((CharSequence)indicatorTargetInfo.getNumber()) ? "" : indicatorTargetInfo.getNumber();
            for (int i = 0; i < indiSize; ++i) {
                PerformanceRuleInfo ruleInfo;
                String refTargetNumber;
                IndicatorTargetInfo info = indicatorColl.get(i);
                String string = refTargetNumber = StringUtils.isEmpty((CharSequence)info.getNumber()) ? "" : info.getNumber();
                if (null != indicatorReftarget && (indicatorReftarget.equals(info.getId().toString()) || indicatorReftarget.equals(info.getRefTarget()))) {
                    hasHistorScore = true;
                } else if (indicatorTargetInfo.getName().equals(info.getName()) && indiTargetNumber.equals(refTargetNumber)) {
                    hasHistorScore = true;
                }
                if (!hasHistorScore) continue;
                if (calItem.equals("0")) {
                    if (null == info.getScore()) break;
                    returnValue = info.getScore();
                    break;
                }
                if (!calItem.equals("3")) continue;
                if (null != info.getGrade()) {
                    returnValue = info.getGrade();
                    break;
                }
                if (null == info.getScore() || null == (ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfo(this.ctx, periodInfo.getPerfRule().getId().toString())).getScoreRate()) break;
                returnValue = new PerfGoasFillService().getCurrentSelectVal(this.ctx, ruleInfo.getScoreRate().getId().toString(), Float.valueOf(info.getScore()).floatValue());
                break;
            }
        }
        return returnValue;
    }

    public double getOrgTargetHisEvaluResult(Map<String, Object> params, String orgNumber, String year, String frequency, String timeOffset, String evaluMode) throws EASBizException, BOSException {
        String score = this.getOrgIndicatorScoreOrGrade(params, orgNumber, year, frequency, timeOffset, evaluMode, "0");
        if (!StringUtils.isEmpty((CharSequence)score)) {
            return Double.valueOf(score);
        }
        return 0.0;
    }

    public String getOrgTargetHisEvaluGrade(Map<String, Object> params, String orgNumber, String year, String frequency, String timeOffset, String evaluMode) throws EASBizException, BOSException {
        String grade = this.getOrgIndicatorScoreOrGrade(params, orgNumber, year, frequency, timeOffset, evaluMode, "0");
        return grade;
    }

    protected String getOrgIndicatorScoreOrGrade(Map<String, Object> params, String orgNumber, String year, String frequency, String timeOffset, String evaluMode, String calItem) throws BOSException {
        AdminOrgUnitInfo currentAdminOrg;
        String returnValue = null;
        String evaObj = (String)params.get("T_EVA_INDICATORTARGET_FEVAOBJID");
        String targetId = (String)params.get("T_EVA_INDICATORTARGET_FID");
        FilterInfo evaObjFilter = new FilterInfo();
        evaObjFilter.getFilterItems().add(new FilterItemInfo("id", (Object)evaObj, CompareType.EQUALS));
        EntityViewInfo evaObjViewInfo = new EntityViewInfo();
        SelectorItemCollection evaObjSic = evaObjViewInfo.getSelector();
        evaObjSic.add("id");
        evaObjSic.add("period.id");
        evaObjSic.add("evaluOrgAdmin.id");
        evaObjSic.add("evaluOrgAdmin.parent.number");
        evaObjSic.add("evaluOrgAdmin.number");
        evaObjSic.add("evaluOrgAdmin.parent.id");
        evaObjSic.add("adminOrgUnit.number");
        evaObjSic.add("adminOrgUnit.id");
        evaObjSic.add("adminOrgUnit.parent.id");
        evaObjSic.add("adminOrgUnit.parent.number");
        evaObjViewInfo.setFilter(evaObjFilter);
        PerfEvaObjectInfo evaObjInfo = new PerfEvaObjectInfo();
        PerfEvaObjectCollection evaObjColl = PerfEvaObjectFactory.getLocalInstance(this.ctx).getPerfEvaObjectCollection(evaObjViewInfo);
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)evaObjColl)) {
            evaObjInfo = evaObjColl.get(0);
        }
        PerfPeriodInfo periodInfo = new PerfPeriodInfo();
        if (evaObjInfo != null && evaObjInfo.getPeriod() != null && evaObjInfo.getPeriod().getId() != null) {
            periodInfo = this.getCurrentPerfperiodInfo(this.ctx, evaObjInfo.getPeriod().getId().toString());
        }
        if ("0".equals(evaluMode)) {
            evaluMode = periodInfo.getPerfRule().getEvaluMode().getNumber();
        }
        if (null == (currentAdminOrg = evaObjInfo.getEvaluOrgAdmin())) {
            currentAdminOrg = evaObjInfo.getAdminOrgUnit();
        }
        if ("0".equals(orgNumber)) {
            orgNumber = currentAdminOrg.getNumber();
        } else if (GET_SCORE.equals(orgNumber)) {
            orgNumber = currentAdminOrg.getParent().getNumber();
        }
        IndicatorTargetInfo indicatorTargetInfo = GetEntityInfoUtils.getIndicatorTargetByTarget(this.ctx, targetId);
        Set<String> periodSet = this.getPeriodColl(periodInfo, year, frequency, timeOffset, evaluMode, true);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("perfPeriod", periodSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("evaObj.evaluOrgAdmin.number", (Object)orgNumber, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("id");
        selector.add("refTarget");
        selector.add("score");
        selector.add("number");
        selector.add("name");
        viewInfo.setFilter(filter);
        IIndicatorTarget iIndicatorTarget = IndicatorTargetFactory.getLocalInstance(this.ctx);
        IndicatorTargetCollection indicatorColl = iIndicatorTarget.getIndicatorTargetCollection(viewInfo);
        if (null != indicatorColl && indicatorColl.size() > 0) {
            int indiSize = indicatorColl.size();
            String indiTargetNumber = StringUtils.isEmpty((CharSequence)indicatorTargetInfo.getNumber()) ? "" : indicatorTargetInfo.getNumber();
            boolean hasHistorScore = false;
            String indicatorReftarget = indicatorTargetInfo.getRefTarget();
            for (int i = 0; i < indiSize; ++i) {
                String refTargetNumber;
                IndicatorTargetInfo info = indicatorColl.get(i);
                String string = refTargetNumber = StringUtils.isEmpty((CharSequence)info.getNumber()) ? "" : info.getNumber();
                if (null != indicatorReftarget && (indicatorReftarget.equals(info.getId().toString()) || indicatorReftarget.equals(info.getRefTarget()))) {
                    hasHistorScore = true;
                } else if (indicatorTargetInfo.getName().equals(info.getName()) && indiTargetNumber.equals(refTargetNumber)) {
                    hasHistorScore = true;
                }
                if (!hasHistorScore) continue;
                if (calItem.equals("0")) {
                    if (null == info.getScore()) break;
                    returnValue = info.getScore();
                    break;
                }
                if (!calItem.equals("3")) continue;
                if (null == info.getGrade()) break;
                returnValue = info.getGrade();
                break;
            }
        }
        return returnValue;
    }

    public double getHisTargetVal(Map<String, Object> params, String indicatorNumber, String year, String frequency, String timeOffset, String evaluMode) throws EASBizException, BOSException {
        Map<String, String> funParams = this.assembleTargetFunParam(indicatorNumber, year, frequency, timeOffset, evaluMode);
        String targetField = "targetValue";
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("targetValue"));
        return this.getEvaluHisVal(params, funParams, selector, "targetValue", false);
    }

    public double getHisActualVal(Map<String, Object> params, String indicatorNumber, String year, String frequency, String timeOffset, String evaluMode) throws EASBizException, BOSException {
        Map<String, String> funParams = this.assembleTargetFunParam(indicatorNumber, year, frequency, timeOffset, evaluMode);
        String targetField = "actualCompleValue";
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("actualCompleValue"));
        return this.getEvaluHisVal(params, funParams, selector, "actualCompleValue", false);
    }

    private double getEvaluHisVal(Map<String, Object> params, Map<String, String> funParams, SelectorItemCollection selector, String getTargetField, Boolean isOrg) throws BOSException {
        Set<String> periodSet;
        IndicatorTargetCollection currentIndicatorColl;
        String targetId;
        double returnValue = 0.0;
        if (CollectionUtils.isEmpty(funParams) || selector == null || selector.size() < 1 || StringUtils.isEmpty((CharSequence)getTargetField)) {
            return returnValue;
        }
        if (isOrg == null) {
            isOrg = false;
        }
        String indicatorNumber = funParams.get("indicatorNumber");
        String orgNumber = funParams.get("orgNumber");
        String year = funParams.get("year");
        String frequency = funParams.get("frequency");
        String timeOffset = funParams.get("timeOffset");
        String evaluMode = funParams.get("evaluMode");
        String evaObj = (String)params.get("T_EVA_INDICATORTARGET_FEVAOBJID");
        IIndicatorTarget iIndicatorTarget = IndicatorTargetFactory.getLocalInstance(this.ctx);
        if ("0".equals(indicatorNumber) && !StringUtils.isEmpty((CharSequence)(targetId = (String)params.get("T_EVA_INDICATORTARGET_FID"))) && (currentIndicatorColl = iIndicatorTarget.getIndicatorTargetCollection("select number where id = '" + targetId + "'")) != null && currentIndicatorColl.size() > 0) {
            indicatorNumber = currentIndicatorColl.get(0).getNumber();
        }
        PerfEvaObjectInfo evaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(this.ctx, evaObj);
        PerfPeriodInfo periodInfo = new PerfPeriodInfo();
        if (evaObjInfo != null && evaObjInfo.getPeriod() != null && evaObjInfo.getPeriod().getId() != null) {
            periodInfo = this.getCurrentPerfperiodInfo(this.ctx, evaObjInfo.getPeriod().getId().toString());
        }
        if ("0".equals(evaluMode)) {
            evaluMode = periodInfo.getPerfRule().getEvaluMode().getNumber();
        }
        if ((periodSet = this.getPeriodColl(periodInfo, year, frequency, timeOffset, evaluMode, (boolean)isOrg)) == null || periodSet.size() <= 0) {
            return returnValue;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        filterItems.add(new FilterItemInfo("perfPeriod", periodSet, CompareType.INCLUDE));
        filterItems.add(new FilterItemInfo("number", (Object)indicatorNumber, CompareType.EQUALS));
        if (evaObjInfo != null) {
            if (isOrg.booleanValue()) {
                AdminOrgUnitInfo currentAdminOrg = evaObjInfo.getEvaluOrgAdmin();
                if (null == currentAdminOrg) {
                    currentAdminOrg = evaObjInfo.getAdminOrgUnit();
                }
                if ("0".equals(orgNumber)) {
                    orgNumber = currentAdminOrg.getNumber();
                } else if (GET_SCORE.equals(orgNumber)) {
                    orgNumber = currentAdminOrg.getParent().getNumber();
                }
                filter.getFilterItems().add(new FilterItemInfo("evaObj.evaluOrgAdmin.number", (Object)orgNumber, CompareType.EQUALS));
            } else {
                filterItems.add(new FilterItemInfo("evaObj.perfFile.id", (Object)evaObjInfo.getPerfFile().getId().toString(), CompareType.EQUALS));
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(selector);
        filterItems.add(new FilterItemInfo("actCompValState", (Object)GET_SCORE));
        viewInfo.setFilter(filter);
        IndicatorTargetCollection indicatorColl = iIndicatorTarget.getIndicatorTargetCollection(viewInfo);
        if (null != indicatorColl && indicatorColl.size() > 0 && null != indicatorColl.get(0).get(getTargetField)) {
            returnValue = Double.valueOf(indicatorColl.get(0).getString(getTargetField));
        }
        return returnValue;
    }

    public double getOrgHisTargetVal(Map<String, Object> params, String indicatorNumber, String orgNumber, String year, String frequency, String timeOffset, String evaluMode) throws EASBizException, BOSException {
        Map<String, String> funParams = this.assembleTargetFunParam(indicatorNumber, year, frequency, timeOffset, evaluMode);
        funParams.put("orgNumber", orgNumber);
        String targetField = "targetValue";
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("targetValue"));
        return this.getEvaluHisVal(params, funParams, selector, "targetValue", true);
    }

    public double getOrgHisActualVal(Map<String, Object> params, String indicatorNumber, String orgNumber, String year, String frequency, String timeOffset, String evaluMode) throws EASBizException, BOSException {
        Map<String, String> funParams = this.assembleTargetFunParam(indicatorNumber, year, frequency, timeOffset, evaluMode);
        funParams.put("orgNumber", orgNumber);
        String targetField = "actualCompleValue";
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("actualCompleValue"));
        return this.getEvaluHisVal(params, funParams, selector, "actualCompleValue", true);
    }

    private Map<String, String> assembleTargetFunParam(String indicatorNumber, String year, String frequency, String timeOffset, String evaluMode) {
        HashMap<String, String> funParams = new HashMap<String, String>();
        funParams.put("indicatorNumber", indicatorNumber);
        funParams.put("year", year);
        funParams.put("frequency", frequency);
        funParams.put("timeOffset", timeOffset);
        funParams.put("evaluMode", evaluMode);
        return funParams;
    }

    protected Set<String> getPeriodColl(PerfPeriodInfo periodInfo, String year, String frequency, String timeOffset, String evaluMode, boolean isOrg) {
        HashSet<String> periodSet;
        block4: {
            int cycleType;
            int perfYear;
            int curPeriodTime;
            int timeOffsetInt;
            block3: {
                timeOffsetInt = Integer.parseInt(timeOffset);
                int curYear = Integer.valueOf(periodInfo.getYear());
                curPeriodTime = Integer.valueOf(periodInfo.getTimePeriod());
                perfYear = 0;
                perfYear = Integer.parseInt(year) < 0 ? PerfDateUtils.getRelativeYear(Integer.parseInt(year), curYear) : PerfDateUtils.getRelativeYear(Integer.parseInt(year), curYear);
                cycleType = 100;
                cycleType = Integer.parseInt(frequency) == 0 ? periodInfo.getCycleType().getValue() : this.converseCycleType(Integer.parseInt(frequency));
                periodSet = new HashSet<String>(8);
                if (!MODE_MULTI.equals(evaluMode)) break block3;
                MultiPerfPeriodCollection periodColl = this.getMultiPeriodColl(timeOffsetInt, perfYear, cycleType, curPeriodTime);
                if (null == periodColl || periodColl.size() <= 0) break block4;
                int periodSize = periodColl.size();
                for (int i = 0; i < periodSize; ++i) {
                    periodSet.add(periodColl.get(i).getId().toString());
                }
                break block4;
            }
            PerfPeriodCollection periodColl = this.getPeriodColl(timeOffsetInt, evaluMode, perfYear, cycleType, curPeriodTime, isOrg);
            if (null != periodColl && periodColl.size() > 0) {
                int periodSize = periodColl.size();
                for (int i = 0; i < periodSize; ++i) {
                    periodSet.add(periodColl.get(i).getId().toString());
                }
            }
        }
        return periodSet;
    }

    protected int converseCycleType(int frequency) {
        int cycleType = 100;
        switch (frequency) {
            case 1: {
                cycleType = 100;
                break;
            }
            case 2: {
                cycleType = 200;
                break;
            }
            case 3: {
                cycleType = 300;
                break;
            }
            case 4: {
                cycleType = 400;
            }
        }
        return cycleType;
    }

    protected PerfPeriodCollection getPeriodColl(int timeOffset, String evaluMode, int refYear, int cycleType, int curPeriodTime, boolean isOrg) {
        PerfPeriodCollection periodColl = null;
        int periodYear = refYear;
        int periodTime = curPeriodTime;
        switch (cycleType) {
            case 100: {
                periodTime = periodYear = PerfDateUtils.getRelativeYearByGiveYear(refYear, timeOffset);
                break;
            }
            case 200: 
            case 300: 
            case 400: {
                periodTime = timeOffset;
            }
        }
        if (timeOffset == 0) {
            periodTime = curPeriodTime;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)periodYear, CompareType.EQUALS));
        if (cycleType != 100) {
            filter.getFilterItems().add(new FilterItemInfo("timePeriod", (Object)periodTime, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("cycleType", (Object)cycleType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("perfRule.evaluMode.number", (Object)evaluMode, CompareType.EQUALS));
        if (isOrg) {
            filter.getFilterItems().add(new FilterItemInfo("perfPlan.isOrg", (Object)GET_SCORE, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("perfPlan.isOrg", (Object)GET_SCORE, CompareType.NOTEQUALS));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("id");
        viewInfo.setFilter(filter);
        try {
            periodColl = PerfPeriodFactory.getLocalInstance(this.ctx).getPerfPeriodCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return periodColl;
    }

    protected EvaResultSummaryCollection getManualEntryResult(Context ctx, PerfPeriodInfo curPeriod, String offsetYear, String frequency, String timeOffset, String perfModel, String perfFile, String personId) {
        int currentYear = Integer.valueOf(curPeriod.getYear());
        int curCycleType = curPeriod.getCycleType().getValue();
        int perfYear = 0;
        perfYear = Integer.parseInt(offsetYear) < 0 ? PerfDateUtils.getRelativeYear(Integer.parseInt(offsetYear), currentYear) : PerfDateUtils.getRelativeYear(Integer.parseInt(offsetYear), currentYear);
        int cycleType = 100;
        int periodYear = perfYear;
        int curPeriodTime = Integer.valueOf(curPeriod.getTimePeriod());
        Integer timeOffsetInt = Integer.valueOf(timeOffset);
        int periodTime = timeOffsetInt;
        cycleType = Integer.parseInt(frequency) == 0 ? curCycleType : this.converseCycleType(Integer.parseInt(frequency));
        switch (cycleType) {
            case 100: {
                periodTime = periodYear = PerfDateUtils.getRelativeYearByGiveYear(perfYear, timeOffsetInt);
                break;
            }
            case 200: 
            case 300: 
            case 400: {
                periodTime = timeOffsetInt;
            }
        }
        if (timeOffsetInt == 0) {
            periodTime = curPeriodTime;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        filterItems.add(new FilterItemInfo("periodYear", (Object)perfYear, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("periodType", (Object)cycleType, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("periodTime", (Object)periodTime, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("perfModel.number", (Object)perfModel, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("isImportByHand", (Object)GET_SCORE));
        filterItems.add(new FilterItemInfo("perfFile", (Object)perfFile, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("id");
        selector.add("lastSumScore");
        selector.add("lastGradeLevel");
        viewInfo.setFilter(filter);
        try {
            EvaResultSummaryCollection evaResultColl = EvaResultSummaryFactory.getLocalInstance(ctx).getEvaResultSummaryCollection(viewInfo);
            if (evaResultColl == null || evaResultColl.size() < 1) {
                filterItems.removeObject(filterItems.size() - 1);
                filterItems.add(new FilterItemInfo("person", (Object)personId));
                evaResultColl = EvaResultSummaryFactory.getLocalInstance(ctx).getEvaResultSummaryCollection(viewInfo);
            }
            return evaResultColl;
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            return null;
        }
    }

    protected EvaResultSummaryCollection getManualMulti360OrgEntryResult(Context ctx, String curYear, int curCycleType, String offsetYear, String frequency, String timeOffset, String perfModel, String orgNumber) {
        int currentYear = Integer.valueOf(curYear);
        int perfYear = 0;
        perfYear = Integer.parseInt(offsetYear) < 0 ? PerfDateUtils.getRelativeYear(Integer.parseInt(offsetYear), currentYear) : PerfDateUtils.getRelativeYear(Integer.parseInt(offsetYear), currentYear);
        int cycleType = 100;
        int periodYear = perfYear;
        int periodTime = Integer.valueOf(timeOffset);
        cycleType = Integer.parseInt(frequency) == 0 ? curCycleType : this.converseCycleType(Integer.parseInt(frequency));
        switch (cycleType) {
            case 100: {
                periodTime = periodYear = PerfDateUtils.getRelativeYearByGiveYear(perfYear, Integer.valueOf(timeOffset));
                break;
            }
            case 200: 
            case 300: 
            case 400: {
                periodTime = Integer.valueOf(timeOffset);
            }
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)perfYear, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)cycleType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodTime", (Object)periodTime, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("perfModel.number", (Object)perfModel, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("adminOrgNumber", (Object)orgNumber, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("id");
        selector.add("lastSumScore");
        selector.add("lastGradeLevel");
        viewInfo.setFilter(filter);
        try {
            EvaResultSummaryCollection evaResultColl = EvaResultSummaryFactory.getLocalInstance(ctx).getEvaResultSummaryCollection(viewInfo);
            return evaResultColl;
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            return null;
        }
    }

    protected OrgEvaResultSummaryCollection getManualEntryOrgResult(Context ctx, PerfPeriodInfo curPeriod, String offsetYear, String frequency, String timeOffset, String perfModel, String orgNumber) {
        int currentYear = Integer.valueOf(curPeriod.getYear());
        int curCycleType = curPeriod.getCycleType().getValue();
        int perfYear = 0;
        perfYear = Integer.parseInt(offsetYear) < 0 ? PerfDateUtils.getRelativeYear(Integer.parseInt(offsetYear), currentYear) : PerfDateUtils.getRelativeYear(Integer.parseInt(offsetYear), currentYear);
        int cycleType = 100;
        int periodYear = perfYear;
        int curPeriodTime = Integer.valueOf(curPeriod.getTimePeriod());
        Integer timeOffsetInt = Integer.valueOf(timeOffset);
        int periodTime = timeOffsetInt;
        cycleType = Integer.parseInt(frequency) == 0 ? curCycleType : this.converseCycleType(Integer.parseInt(frequency));
        switch (cycleType) {
            case 100: {
                periodTime = periodYear = PerfDateUtils.getRelativeYearByGiveYear(perfYear, timeOffsetInt);
                break;
            }
            case 200: 
            case 300: 
            case 400: {
                periodTime = timeOffsetInt;
            }
        }
        if (timeOffsetInt == 0 && cycleType != 100) {
            periodTime = curPeriodTime;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)perfYear, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)cycleType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodTime", (Object)periodTime, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("perfModel.number", (Object)perfModel, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgNumber, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("id");
        selector.add("lastSumScore");
        selector.add("lastGradeLevel");
        viewInfo.setFilter(filter);
        try {
            OrgEvaResultSummaryCollection evaResultColl = OrgEvaResultSummaryFactory.getLocalInstance(ctx).getOrgEvaResultSummaryCollection(viewInfo);
            return evaResultColl;
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            return null;
        }
    }

    protected MultiPerfPeriodCollection getMultiPeriodColl(int timeOffset, int refYear, int cycleType, int curPeriodTime) {
        MultiPerfPeriodCollection periodColl = null;
        int periodYear = refYear;
        int periodTime = curPeriodTime;
        switch (cycleType) {
            case 100: {
                periodTime = periodYear = PerfDateUtils.getRelativeYearByGiveYear(refYear, timeOffset);
                break;
            }
            case 200: 
            case 300: 
            case 400: {
                periodTime = timeOffset;
            }
        }
        if (timeOffset == 0) {
            periodTime = curPeriodTime;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)periodYear, CompareType.EQUALS));
        if (cycleType != 100) {
            filter.getFilterItems().add(new FilterItemInfo("timePeriod", (Object)periodTime, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("cycleType", (Object)cycleType, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("id");
        viewInfo.setFilter(filter);
        try {
            periodColl = MultiPerfPeriodFactory.getLocalInstance(this.ctx).getMultiPerfPeriodCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return periodColl;
    }

    protected int getCurPeriodTime(int cycleType, int curPeriodTime) {
        int periodTime = 0;
        Date today = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        switch (cycleType) {
            case 100: {
                periodTime = calendar.get(1);
                break;
            }
            case 200: {
                int month = 3;
                if (month >= 5) {
                    periodTime = 2;
                    break;
                }
                periodTime = 1;
                break;
            }
            case 300: {
                int month = 3;
                if (month < 4) {
                    periodTime = 1;
                    break;
                }
                if (month >= 4 && month < 7) {
                    periodTime = 2;
                    break;
                }
                if (month >= 7 && month < 10) {
                    periodTime = 3;
                    break;
                }
                periodTime = 4;
                break;
            }
            case 400: {
                periodTime = 3;
            }
        }
        return periodTime;
    }

    protected PerfPeriodInfo getCurrentPerfperiodInfo(Context ctx, String period) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)period, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add("number");
        sic.add("timePeriod");
        sic.add("cycleType");
        sic.add("year");
        sic.add("perfRule.evaluMode.number");
        sic.add("perfRule.id");
        viewInfo.setFilter(filter);
        try {
            PerfPeriodCollection coll = PerfPeriodFactory.getLocalInstance(ctx).getPerfPeriodCollection(viewInfo);
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)coll)) {
                return coll.get(0);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return null;
    }

    public double deductScore(Map<String, Object> params, String deductParam) {
        BigDecimal result;
        block24: {
            result = new BigDecimal("0.00");
            String evaObj = (String)params.get("T_EVA_INDICATORTARGET_FEVAOBJID");
            String indicatorId = (String)params.get("T_EVA_INDICATORTARGET_FID");
            IndicatorTargetInfo indicatorTargetInfo = GetEntityInfoUtils.getIndicatorTargetByTarget(this.ctx, indicatorId);
            String actualCompleteVal = indicatorTargetInfo.getActualCompleValue();
            BigDecimal completeVal = new BigDecimal("0.00");
            if (!StringUtils.isEmpty((CharSequence)actualCompleteVal)) {
                completeVal = new BigDecimal(actualCompleteVal);
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("period.perfRule.pariMutual.max"));
            sic.add(new SelectorItemInfo("id"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)evaObj, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            try {
                PerfEvaObjectCollection evaObjColl = PerfEvaObjectFactory.getLocalInstance(this.ctx).getPerfEvaObjectCollection(viewInfo);
                if (evaObjColl.isEmpty()) break block24;
                BigDecimal max = evaObjColl.get(0).getPeriod().getPerfRule().getPariMutual().getMax();
                String rgex = "\\{(.*?)\\}";
                Pattern pattern = Pattern.compile(rgex);
                Matcher m = pattern.matcher(deductParam);
                while (m.find()) {
                    int i = 1;
                    String group = m.group(i);
                    String[] arr = group.split(COMMA);
                    String leftBracket = String.valueOf(arr[0].charAt(0));
                    String leftParam = arr[0].substring(1, arr[0].length());
                    String rightParma = arr[1].substring(0, arr[1].length() - 1);
                    String rightBracket = String.valueOf(arr[1].charAt(arr[1].length() - 1));
                    BigDecimal deductScore = new BigDecimal(arr[2]);
                    if (!StringUtils.isEmpty((CharSequence)leftParam)) {
                        BigDecimal left = new BigDecimal(leftParam);
                        if (!StringUtils.isEmpty((CharSequence)rightParma)) {
                            BigDecimal right = new BigDecimal(rightParma);
                            if (leftBracket.equals(LEFT_BRACKETS)) {
                                if (rightBracket.equals(RIGHT_BRACKETS) && completeVal.compareTo(left) >= 0 && completeVal.compareTo(right) <= 0) {
                                    result = max.subtract(completeVal.multiply(deductScore));
                                    break;
                                }
                                if (completeVal.compareTo(left) >= 0 && completeVal.compareTo(right) < 0) {
                                    result = max.subtract(completeVal.multiply(deductScore));
                                    break;
                                }
                            } else {
                                if (rightBracket.equals(RIGHT_BRACKETS) && completeVal.compareTo(left) > 0 && completeVal.compareTo(right) <= 0) {
                                    result = max.subtract(completeVal.multiply(deductScore));
                                    break;
                                }
                                if (completeVal.compareTo(left) > 0 && completeVal.compareTo(right) < 0) {
                                    result = max.subtract(completeVal.multiply(deductScore));
                                    break;
                                }
                            }
                        } else if (leftBracket.equals(LEFT_BRACKETS)) {
                            if (completeVal.compareTo(left) >= 0) {
                                result = max.subtract(completeVal.multiply(deductScore));
                                break;
                            }
                        } else if (completeVal.compareTo(left) > 0) {
                            result = max.subtract(completeVal.multiply(deductScore));
                            break;
                        }
                    } else if (!StringUtils.isEmpty((CharSequence)rightParma)) {
                        BigDecimal right = new BigDecimal(rightParma);
                        if (rightBracket.equals(RIGHT_BRACKETS)) {
                            if (completeVal.compareTo(right) <= 0) {
                                result = max.subtract(completeVal.multiply(deductScore));
                                break;
                            }
                        } else if (completeVal.compareTo(right) < 0) {
                            result = max.subtract(completeVal.multiply(deductScore));
                            break;
                        }
                    }
                    ++i;
                }
            }
            catch (BOSException e) {
                logger.error("BOSException", (Throwable)e);
            }
        }
        if (result.compareTo(BigDecimal.ZERO) < 0) {
            result = BigDecimal.ZERO;
        }
        return result.doubleValue();
    }

    public double getOthersScore(Map<String, Object> params, String year, String frequency, String othersType, String periodOffset, String evaluMode, String hrOrgUnit, String employeeType) throws EASBizException, BOSException {
        EvaResultSummaryInfo othersEvaResult = this.getOthersEvaResult(this.ctx, params, year, frequency, othersType, periodOffset, evaluMode, hrOrgUnit, employeeType);
        return othersEvaResult.getLastSumScore();
    }

    public String getOthersGrade(Map<String, Object> params, String year, String frequency, String othersType, String periodOffset, String evaluMode, String hrOrgUnit, String employeeType) throws EASBizException, BOSException {
        EvaResultSummaryInfo othersEvaResult = this.getOthersEvaResult(this.ctx, params, year, frequency, othersType, periodOffset, evaluMode, hrOrgUnit, employeeType);
        return othersEvaResult.getLastGradeLevel();
    }

    public EvaResultSummaryInfo getOthersEvaResult(Context ctx, Map<String, Object> params, String year, String frequency, String othersType, String periodOffset, String evaluMode, String hrOrgUnit, String employeeType) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((CharSequence)year)) {
            throw new BOSException("param [year] is null");
        }
        if (StringUtils.isEmpty((CharSequence)frequency)) {
            throw new BOSException("param [frequency] is null");
        }
        if (StringUtils.isEmpty((CharSequence)othersType)) {
            throw new BOSException("param [othersType] is null");
        }
        if (StringUtils.isEmpty((CharSequence)periodOffset)) {
            throw new BOSException("param [period] is null");
        }
        if (StringUtils.isEmpty((CharSequence)evaluMode)) {
            throw new BOSException("param [evaluMode] is null");
        }
        String evaObj = (String)params.get("T_EVA_INDICATORTARGET_FEVAOBJID");
        PerfEvaObjectInfo evaObjectInfo = PerfEvaObjectFactory.getLocalInstance(ctx).getPerfEvaObjectInfo("select id,isOrg,perfFile.assignType,perfFile.position,perfFile.adminOrgUnit.responPosition.id,adminHis.responPosition.id,period.year where id = '" + evaObj + "'");
        PerfPeriodInfo period = evaObjectInfo.getPeriod();
        String curYear = period.getYear();
        if ("0".equals(year)) {
            year = period.getYear();
        } else if (Integer.parseInt(year) < 0) {
            year = String.valueOf(PerfDateUtils.getRelativeYear(Integer.parseInt(year), Integer.parseInt(curYear)));
        }
        int frequencyType = GetHistoryEvaluresutService.convertFrequency(frequency);
        if ("0".equals(periodOffset)) {
            periodOffset = year;
        }
        boolean isOrg = OrgAssessmentUtils.isOrgAssessment(evaObjectInfo);
        int employeeTypeInt = -1;
        if (!isOrg) {
            employeeTypeInt = StringUtils.isEmpty((CharSequence)employeeType) ? evaObjectInfo.getPerfFile().getAssignType().getValue() : this.getEmployeeType(employeeType);
        }
        Set<String> personSet = this.getOthersTypePerson(ctx, evaObjectInfo, othersType, isOrg);
        EvaResultSummaryCollection evaResultSummaryCollection = GetHistoryEvaluresutService.getEvaResultSummaryCollection(ctx, year, Collections.singleton(periodOffset), frequencyType, evaluMode, hrOrgUnit, employeeTypeInt, personSet, 3);
        if (evaResultSummaryCollection == null || evaResultSummaryCollection.size() == 0) {
            throw new BOSException("current period result is empty");
        }
        if (evaResultSummaryCollection.size() > 1) {
            throw new BOSException("current period is more than one result");
        }
        EvaResultSummaryInfo evaResultSummaryInfo = evaResultSummaryCollection.get(0);
        return evaResultSummaryInfo;
    }

    public static int convertFrequency(String frequency) throws BOSException {
        switch (frequency) {
            case "Y": 
            case "100": {
                return 100;
            }
            case "H": 
            case "200": {
                return 200;
            }
            case "Q": 
            case "300": {
                return 300;
            }
            case "M": 
            case "400": {
                return 400;
            }
        }
        return GetHistoryEvaluresutService.convertFrequencyByCycleTypeEnum(frequency);
    }

    public static int convertFrequencyByCycleTypeEnum(String frequency) throws BOSException {
        if (EvalplanCycleTypeEnum.FULL_YEAR.getAlias(LocaleUtils.getDefaultLocale()).equals(frequency)) {
            return 100;
        }
        if (EvalplanCycleTypeEnum.HALF_YEAR.getAlias(LocaleUtils.getDefaultLocale()).equals(frequency)) {
            return 200;
        }
        if (EvalplanCycleTypeEnum.QUARTER.getAlias(LocaleUtils.getDefaultLocale()).equals(frequency)) {
            return 300;
        }
        if (EvalplanCycleTypeEnum.MONTHLY.getAlias(LocaleUtils.getDefaultLocale()).equals(frequency)) {
            return 400;
        }
        throw new BOSException("param [frequency] is invalid");
    }

    public static EvaResultSummaryCollection getEvaResultSummaryCollection(Context ctx, String year, Set<String> periods, int frequencyType, String evaluMode, String hrOrgUnit, int employeeType, Set<String> personSet, Integer billState) throws BOSException {
        if (CollectionUtils.isEmpty(personSet)) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("billState");
        sic.add("lastSumScore");
        sic.add("lastGradeLevel");
        evi.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        evi.setFilter(filterInfo);
        if (billState != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)billState, CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("periodYear", (Object)year, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("periodTime", periods, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("periodType", (Object)frequencyType, CompareType.EQUALS));
        if (StringUtils.isNotEmpty((CharSequence)evaluMode)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("perfModel.number", (Object)evaluMode, CompareType.EQUALS));
        }
        if (StringUtils.isNotEmpty((CharSequence)hrOrgUnit)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.number", (Object)hrOrgUnit, CompareType.EQUALS));
        }
        if (employeeType >= 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("perfFile.assignType", (Object)employeeType));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", personSet, CompareType.INCLUDE));
        return EvaResultSummaryFactory.getLocalInstance(ctx).getEvaResultSummaryCollection(evi);
    }

    private int getEmployeeType(String employeeType) throws BOSException, EASBizException {
        if (StringUtils.isNotEmpty((CharSequence)employeeType)) {
            return PerfFileAssignTypeEnum.getEnum(Integer.parseInt(employeeType)).getValue();
        }
        throw new BOSException("param [employeeType] is null");
    }

    private Set<String> getOthersTypePerson(Context ctx, PerfEvaObjectInfo evaObject, String othersType, boolean isOrg) throws BOSException, EASBizException {
        Map<String, String> personByPosition;
        String position;
        HashSet<String> result;
        block26: {
            IPosition iposition;
            block25: {
                result = new HashSet<String>();
                String otherTypeInclude = "0,1,2";
                if (!otherTypeInclude.contains(othersType)) {
                    PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select id,name where number = '" + othersType + "'");
                    if (personCollection != null && personCollection.size() > 0) {
                        if (personCollection.size() > 1) {
                            throw new BOSException("param [othersType] get more then one person");
                        }
                        result.add(personCollection.get(0).getId().toString());
                        return result;
                    }
                    throw new BOSException("param [othersType] can not get person");
                }
                position = "";
                iposition = PositionFactory.getLocalInstance((Context)ctx);
                if (!isOrg) break block25;
                switch (othersType) {
                    case "0": {
                        List<String> orgResponserIdByEvaObject = OrgAssessmentUtils.getOrgResponserIdByEvaObject(ctx, evaObject.getId().toString());
                        result.addAll(orgResponserIdByEvaObject);
                        return result;
                    }
                    case "1": {
                        if (evaObject.getAdminHis().getResponPosition() == null) break;
                        position = evaObject.getAdminHis().getResponPosition().getId().toString();
                        PositionCollection positionCollection = iposition.getPositionCollection("select parent.id where id = '" + position + "'");
                        position = "";
                        if (positionCollection != null && positionCollection.size() > 0 && positionCollection.get(0).getParent() != null) {
                            position = positionCollection.get(0).getParent().getId().toString();
                            break;
                        }
                        break block26;
                    }
                    case "2": {
                        if (evaObject.getAdminHis().getResponPosition() == null) break;
                        position = evaObject.getAdminHis().getResponPosition().getId().toString();
                        PositionCollection positionCollection = iposition.getPositionCollection("select parent.parent.id where id = '" + position + "'");
                        position = "";
                        if (positionCollection == null || positionCollection.size() <= 0 || positionCollection.get(0).getParent() == null || positionCollection.get(0).getParent().getParent() == null) break;
                        position = positionCollection.get(0).getParent().getParent().getId().toString();
                    }
                }
                break block26;
            }
            PerfFileInfo perfFile = evaObject.getPerfFile();
            switch (othersType) {
                case "0": {
                    if (perfFile.getAdminOrgUnit() == null || perfFile.getAdminOrgUnit().getResponPosition() == null) break;
                    position = perfFile.getAdminOrgUnit().getResponPosition().getId().toString();
                    break;
                }
                case "1": {
                    if (perfFile.getPosition() == null) break;
                    position = perfFile.getPosition().getId().toString();
                    PositionCollection positionCollection = iposition.getPositionCollection("select parent.id where id = '" + position + "'");
                    position = "";
                    if (positionCollection == null || positionCollection.size() <= 0 || positionCollection.get(0).getParent() == null) break;
                    position = positionCollection.get(0).getParent().getId().toString();
                    break;
                }
                case "2": {
                    if (perfFile.getPosition() == null) break;
                    position = perfFile.getPosition().getId().toString();
                    PositionCollection positionCollection = iposition.getPositionCollection("select parent.parent.id where id = '" + position + "'");
                    position = "";
                    if (positionCollection == null || positionCollection.size() <= 0 || positionCollection.get(0).getParent() == null || positionCollection.get(0).getParent().getParent() == null) break;
                    position = positionCollection.get(0).getParent().getParent().getId().toString();
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)position) && !CollectionUtils.isEmpty(personByPosition = PerfWorkFlowUtils.getPersonByPosition(ctx, position))) {
            result.addAll(personByPosition.keySet());
            return result;
        }
        throw new BOSException("param [othersType] can not get person");
    }
}

