/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.multiEvalution.commontask.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSumStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IEvaResultSummary;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.IPerfScorLevelDefine;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreLevelInfo;
import com.kingdee.shr.perfweb.app.common.BusinessOpTypeEnum;
import com.kingdee.shr.perfweb.app.common.GeneralTaskPoolFactory;
import com.kingdee.shr.perfweb.app.common.GeneralTaskPoolInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.common.YesOrNotEnum;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.IMultiEvaluInst;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaluInstFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaluInstInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiSummaryScoreDetailFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.IMultiPerfEvaObject;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPlanInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfRelationDetailsCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfRelationDetailsInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.ScoreTaskStatusEnum;
import com.kingdee.shr.perfweb.app.workflow.TaskStatusEnum;
import com.kingdee.shr.perfweb.bizmanage.utils.GetBizManageEntityUtils;
import com.kingdee.shr.perfweb.multiEvalution.commontask.utils.GetMultiEvaEntityUtils;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PerfPortalUtils;
import com.kingdee.shr.perfweb.util.PerfWorkflowOptimizationUtils;
import com.kingdee.shr.perfweb.util.PeriodUtil;
import com.kingdee.shr.perfweb.utils.PerfwebThreadPoolUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalcuMultiEvaScoreUtils {
    private static Logger logger = LoggerFactory.getLogger(CalcuMultiEvaScoreUtils.class);

    public static String calcSingleQuesScore(Context ctx, String taskId) {
        String quesScore = null;
        BigDecimal sumScore = BigDecimal.ZERO;
        int toCalcuCount = 0;
        MultiEvaluInstInfo multiEvaluInstInfo = GetMultiEvaEntityUtils.getMultiEvaluInstInfoByTaskId(ctx, taskId);
        if (null != multiEvaluInstInfo) {
            String evaluInst = multiEvaluInstInfo.getId().toString();
            StringBuffer sqlBuffer = new StringBuffer("SELECT d.FQuestionScore,q.FWeight FROM T_EVA_QuesScoreDetail d ");
            sqlBuffer.append(" LEFT JOIN T_PEF_QuestionnaireQuestion q ON d.FQuestionnaierQuestionID = q.FQuesCloudQuestionId").append(" WHERE FMultiEvaluInstID='").append(evaluInst).append("'");
            IRowSet rowset = null;
            try {
                rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
                while (rowset.next()) {
                    String score = rowset.getString("FQuestionScore");
                    String weight = rowset.getString("FWeight");
                    if (StringUtils.isEmpty((CharSequence)score) || StringUtils.isEmpty((CharSequence)weight)) continue;
                    sumScore = sumScore.add(BigDecimal.valueOf(Float.valueOf(score).floatValue() * Float.valueOf(weight).floatValue() / 100.0f));
                    ++toCalcuCount;
                }
                if (toCalcuCount > 0) {
                    quesScore = String.valueOf(PerfPortalUtils.roudUpRemainGiveDecimal(2, sumScore.floatValue()));
                }
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
            }
            catch (SQLException e) {
                logger.error("SQLException: ", (Throwable)e);
            }
        }
        return quesScore;
    }

    public static void calcuAndSaveSingleQuesScore(Context ctx, String taskId) {
        String quesScore = CalcuMultiEvaScoreUtils.calcSingleQuesScore(ctx, taskId);
        try {
            IMultiEvaluInst iMultiEvaluInst = MultiEvaluInstFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("score"));
            MultiEvaluInstInfo multiEvaluInstInfo = GetMultiEvaEntityUtils.getMultiEvaluInstInfoByTaskId(ctx, taskId);
            if (null != multiEvaluInstInfo) {
                multiEvaluInstInfo.setScore(quesScore);
                iMultiEvaluInst.updatePartial(multiEvaluInstInfo, sic);
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-SAVEQUESTIONNAIRESCOREERR\uff01", (Throwable)e);
        }
    }

    public static void calcuMutiEvaSummaryScore(Context ctx, String businessId) {
        String sumscore = null;
        String level = "";
        BigDecimal sumscoreTmp = new BigDecimal("0");
        boolean isAllNoScore = true;
        MultiPerfEvaObjectInfo multiPerfEvaObjectInfo = GetMultiEvaEntityUtils.getMultiPerfEvaObjectInfoById(ctx, businessId);
        if (null != multiPerfEvaObjectInfo) {
            if (null == multiPerfEvaObjectInfo.getMultiPerfRelationship()) {
                CalcuMultiEvaScoreUtils.createMultiEvaResummary(ctx, businessId, null, null);
                return;
            }
            String multiPeriodID = multiPerfEvaObjectInfo.getMultiPeriod().getId().toString();
            MultiPerfPeriodInfo multiPerfperiodInfo = GetMultiEvaEntityUtils.getMultiPerfPeriodInfoById(ctx, multiPeriodID);
            String planId = multiPerfperiodInfo.getMultiPerfplan().getId().toString();
            MultiPerfPlanInfo multiPerfPlanInfo = GetMultiEvaEntityUtils.getMultiPerfPlanInfoById(ctx, planId);
            String perfScore = multiPerfPlanInfo.getPerfScore().getId().toString();
            PerfScoreInfo perfScoreInfo = GetEntityInfoUtils.getPerfScoreInfoById(ctx, perfScore);
            BigDecimal maxScore = perfScoreInfo.getMax();
            String relationId = multiPerfEvaObjectInfo.getMultiPerfRelationship().getId().toString();
            MultiPerfRelationDetailsCollection multiPerfRelaDetailsColl = GetMultiEvaEntityUtils.getMultiPerfRelationDetailsCollByRelation(ctx, relationId);
            if (null != multiPerfRelaDetailsColl && multiPerfRelaDetailsColl.size() > 0) {
                int redetailSize = multiPerfRelaDetailsColl.size();
                StringBuffer sqlBuffer = new StringBuffer("select count(*) from T_EVA_MultiPerfRelationReport r ");
                sqlBuffer.append(" inner join T_EVA_MultiEvaTask t on t.FMultiPerfRelationReport=r.FID where FPerfEvaObjID='").append(businessId).append("' and FRelationDetailID=? and  t.FIsEffect='1' and t.FStatus='3'");
                StringBuffer multiEvaluInstSql = new StringBuffer("select m.FScore,t.FQuestionnaireSumScore from T_EVA_MultiEvaluInst m ");
                multiEvaluInstSql.append(" inner join T_EVA_MultiEvaTask t on m.FMultiEvaTaskID=t.FID").append(" left join T_EVA_MultiPerfRelationReport r on t.FMultiPerfRelationReport=r.FID").append(" where t.FIsEffect='1' and t.FStatus='3' and r.FRelationDetailID=? and r.FPerfEvaObjID=?");
                IRowSet rowSet = null;
                IRowSet rowSet2 = null;
                for (int i = 0; i < redetailSize; ++i) {
                    int nodeProcesserCount = 0;
                    Object[] params = new Object[1];
                    MultiPerfRelationDetailsInfo multiRelationDetailsInfo = multiPerfRelaDetailsColl.get(i);
                    params[0] = multiRelationDetailsInfo.getId().toString();
                    try {
                        float weight = Float.valueOf(multiRelationDetailsInfo.getWeight()).floatValue();
                        rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])params);
                        if (null != rowSet && rowSet.next()) {
                            nodeProcesserCount = rowSet.getInt(1);
                        }
                        Object[] params2 = new Object[]{multiRelationDetailsInfo.getId().toString(), businessId};
                        rowSet2 = DbUtil.executeQuery((Context)ctx, (String)multiEvaluInstSql.toString(), (Object[])params2);
                        BigDecimal nodeSumScore = new BigDecimal("0");
                        while (null != rowSet2 && rowSet2.next()) {
                            String score = rowSet2.getString("FScore");
                            String questionnaireSumScore = rowSet2.getString("FQuestionnaireSumScore");
                            if (StringUtils.isEmpty((CharSequence)score) || StringUtils.isEmpty((CharSequence)questionnaireSumScore) || "0".equals(questionnaireSumScore)) continue;
                            BigDecimal bgScore = new BigDecimal(score);
                            BigDecimal bgQuesSumScore = new BigDecimal(questionnaireSumScore);
                            isAllNoScore = false;
                            nodeSumScore = nodeSumScore.add(bgScore.divide(bgQuesSumScore, 6, RoundingMode.HALF_UP).multiply(maxScore));
                            logger.error("nodeSumScore is : " + nodeSumScore);
                        }
                        if (nodeProcesserCount == 0) continue;
                        nodeSumScore = nodeSumScore.divide(new BigDecimal(nodeProcesserCount), 6, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(weight)).divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
                        sumscoreTmp = sumscoreTmp.add(nodeSumScore);
                        continue;
                    }
                    catch (SQLException e) {
                        logger.error("\u3010PERFWEB\u3011-MULTIEVALUCALCSCORESQLERR\uff01", (Throwable)e);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("\u3010PERFWEB\u3011-MULTIEVALUCALCSCOREERR\uff01", (Throwable)e);
                    }
                }
            }
            if (!isAllNoScore) {
                sumscore = String.valueOf(sumscoreTmp.setScale(2, 4));
                if (multiPerfPlanInfo.getPerfRate() != null) {
                    level = CalcuMultiEvaScoreUtils.getLevelByMultiScore(ctx, multiPerfPlanInfo.getPerfRate().getId().toString(), Float.parseFloat(sumscore));
                }
            }
            CalcuMultiEvaScoreUtils.createMultiEvaResummary(ctx, businessId, sumscore, level);
            try {
                CalcuMultiEvaScoreUtils.createMultiScoreDetailTask(ctx, businessId);
                PerfwebThreadPoolUtils.startCreateMultiScoreweightDetail(ctx);
            }
            catch (Exception e) {
                logger.error("\u3010PERFWEB\u3011-invoke CalcuMultiEvaScoreUtils.createMultiScoreDetailTask(ctx, businessId) error,param is :" + businessId);
                logger.error("Exception: ", (Throwable)e);
            }
        }
    }

    public static String getLevelByMultiScore(Context ctx, String perfRateId, float score) {
        String level;
        block3: {
            level = "";
            try {
                PerfScoreLevelInfo scoreLevelInfo;
                float scoreMin = 0.0f;
                if (StringUtils.isEmpty((CharSequence)perfRateId) || (scoreLevelInfo = GetEntityInfoUtils.getPerfScoreLevelInfo(ctx, perfRateId)) == null) break block3;
                String perfScoreLevel = scoreLevelInfo.getId().toString();
                IPerfScorLevelDefine iPerfScorLevelDefine = PerfScorLevelDefineFactory.getLocalInstance(ctx);
                PerfScorLevelDefineCollection scoreLvDefColl = iPerfScorLevelDefine.getPerfScorLevelDefineCollection(" where perfScoreLevel='" + perfScoreLevel + "' order by scoreUpLimit desc");
                if (scoreLvDefColl == null || scoreLvDefColl.size() <= 0) break block3;
                PerfScorLevelDefineInfo maxDefineInfo = scoreLvDefColl.get(0);
                for (int i = 0; i < scoreLvDefColl.size(); ++i) {
                    PerfScorLevelDefineInfo scoreLevelDefineInfo = scoreLvDefColl.get(i);
                    float scoreLowLimit = scoreLevelDefineInfo.getScoreLowLimit().floatValue();
                    float scoreUpLimit = scoreLevelDefineInfo.getScoreUpLimit().floatValue();
                    if (!(score == scoreMin && scoreLowLimit == score || score > scoreLowLimit && score <= scoreUpLimit) && maxDefineInfo.getScoreUpLimit().compareTo(BigDecimal.valueOf(score)) > 0) continue;
                    level = scoreLevelDefineInfo.getPerfLevelName();
                    break;
                }
            }
            catch (BOSException e) {
                logger.error("perfweb getLevelByMultiScore hava error!", (Throwable)e);
            }
        }
        return level;
    }

    public static void createMultiEvaResummary(Context ctx, String businessId, String sumscore, String level) {
        try {
            MultiPerfEvaObjectInfo multiEvaObjectInfo = GetMultiEvaEntityUtils.getMultiPerfEvaObjectInfoById(ctx, businessId);
            if (null != multiEvaObjectInfo) {
                boolean isOrg;
                MultiPerfPeriodInfo periodInfo = GetMultiEvaEntityUtils.getMultiPerfPeriodInfoById(ctx, multiEvaObjectInfo.getMultiPeriod().getId().toString());
                MultiPerfPlanInfo planInfo = GetMultiEvaEntityUtils.getMultiPerfPlanInfoById(ctx, periodInfo.getMultiPerfplan().getId().toString());
                boolean bl = isOrg = multiEvaObjectInfo.getIsOrg() != null && 1 == multiEvaObjectInfo.getIsOrg().getValue();
                if (isOrg) {
                    CalcuMultiEvaScoreUtils.processOrgEvaResult(ctx, multiEvaObjectInfo, periodInfo, planInfo, sumscore, level);
                } else {
                    CalcuMultiEvaScoreUtils.processPersonEvaResult(ctx, multiEvaObjectInfo, periodInfo, planInfo, sumscore, level);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-CREATEMULTIEVALURESULTERR:" + e.getMessage());
        }
    }

    private static void processOrgEvaResult(Context ctx, MultiPerfEvaObjectInfo multiEvaObjectInfo, MultiPerfPeriodInfo periodInfo, MultiPerfPlanInfo planInfo, String sumscore, String level) throws BOSException, EASBizException {
        OrgEvaResultSummaryInfo evaResultSummaryInfo = PerfWorkflowOptimizationUtils.processMultiOrgEvaResultSummaryInfo(ctx, multiEvaObjectInfo, periodInfo, planInfo, sumscore, level);
        if (null != evaResultSummaryInfo) {
            OrgEvaResultSummaryFactory.getLocalInstance(ctx).save((CoreBaseInfo)evaResultSummaryInfo);
        }
    }

    private static void processPersonEvaResult(Context ctx, MultiPerfEvaObjectInfo multiEvaObjectInfo, MultiPerfPeriodInfo periodInfo, MultiPerfPlanInfo planInfo, String sumscore, String level) throws BOSException, EASBizException {
        PositionCollection positionColl;
        PerfFileInfo perfFileInfo = GetBizManageEntityUtils.getPerfFileInfo(ctx, multiEvaObjectInfo.getPerfFile().getId().toString());
        IEvaResultSummary iEvaResultSummary = EvaResultSummaryFactory.getLocalInstance(ctx);
        EvaResultSummaryInfo evaResultSummaryInfo = null;
        String businessId = multiEvaObjectInfo.getId().toString();
        if (iEvaResultSummary.exists(" where businessId='" + businessId + "'")) {
            evaResultSummaryInfo = iEvaResultSummary.getEvaResultSummaryInfo(" where businessId='" + businessId + "'");
            if (evaResultSummaryInfo.getBillState().getValue() == 3) {
                return;
            }
        } else {
            evaResultSummaryInfo = new EvaResultSummaryInfo();
            evaResultSummaryInfo.setBillState(HRBillStateEnum.SUBMITED);
            evaResultSummaryInfo.setStatus(EvaResultSumStatusEnum.NOCARRY);
        }
        evaResultSummaryInfo.setMultiPeriod(periodInfo);
        evaResultSummaryInfo.setMultiPerfPlan(planInfo);
        evaResultSummaryInfo.setEvaPlanName(planInfo.getName());
        evaResultSummaryInfo.setPeriodName(periodInfo.getName());
        evaResultSummaryInfo.setPlanNumber(planInfo.getNumber());
        evaResultSummaryInfo.setPeriodNumber(periodInfo.getNumber());
        evaResultSummaryInfo.setPnumber(multiEvaObjectInfo.getNumber());
        evaResultSummaryInfo.setPname(multiEvaObjectInfo.getName());
        evaResultSummaryInfo.setAssignType(perfFileInfo != null ? perfFileInfo.getAssignType().getAlias() : null);
        if (null != multiEvaObjectInfo.getAdminOrgUnit().getId()) {
            AdminOrgUnitInfo adminOrgUnitInfo = GetEntityInfoUtils.getAdminOrgUnitInfo(ctx, multiEvaObjectInfo.getAdminOrgUnit().getId().toString());
            evaResultSummaryInfo.put("adminOrg", multiEvaObjectInfo.getAdminOrgUnit().getId().toString());
            evaResultSummaryInfo.setAdminOrgName(adminOrgUnitInfo.getName());
            evaResultSummaryInfo.setAdminOrgNumber(adminOrgUnitInfo.getNumber());
            evaResultSummaryInfo.setAdminOrgLongNumber(adminOrgUnitInfo.getLongNumber());
        }
        evaResultSummaryInfo.put("sumScore", sumscore);
        evaResultSummaryInfo.put("gradeLevel", level);
        evaResultSummaryInfo.setIsImportByHand(YesOrNoEnum.NO);
        evaResultSummaryInfo.setPeriodYear(periodInfo.getYear());
        evaResultSummaryInfo.setPeriodType(periodInfo.getCycleType());
        evaResultSummaryInfo.setPeriodTime(Integer.parseInt(periodInfo.getTimePeriod()));
        evaResultSummaryInfo.put("perfModel", "pER9PCMLSzypG7wVLbGZqqtdChg=");
        evaResultSummaryInfo.setPerson(multiEvaObjectInfo.getPerson());
        if (null != perfFileInfo && null != perfFileInfo.getPosition().getId() && null != (positionColl = GetEntityInfoUtils.getPositionCollection(ctx, perfFileInfo.getPosition().getId().toString())) && positionColl.size() > 0) {
            PositionInfo posInfo = positionColl.get(0);
            evaResultSummaryInfo.setPositionId(perfFileInfo.getPosition().getId().toString());
            evaResultSummaryInfo.setPositionName(posInfo.getName());
        }
        if (planInfo.getPerfRate() != null) {
            evaResultSummaryInfo.put("perfScorLevel", planInfo.getPerfRate().getId().toString());
            if (!StringUtils.isEmpty((CharSequence)level)) {
                PerfScorLevelDefineInfo defineInfo = GetEntityInfoUtils.getPerfScorLevelDefineInfo(ctx, planInfo.getPerfRate().getId().toString(), level);
                evaResultSummaryInfo.put("perfScorLevelDefine", defineInfo.getId().toString());
            }
        }
        evaResultSummaryInfo.setPerfFile(perfFileInfo);
        String periodTimeNumber = PeriodUtil.getTimeNumber(String.valueOf(periodInfo.getCycleType().getValue()), periodInfo.getYear(), periodInfo.getTimePeriod());
        evaResultSummaryInfo.setPeriodTimeNumber(periodTimeNumber);
        evaResultSummaryInfo.setHrOrgUnit(multiEvaObjectInfo.getHrUnitOrg());
        evaResultSummaryInfo.setHistoryImport(false);
        if (null != perfFileInfo) {
            evaResultSummaryInfo.setUseDefault(perfFileInfo.isUseDefault());
        }
        evaResultSummaryInfo.setBusinessId(businessId);
        iEvaResultSummary.save((CoreBaseInfo)evaResultSummaryInfo);
    }

    public static boolean isAllProcesserSubmit(Context ctx, String businessId) {
        boolean flag = false;
        int totalProcesserCount = 0;
        int submittedProcesserCount = 0;
        StringBuffer sql = new StringBuffer("select count(*) from T_EVA_MultiEvaTask where FBusinessId='").append(businessId).append("' and FIsEffect='").append("1").append("'");
        String statusCondition = "('3','4')";
        StringBuffer submitSql = new StringBuffer("select count(*) from T_EVA_MultiEvaTask where FBusinessId='").append(businessId).append("' and FIsEffect='").append("1").append("' and FStatus in ").append(statusCondition);
        IRowSet rowset = null;
        IRowSet submitRowset = null;
        try {
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (null != rowset && rowset.next()) {
                totalProcesserCount = rowset.getInt(1);
            }
            if (null != (submitRowset = DbUtil.executeQuery((Context)ctx, (String)submitSql.toString())) && submitRowset.next()) {
                submittedProcesserCount = submitRowset.getInt(1);
            }
            if (submittedProcesserCount == totalProcesserCount) {
                flag = true;
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return flag;
    }

    public static void writeBackScoreTaskStatus(Context ctx, String evaObj, ScoreTaskStatusEnum scoreTaskStatus) {
        try {
            IMultiPerfEvaObject iMultiPerfEvaObject = MultiPerfEvaObjectFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("paperStatus"));
            MultiPerfEvaObjectInfo multiPerfEvaObjectInfo = GetMultiEvaEntityUtils.getMultiPerfEvaObjectInfoById(ctx, evaObj);
            if (null != multiPerfEvaObjectInfo) {
                multiPerfEvaObjectInfo.setPaperStatus(scoreTaskStatus);
                iMultiPerfEvaObject.updatePartial(multiPerfEvaObjectInfo, sic);
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-SAVEEVAOBJSCORESTATUSERR\uff01", (Throwable)e);
        }
    }

    public static void createMultiScoreDetailTask(Context ctx, String businessId) throws EASBizException, BOSException {
        MultiSummaryScoreDetailFactory.getLocalInstance(ctx).delete(" where multiEvaObj='" + businessId + "'");
        GeneralTaskPoolInfo generalTaskPoolInfo = new GeneralTaskPoolInfo();
        generalTaskPoolInfo.setBusinessId(businessId);
        generalTaskPoolInfo.setBusinessType(BusinessOpTypeEnum.CREATE_MULTISUMMARYSCOREDETAIL);
        generalTaskPoolInfo.setDealStatus(TaskStatusEnum.UNDEAL);
        generalTaskPoolInfo.setIsAlreadyDeal(YesOrNotEnum.NO);
        generalTaskPoolInfo.setLock(YesOrNotEnum.NO);
        GeneralTaskPoolFactory.getLocalInstance(ctx).addnew(generalTaskPoolInfo);
    }
}

