/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.multiEvalution.commontask.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.cloudservice.CloudServiceConfigCollection;
import com.kingdee.shr.cloudservice.CloudServiceConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.cloudservice.ICloudServiceConfig;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileInfo;
import com.kingdee.shr.perfweb.app.common.PerfConfigCollection;
import com.kingdee.shr.perfweb.app.common.PerfConfigFactory;
import com.kingdee.shr.perfweb.app.common.PerfConfigInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.IMultiEvaTask;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaTaskCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaTaskControllerBean;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaTaskFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaTaskInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.QuesCloudDataSyncFacadeControllerBean;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfRelationDetailsInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfRelationReportInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebMultiOrgResource;
import com.kingdee.shr.perfweb.multiEvalution.commontask.bean.CloudServiceConfigBean;
import com.kingdee.shr.perfweb.multiEvalution.commontask.bean.EmailBean;
import com.kingdee.shr.perfweb.multiEvalution.commontask.bean.MultiEvaTaskBean;
import com.kingdee.shr.perfweb.multiEvalution.commontask.bean.QuesScoreDetailUnionBean;
import com.kingdee.shr.perfweb.multiEvalution.commontask.utils.GetMultiEvaEntityUtils;
import com.kingdee.shr.perfweb.multiEvalution.commontask.utils.QuesServerInstance;
import com.kingdee.shr.perfweb.multiEvalution.commontask.utils.QuestionaierUtils;
import com.kingdee.shr.perfweb.multiEvalution.quescloud.QuesCloudRequest;
import com.kingdee.shr.perfweb.multiEvalution.quescloud.result.QuesCloudResult;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.PerfDateUtils;
import com.kingdee.shr.perfweb.utils.PerfwebStrUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MultiEvaTaskUtils {
    private static Logger logger = LoggerFactory.getLogger(MultiEvaTaskUtils.class);
    private static final String COMBINEBYASSIGNCOMPANY = "3";
    private static final String ASSIGNCOMPNYID = "assignCompnyId";
    private static final String COMBINEBYCOMPANY = "1";
    private static final String COMBINEBYDEPARTMENT = "2";
    private static final String COMBINEBYRELATION = "combineByRelation";
    private static final String COMBINEBYADMINORG = "combineByAdminOrg";
    private static final String ORGEVAOBJINFOTYPE = "orgEvaObjInfoType";

    @Deprecated
    public static String assmbleMultiEvaTaskData(Context ctx, String taskId) {
        String multiEvaTaskData = null;
        MultiEvaTaskBean multiEvaTaskBean = new MultiEvaTaskBean();
        MultiEvaTaskInfo multiEvaTaskInfo = GetMultiEvaEntityUtils.getMultiEvaTaskInfo(ctx, taskId);
        if (null != multiEvaTaskInfo) {
            String questionnaierId = multiEvaTaskInfo.getQuestionnaier();
            multiEvaTaskBean.setTaskId(taskId);
            multiEvaTaskBean.setQuestionnaier(questionnaierId);
            multiEvaTaskBean.setBusinessId(multiEvaTaskInfo.getBusinessId());
            multiEvaTaskBean.setEvaluType(multiEvaTaskInfo.getEvaluType());
            multiEvaTaskBean.setBusinessType(multiEvaTaskInfo.getBusinessType());
            multiEvaTaskBean.setReceiver(multiEvaTaskInfo.getReceiver());
            multiEvaTaskBean.setReceiverName(multiEvaTaskInfo.getReceiverName());
            multiEvaTaskBean.setReceiverPhone(multiEvaTaskInfo.getReceiverPhone());
            multiEvaTaskBean.setReceiverEmail(multiEvaTaskInfo.getReceiverEmail());
            multiEvaTaskBean.setQuestionnaireDefBean(QuestionaierUtils.assembleQuestionnaireDefBean(ctx, questionnaierId));
        }
        Gson gson = new Gson();
        multiEvaTaskData = gson.toJson((Object)multiEvaTaskBean);
        return multiEvaTaskData;
    }

    public static MultiEvaTaskBean assmbleMultiEvaTask(Context ctx, MultiEvaTaskInfo multiEvaTaskInfo) {
        MultiEvaTaskBean multiEvaTaskBean = new MultiEvaTaskBean();
        String taskId = multiEvaTaskInfo.getId().toString();
        if (null != multiEvaTaskInfo) {
            YesOrNoEnum isOrg;
            String questionnaierId = multiEvaTaskInfo.getQuestionnaier();
            multiEvaTaskBean.setTaskId(taskId);
            multiEvaTaskBean.setQuestionnaier(questionnaierId);
            multiEvaTaskBean.setBusinessId(multiEvaTaskInfo.getBusinessId());
            multiEvaTaskBean.setEvaluType(multiEvaTaskInfo.getEvaluType());
            multiEvaTaskBean.setBusinessType(multiEvaTaskInfo.getBusinessType());
            multiEvaTaskBean.setReceiver(multiEvaTaskInfo.getReceiver());
            multiEvaTaskBean.setReceiverName(multiEvaTaskInfo.getReceiverName());
            multiEvaTaskBean.setReceiverPhone(multiEvaTaskInfo.getReceiverPhone());
            multiEvaTaskBean.setReceiverEmail(multiEvaTaskInfo.getReceiverEmail());
            multiEvaTaskBean.setEid(multiEvaTaskInfo.getEid());
            multiEvaTaskBean.setQuestionnaierVersion(multiEvaTaskInfo.getQuestionnaierVersion());
            MultiPerfRelationDetailsInfo relationDetailsInfo = multiEvaTaskInfo.getMultiPerfRelationReport().getRelationDetail();
            multiEvaTaskBean.setRelationId(relationDetailsInfo.getId().toString());
            multiEvaTaskBean.setRelationName(relationDetailsInfo.getEvaluationPersonName());
            MultiPerfEvaObjectInfo perfEvaObjectInfo = multiEvaTaskInfo.getMultiPerfRelationReport().getPerfEvaObj();
            multiEvaTaskBean.setAdminOrgUnitId(perfEvaObjectInfo.getAdminOrgUnit().getId().toString());
            multiEvaTaskBean.setAdminOrgUnitName(perfEvaObjectInfo.getAdminOrgUnit().getName());
            AdminOrgUnitInfo companyInfo = perfEvaObjectInfo.getAdminOrgUnit().getCompany();
            AdminOrgUnitInfo departmentInfo = perfEvaObjectInfo.getAdminOrgUnit().getDepartment();
            if (companyInfo != null) {
                multiEvaTaskBean.setCompanyId(companyInfo.getId().toString());
                multiEvaTaskBean.setCompanyName(companyInfo.getName());
            }
            if (departmentInfo != null) {
                multiEvaTaskBean.setDepartmentId(departmentInfo.getId().toString());
                multiEvaTaskBean.setDepartmentName(departmentInfo.getName());
            }
            multiEvaTaskBean.setAdminOrgUnitSortCode(perfEvaObjectInfo.getAdminOrgUnit().getSortCode());
            MultiPerfEvaObjectInfo multiPerfEvaObjectInfo = multiEvaTaskInfo.getMultiPerfRelationReport().getPerfEvaObj();
            PerfFileInfo perfFileInfo = multiPerfEvaObjectInfo.getPerfFile();
            PersonInfo personInfo = perfFileInfo != null ? perfFileInfo.getPerson() : null;
            PositionInfo positionInfo = perfFileInfo != null ? perfFileInfo.getPosition() : null;
            AdminOrgUnitInfo adminOrgUnit = multiPerfEvaObjectInfo.getAdminOrgUnit();
            if (personInfo != null) {
                multiEvaTaskBean.setPersonSortCode(personInfo.getIndexOf());
                multiEvaTaskBean.setPersonNumber(personInfo.getNumber());
                multiEvaTaskBean.setPersonName(personInfo.getName());
            }
            if (positionInfo != null) {
                multiEvaTaskBean.setPositionName(positionInfo.getName());
                multiEvaTaskBean.setPositionSortCode(positionInfo.getIndex());
            }
            if (null != multiEvaTaskInfo.getIsSendEmail()) {
                multiEvaTaskBean.setIsSendEmail("0");
            }
            if (null != multiEvaTaskInfo.getIsSendShortMsg()) {
                multiEvaTaskBean.setIsSendShortMsg("0");
            }
            if ((isOrg = multiEvaTaskInfo.getMultiPerfRelationReport().getPerfEvaObj().getIsOrg()).getValue() == 1) {
                multiEvaTaskBean.setPersonNumber(adminOrgUnit.getNumber());
                multiEvaTaskBean.setPersonName(adminOrgUnit.getName());
            }
            multiEvaTaskBean.setIsOrg(isOrg == null ? 0 : isOrg.getValue());
        }
        return multiEvaTaskBean;
    }

    public static void sendMultiEvaTask(Context ctx, List<String> taskIdList) {
        try {
            Map<String, String> configMap = MultiEvaTaskUtils.getMultiEvaluateConfig(ctx);
            String combineByRelation = configMap.get(COMBINEBYRELATION);
            String combineByAdminOrg = configMap.get(COMBINEBYADMINORG);
            String orgEvaObjInfoType = configMap.get(ORGEVAOBJINFOTYPE);
            String assignCompnyId = configMap.get(ASSIGNCOMPNYID);
            ArrayList<MultiEvaTaskBean> orgTaskBeanList = new ArrayList<MultiEvaTaskBean>();
            ArrayList<MultiEvaTaskBean> taskBeanByAssignCompanyList = new ArrayList<MultiEvaTaskBean>();
            ArrayList<MultiEvaTaskBean> taskBeanList = new ArrayList<MultiEvaTaskBean>();
            if (null != taskIdList && taskIdList.size() > 0) {
                StringBuffer idConditionBuffer = new StringBuffer("(").append(PerfwebStrUtils.convertListToString(taskIdList)).append(")");
                IMultiEvaTask iMultiEvaTask = MultiEvaTaskFactory.getLocalInstance(ctx);
                MultiEvaTaskCollection multiEvaTaskColl = iMultiEvaTask.getMultiEvaTaskCollection("select multiPerfRelationReport.relationDetail.id, multiPerfRelationReport.relationDetail.evaluationPersonName, * where id in " + idConditionBuffer.toString());
                if (multiEvaTaskColl != null && !multiEvaTaskColl.isEmpty()) {
                    HashSet<String> businessIds = new HashSet<String>();
                    Iterator it = multiEvaTaskColl.iterator();
                    while (it.hasNext()) {
                        MultiEvaTaskInfo taskInfo = (MultiEvaTaskInfo)it.next();
                        businessIds.add(taskInfo.getBusinessId());
                    }
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", businessIds, CompareType.INCLUDE));
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    selectors.add(new SelectorItemInfo("adminOrgUnit.id"));
                    selectors.add(new SelectorItemInfo("adminOrgUnit.name"));
                    selectors.add(new SelectorItemInfo("adminOrgUnit.number"));
                    selectors.add(new SelectorItemInfo("adminOrgUnit.company.id"));
                    selectors.add(new SelectorItemInfo("adminOrgUnit.company.name"));
                    selectors.add(new SelectorItemInfo("adminOrgUnit.department.id"));
                    selectors.add(new SelectorItemInfo("adminOrgUnit.department.name"));
                    selectors.add(new SelectorItemInfo("adminOrgUnit.sortCode"));
                    selectors.add(new SelectorItemInfo("perfFile.position.index"));
                    selectors.add(new SelectorItemInfo("perfFile.position.name"));
                    selectors.add(new SelectorItemInfo("perfFile.person.number"));
                    selectors.add(new SelectorItemInfo("perfFile.person.name"));
                    selectors.add(new SelectorItemInfo("perfFile.person.indexOf"));
                    selectors.add(new SelectorItemInfo("isOrg"));
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(filterInfo);
                    evi.setSelector(selectors);
                    MultiPerfEvaObjectCollection evaObjectColls = MultiPerfEvaObjectFactory.getLocalInstance(ctx).getMultiPerfEvaObjectCollection(evi);
                    HashMap<String, MultiPerfEvaObjectInfo> evaObjMap = new HashMap<String, MultiPerfEvaObjectInfo>();
                    if (evaObjectColls != null && !evaObjectColls.isEmpty()) {
                        Iterator evaObjit = evaObjectColls.iterator();
                        while (evaObjit.hasNext()) {
                            MultiPerfEvaObjectInfo evaObjectInfo = (MultiPerfEvaObjectInfo)evaObjit.next();
                            evaObjMap.put(evaObjectInfo.getId().toString(), evaObjectInfo);
                        }
                    }
                    Iterator it2 = multiEvaTaskColl.iterator();
                    while (it2.hasNext()) {
                        MultiEvaTaskInfo taskInfo = (MultiEvaTaskInfo)it2.next();
                        MultiPerfRelationReportInfo reportInfo = taskInfo.getMultiPerfRelationReport();
                        reportInfo.setPerfEvaObj((MultiPerfEvaObjectInfo)evaObjMap.get(taskInfo.getBusinessId()));
                    }
                }
                int multiEvaTaskSize = multiEvaTaskColl.size();
                for (int i = 0; i < multiEvaTaskSize; ++i) {
                    MultiEvaTaskBean taskBean = MultiEvaTaskUtils.assmbleMultiEvaTask(ctx, multiEvaTaskColl.get(i));
                    if (1 == taskBean.getIsOrg()) {
                        orgTaskBeanList.add(taskBean);
                        continue;
                    }
                    AdminOrgUnitInfo compnayInfo = multiEvaTaskColl.get(i).getMultiPerfRelationReport().getPerfEvaObj().getAdminOrgUnit().getCompany();
                    if (compnayInfo != null && !StringUtils.isEmpty((CharSequence)assignCompnyId) && compnayInfo.getId().toString().equals(assignCompnyId)) {
                        taskBeanByAssignCompanyList.add(taskBean);
                        continue;
                    }
                    taskBeanList.add(taskBean);
                }
                Map<String, String> quesServerMap = QuesServerInstance.getServerInfo(ctx);
                String path = "quescloud/evatask/receivenew?serviceId=" + quesServerMap.get(QuesServerInstance.SERVICE_ID);
                if (!CollectionUtils.isEmpty(orgTaskBeanList)) {
                    path = path + "&isCombineTask=1";
                    path = path + "&combineByRelation=1";
                    path = path + "&orgEvaObjInfoType=" + orgEvaObjInfoType;
                    MultiEvaTaskUtils.sendEvaTasks(ctx, path, orgTaskBeanList, "0");
                } else {
                    String combineType;
                    path = path + "&isCombineTask=1";
                    if (!StringUtils.isEmpty((CharSequence)combineByRelation)) {
                        path = path + "&combineByRelation=" + combineByRelation;
                    }
                    if (!CollectionUtils.isEmpty(taskBeanByAssignCompanyList)) {
                        path = path + "&combineByAdminOrg=2";
                        combineType = MultiEvaTaskUtils.getCombineType(combineByRelation, COMBINEBYDEPARTMENT);
                        MultiEvaTaskUtils.sendEvaTasks(ctx, path, taskBeanByAssignCompanyList, combineType);
                    } else {
                        if (!StringUtils.isEmpty((CharSequence)combineByAdminOrg)) {
                            path = path + "&combineByAdminOrg=" + combineByAdminOrg;
                        }
                        combineType = MultiEvaTaskUtils.getCombineType(combineByRelation, combineByAdminOrg);
                        MultiEvaTaskUtils.sendEvaTasks(ctx, path, taskBeanList, combineType);
                    }
                }
            }
        }
        catch (Exception e) {
            if (!MultiEvaTaskUtils.judgeQuesIsReachable(ctx)) {
                QuesCloudDataSyncFacadeControllerBean.quesIsReachable = false;
            }
            logger.error("\u3010PERFWEB\u3011-send QUESCLOUD task error ,message :" + e.getMessage());
        }
    }

    public static boolean sendEmail(Context ctx, EmailBean emailBean) {
        Gson gson = new Gson();
        boolean flag = false;
        try {
            if (null != emailBean.getServer()) {
                String path = "quescloud/enterprise/sendemail";
                QuesCloudRequest request = new QuesCloudRequest(ctx, path);
                QuesCloudResult result = request.buildRequest().doPost(gson.toJson((Object)emailBean));
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                if (result != null && result.isSuccess() && result.getData() != null) {
                    Map res = (Map)gson.fromJson(result.getData().toString(), type);
                    Object flag1 = res.get("flag");
                    if (flag1 instanceof Boolean) {
                        flag = (Boolean)flag1;
                    } else {
                        String flagStr = (String)flag1;
                        if ("true".equals(flagStr)) {
                            flag = true;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-send email by quescloud email service failed !", (Throwable)e);
        }
        return flag;
    }

    private static Map<String, String> getMultiEvaluateConfig(Context ctx) throws BOSException {
        String[] combineVals;
        String combineFlag;
        HashMap<String, String> configMap = new HashMap<String, String>();
        String combineByAdminOrg = "";
        PerfConfigCollection configs = PerfConfigFactory.getLocalInstance(ctx).getPerfConfigCollection("select paraName, paraValue where category='multiEvaluate' ");
        if (configs != null && !configs.isEmpty()) {
            Iterator it = configs.iterator();
            while (it.hasNext()) {
                PerfConfigInfo perfConfigInfo = (PerfConfigInfo)it.next();
                String paraName = perfConfigInfo.getParaName();
                String value = perfConfigInfo.getParaValue();
                if (COMBINEBYRELATION.equals(paraName)) {
                    configMap.put(COMBINEBYRELATION, value);
                    continue;
                }
                if (COMBINEBYADMINORG.equals(paraName)) {
                    configMap.put(COMBINEBYADMINORG, value);
                    combineByAdminOrg = value;
                    continue;
                }
                if (!ORGEVAOBJINFOTYPE.equals(paraName)) continue;
                configMap.put(ORGEVAOBJINFOTYPE, value);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)combineByAdminOrg) && COMBINEBYASSIGNCOMPANY.equals(combineFlag = (combineVals = combineByAdminOrg.split("\\$"))[0])) {
            configMap.put(COMBINEBYADMINORG, COMBINEBYCOMPANY);
            if (combineVals.length > 1) {
                configMap.put(ASSIGNCOMPNYID, combineVals[1]);
            }
        }
        return configMap;
    }

    private static String getCombineType(String combineByRelation, String combineByAdminOrg) {
        String combineType = "0";
        if (COMBINEBYCOMPANY.equals(combineByRelation)) {
            if (COMBINEBYCOMPANY.equals(combineByAdminOrg)) {
                combineType = COMBINEBYCOMPANY;
            } else if (COMBINEBYDEPARTMENT.equals(combineByAdminOrg)) {
                combineType = COMBINEBYDEPARTMENT;
            }
        } else {
            combineType = COMBINEBYCOMPANY.equals(combineByAdminOrg) ? "4" : (COMBINEBYDEPARTMENT.equals(combineByAdminOrg) ? "5" : COMBINEBYASSIGNCOMPANY);
        }
        return combineType;
    }

    private static void sendEvaTasks(Context ctx, String path, List<MultiEvaTaskBean> taskBeanList, String combineType) throws EASBizException, BOSException {
        Gson gson = new Gson();
        QuesCloudRequest request = new QuesCloudRequest(ctx, path);
        QuesCloudResult result = request.buildRequest().doPost(gson.toJson(taskBeanList));
        ArrayList<String> taskIdList = new ArrayList<String>();
        for (MultiEvaTaskBean taskBean : taskBeanList) {
            taskIdList.add(taskBean.getTaskId());
        }
        if (result != null && result.isSuccess() && result.getData() != null) {
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            logger.error("==========QUESCLOUD response data");
            Map resMap = (Map)gson.fromJson(result.getData().toString(), type);
            List res = (List)resMap.get("result");
            logger.error("quescloud return shorturl");
            if (null != res && res.size() > 0) {
                String updateSQL = "update T_EVA_MultiEvaTask set FSendToQuesStatus=1,FQuestionnaireIsSync='0',FStatus='1',FShortUrl=?,FLoginKey=?,FQuestionnaireSumScore=?, FCombineShortUrl =?, FCombineLoginKey=?, FBatchTaskId=?, FCombineType=?  where FID=?";
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                for (Map map : res) {
                    String multiEvaTaskId = (String)map.get("taskId");
                    String shorturl = (String)map.get("shorturl");
                    String loginkey = (String)map.get("loginkey");
                    String questionnaireSumScore = (String)map.get("score");
                    String combineShortUrl = (String)map.get("cshorturl");
                    String combineLoginkey = (String)map.get("cloginkey");
                    String batchTaskId = (String)map.get("batchTaskId");
                    Object[] param = new Object[]{shorturl, loginkey, questionnaireSumScore, combineShortUrl, combineLoginkey, batchTaskId, combineType, multiEvaTaskId};
                    paramsList.add(param);
                }
                DbUtil.executeBatch((Context)ctx, (String)updateSQL, paramsList);
                MultiEvaTaskControllerBean.sendMsg(ctx, StringUtils.join(taskIdList, (String)","));
            } else {
                String ids = "(" + PerfwebStrUtils.convertListToString(taskIdList) + ")";
                String updateSQL = "update T_EVA_MultiEvaTask set FStatus='2',FErrorMsg='" + resMap.get("message") + "'  where FID in " + ids;
                DbUtil.execute((Context)ctx, (String)updateSQL);
            }
        } else {
            String ids = "(" + PerfwebStrUtils.convertListToString(taskIdList) + ")";
            String updateSQL = "update T_EVA_MultiEvaTask set FStatus='2',FErrorMsg='" + SHRPerfWebResourceUtil.getRes(SHRPerfWebMultiOrgResource.SENDQUESCLOUDERRORTRY, ctx) + "'  where FID in " + ids;
            DbUtil.execute((Context)ctx, (String)updateSQL);
        }
    }

    public static void syncCloudServiceConfigToQuesCloud(Context ctx) {
        Gson gson = new Gson();
        try {
            ICloudServiceConfig iCloudServiceConfig = CloudServiceConfigFactory.getLocalInstance((Context)ctx);
            CloudServiceConfigCollection cloudServiceConfigColl = iCloudServiceConfig.getCloudServiceConfigCollection();
            if (null != cloudServiceConfigColl && cloudServiceConfigColl.size() > 0) {
                CloudServiceConfigInfo cloudServiceConfigInfo = cloudServiceConfigColl.get(0);
                CloudServiceConfigBean cloudServiceBean = new CloudServiceConfigBean();
                if (cloudServiceConfigInfo.isQuickRelease()) {
                    cloudServiceBean.setQuickrelease(1);
                } else {
                    cloudServiceBean.setQuickrelease(0);
                }
                cloudServiceBean.setEnterpriseid(cloudServiceConfigInfo.getEnterpriseID());
                cloudServiceBean.setServiceid(cloudServiceConfigInfo.getServiceID());
                cloudServiceBean.setServicekey(cloudServiceConfigInfo.getServiceKey());
                cloudServiceBean.setEnterfullname(cloudServiceConfigInfo.getEnterFullName());
                cloudServiceBean.setEntersimplename(cloudServiceConfigInfo.getEnterSimpleName());
                cloudServiceBean.setRegisteremail(cloudServiceConfigInfo.getRegisterEmail());
                cloudServiceBean.setEnterpubnetwork(cloudServiceConfigInfo.getEnterPubNetwork());
                cloudServiceBean.setEnteroffcialweb(cloudServiceConfigInfo.getEnterOffcialWeb());
                cloudServiceBean.setCloudaccout(cloudServiceConfigInfo.getCloudAccout());
                cloudServiceBean.setCloudpwd(cloudServiceConfigInfo.getCloudPwd());
                cloudServiceBean.setStoptime(PerfDateUtils.formatDate(cloudServiceConfigInfo.getStopTime(), "yyyy-MM-dd"));
                cloudServiceBean.setAccesstoken(cloudServiceConfigInfo.getAccessToken());
                cloudServiceBean.setIsauthorize(cloudServiceConfigInfo.getIsAuthorize().getValue());
                String path = "quescloud/enterprise/sync";
                QuesCloudRequest request = new QuesCloudRequest(ctx, path);
                QuesCloudResult quesCloudResult = request.buildRequest().doPost(gson.toJson((Object)cloudServiceBean));
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-SYNCENTERPRISECONFIGTOQUESCLOUDERR \uff01", (Throwable)e);
        }
    }

    public static List<HashMap<String, String>> getLoginUrlFromQuescloud(Context ctx, String taskIdStr) {
        if (StringUtils.isEmpty((CharSequence)taskIdStr)) {
            return null;
        }
        ArrayList<HashMap<String, String>> resList = new ArrayList<HashMap<String, String>>(2);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", taskIdStr);
        Gson gson = new Gson();
        String path = "quescloud/enterprise/getloginurl";
        try {
            QuesCloudRequest request = new QuesCloudRequest(ctx, path, params);
            QuesCloudResult result = request.buildRequest().doPost();
            if (result != null && result.isSuccess() && result.getData() != null) {
                Type type = new TypeToken<List<Map<String, String>>>(){}.getType();
                List res = (List)gson.fromJson(result.getData().toString(), type);
                String updateSQL = "update T_EVA_MultiEvaTask set FShortUrl=?,FLoginKey=? where FID=?";
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                for (Map map : res) {
                    HashMap<String, String> resMap = new HashMap<String, String>();
                    String shorturl = (String)map.get("shorturl");
                    String loginkey = (String)map.get("loginkey");
                    String taskId = (String)map.get("taskId");
                    resMap.put("shorturl", shorturl);
                    resMap.put("taskId", taskId);
                    resMap.put("loginkey", loginkey);
                    resList.add(resMap);
                    Object[] param = new Object[]{shorturl, loginkey, taskId};
                    paramsList.add(param);
                }
                try {
                    DbUtil.executeBatch((Context)ctx, (String)updateSQL, paramsList);
                }
                catch (BOSException e) {
                    logger.error("BOSException: ", (Throwable)e);
                }
            }
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return resList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean judgeQuesIsReachable(Context ctx) {
        boolean isReachable = false;
        Socket socket = new Socket();
        try {
            Map<String, String> map = QuesServerInstance.getServerInfo(ctx);
            String serverUrl = map.get(QuesServerInstance.CLOUD_SERVERURL);
            socket.setSoTimeout(3000);
            InetSocketAddress address = new InetSocketAddress(serverUrl.replace("http://", "").replace("/", ""), 80);
            socket.connect(address, 3000);
            String path = "quescloud/connect/isreachable";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("data", "");
            QuesCloudRequest request = new QuesCloudRequest(ctx, path, params);
            QuesCloudResult result = request.buildRequest().doPost();
            if (result != null && result.isSuccess() && result.getData() != null) {
                isReachable = true;
            }
        }
        catch (Exception e) {
            logger.error("judgeQuesIsReachable is error: ", (Throwable)e);
        }
        finally {
            if (!socket.isConnected() && !socket.isClosed()) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.error("judgeQuesIsReachable IOException: ", (Throwable)e);
                }
            }
        }
        return isReachable;
    }

    public static List<QuesScoreDetailUnionBean> getScoreDetailByEvaObj(Context ctx, List<String> evaObjIds) {
        List<QuesScoreDetailUnionBean> resultData = new ArrayList<QuesScoreDetailUnionBean>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", MultiEvaTaskUtils.joinStr(Sets.newHashSet(evaObjIds), ","));
        String path = "quescloud/getScoreDetailByEvaObj";
        try {
            Object data;
            QuesCloudRequest request = new QuesCloudRequest(ctx, path, params);
            QuesCloudResult result = request.buildRequest().doPost();
            if (result != null && result.isSuccess() && result.getData() != null && (data = result.getData()) != null) {
                resultData = JSON.parseArray((String)JSON.toJSONString((Object)data), QuesScoreDetailUnionBean.class);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return resultData;
    }

    private static String joinStr(Set<String> taskIds, String joinStr) {
        StringBuffer sb = new StringBuffer();
        if (taskIds != null && taskIds.size() > 0) {
            for (String taskId : taskIds) {
                sb.append(taskId).append(joinStr);
            }
            if (sb.length() > 1) {
                sb.setLength(sb.length() - 1);
            }
        }
        return sb.toString();
    }
}

