/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException2;
import com.kingdee.shr.perfweb.osf.converter.CoreConverter;
import com.kingdee.shr.perfweb.osf.model.SimpleFieldInfo;
import com.kingdee.shr.perfweb.util.MetaDataUtil;
import com.kingdee.shr.perfweb.utils.MapUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonListHandlerService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger(CommonListHandlerService.class);
    private static final String QUERY = "query";
    private static final String ENTITY = "entity";
    private static final int PAGE = 1;
    private static final int ROWS = 10;

    public Object process(Context context, Map map) throws EASBizException, BOSException {
        String query = (String)map.get(QUERY);
        String entity = (String)map.get(ENTITY);
        if (StringUtils.isEmpty((String)query) && StringUtils.isEmpty((String)entity)) {
            throw new SHRPerfWebBizException2(SHRPerfWebBizException2.UIPKORENTITYREQUIRED);
        }
        int page = map.get("page") != null ? Integer.valueOf((String)map.get("page")) : 1;
        int rows = map.get("rows") != null ? Integer.valueOf((String)map.get("rows")) : 10;
        HashMap<String, Object> reMap = new HashMap<String, Object>();
        reMap.put("page", page);
        reMap.put("rows", rows);
        try {
            ArrayList<HashMap<String, Object>> listData;
            int totalCount = 0;
            EntityViewInfo ev = this.getEntityViewInfo(context, map);
            List<SimpleFieldInfo> fieldList = !StringUtils.isEmpty((String)query) ? new CoreConverter().buildSimpleFieldsByQuery(context, query, map) : new CoreConverter().buildSimpleFieldsByModel(context, entity, map);
            this.afterGetFieldList(context, map, fieldList);
            reMap.put("fieldList", fieldList);
            if (this.breakQuery(context, map)) {
                reMap.put("data", null);
                reMap.put("total", 0);
                return reMap;
            }
            if (!StringUtils.isEmpty((String)query)) {
                IQueryExecutor executor = this.getExecutor(context, map);
                executor.setObjectView(ev);
                totalCount = executor.getRowCount();
                int length = rows;
                if (page * rows > totalCount) {
                    length = totalCount - (page - 1) * rows;
                }
                IRowSet iRowSet = executor.executeQueryForRealPage((page - 1) * rows, length);
                listData = this.commonAfterGetListData(context, iRowSet);
            } else {
                ICoreBase bizInterface = MetaDataUtil.getBizInterface(entity);
                totalCount = bizInterface.getCount(ev);
                int length = rows;
                if (page * rows > totalCount) {
                    length = totalCount - (page - 1) * rows;
                }
                listData = bizInterface.getPagingList(ev, (page - 1) * rows, length);
            }
            this.afterGetListData(context, listData);
            reMap.put("data", listData);
            reMap.put("total", totalCount);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR);
        }
        this.afterResultData(context, reMap);
        return reMap;
    }

    protected void setBreakQueryFlag(Context ctx, Map param) {
        param.put("isBreakQuery", true);
    }

    protected boolean breakQuery(Context ctx, Map param) {
        Object isBreakQuery = param.get("isBreakQuery");
        if (isBreakQuery == null) {
            return false;
        }
        return (Boolean)isBreakQuery;
    }

    protected FilterInfo getFilter(Context ctx, Map param) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.mergeFilter(this.getDefoFilter(ctx, param), "AND");
        filter.mergeFilter(this.getOsfFilter(ctx, param), "AND");
        filter.mergeFilter(this.getParamFilter(ctx, param), "AND");
        filter.mergeFilter(this.getAdvanceFilter(ctx, param), "AND");
        return filter;
    }

    public FilterInfo getAdvanceFilter(Context ctx, Map param) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    public FilterInfo getDefoFilter(Context ctx, Map param) throws BOSException, EASBizException {
        return null;
    }

    public FilterInfo getOsfFilter(Context ctx, Map param) throws EASBizException {
        FilterInfo filter;
        String filterStr = MapUtils.getParam(param, "osfFilter");
        if (StringUtils.isEmpty((String)filterStr)) {
            return null;
        }
        try {
            filter = new FilterInfo(filterStr);
        }
        catch (ParserException e) {
            logger.error("ParserException: ", (Throwable)e);
            throw new SHRPerfWebBizException2(SHRPerfWebBizException2.PARSEFILTEROFOSFERR);
        }
        return filter;
    }

    public FilterInfo getParamFilter(Context ctx, Map param) throws EASBizException {
        FilterInfo filter;
        String filterStr = MapUtils.getParam(param, "paramfilter");
        if (StringUtils.isEmpty((String)filterStr)) {
            return null;
        }
        try {
            filter = new FilterInfo(filterStr);
        }
        catch (ParserException e) {
            logger.error("ParserException: ", (Throwable)e);
            throw new SHRPerfWebBizException2(SHRPerfWebBizException2.PARAMFILTERERR);
        }
        return filter;
    }

    public SelectorItemCollection getSelector(Context ctx, Map param) {
        SelectorItemCollection sc = (SelectorItemCollection)param.get("SelectorItemCollection");
        this.getDefoSelector(sc, param);
        return sc;
    }

    public void getDefoSelector(SelectorItemCollection sc, Map param) {
    }

    public SorterItemCollection getSorter(Context ctx, Map param) throws EASBizException {
        SorterItemCollection st = this.assembleSorter(ctx, param);
        this.getDefoSorter(st, param);
        return st;
    }

    public void getDefoSorter(SorterItemCollection st, Map param) {
    }

    public IQueryExecutor getExecutor(Context ctx, Map map) throws EASBizException {
        MetaDataPK queryPK = MetaDataPK.create((String)((String)map.get(QUERY)));
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isIgnorePermissionCheck = false;
        return exec;
    }

    public EntityViewInfo getEntityViewInfo(Context ctx, Map param) throws BOSException, EASBizException {
        this.assembleColumnModel(param);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(this.getFilter(ctx, param));
        ev.setSelector(this.getSelector(ctx, param));
        ev.setSorter(this.getSorter(ctx, param));
        return ev;
    }

    private ArrayList<HashMap<String, Object>> commonAfterGetListData(Context ctx, IRowSet iRowSet) throws EASBizException {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        try {
            while (iRowSet.next()) {
                HashMap<String, Object> colmn = new HashMap<String, Object>();
                int columnCount = iRowSet.getRowSetMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    colmn.put(iRowSet.getRowSetMetaData().getColumnName(i), iRowSet.getObject(i) == null ? "" : iRowSet.getObject(i));
                }
                list.add(colmn);
            }
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
            throw new SHRPerfWebBizException2(SHRPerfWebBizException2.LOADDATAERR);
        }
        return list;
    }

    public void afterGetFieldList(Context ctx, Map map, List<SimpleFieldInfo> fieldList) {
    }

    public void afterGetListData(Context ctx, List list) {
    }

    public void afterResultData(Context ctx, Map<String, Object> reMap) {
    }

    protected List getFields(Context ctx, Map map) {
        return null;
    }

    private List<Map<String, Object>> assembleColumnModel(Map param) throws EASBizException {
        HashSet<String> fieldSet = new HashSet<String>();
        try {
            String queryModel = MapUtils.getParam(param, "fieldList");
            if (StringUtils.isEmpty((String)queryModel)) {
                return null;
            }
            queryModel = org.apache.commons.lang.StringUtils.deleteWhitespace((String)queryModel);
            SelectorItemCollection sc = new SelectorItemCollection();
            String[] queryMode = queryModel.split(";");
            String[] properties = null;
            String columnName = null;
            for (int i = 0; i < queryMode.length; ++i) {
                properties = queryMode[i].split(",|\uff0c");
                columnName = properties[0];
                if (fieldSet.contains(columnName)) continue;
                fieldSet.add(columnName);
                sc.add(new SelectorItemInfo(columnName));
                properties = queryMode[i].split(",");
                sc.add(new SelectorItemInfo(columnName));
            }
            param.put("SelectorItemCollection", sc);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PARSEFIELDOFOSF);
        }
        return null;
    }

    private SorterItemCollection assembleSorter(Context ctx, Map param) throws EASBizException {
        SorterItemCollection sc;
        try {
            String queryModel = MapUtils.getParam(param, "sorterItems");
            if (StringUtils.isEmpty((String)queryModel)) {
                return null;
            }
            queryModel = queryModel.trim();
            sc = new SorterItemCollection();
            String[] queryMode = queryModel.split(",|\uff0c");
            for (int i = 0; i < queryMode.length; ++i) {
                String[] properties = queryMode[i].trim().split(" |  ");
                String columnName = properties[0];
                if (StringUtils.isEmpty((String)columnName)) continue;
                SorterItemInfo sorter = new SorterItemInfo(columnName);
                if (properties.length > 1 && "desc".equalsIgnoreCase(properties[1].trim())) {
                    sorter.setSortType(SortType.DESCEND);
                }
                sc.add(sorter);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PARSEFIELDOFOSF);
        }
        return sc;
    }
}

