/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.util.PerfDbUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMultiPerfPlanEvaObjectService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)GetMultiPerfPlanEvaObjectService.class.getName());

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        String batchTaskId = (String)map.get("batchTaskId");
        HashMap resultMap = new HashMap();
        try {
            String baseSQL;
            int isOrg = 0;
            if (GetMultiPerfPlanEvaObjectService.isOrg(map)) {
                isOrg = 1;
            }
            if (StringUtils.isEmpty((CharSequence)(baseSQL = this.getSQL(HRFilterUtils.getCurrentPersonId((Context)ctx), batchTaskId, "1", isOrg, ctx)))) {
                logger.error("GetMultiPerfPlanEvaObjectService request params has null!");
                return resultMap;
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)baseSQL, (Object[])new Object[]{HRFilterUtils.getCurrentPersonId((Context)ctx), "1", batchTaskId, isOrg});
            ArrayList userData = new ArrayList();
            int totalCount = rowSet.size();
            if (0 == totalCount) {
                resultMap.put("userData", userData);
                return resultMap;
            }
            int rows = (Integer)map.get("rows");
            int page = (Integer)map.get("page");
            int length = rows;
            if (page * rows > totalCount) {
                length = totalCount - (page - 1) * rows;
            }
            IRowSet dataSet = PerfDbUtil.executeQuery(ctx, baseSQL, (page - 1) * rows, length, new Object[]{HRFilterUtils.getCurrentPersonId((Context)ctx), "1", batchTaskId, isOrg});
            IRowSetMetaData rowSetMetaData = dataSet.getRowSetMetaData();
            while (dataSet.next()) {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                int count = rowSetMetaData.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    String columnName = rowSetMetaData.getColumnName(i);
                    Object value = dataSet.getObject(i);
                    userInfo.put(columnName, value);
                }
                userData.add(userInfo);
            }
            resultMap.put("userData", userData);
        }
        catch (SQLException e) {
            logger.error("GetMultiPerfPlanEvaObjectService error:", (Throwable)e);
        }
        return resultMap;
    }

    private String getSQL(String currentPersonId, String batchTaskId, String status, int isOrg, Context ctx) {
        logger.info("GetMultiPerfPlanEvaObjectService request : batchTaskId:" + batchTaskId + ",status:" + status);
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{currentPersonId, status, batchTaskId})) {
            return null;
        }
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        return "select  distinct task.fstatus as status ,evaObj.FName" + mlFlag + " as objName,evaObj.fnumber as objNumber,position.fname" + mlFlag + " as jobName,org.fname" + mlFlag + " as orgName, company.fname" + mlFlag + " as companyName, department.fname" + mlFlag + " as departmentName  FROM T_EVA_MultiEvaTask AS task LEFT OUTER JOIN T_EVA_MultiPerfRelationReport AS report ON task.FMultiPerfRelationReport = report.FID LEFT OUTER JOIN T_EVA_MultiPerfEvaObject AS evaObj ON report.FPerfEvaObjID = evaObj.FID LEFT OUTER JOIN T_EVA_PerfFile AS perfFile ON evaObj.FPerfFileID = perfFile.FID LEFT OUTER JOIN T_ORG_Position AS position ON perfFile.FPositionID = position.FID LEFT OUTER JOIN T_ORG_Admin AS org  ON evaObj.FAdminOrgUnitID = org.FID LEFT OUTER JOIN T_ORG_Admin AS company  ON org.FCompanyId = company.FID LEFT OUTER JOIN T_ORG_Admin AS department  ON org.FDepartmentId = department.FID where task.FCombineShortUrl is not null  and task.FIsEffect = '1' and evaObj.FPaperStatus = '200' and task.FReceiver  = ? and task.FStatus = ? and task.FBatchTaskId = ? and evaObj.FIsOrg = ?  order by evaObj.fnumber";
    }

    private static boolean isOrg(Map map) {
        return map.get("isOrg") != null && map.get("isOrg").toString().equals("1");
    }
}

