/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanAdminRangeCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanAdminRangeFactory;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.AdminOrgFilterUtil;
import com.kingdee.shr.perfweb.util.PerfDbUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.PerfwebStrUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GetPerfPlansService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)GetPerfPlansService.class.getName());
    private static final String SHOWMULTIPLAN = "1";
    private static final String SHOWIMPORT = "1";
    public static final String IMPORTBYHAND = "importByHand";
    public static final String HISTORYIMPORT = "historyImport";

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        String belongOrgID = (String)map.get("belongOrgID");
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        String planName = (String)map.get("planName");
        String showMultiPlan = (String)map.get("showMultiPlan");
        String showImport = (String)map.get("showImport");
        String isOrg = (String)map.get("isOrg");
        Object[] params = new Object[]{};
        try {
            int pages;
            String baseSQL = GetPerfPlansService.getBaseSQL(ctx, belongOrgID, planName, showMultiPlan, isOrg);
            if (!StringUtils.isEmpty((CharSequence)planName)) {
                params = Arrays.copyOf(params, params.length + 1);
                params[0] = "%" + planName + "%";
            }
            if (!StringUtils.isEmpty((CharSequence)planName) && "1".equals(showMultiPlan)) {
                params = Arrays.copyOf(params, params.length + 1);
                params[1] = "%" + planName + "%";
            }
            logger.error("[perfweb]GetPerfPlansService osf,baseSQL:" + baseSQL);
            logger.error("[perfweb]GetPerfPlansService osf,params:" + Arrays.toString(params));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)baseSQL, (Object[])params);
            int totalCount = rowSet.size();
            int rows = (Integer)map.get("rows");
            int page = (Integer)map.get("page");
            int length = rows;
            if (page * rows > totalCount) {
                length = totalCount - (page - 1) * rows;
            }
            IRowSet dataSet = PerfDbUtil.executeQuery(ctx, baseSQL, (page - 1) * rows, length, params);
            IRowSetMetaData md = dataSet.getRowSetMetaData();
            LinkedList data = new LinkedList();
            while (dataSet.next()) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                int count = md.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    String columnName = md.getColumnName(i);
                    Object value = dataSet.getObject(i);
                    rowMap.put(columnName.toLowerCase(), value);
                }
                data.add(rowMap);
            }
            int n = pages = totalCount % rows == 0 ? totalCount / rows : totalCount / rows + 1;
            if ("1".equals(showImport)) {
                HashMap<String, String> rowMap = new HashMap<String, String>();
                if (page == pages || !StringUtils.isEmpty((CharSequence)planName) && SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTBYHAND, ctx).contains(planName)) {
                    rowMap.put("id", IMPORTBYHAND);
                    rowMap.put("name", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTBYHAND, ctx));
                    rowMap.put("type", "2");
                    data.add(rowMap);
                    ++totalCount;
                }
                if (page == pages || !StringUtils.isEmpty((CharSequence)planName) && SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.HISTORYIMPORT, ctx).contains(planName)) {
                    rowMap = new HashMap();
                    rowMap.put("id", HISTORYIMPORT);
                    rowMap.put("name", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.HISTORYIMPORT, ctx));
                    rowMap.put("type", "2");
                    data.add(rowMap);
                    ++totalCount;
                }
            }
            result.put("pages", Integer.valueOf(pages));
            result.put("records", Integer.valueOf(totalCount));
            result.put("rows", data);
        }
        catch (SQLException e) {
            logger.error("perfPlan query failed", (Throwable)e);
        }
        return result;
    }

    private static String getBaseSQL(Context ctx, String belongOrgId, String planName, String showMultiPlan, String isOrg) {
        StringBuilder sb = new StringBuilder();
        try {
            String adminRangeSQL = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)HRFilterUtils.getCurrentUserId((Context)ctx), (String)"f9d05c11-b530-4ec7-acfd-3cb82819878cPERMITEM");
            String userHROrgRangeInSQL = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)HRFilterUtils.getCurrentUserId((Context)ctx), (String)"f9d05c11-b530-4ec7-acfd-3cb82819878cPERMITEM");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("admin.id", (Object)adminRangeSQL, CompareType.INNER));
            if (!StringUtils.isEmpty((CharSequence)belongOrgId)) {
                filter.getFilterItems().add(new FilterItemInfo("admin.id", (Object)AdminOrgFilterUtil.getUserIncludeSubAdminOrgRangeSql(ctx, belongOrgId), CompareType.INNER));
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("perfPlanAdminUseRange.perfPlan"));
            view.setSelector(sic);
            view.setFilter(filter);
            HashSet<String> planIdSet = new HashSet<String>();
            try {
                PerfPlanAdminRangeCollection coll = PerfPlanAdminRangeFactory.getLocalInstance(ctx).getPerfPlanAdminRangeCollection(view);
                for (int i = 0; i < coll.size(); ++i) {
                    planIdSet.add(coll.get(i).getPerfPlanAdminUseRange().getPerfPlan().getId().toString());
                }
            }
            catch (BOSException e) {
                logger.error("", (Throwable)e);
            }
            String isOrgSql = "";
            if ("1".equals(isOrg) || "0".equals(isOrg)) {
                isOrgSql = " and FIsOrg = " + isOrg;
            }
            String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
            sb.append(" select FID as id, FNAME").append(mlFlag).append(" as name,'0' as type from T_EVA_PERFPLAN ").append(" where FHrUnitOrgID in( ").append(userHROrgRangeInSQL).append(")").append(isOrgSql);
            if (!CollectionUtils.isEmpty(planIdSet)) {
                sb.append(" and fid in (").append(PerfwebStrUtils.convertListToString(planIdSet.toArray())).append(")");
            }
            if (!StringUtils.isEmpty((CharSequence)planName)) {
                sb.append(" and FNAME").append(mlFlag).append(" like ? ");
            }
            if ("1".equals(showMultiPlan)) {
                sb.append(" union ");
                sb.append("SELECT FID AS id, FName").append(mlFlag).append(" AS name, '1' AS type  from T_EVA_MultiPerfPlan multiPerfPlan").append(" where FPStatus = '1' ").append(isOrgSql);
                if (!StringUtils.isEmpty((CharSequence)belongOrgId)) {
                    sb.append(" and FBelongOrgID in (").append(AdminOrgFilterUtil.getUserIncludeSubAdminOrgRangeSql(ctx, belongOrgId)).append(")");
                }
                if (!StringUtils.isEmpty((CharSequence)planName)) {
                    sb.append(" and FName").append(mlFlag).append(" like ? ");
                }
            }
            sb.append(" order by type, name");
        }
        catch (Exception e) {
            logger.error("getBaseSQL error:", (Throwable)e);
        }
        return sb.toString();
    }
}

