/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsTargetFacadeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IGoalsTargetFacade;
import com.kingdee.shr.perfweb.app.base.evalplan.IIndicatorTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IRecordTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectControllerBean;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectPersonalGoalStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaTargetBackReasonFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaTargetBackReasonInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.SubAreaTypeEnum;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.bean.MsgConfigBean;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.AdminRangeUtils;
import com.kingdee.shr.perfweb.utils.IndicatorUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoalsTransmitService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)GoalsTransmitService.class.getName());

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        String evaObjIds = (String)param.get("evaObj");
        String backReason = (String)param.get("backReason");
        String[] ids = evaObjIds.split(",");
        String type = (String)param.get("type");
        if (StringUtil.isEmptyString((String)evaObjIds) || StringUtil.isEmptyString((String)type)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("resultFlag", "failure");
            map.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PARAMREQUIRED, ctx));
            return result.add(map);
        }
        if ("0".equals(type)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<String> validEvaObjs = new ArrayList<String>();
            for (String evaObj : ids) {
                Map<String, String> validRequiredRet = IndicatorUtils.validFormInputRequired(ctx, evaObj);
                if ("200".equals(validRequiredRet.get("ret"))) {
                    validEvaObjs.add(evaObj);
                    continue;
                }
                Object errorDes = map.get("errorDes");
                if (errorDes == null) {
                    map.put("errorDes", validRequiredRet.get("msg"));
                    continue;
                }
                String errMsg = String.valueOf(errorDes);
                errMsg = errMsg + ";" + validRequiredRet.get("msg");
                map.put("errorDes", errMsg);
            }
            int sucess = validEvaObjs.size();
            if (sucess > 0) {
                try {
                    sucess = this.goalsTramsmit(ctx, validEvaObjs.toArray(new String[sucess]));
                }
                catch (Exception e) {
                    sucess = 0;
                    map.put("failedMsg", e.getMessage());
                }
            }
            map.put("sucess", sucess);
            map.put("failed", ids.length - sucess);
            result.add(map);
        } else if ("1".equals(type)) {
            Map<String, Object> resultMap = this.goalsBack(ctx, ids, backReason, param);
            int sucess = (Integer)resultMap.get("sucess");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sucess", sucess);
            map.put("failed", ids.length - sucess);
            map.put("failedMsg", resultMap.get("failedMsg"));
            result.add(map);
        }
        return result;
    }

    private int goalsTramsmit(Context ctx, String[] evaObjIds) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < evaObjIds.length; ++i) {
            set.add(evaObjIds[i]);
        }
        PerfEvaObjectCollection coll = new PerfEvaObjectCollection();
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            filter.mergeFilter(fi, "and");
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("period"));
            sic.add(new SelectorItemInfo("period.perfPlan.*"));
            viewInfo.setFilter(filter);
            coll = PerfEvaObjectFactory.getLocalInstance(ctx).getPerfEvaObjectCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        int sucess = 0;
        try {
            boolean weightForce100 = true;
            IGoalsTargetFacade iGoalsTargetFacade = GoalsTargetFacadeFactory.getLocalInstance(ctx);
            for (int i = 0; i < coll.size(); ++i) {
                PerfEvaObjectInfo info = coll.get(i);
                weightForce100 = info.getPeriod().getPerfPlan().isWeightForce100();
                PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfoByEvaObj(ctx, info.getId().toString());
                if (ruleInfo.getScoringWay().getValue() == 1) {
                    String errorInfo = IndicatorUtils.detectAreaIndicatorWeight(ctx, info.getPeriod().getId().toString(), info.getId().toString());
                    if (!"200".equals(errorInfo)) {
                        continue;
                    }
                } else if (weightForce100) {
                    float weight = GoalsTransmitService.calculateEvaObjTargetWeight(ctx, info.getId().toString());
                    if (weight != 100.0f) {
                        continue;
                    }
                } else {
                    IndicatorTargetCollection indicatorTargetCollection = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetCollection(" where evaObj='" + info.getId().toString() + "'");
                    RecordTargetCollection recordTargetCollection = RecordTargetFactory.getLocalInstance(ctx).getRecordTargetCollection(" where evaObj='" + info.getId().toString() + "'");
                    if (indicatorTargetCollection.size() == 0 && recordTargetCollection.size() == 0) {
                        throw new IllegalArgumentException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.NOTARGETS, ctx));
                    }
                }
                iGoalsTargetFacade.batchGoalsTransmit(info.getId().toString(), info.getPeriod().getId().toString());
                ++sucess;
                AdminRangeUtils.sendMessageToFillers(ctx, new String[]{info.getId().toString()});
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw new IllegalArgumentException(e.getMessage());
            }
            logger.error("", (Throwable)e);
        }
        return sucess;
    }

    private Map<String, Object> goalsBack(Context ctx, String[] evaObjIds, String backReason, Map param) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String failedMsg = "";
        HashSet<String> set = new HashSet<String>();
        HashSet<String> doSet = new HashSet<String>();
        for (int i = 0; i < evaObjIds.length; ++i) {
            set.add(evaObjIds[i]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        filter.mergeFilter(fi, "and");
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("period.perfPlan"));
        sic.add(new SelectorItemInfo("personalGoalStatus"));
        sic.add(new SelectorItemInfo("name"));
        viewInfo.setFilter(filter);
        PerfEvaObjectCollection coll = PerfEvaObjectFactory.getLocalInstance(ctx).getPerfEvaObjectCollection(viewInfo);
        int sucess = 0;
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        ArrayList<String> unitAfterFillSet = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            PerfEvaObjectInfo info = coll.get(i);
            PerfEvaObjectPersonalGoalStatusEnum personalGoalStatus = info.getPersonalGoalStatus();
            if (!personalGoalStatus.equals((Object)PerfEvaObjectPersonalGoalStatusEnum.UNASSIGBED)) {
                failedMsg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.BACKERRASGOALSUNSBMITORTRNSMITTED, ctx);
                continue;
            }
            try {
                GoalsTargetFacadeFactory.getLocalInstance(ctx).batchBack(info.getId().toString(), info.getPeriod().getId().toString());
                PerfEvaTargetBackReasonInfo backReasonInfo = new PerfEvaTargetBackReasonInfo();
                backReasonInfo.setReason(backReason);
                backReasonInfo.setEvaObj(info);
                backReasonInfo.setId(BOSUuid.create((String)"792D9BC8"));
                coreBaseCollection.add((CoreBaseInfo)backReasonInfo);
                ++sucess;
                doSet.add(info.getId().toString());
                PerfPlanInfo perfPlanInfo = PerfPlanFactory.getLocalInstance(ctx).getPerfPlanInfo("where id='" + info.getPeriod().getPerfPlan().getId().toString() + "'");
                if (!perfPlanInfo.isOnlyFillerReceiver()) continue;
                unitAfterFillSet.add(info.getId().toString());
                continue;
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
                failedMsg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.OPERATEFAILED, ctx);
            }
        }
        if (coreBaseCollection.size() > 0) {
            PerfEvaTargetBackReasonFactory.getLocalInstance(ctx).addnew(coreBaseCollection);
        }
        String yzjType = (String)param.get("yzjType");
        String sysType = (String)param.get("sysType");
        String smsType = (String)param.get("smsType");
        String emailType = (String)param.get("emailType");
        MsgConfigBean config = new MsgConfigBean();
        config.setEmailType("SEND".equals(emailType));
        config.setSmsType("SEND".equals(smsType));
        config.setYzjType("SEND".equals(yzjType));
        config.setSysType("SEND".equals(sysType));
        config.setSmsTemplateCode("Perf0027");
        if (config.isSend()) {
            ArrayList<String> sucessSet = new ArrayList<String>(doSet);
            new PerfEvaObjectControllerBean().urgedPersonalGoalsBack(ctx, sucessSet, config);
        }
        if (unitAfterFillSet.size() > 0) {
            StringBuilder evaObjIdStr = new StringBuilder("");
            for (String id : unitAfterFillSet) {
                evaObjIdStr.append("'").append(id).append("',");
            }
            String evaObjIdCondition = "";
            if (evaObjIdStr.length() > 0) {
                evaObjIdCondition = evaObjIdStr.substring(0, evaObjIdStr.length() - 1);
            }
            String updateSql = "update T_EVA_PerfEvaObject set funitAfterFiller=0 where FID in (" + evaObjIdCondition + ")";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
        resultMap.put("sucess", sucess);
        resultMap.put("failedMsg", failedMsg);
        return resultMap;
    }

    public static float calculateEvaObjTargetWeight(Context ctx, String evaObj) {
        try {
            IndicatorTargetCollection indicatorColl;
            BigDecimal weight = BigDecimal.ZERO;
            IRecordTarget irecordTarget = RecordTargetFactory.getLocalInstance(ctx);
            IIndicatorTarget iindicatorTarget = IndicatorTargetFactory.getLocalInstance(ctx);
            RecordTargetCollection recordTargetColl = irecordTarget.getRecordTargetCollection("where evaObj='" + evaObj + "'");
            if (recordTargetColl != null && recordTargetColl.size() > 0) {
                for (int i = 0; i < recordTargetColl.size(); ++i) {
                    String targetWeight;
                    String sumScoreRule = "";
                    boolean sumScoreRuleFlag = false;
                    String areaBase = recordTargetColl.get(i).getAreaBase().getId().toString();
                    EvaluFormAreaBaseCollection areaBaseColl = GetEntityInfoUtils.getEvaluFormAreaBaseCollById(ctx, areaBase);
                    if (areaBaseColl != null && areaBaseColl.size() > 0) {
                        sumScoreRule = areaBaseColl.get(0).getSumScoreRule().getValue();
                        boolean bl = sumScoreRuleFlag = sumScoreRule.equals("400") || sumScoreRule.equals("500");
                    }
                    if (StringUtil.isEmptyString((String)(targetWeight = recordTargetColl.get(i).getWeight())) && StringUtils.isEmpty((String)recordTargetColl.get(i).getKeyItem())) {
                        return 101.0f;
                    }
                    if (StringUtil.isEmptyString((String)targetWeight) || sumScoreRuleFlag) continue;
                    weight = weight.add(new BigDecimal(targetWeight));
                }
            }
            if ((indicatorColl = iindicatorTarget.getIndicatorTargetCollection("where evaObj='" + evaObj + "'")) != null && indicatorColl.size() > 0) {
                for (int j = 0; j < indicatorColl.size(); ++j) {
                    String sumScoreRule = "";
                    boolean sumScoreRuleFlag = false;
                    String areaBase = indicatorColl.get(j).getAreaBase().getId().toString();
                    EvaluFormAreaBaseCollection areaBaseColl = GetEntityInfoUtils.getEvaluFormAreaBaseCollById(ctx, areaBase);
                    if (areaBaseColl != null && areaBaseColl.size() > 0) {
                        sumScoreRule = areaBaseColl.get(0).getSumScoreRule().getValue();
                        boolean bl = sumScoreRuleFlag = sumScoreRule.equals("400") || sumScoreRule.equals("500");
                    }
                    if (SubAreaTypeEnum.ADDSUB.equals((Object)areaBaseColl.get(0).getSubAreaType())) continue;
                    String targetWeight = indicatorColl.get(j).getWeight();
                    if (StringUtil.isEmptyString((String)targetWeight) && !indicatorColl.get(j).isRejection() && StringUtils.isEmpty((String)indicatorColl.get(j).getName())) {
                        return 101.0f;
                    }
                    if (StringUtil.isEmptyString((String)targetWeight) || sumScoreRuleFlag) continue;
                    weight = weight.add(new BigDecimal(targetWeight));
                }
            }
            return weight.floatValue();
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            return 0.0f;
        }
    }
}

