/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf.targetrelation;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsTransmitFacadeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectPersonalGoalStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetDecomposeFacadeFactory;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetReviseBillCollection;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetReviseBillFactory;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetReviseBillInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.portal.bean.IndicatorBeanList;
import com.kingdee.shr.perfweb.portal.bean.RecordBeanList;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.portal.serviceImpl.TargetRelationService;
import com.kingdee.shr.perfweb.util.PerfPlanExecuteUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.IndicatorUtils;
import com.kingdee.shr.perfweb.utils.PerfPlanUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DecomposeOrSaveTargetService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger(DecomposeOrSaveTargetService.class);
    private static final String OPERATOR_TYPE1 = "1";
    private static final String OPERATOR_TYPE2 = "2";

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        String type = (String)map.get("type");
        String targetId = (String)map.get("targetId");
        String recordList = (String)map.get("recordList");
        String indicatorList = (String)map.get("indicatorList");
        String recordFieldArr = (String)map.get("recordFieldArr");
        String indicatorFieldArr = (String)map.get("indicatorFieldArr");
        Gson gson = new Gson();
        RecordBeanList recordArr = (RecordBeanList)gson.fromJson(recordList, RecordBeanList.class);
        IndicatorBeanList indicatorArr = (IndicatorBeanList)gson.fromJson(indicatorList, IndicatorBeanList.class);
        ArrayList recordFieldList = (ArrayList)gson.fromJson(recordFieldArr, new ArrayList().getClass());
        ArrayList indicatorFieldList = (ArrayList)gson.fromJson(indicatorFieldArr, new ArrayList().getClass());
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (OPERATOR_TYPE1.equals(type)) {
            String targetSuccessor = (String)map.get("targetSuccessor");
            List targetSuccessorList = (List)gson.fromJson(targetSuccessor, new TypeToken<List<Map>>(){}.getType());
            return this.decomposeTarget(ctx, targetSuccessorList, targetId, indicatorArr, recordArr, indicatorFieldList, recordFieldList);
        }
        int scoringWay = 0;
        if (map.get("scoringWay") != null) {
            scoringWay = (Integer)map.get("scoringWay");
        }
        String periodId = (String)map.get("periodId");
        String toDeleteIndicatorIds = (String)map.get("toDeleteIndicatorIds");
        String evaObj = (String)map.get("evaObj");
        String indicatorUpdateObj = (String)map.get("indicatorUpdateObj");
        if (OPERATOR_TYPE2.equals(type)) {
            TargetReviseBillCollection coll = TargetReviseBillFactory.getLocalInstance(ctx).getTargetReviseBillCollection("select *,indicators.*,records.* WHERE evaObj = '" + evaObj + "' and  billState in (0,1,2)");
            if (coll == null || coll.isEmpty()) {
                result.put("success", 0);
                result.put("errMsg", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REVISEBILLNOTFOUND, ctx));
                return result;
            }
            TargetReviseBillInfo reviseBillInfo = coll.get(0);
            if (!HRBillStateEnum.SAVED.equals((Object)reviseBillInfo.getBillState()) && !HRBillStateEnum.SUBMITED.equals((Object)reviseBillInfo.getBillState())) {
                result.put("success", 0);
                result.put("errMsg", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SAVEFAILEDASBILLAUDITING, ctx));
                return result;
            }
            this.saveTarget(ctx, evaObj, periodId, scoringWay, toDeleteIndicatorIds, indicatorArr, recordArr, indicatorFieldList, recordFieldList, indicatorUpdateObj, reviseBillInfo);
        } else {
            PerfGoasFillService.getInstance().saveTarget(ctx, map);
        }
        result.put("success", 1);
        return result;
    }

    private Map<String, Object> decomposeTarget(Context ctx, List<Map> targetSuccessorList, String targetId, IndicatorBeanList indicatorArr, RecordBeanList recordArr, ArrayList<String> indicatorFieldList, ArrayList<String> recordFieldList) throws BOSException, EASBizException {
        String areaBase;
        ObjectBaseInfo targetInfo;
        HashSet<String> evaObjs = new HashSet<String>();
        for (int i = 0; i < targetSuccessorList.size(); ++i) {
            Map targetSuccessorMap = targetSuccessorList.get(i);
            evaObjs.add(targetSuccessorMap.get("id").toString());
        }
        if (indicatorArr.getIndicatorList() != null && indicatorArr.getIndicatorList().size() > 0) {
            targetInfo = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetInfo("SELECT areaBase WHERE ID ='" + targetId + "'");
            areaBase = targetInfo.getAreaBase().getId().toString();
        } else {
            targetInfo = RecordTargetFactory.getLocalInstance(ctx).getRecordTargetInfo("SELECT areaBase WHERE ID ='" + targetId + "'");
            areaBase = targetInfo.getAreaBase().getId().toString();
        }
        TargetRelationService targetRelationService = TargetRelationService.getInstance();
        List<IndicatorTargetInfo> list = null;
        try {
            list = targetRelationService.assembleData(ctx, recordArr, indicatorArr, recordFieldList, indicatorFieldList, evaObjs, areaBase);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        if (!CollectionUtils.isEmpty(list)) {
            return this.saveTargetAndRelation(ctx, list, targetId);
        }
        return null;
    }

    private Map<String, Object> saveTargetAndRelation(Context ctx, List list, String targetId) throws BOSException, EASBizException {
        int sucess = 0;
        int failure = 0;
        String billId = "";
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<String> sucessIds = new HashSet<String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)targetId, CompareType.EQUALS));
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("perfPeriod.perfrule.scoringWay"));
        viewInfo.setFilter(filter);
        IndicatorTargetCollection coll = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetCollection(viewInfo);
        int scoringWay = coll.get(0).getPerfPeriod().getPerfRule().getScoringWay().getValue();
        IPerfEvaObject iperfEvaObj = PerfEvaObjectFactory.getLocalInstance(ctx);
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add(new SelectorItemInfo("personalGoalStatus"));
        for (int i = 0; i < list.size(); ++i) {
            IObjectValue info = (IObjectValue)list.get(i);
            String id = ((PerfEvaObjectInfo)info.get("evaObj")).getId().toString();
            billId = billId + id + ",";
            if (sucessIds.contains(id)) continue;
            sucessIds.add(id);
            try {
                boolean isDecomposeExist = TargetDecomposeFacadeFactory.getLocalInstance(ctx).targetDecompose2(info, targetId, OPERATOR_TYPE1);
                if (isDecomposeExist) {
                    ++failure;
                    continue;
                }
                if (scoringWay == 0) {
                    float weight = PerfPlanExecuteUtils.calculateEvaObjTargetWeight(ctx, id);
                    GoalsTransmitFacadeFactory.getLocalInstance(ctx).writeBackEvaObjGoalsPercent(id, String.valueOf(weight));
                } else if (scoringWay == 1) {
                    float tarScore = PerfPlanExecuteUtils.calculateEvaObjTargetTarScore(ctx, id);
                    GoalsTransmitFacadeFactory.getLocalInstance(ctx).writeBackEvaObjGoalsScore(id, String.valueOf(tarScore));
                }
                PerfEvaObjectInfo updateEvaObject = (PerfEvaObjectInfo)info.get("evaObj");
                updateEvaObject.setPersonalGoalStatus(PerfEvaObjectPersonalGoalStatusEnum.ESTABLISHED);
                iperfEvaObj.updatePartial(updateEvaObject, sic1);
                ++sucess;
                continue;
            }
            catch (BOSException e) {
                ++failure;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        result.put("successCount", sucess);
        result.put("failureCount", failure);
        if (failure > 0) {
            result.put("errMsg", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DECOMPOSERELATIONEXISTED, ctx));
        }
        return result;
    }

    private void saveTarget(Context ctx, String evaObj, String periodId, int scoringWay, String toDeleteIndicatorIds, IndicatorBeanList indicatorArr, RecordBeanList recordArr, ArrayList<String> indicatorFieldList, ArrayList<String> recordFieldList, String indicatorUpdateObj, TargetReviseBillInfo reviseBillInfo) throws BOSException, EASBizException {
        StringBuffer filterBuffer = new StringBuffer("(''");
        if (!StringUtils.isEmpty((CharSequence)toDeleteIndicatorIds)) {
            String[] toDeleteIds;
            for (String toDeleteId : toDeleteIds = toDeleteIndicatorIds.split(",")) {
                filterBuffer.append(",").append("'").append(toDeleteId).append("'");
            }
        }
        filterBuffer.append(")");
        if (recordArr != null && reviseBillInfo != null) {
            IndicatorUtils.updateRecordTargetHIS(ctx, recordArr, recordFieldList, periodId, reviseBillInfo, scoringWay);
        }
        if (indicatorArr != null && reviseBillInfo != null) {
            IndicatorUtils.updateIndicatorTargetHIS(ctx, indicatorArr, indicatorFieldList, periodId, reviseBillInfo, scoringWay);
        }
        if (reviseBillInfo != null && !StringUtils.isEmpty((CharSequence)toDeleteIndicatorIds)) {
            PerfPlanUtils.deleteIndicatorTargetHIS(ctx, filterBuffer.toString(), evaObj);
        }
    }
}

