/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf.targetrelation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsProgressCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsProgressInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.osf.converter.CoreConverter;
import com.kingdee.shr.perfweb.osf.model.SimpleFieldInfo;
import com.kingdee.shr.perfweb.portal.bean.AreaFieldBean;
import com.kingdee.shr.perfweb.portal.bean.EvaAreaListBean;
import com.kingdee.shr.perfweb.portal.bean.PersonalEvaBaseBean;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.portal.serviceImpl.TargetRelationService;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.shr.perfweb.utils.PermissionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GetTargetAndRelationService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger(GetTargetAndRelationService.class);

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap();
        String targetId = (String)map.get("targetId");
        try {
            PerfGoasFillService perfGoasFillService = PerfGoasFillService.getInstance();
            result = perfGoasFillService.compositeEvaObjectDataByTargetIdAction(ctx, targetId);
            GoalsProgressInfo goalsProgressInfo = null;
            GoalsProgressCollection goalsProgressColls = perfGoasFillService.getProgressCollByTargetId(ctx, targetId);
            if (goalsProgressColls != null && !goalsProgressColls.isEmpty()) {
                goalsProgressInfo = goalsProgressColls.get(0);
            }
            TargetRelationService targetRelationService = TargetRelationService.getInstance();
            targetRelationService.getRelationTarget(ctx, targetId, result);
            List decomposeList = (List)result.get("decompose");
            if (decomposeList != null) {
                HashSet<String> evaObjIds = new HashSet<String>();
                for (Object item : decomposeList) {
                    if (item.get("FREJECTION") != null && ((Boolean)item.get("FREJECTION")).booleanValue()) {
                        item.put("FREJECTION", "1");
                    } else {
                        item.put("FREJECTION", "0");
                    }
                    evaObjIds.add(((PerfEvaObjectInfo)item.get("FEVAOBJ")).getId().toString());
                }
                Map<String, String> responseMap = OrgAssessmentUtils.getResponsorsMap(ctx, evaObjIds);
                if (responseMap != null) {
                    for (Map item : decomposeList) {
                        item.put("FRESPONSERNAME", responseMap.get(((PerfEvaObjectInfo)item.get("FEVAOBJ")).getId().toString()));
                    }
                }
            }
            PersonalEvaBaseBean row = (PersonalEvaBaseBean)result.get("rows");
            List<SimpleFieldInfo> simpleFieldInfos = new CoreConverter().buildSimpleFieldsByModel(ctx, "com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTarget", map);
            for (EvaAreaListBean evaAreaListBean : row.getEvaAreaList()) {
                ArrayList<HashMap<String, Object>> indicatorList;
                for (AreaFieldBean fieldBean : evaAreaListBean.getFieldList()) {
                    for (SimpleFieldInfo simpleFieldInfo : simpleFieldInfos) {
                        String baseColName = fieldBean.getColName().substring(1);
                        if (baseColName.equalsIgnoreCase(simpleFieldInfo.getFieldName())) {
                            fieldBean.setFieldType(simpleFieldInfo.getFieldType());
                            fieldBean.setOptions(simpleFieldInfo.getOptions());
                            fieldBean.setHidden(simpleFieldInfo.isHidden());
                            fieldBean.setDataSource(simpleFieldInfo.getDataSource());
                        }
                        if (!baseColName.equalsIgnoreCase("COMMENT") && !baseColName.equalsIgnoreCase("SCORE") && !baseColName.equalsIgnoreCase("ACTUALCOMPLEVALUE") && !baseColName.equalsIgnoreCase("ACTUALCOMPLETETIME") && !baseColName.equalsIgnoreCase("ACTUALCOMPLETEDESC")) continue;
                        fieldBean.setHidden(true);
                    }
                }
                if (!evaAreaListBean.getAreaType().equals("200") || CollectionUtils.isEmpty(indicatorList = evaAreaListBean.getEvaIndicatorList())) continue;
                HashMap values = (HashMap)indicatorList.get(0);
                if (goalsProgressInfo != null) {
                    values.put("FACTUALCOMPLEVALUE", goalsProgressInfo.getActualCompleValue());
                    values.put("FTARGETVALUE", goalsProgressInfo.getTargetValue());
                    values.put("FCOMPLEPROGRESS", goalsProgressInfo.getCompleProgress());
                    values.put("FGOALSPERSON", goalsProgressInfo.getCreator().getName());
                    continue;
                }
                values.put("FCOMPLEPROGRESS", "0");
                values.put("FGOALSPERSON", values.get("FPERSONNAME"));
            }
            result.put("isShowField", targetRelationService.getIsShowField(ctx, targetId));
            boolean perfSumInterview = PermissionUtils.hasFunctionPermission(ctx, "targetDecompose");
            result.put("targetDecompose", perfSumInterview);
        }
        catch (Exception e) {
            logger.error("GetTargetAndRelationService err: ", (Throwable)e);
        }
        return result;
    }
}

