/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.portal.serviceImpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileFactory;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetTransmitWayEnum;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.portal.bean.AreaFieldBean;
import com.kingdee.shr.perfweb.portal.bean.EvaAreaListBean;
import com.kingdee.shr.perfweb.portal.serviceImpl.AbstractAreaTypeBaseService;
import com.kingdee.shr.perfweb.portal.serviceImpl.AreaTypeServiceFactory;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfFillScoreService;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.IndicatorUtils;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.shr.perfweb.utils.PerfWorkFlowUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfFillTargetService
extends PerfFillScoreService {
    private final Logger logger = LoggerFactory.getLogger(PerfFillTargetService.class);

    @Override
    protected String buildAreaQuerySql(Context ctx, String gradeTaskNode, String evaObjId, String personId, String reluId, String refAreaType, PerfEvaObjectInfo evaObjectInfo) throws SQLException, BOSException {
        String areaQuerySql = StringUtils.isNotEmpty((CharSequence)refAreaType) ? "where performanceRule='" + reluId + "' and areaType = '" + refAreaType + "' order by Seq ASC" : "where performanceRule='" + reluId + "' order by Seq ASC";
        return areaQuerySql;
    }

    @Override
    protected IRowSet executeTargetQuerySql(Context ctx, YesOrNoEnum isShowQuantity, String areaType, ArrayList<AreaFieldBean> fieldList, String evaObj, String areaId, String personId) throws BOSException {
        StringBuilder sqlBuilder = new StringBuilder("select indicator.FID AS FID,indicator.FEXTENDID AS FEXTENDID,indicator.FWEIGHT AS FWEIGHT");
        for (int k = 0; k < fieldList.size(); ++k) {
            String colName = fieldList.get(k).getColName();
            if (colName.equalsIgnoreCase("FWEIGHT")) continue;
            if (colName.toUpperCase(Locale.ENGLISH).contains("EXTEND")) {
                sqlBuilder.append(",helper.").append(colName).append(" AS ").append(colName);
                continue;
            }
            if ("200".equals(areaType) && IndicatorUtils.multiTBField4Indicator.contains(colName.toUpperCase(Locale.ENGLISH)) || "300".equals(areaType) && IndicatorUtils.multiTBField4Record.contains(colName.toUpperCase(Locale.ENGLISH))) {
                sqlBuilder.append(",indicator.").append(colName).append(SHRPerfWebResourceUtil.getMlFlag(ctx)).append(" AS ").append(colName);
                continue;
            }
            sqlBuilder.append(",indicator.").append(colName).append(" AS ").append(colName);
        }
        if ("200".equals(areaType)) {
            for (String multiField : IndicatorUtils.multiTBFields4Indicator) {
                sqlBuilder.append(",indicator.").append(multiField).append(" AS ").append(multiField);
            }
            sqlBuilder.append(" from T_EVA_IndicatorTarget indicator left join T_EVA_IndicatorExtendHelper helper ").append("on indicator.FExtendId = helper.FID where indicator.FEvaObjID='").append(evaObj).append("' and indicator.FAreaBaseID='").append(areaId).append("' order by indicator.FSeq asc, to_char(indicator.FCreateTime, 'YYYY-MM-DD HH24:MI:SS')  asc,indicator.FNumber asc ,indicator.FName").append(SHRPerfWebResourceUtil.getMlFlag(ctx)).append(" asc");
        } else {
            for (String multiField : IndicatorUtils.multiTBFields4Record) {
                sqlBuilder.append(",indicator.").append(multiField).append(" AS ").append(multiField);
            }
            sqlBuilder.append(" from T_EVA_RecordTarget indicator left join T_EVA_IndicatorExtendHelper helper ").append("on indicator.FExtendId = helper.FID where indicator.FEvaObjID='").append(evaObj).append("' and indicator.FAreaBaseID='").append(areaId).append("' order by indicator.FSeq asc, to_char(indicator.FCreateTime, 'YYYY-MM-DD HH24:MI:SS')  asc,indicator.FKeyCode asc ,indicator.FKeyItem").append(SHRPerfWebResourceUtil.getMlFlag(ctx)).append(" asc");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
    }

    @Override
    protected void packageTargetDetailInfo(Context ctx, IRowSet rowSet, EvaAreaListBean evaAreaBean, String gradeTaskNode, String personId, PerfEvaObjectInfo evaObjectInfo) throws SQLException, BOSException, EASBizException {
        AbstractAreaTypeBaseService areaTypeService = AreaTypeServiceFactory.getAreaTypeService(evaAreaBean.getAreaType());
        if (areaTypeService == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("PerfFillTargetService get areaTypeService is null");
            }
            return;
        }
        areaTypeService.packageTargetDetailInfo(ctx, rowSet, evaAreaBean, gradeTaskNode, personId, evaObjectInfo, "0");
    }

    @Override
    protected boolean isNeedCopy(String concurrent) {
        return false;
    }

    @Override
    protected void dealFillTargetInfo(Context ctx, Map<String, Object> result, PerfEvaObjectInfo evaObjectInfo, PerfPeriodInfo periodInfo) throws BOSException, EASBizException {
        result.put("goalsScore", evaObjectInfo.getGoalsScore());
        result.put("goalsPercent", evaObjectInfo.getGoalsPercent());
        PerfPlanInfo plan = periodInfo.getPerfPlan();
        int targetCanEdit = plan.isTargetCanEdit() ? 1 : 0;
        result.put("targetCanEdit", targetCanEdit);
        if (periodInfo == null) {
            result.put("goalsGiver", "");
        } else if (!OrgAssessmentUtils.isOrgAssessment(evaObjectInfo)) {
            if (plan.getTargetTransmitWay().getValue().equals(TargetTransmitWayEnum.PROCESS.getValue())) {
                result.put("goalsGiver", "");
            } else {
                PerfGoalsObjectCollection coll;
                int isSuperior = evaObjectInfo.getIsSuperior().getValue();
                StringBuilder sb = new StringBuilder(48);
                if (1 == isSuperior) {
                    String perfFileId = evaObjectInfo.getPerfFile().getId().toString();
                    PerfFileInfo perfFileInfo = PerfFileFactory.getLocalInstance(ctx).getPerfFileInfo(" where id='" + perfFileId + "'");
                    Map<String, String> directMap = PerfWorkFlowUtils.getDirectSuperior(ctx, perfFileInfo.getPosition().getId().toString());
                    for (String key : directMap.keySet()) {
                        sb.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUPERIORWITHPREFIX, ctx, new Object[]{directMap.get(key)})).append(",");
                    }
                }
                try {
                    coll = PerfGoalsObjectFactory.getRemoteInstance().getPerfGoalsObjectCollection("where perfEvaObject ='" + evaObjectInfo.getId().toString() + "'");
                }
                catch (BOSException e) {
                    this.logger.error("BOSException: ", (Throwable)e);
                    coll = new PerfGoalsObjectCollection();
                }
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    sb.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ASSIGNERWITHPREFIX, ctx, new Object[]{coll.get(i).getPersonName()})).append(",");
                }
                if (sb.length() > 0) {
                    result.put("goalsGiver", sb.substring(0, sb.length() - 1));
                } else {
                    result.put("goalsGiver", sb.toString());
                }
            }
        }
    }

    @Override
    protected void setNeedScore(Context ctx, Map<String, Object> result, String gradeTaskNode) throws BOSException {
    }

    @Override
    protected void getAreaSumScore(Context ctx, String gradeTaskNode, String evaObj, ArrayList<EvaAreaListBean> evaAreaBeanList) {
    }

    @Override
    protected List<EvaAreaListBean> setNodeInfoToEvaArea(Context ctx, List<EvaAreaListBean> evaAreaBeanList, String gradeTaskNode, String targetTableName) {
        return null;
    }
}

