/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.portal.serviceImpl;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.IRecordTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PersonalGoalsStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IRecordFieldConf;
import com.kingdee.shr.perfweb.app.base.evalrule.RecordFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.RecordFieldConfFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.RecordFieldConfInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstInfo;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.base.bean.SelectFieldTypeConfigBean;
import com.kingdee.shr.perfweb.exception.SHRPerfWebException;
import com.kingdee.shr.perfweb.osf.converter.FieldTypeConverter;
import com.kingdee.shr.perfweb.osf.model.FieldType;
import com.kingdee.shr.perfweb.osf.model.Option;
import com.kingdee.shr.perfweb.portal.bean.AreaFieldBean;
import com.kingdee.shr.perfweb.portal.bean.EvaAreaListBean;
import com.kingdee.shr.perfweb.portal.serviceImpl.AbstractAreaTypeBaseService;
import com.kingdee.shr.perfweb.util.EvaFormUtil;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.MetaDataUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.IndicatorUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordTargetService
extends AbstractAreaTypeBaseService {
    private final Logger logger = LoggerFactory.getLogger(RecordTargetService.class);
    private static final String TARGET_TABLE_NAME = "T_EVA_RecordTarget";

    @Override
    public String getTargetTableName() {
        return TARGET_TABLE_NAME;
    }

    @Override
    public void packageFiledListWithEvaAreaBeans(Context ctx, ArrayList<EvaAreaListBean> evaAreaBeanList) throws SHRPerfWebException {
        try {
            String areaBaseIdStr = evaAreaBeanList.stream().map(evaAreaBean -> "'" + evaAreaBean.getAreaId() + "'").collect(Collectors.joining(","));
            RecordFieldConfCollection recordFieldColl = this.getRecordFieldColl(ctx, areaBaseIdStr);
            if (recordFieldColl != null && recordFieldColl.size() > 0) {
                for (EvaAreaListBean evaAreaBean2 : evaAreaBeanList) {
                    ArrayList<AreaFieldBean> fieldList = new ArrayList<AreaFieldBean>();
                    for (int j = 0; j < recordFieldColl.size(); ++j) {
                        PropertyInfo propertyInfo;
                        SelectFieldTypeConfigBean selectFieldTypeConfigBean;
                        String fieldTypeConfig;
                        RecordFieldConfInfo recordFieldInfo = recordFieldColl.get(j);
                        if (!evaAreaBean2.getAreaId().equals(recordFieldInfo.getAreaBase())) continue;
                        AreaFieldBean areaFieldBean = new AreaFieldBean();
                        areaFieldBean.setId(recordFieldInfo.getId().toString());
                        areaFieldBean.setColName(recordFieldInfo.getColName());
                        areaFieldBean.setShowName(recordFieldInfo.getShowName());
                        areaFieldBean.setRequired(recordFieldInfo.getIsRequired() != null && "1".equals(recordFieldInfo.getIsRequired().getValue()));
                        areaFieldBean.setSeqNo(recordFieldInfo.getSeqNo());
                        areaFieldBean.setTemplateId(recordFieldInfo.getFieldTemplate());
                        if (recordFieldInfo.getFieldShowLocation() != null) {
                            areaFieldBean.setFieldShowLocation(recordFieldInfo.getFieldShowLocation().getValue());
                        }
                        if (recordFieldInfo.getFieldMaintenanceStage() != null) {
                            areaFieldBean.setFieldMaintenanceStage(recordFieldInfo.getFieldMaintenanceStage().getValue());
                        }
                        areaFieldBean.setFillOverwrite(recordFieldInfo.getFillOverwrite());
                        if ("FINDECATORTYPE".equalsIgnoreCase(recordFieldInfo.getColName())) {
                            areaFieldBean.setFieldType(FieldType.F7);
                        } else {
                            areaFieldBean.setFieldType(FieldTypeConverter.toFieldType(recordFieldInfo.getFieldType()));
                        }
                        if (FieldType.Select.equals((Object)areaFieldBean.getFieldType()) && StringUtils.isNotBlank((CharSequence)(fieldTypeConfig = recordFieldInfo.getFieldTypeConfig())) && (selectFieldTypeConfigBean = (SelectFieldTypeConfigBean)JSON.parseObject((String)fieldTypeConfig, SelectFieldTypeConfigBean.class)) != null) {
                            List<Option> options = selectFieldTypeConfigBean.getOptions();
                            areaFieldBean.setOptions(options);
                        }
                        if ((propertyInfo = MetaDataUtil.getPropertyInfo(RecordTarget.class.getCanonicalName(), recordFieldInfo.getColName().substring(1))) == null) {
                            areaFieldBean.setMultiLang(false);
                        } else {
                            areaFieldBean.setMultiLang(propertyInfo.getMappingField().isMultilingual());
                        }
                        fieldList.add(areaFieldBean);
                    }
                    AreaFieldBean areaFieldBean = new AreaFieldBean();
                    areaFieldBean.setColName("FISUNITED");
                    areaFieldBean.setShowName(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.UNIFIEDTRANSMITORNOT, ctx));
                    fieldList.add(areaFieldBean);
                    evaAreaBean2.setFieldList(fieldList);
                }
            }
        }
        catch (BOSException e) {
            this.logger.error("RecordTargetService#packageFiledListWithEvaAreaBeans is error", (Throwable)e);
            throw new SHRPerfWebException("RecordTargetService#packageFiledListWithEvaAreaBeans is error");
        }
    }

    private RecordFieldConfCollection getRecordFieldColl(Context ctx, String areaBaseId) throws BOSException {
        IRecordFieldConf irecordFieldConf = RecordFieldConfFactory.getLocalInstance(ctx);
        return irecordFieldConf.getRecordFieldConfCollection(" where areaBase in (" + areaBaseId + ") order by seqNo ASC");
    }

    @Override
    public void packageTargetDetailInfo(Context ctx, IRowSet rs, EvaAreaListBean evaAreaBean, String gradeTaskNode, String personId, PerfEvaObjectInfo evaObjectInfo, String getTargetType) throws SQLException, BOSException, EASBizException {
        HashSet<String> targetIdSet = new HashSet<String>(16);
        while (rs.next()) {
            targetIdSet.add(rs.getString("FID"));
        }
        HashMap<String, RecordTargetInfo> recordMap = new HashMap<String, RecordTargetInfo>(16);
        HashMap<String, GradeTargetInstInfo> gtInstMap = new HashMap<String, GradeTargetInstInfo>(16);
        this.getRecordTargetDataMap(ctx, targetIdSet, evaObjectInfo, gradeTaskNode, gtInstMap, getTargetType, personId, recordMap);
        DecimalFormat df = new DecimalFormat("0.00");
        HashSet<String> tarIdSet = new HashSet<String>(16);
        BigDecimal areaWeight = BigDecimal.ZERO;
        BigDecimal areaTarScore = BigDecimal.ZERO;
        ArrayList<HashMap<String, Object>> evaRecordList = new ArrayList<HashMap<String, Object>>();
        rs.beforeFirst();
        Map<String, Map<String, Object>> targetExtendInfoMap = EvaFormUtil.putExtendInfos(ctx, targetIdSet);
        while (rs.next()) {
            String nodeTask;
            HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
            String weightStr = "0";
            String tarScoreStr = "0";
            String targetId = rs.getString("FID");
            fieldValueMap.put("FID", targetId);
            RecordTargetInfo info = (RecordTargetInfo)recordMap.get(targetId);
            fieldValueMap.put("FGOALSSTATUS", (Object)(info.getGoalsStatus() == null ? PersonalGoalsStatusEnum.SAVE : info.getGoalsStatus()));
            fieldValueMap.put("FPSTARTDATE", info.getPerfPeriod().getPStartDate());
            fieldValueMap.put("FPENDDATE", info.getPerfPeriod().getPEndDate());
            fieldValueMap.put("FREFTARGET", info.getRefTarget());
            fieldValueMap.put("FSEQ", info.getSeq());
            fieldValueMap.put("FEXTENDID", rs.getString("FEXTENDID"));
            if (null != gtInstMap.get(targetId)) {
                String gradRank = "";
                GradeTargetInstInfo gtInstInfo = (GradeTargetInstInfo)gtInstMap.get(targetId);
                Object targetScore = gtInstInfo.get("targetScore");
                fieldValueMap.put("targetScore", targetScore == null ? "" : targetScore);
                if (!StringUtils.isEmpty((CharSequence)gtInstInfo.getGradeRank())) {
                    gradRank = gtInstInfo.getGradeRank();
                }
                fieldValueMap.put("gradeRank", gradRank);
                fieldValueMap.put("FCOMMENT", gtInstInfo.getComment());
                fieldValueMap.put("nodeTask", gtInstInfo.getGradeTaskNode().getId().toString());
                fieldValueMap.put("isRejection", (Object)gtInstInfo.getIsRejection());
            } else {
                fieldValueMap.put("targetScore", "");
                fieldValueMap.put("gradeRank", "");
                fieldValueMap.put("isRejection", (Object)YesOrNoEnum.NO);
            }
            WFNodeDefInfo wfNode = null;
            if ((getTargetType.equals("1") || getTargetType.equals("2")) && StringUtils.isNotEmpty((CharSequence)(nodeTask = (String)fieldValueMap.get("nodeTask")))) {
                GradeTaskNodeInstInfo gradeTaskNodeInstInfo = GetEntityInfoUtils.getGradeTaskNodeAndNodeDefInfoById(ctx, nodeTask);
                wfNode = gradeTaskNodeInstInfo.getWfNode();
            }
            Map<String, Object> putExtendInfo = targetExtendInfoMap.get(targetId);
            for (int m = 0; m < evaAreaBean.getFieldList().size(); ++m) {
                AreaFieldBean areaFieldBean = evaAreaBean.getFieldList().get(m);
                String colName = areaFieldBean.getColName();
                String colValue = rs.getString(colName);
                colValue = colValue == null ? "" : colValue;
                FieldType fieldType = areaFieldBean.getFieldType();
                colValue = EvaFormUtil.setBooleanMulitLan(ctx, fieldType, colValue, colName, fieldValueMap);
                if (colName.equalsIgnoreCase("FTARSCORE") && StringUtils.isBlank((CharSequence)colValue)) {
                    colValue = "0";
                    fieldValueMap.put(colName, colValue);
                    continue;
                }
                if (colName.equalsIgnoreCase("FWEIGHT") && !StringUtils.isBlank((CharSequence)colValue)) {
                    fieldValueMap.put(colName, df.format(Double.valueOf(colValue)));
                    continue;
                }
                if (colName.contains("FEXTEND")) {
                    if ("0".equals(areaFieldBean.getFillOverwrite()) && !"100".equals(areaFieldBean.getFieldMaintenanceStage())) {
                        if (putExtendInfo == null || putExtendInfo.get(colName) == null) {
                            fieldValueMap.put(colName, "");
                        } else {
                            fieldValueMap.put(colName, putExtendInfo.get(colName));
                        }
                    } else {
                        fieldValueMap.put(colName, colValue);
                    }
                    String fieldMaintenanceShow = EvaFormUtil.judgeIndicatorCanEdit(evaAreaBean.getAreaId(), colName, getTargetType, wfNode);
                    if ("1".equals(getTargetType) && "100".equals(areaFieldBean.getFieldMaintenanceStage())) {
                        fieldMaintenanceShow = "2";
                    }
                    areaFieldBean.setFieldMaintenanceShow(fieldMaintenanceShow);
                    continue;
                }
                if (IndicatorUtils.multiTBField4Record.contains(colName.toUpperCase(Locale.ENGLISH))) {
                    fieldValueMap.put(colName + "_L1", rs.getString(colName + "_L1"));
                    fieldValueMap.put(colName + "_L2", rs.getString(colName + "_L2"));
                    fieldValueMap.put(colName + "_L3", rs.getString(colName + "_L3"));
                }
                fieldValueMap.put(colName, colValue);
            }
            if (tarIdSet.contains(rs.getString("FID"))) continue;
            int value = evaAreaBean.getCanRate();
            if (1 == value) {
                if (evaAreaBean.getScoringWay() == 1) {
                    tarScoreStr = rs.getString("FTARSCORE");
                } else {
                    weightStr = rs.getString("FWEIGHT");
                }
            } else {
                tarScoreStr = "0";
                weightStr = "0";
            }
            if (StringUtils.isEmpty((CharSequence)weightStr)) {
                weightStr = "0";
            }
            if (StringUtils.isEmpty((CharSequence)tarScoreStr)) {
                tarScoreStr = "0";
            }
            areaWeight = areaWeight.add(new BigDecimal(weightStr));
            areaTarScore = areaTarScore.add(new BigDecimal(tarScoreStr));
            tarIdSet.add(rs.getString("FID"));
            evaRecordList.add(fieldValueMap);
        }
        evaAreaBean.setAreaWeight(df.format(areaWeight));
        if (evaAreaBean.getScoringWay() == 1) {
            evaAreaBean.setAreaWeight(df.format(areaTarScore));
        }
        evaAreaBean.setEvaRecordList(evaRecordList);
    }

    protected void getRecordTargetDataMap(Context ctx, HashSet<String> targetIdSet, PerfEvaObjectInfo perfEvaObjectInfo, String gradeTaskNode, Map<String, GradeTargetInstInfo> gradeTargetInfoMap, String getTargetType, String personId, Map<String, RecordTargetInfo> recordMap) {
        try {
            IRecordTarget iRecordTarget = RecordTargetFactory.getLocalInstance(ctx);
            FilterInfo recordFilter = new FilterInfo();
            recordFilter.getFilterItems().add(new FilterItemInfo("id", targetIdSet, CompareType.INCLUDE));
            EntityViewInfo recordViewInfo = new EntityViewInfo();
            SelectorItemCollection recordSic = recordViewInfo.getSelector();
            recordSic.add("id");
            recordSic.add("refTarget");
            recordSic.add("goalsStatus");
            recordSic.add("perfPeriod.pStartDate");
            recordSic.add("perfPeriod.pEndDate");
            recordViewInfo.setFilter(recordFilter);
            RecordTargetCollection recordTargetColl = iRecordTarget.getRecordTargetCollection(recordViewInfo);
            if (null != recordTargetColl && recordTargetColl.size() > 0) {
                for (int q = 0; q < recordTargetColl.size(); ++q) {
                    recordMap.put(recordTargetColl.get(q).getId().toString(), recordTargetColl.get(q));
                }
            }
            this.getGradeTargetInfoMap(ctx, perfEvaObjectInfo, gradeTaskNode, gradeTargetInfoMap, personId, getTargetType);
        }
        catch (Exception e) {
            this.logger.error("Exception: ", (Throwable)e);
        }
    }
}

