/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.portal.serviceImpl;

import com.google.common.base.Strings;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsProgressInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetDecomposeCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetDecomposeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetDecomposeInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IIndicatorExtendHelper;
import com.kingdee.shr.perfweb.app.base.evalrule.IndicatorExtendHelperFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.IndicatorExtendHelperInfo;
import com.kingdee.shr.perfweb.app.base.indecator.IndecatorTypeFactory;
import com.kingdee.shr.perfweb.app.base.indecator.IndecatorTypeInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaInfo;
import com.kingdee.shr.perfweb.portal.bean.IndicatorBean;
import com.kingdee.shr.perfweb.portal.bean.IndicatorBeanList;
import com.kingdee.shr.perfweb.portal.bean.RecordBean;
import com.kingdee.shr.perfweb.portal.bean.RecordBeanList;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetRelationService {
    private static Logger logger = LoggerFactory.getLogger(TargetRelationService.class);
    private static final String EVATARGET = "200";
    private static final String RECORDTARGET = "300";

    public static TargetRelationService getInstance() {
        return TargetRelationServiceInst.instance;
    }

    public void getRelationTarget(Context ctx, String billId, Map<String, Object> map) throws Exception {
        try {
            String type = null;
            HashSet<String> parentSet = new HashSet<String>();
            HashMap<String, IndicatorTargetDecomposeInfo> parentMap = new HashMap<String, IndicatorTargetDecomposeInfo>();
            HashMap<String, IndicatorTargetDecomposeInfo> decompositionMap = new HashMap<String, IndicatorTargetDecomposeInfo>();
            HashSet<String> decompositionSet = new HashSet<String>();
            IndicatorTargetDecomposeCollection coll = IndicatorTargetDecomposeFactory.getLocalInstance(ctx).getIndicatorTargetDecomposeCollection("where decomposeTarget = '" + billId + "' or parent = '" + billId + "'");
            for (int i = 0; i < coll.size(); ++i) {
                IndicatorTargetDecomposeInfo info = coll.get(i);
                type = info.getTargetType().getValue();
                if (billId.equals(info.getParent())) {
                    decompositionSet.add(info.getDecomposeTarget());
                    decompositionMap.put(info.getDecomposeTarget(), info);
                    continue;
                }
                parentSet.add(info.getParent());
                parentMap.put(info.getParent(), info);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("evaObj.number"));
            sic.add(new SelectorItemInfo("evaObj.name"));
            sic.add(new SelectorItemInfo("evaObj.perfFile.position.name"));
            sic.add(new SelectorItemInfo("evaObj.person.id"));
            sic.add(new SelectorItemInfo("evaObj.personalGoalStatus"));
            sic.add(new SelectorItemInfo("perfPeriod.name"));
            sic.add(new SelectorItemInfo("perfPeriod.pStartDate"));
            sic.add(new SelectorItemInfo("perfPeriod.pEndDate"));
            sic.add(new SelectorItemInfo("extend.*"));
            filter.getFilterItems().add(new FilterItemInfo("id", parentSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(sic);
            if (EVATARGET.equals(type)) {
                IndicatorTargetCollection parentColl = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetCollection(view);
                List parentlist = this.convertTOIndicatorBean(ctx, parentColl, parentMap);
                EntityViewInfo view1 = new EntityViewInfo();
                FilterInfo filter1 = new FilterInfo();
                filter1.getFilterItems().add(new FilterItemInfo("id", decompositionSet, CompareType.INCLUDE));
                view1.setFilter(filter1);
                view1.setSelector(sic);
                IndicatorTargetCollection decomposeColl = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetCollection(view1);
                List decomposeColllist = this.convertTOIndicatorBean(ctx, decomposeColl, decompositionMap);
                map.put("parent", parentlist);
                map.put("decompose", decomposeColllist);
            } else {
                RecordTargetCollection parentColl = RecordTargetFactory.getLocalInstance(ctx).getRecordTargetCollection(view);
                EntityViewInfo view1 = new EntityViewInfo();
                FilterInfo filter1 = new FilterInfo();
                filter1.getFilterItems().add(new FilterItemInfo("id", decompositionSet, CompareType.INCLUDE));
                view1.setFilter(filter1);
                view1.setSelector(sic);
                RecordTargetCollection decomposeColl = RecordTargetFactory.getLocalInstance(ctx).getRecordTargetCollection(view1);
                map.put("parent", this.convertTORecordBean(ctx, parentColl));
                map.put("decompose", this.convertTORecordBean(ctx, decomposeColl));
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
    }

    private List convertTOIndicatorBean(Context ctx, IndicatorTargetCollection parentColl, Map<String, IndicatorTargetDecomposeInfo> decompose) throws Exception {
        ArrayList list = new ArrayList();
        Class<?> clazz = Class.forName("com.kingdee.shr.perfweb.portal.bean.IndicatorBean");
        for (int i = 0; i < parentColl.size(); ++i) {
            IndicatorTargetInfo info = parentColl.get(i);
            Enumeration keys = info.keys();
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if ("IndecatorType".equalsIgnoreCase(key)) {
                    String indiType = info.getIndecatorType();
                    if (StringUtils.isEmpty((CharSequence)indiType)) continue;
                    IndecatorTypeInfo typeInfo = IndecatorTypeFactory.getLocalInstance(ctx).getIndecatorTypeInfo("where id ='" + indiType + "'");
                    map.put("F" + key.toUpperCase(), typeInfo);
                    continue;
                }
                if ("scoringformula".equalsIgnoreCase(key)) {
                    String ScoringFormula2 = info.getScoringFormula();
                    if (StringUtils.isEmpty((CharSequence)ScoringFormula2)) continue;
                    ScoringFormulaInfo ScoringFormulaInfo2 = ScoringFormulaFactory.getLocalInstance(ctx).getScoringFormulaInfo("where id ='" + ScoringFormula2 + "'");
                    map.put("F" + key.toUpperCase(), ScoringFormulaInfo2);
                    continue;
                }
                if (info.get(key) == null) continue;
                map.put("F" + key.toUpperCase(), info.get(key));
            }
            IndicatorExtendHelperInfo extend = info.getExtend();
            map.put("FPERSONNAME", info.getEvaObj().getName());
            map.put("FPERSON", info.getEvaObj().getPerson());
            map.put("TARGETSTATE", (Object)info.getGoalsStatus());
            map.put("FGOALSSTATUS", (Object)info.getGoalsStatus());
            map.put("FPSTARTDATE", info.getPerfPeriod().getPStartDate());
            map.put("FPENDDATE", info.getPerfPeriod().getPEndDate());
            map.put("FPERIODNAME", info.getPerfPeriod().getName());
            map.put("FDECOMPOSETYPE", decompose.get(info.getId().toString()).getType().getValue());
            if (info.get("isVisible") != null) {
                map.put("FISVISIBLE", info.isIsVisible() ? 1 : 0);
            }
            Enumeration keys1 = extend.keys();
            while (keys1.hasMoreElements()) {
                String key = (String)keys1.nextElement();
                if (!key.contains("extend")) continue;
                map.put("F" + key.toUpperCase(), extend.get(key) == null ? "" : extend.get(key));
            }
            map.put("attchCount", this.getAttachmentCount(ctx, info.getEvaObj().getId().toString(), info.getId().toString()));
            GoalsProgressInfo progressInfo = new PerfGoasFillService().getProgressInfoByTargetId(info.getId().toString());
            if (progressInfo != null) {
                map.put("FACTUALCOMPLEVALUE", progressInfo.getActualCompleValue());
                map.put("compleProgress", progressInfo.getCompleProgress());
                map.put("FLASTUPDATETIME", progressInfo.getLastUpdateTime());
            } else {
                map.put("compleProgress", 0);
            }
            map.put("photo", null);
            list.add(map);
        }
        return list;
    }

    private List convertTORecordBean(Context ctx, RecordTargetCollection parentColl) throws Exception {
        ArrayList list = new ArrayList();
        Class<?> clazz = Class.forName("com.kingdee.shr.perfweb.portal.bean.IndicatorBean");
        for (int i = 0; i < parentColl.size(); ++i) {
            RecordTargetInfo info = parentColl.get(i);
            Enumeration keys = info.keys();
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (info.get(key) == null) continue;
                map.put("F" + key.toUpperCase(), info.get(key));
            }
            map.put("FPERSONNAME", info.getEvaObj().getName());
            map.put("FPERSON", info.getEvaObj().getPerson());
            map.put("FPSTARTDATE", info.getPerfPeriod().getPStartDate());
            map.put("TARGETSTATE", (Object)info.getGoalsStatus());
            map.put("FGOALSSTATUS", (Object)info.getGoalsStatus());
            map.put("FPENDDATE", info.getPerfPeriod().getPEndDate());
            map.put("FPERIODNAME", info.getPerfPeriod().getName());
            IndicatorExtendHelperInfo extend = info.getExtend();
            Enumeration keys1 = extend.keys();
            while (keys1.hasMoreElements()) {
                String key = (String)keys1.nextElement();
                if (!key.contains("extend")) continue;
                map.put("F" + key.toUpperCase(), extend.get(key) == null ? "" : extend.get(key));
            }
            map.put("attchCount", this.getAttachmentCount(ctx, info.getEvaObj().getId().toString(), info.getId().toString()));
            GoalsProgressInfo progressInfo = new PerfGoasFillService().getProgressInfoByTargetId(info.getId().toString());
            if (progressInfo != null) {
                map.put("compleProgress", progressInfo.getCompleProgress());
                map.put("FLASTUPDATETIME", progressInfo.getLastUpdateTime());
            } else {
                map.put("compleProgress", 0);
            }
            map.put("photo", null);
            list.add(map);
        }
        return list;
    }

    private int getAttachmentCount(Context ctx, String evaObj, String target) {
        int result = 0;
        if (StringUtils.isEmpty((CharSequence)evaObj) || StringUtils.isEmpty((CharSequence)target)) {
            return 0;
        }
        try {
            BoAttchAssoCollection coll = this.getBoAttchAssoCol(ctx, target);
            if (coll.size() > 0) {
                HashSet<String> attachmentIds = new HashSet<String>();
                for (int i = 0; i < coll.size(); ++i) {
                    BoAttchAssoInfo boAttchAssoInfo = coll.get(i);
                    attachmentIds.add(boAttchAssoInfo.getAttachment().getId().toString());
                }
                IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", attachmentIds, CompareType.INCLUDE));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filterInfo);
                evi.setSelector(sic);
                result = iAttachment.getCount(evi);
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        return result;
    }

    private BoAttchAssoCollection getBoAttchAssoCol(Context ctx, String boid) throws BOSException {
        IBoAttchAsso boAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boid", (Object)boid, CompareType.EQUALS));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("attachment.size"));
        sic.add(new SelectorItemInfo("attachment.id"));
        sic.add(new SelectorItemInfo("attachment.name"));
        sic.add(new SelectorItemInfo("attachment.simplename"));
        entityViewInfo.setSelector(sic);
        return boAttchAsso.getBoAttchAssoCollection(entityViewInfo);
    }

    public HashMap<String, Object> getIsShowField(Context ctx, String targetId) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)targetId)) {
            try {
                EvaFormFieldConfCollection evaColl;
                IndicatorTargetInfo indicatorTargetInfo;
                String bosType = BOSUuid.getBOSObjectType((String)targetId, (boolean)true).toString();
                boolean isTargetValue = false;
                boolean isActualCompleValue = false;
                if ("594BDE85".equals(bosType) && (indicatorTargetInfo = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetInfo("select areaBase where id = '" + targetId + "'")) != null && (evaColl = EvaFormFieldConfFactory.getLocalInstance(ctx).getEvaFormFieldConfCollection("select colName where areaBase = '" + indicatorTargetInfo.getAreaBase().getId().toString() + "' and (colName ='FACTUALCOMPLEVALUE' or colName ='FTARGETVALUE')")) != null && evaColl.size() > 0) {
                    int size = evaColl.size();
                    for (int i = 0; i < size; ++i) {
                        if ("FACTUALCOMPLEVALUE".equals(evaColl.get(i).getColName())) {
                            isActualCompleValue = true;
                            continue;
                        }
                        if (!"FTARGETVALUE".equals(evaColl.get(i).getColName())) continue;
                        isTargetValue = true;
                    }
                }
                fieldMap.put("targetValue", isTargetValue);
                fieldMap.put("actualCompleValue", isActualCompleValue);
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
            }
            catch (EASBizException e) {
                logger.error("EASBizException: ", (Throwable)e);
            }
        }
        return fieldMap;
    }

    public HashMap<String, Map<String, Boolean>> getIsShowFields(Context ctx, String evaObj) {
        HashMap<String, Map<String, Boolean>> fieldMap = new HashMap<String, Map<String, Boolean>>();
        if (!StringUtils.isEmpty((CharSequence)evaObj)) {
            try {
                IndicatorTargetCollection targetColls = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetCollection("select areaBase where evaObj = '" + evaObj + "' and areaBase.areaType = '" + EVATARGET + "'");
                if (targetColls != null && !targetColls.isEmpty()) {
                    HashSet<String> areaIds = new HashSet<String>();
                    Iterator it = targetColls.iterator();
                    while (it.hasNext()) {
                        IndicatorTargetInfo targetInfo = (IndicatorTargetInfo)it.next();
                        areaIds.add(targetInfo.getAreaBase().getId().toString());
                    }
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("areaBase", areaIds, CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("colName", (Object)"FACTUALCOMPLEVALUE"));
                    filterInfo.getFilterItems().add(new FilterItemInfo("colName", (Object)"FTARGETVALUE"));
                    filterInfo.setMaskString("#0 and (#1 or #2)");
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(filterInfo);
                    EvaFormFieldConfCollection evaColl = EvaFormFieldConfFactory.getLocalInstance(ctx).getEvaFormFieldConfCollection(evi);
                    if (evaColl != null && !evaColl.isEmpty()) {
                        Iterator it2 = evaColl.iterator();
                        while (it2.hasNext()) {
                            EvaFormFieldConfInfo fieldConfInfo = (EvaFormFieldConfInfo)it2.next();
                            String areaId = fieldConfInfo.getAreaBase();
                            Map<String, Boolean> fieldItem = fieldMap.get(areaId);
                            if (fieldItem == null) {
                                fieldItem = new HashMap<String, Boolean>();
                            }
                            if ("FACTUALCOMPLEVALUE".equals(fieldConfInfo.getColName())) {
                                fieldItem.put("isActualCompleValue", true);
                            }
                            if ("FTARGETVALUE".equals(fieldConfInfo.getColName())) {
                                fieldItem.put("isTargetValue", true);
                            }
                            fieldMap.put(areaId, fieldItem);
                        }
                    }
                }
            }
            catch (BOSException e) {
                logger.error("get area filed conf by evaObj err", (Throwable)e);
            }
        }
        return fieldMap;
    }

    public List<IndicatorTargetInfo> assembleData(Context ctx, RecordBeanList recordArr, IndicatorBeanList indicatorArr, ArrayList<String> recordFieldList, ArrayList<String> indicatorFieldList, Set evaObjs, String areaBase) throws Exception {
        PerfEvaObjectCollection coll = this.getEvaluObjectById(ctx, evaObjs);
        Map<String, String> evaMap = this.getEvaObjAndPerfRule(ctx, evaObjs);
        String REJECTIONNAME = "REJECTION";
        ArrayList<IndicatorTargetInfo> list = new ArrayList<IndicatorTargetInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            ObjectBaseInfo info;
            PerfEvaObjectInfo evaInfo = coll.get(i);
            if (evaInfo.getPersonalGoalStatus().getValue() != 0 && evaInfo.getPersonalGoalStatus().getValue() != 1) continue;
            if (indicatorArr != null && indicatorArr.getIndicatorList().size() > 0) {
                info = this.assembleIndicatorTarget(ctx, indicatorArr, indicatorFieldList, areaBase, evaMap, evaInfo);
                list.add((IndicatorTargetInfo)info);
            }
            if (recordArr == null || recordArr.getRecordList().size() <= 0) continue;
            info = this.assembleRecordTarget(ctx, recordArr, recordFieldList, areaBase, evaMap, evaInfo);
            list.add((IndicatorTargetInfo)info);
        }
        return list;
    }

    private RecordTargetInfo assembleRecordTarget(Context ctx, RecordBeanList recordArr, ArrayList<String> recordFieldList, String araeBase, Map evaMap, PerfEvaObjectInfo evaInfo) throws Exception {
        CoreBaseCollection extendColl = new CoreBaseCollection();
        RecordTargetInfo info = new RecordTargetInfo();
        info.put("person", evaInfo.getPerson());
        info.put("evaPlan", evaInfo.getPeriod().getPerfPlan());
        info.put("perfRule", evaMap.get(evaInfo.getId().toString()));
        info.put("perfPeriod", evaInfo.getPeriod());
        info.put("id", BOSUuid.create((String)"594BDE85"));
        info.put("areaBase", araeBase);
        info.put("evaObj", evaInfo);
        info.put("person", evaInfo.getPerson().getId().toString());
        IndicatorExtendHelperInfo extend = new IndicatorExtendHelperInfo();
        Class<?> clazz = Class.forName("com.kingdee.shr.perfweb.portal.bean.RecordBean");
        for (RecordBean record : recordArr.getRecordList()) {
            for (int j = 0; j < recordFieldList.size(); ++j) {
                String fieldName = recordFieldList.get(j);
                fieldName = fieldName.substring(1, fieldName.length());
                Method method = clazz.getMethod("get" + fieldName, null);
                Object fieldVal = method.invoke((Object)record, new Object[0]);
                if (null != fieldVal) {
                    if ("measureStandard".equalsIgnoreCase(fieldName) && method.invoke((Object)record, new Object[0]).toString().length() > 1024) {
                        logger.error("\u3010PERFWEB\u3011-When saving indicators, the indicators in the record table area [" + record.getID() + "] measure more than 1024 characters truncated!");
                        info.put(fieldName, fieldVal.toString().substring(0, 1024));
                        continue;
                    }
                    if (fieldName.toUpperCase(Locale.ENGLISH).contains("EXTEND")) {
                        extend.put(fieldName, fieldVal);
                        continue;
                    }
                    info.put(fieldName, fieldVal);
                    continue;
                }
                if (fieldName.toUpperCase(Locale.ENGLISH).contains("EXTEND")) {
                    extend.put(fieldName, fieldVal);
                    continue;
                }
                info.put(fieldName, fieldVal);
            }
            extend.setId(BOSUuid.create((String)"801580EF"));
            info.put("extend", extend.getId().toString());
            extend.setEvaObj(evaInfo);
            extendColl.add((CoreBaseInfo)extend);
        }
        if (extendColl.size() > 0) {
            IIndicatorExtendHelper iIndicatorExtendHelper = IndicatorExtendHelperFactory.getLocalInstance(ctx);
            iIndicatorExtendHelper.save(extendColl);
        }
        return info;
    }

    private IndicatorTargetInfo assembleIndicatorTarget(Context ctx, IndicatorBeanList indicatorArr, ArrayList<String> indicatorFieldList, String araeBase, Map evaMap, PerfEvaObjectInfo evaInfo) throws Exception {
        Class<?> clazz = Class.forName("com.kingdee.shr.perfweb.portal.bean.IndicatorBean");
        CoreBaseCollection extendColl = new CoreBaseCollection();
        IndicatorTargetInfo info = new IndicatorTargetInfo();
        info.put("id", BOSUuid.create((String)"594BDE85"));
        info.put("areaBase", araeBase);
        info.put("evaObj", evaInfo);
        info.put("isUnited", "0");
        info.put("goalsStatus", "0");
        if (evaInfo.getPerson() != null) {
            info.put("person", evaInfo.getPerson());
            info.put("person", evaInfo.getPerson().getId().toString());
        }
        info.put("evaPlan", evaInfo.getPeriod().getPerfPlan());
        info.put("perfRule", evaMap.get(evaInfo.getId().toString()));
        info.put("perfPeriod", evaInfo.getPeriod());
        IndicatorExtendHelperInfo extend = new IndicatorExtendHelperInfo();
        for (IndicatorBean indicator : indicatorArr.getIndicatorList()) {
            for (int j = 0; j < indicatorFieldList.size(); ++j) {
                String fieldName = indicatorFieldList.get(j);
                Method method = clazz.getMethod("get" + fieldName, null);
                Object fieldVal = method.invoke((Object)indicator, new Object[0]);
                if (null != fieldVal) {
                    if (fieldName.toUpperCase(Locale.ENGLISH).contains("EXTEND")) {
                        extend.put(fieldName, fieldVal);
                        continue;
                    }
                    info.put(fieldName, fieldVal);
                    continue;
                }
                if (fieldName.toUpperCase(Locale.ENGLISH).contains("EXTEND")) {
                    extend.put(fieldName, fieldVal);
                    continue;
                }
                info.put(fieldName, fieldVal);
            }
            Object qualiOrRation = info.get("qualiOrRation");
            if (qualiOrRation == null || "null".equals(String.valueOf(qualiOrRation))) {
                if (!Strings.isNullOrEmpty((String)info.getScoringFormula())) {
                    info.put("qualiOrRation", 1);
                } else {
                    info.put("qualiOrRation", 0);
                }
            }
            extend.setId(BOSUuid.create((String)"801580EF"));
            extend.setEvaObj(evaInfo);
            info.put("extend", extend.getId().toString());
            info.put("ActualCompleteTime", null);
            extendColl.add((CoreBaseInfo)extend);
        }
        if (extendColl.size() > 0) {
            IIndicatorExtendHelper iIndicatorExtendHelper = IndicatorExtendHelperFactory.getLocalInstance(ctx);
            iIndicatorExtendHelper.save(extendColl);
        }
        return info;
    }

    private PerfEvaObjectCollection getEvaluObjectById(Context ctx, Set id) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("period.*"));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        PerfEvaObjectCollection coll = null;
        try {
            coll = PerfEvaObjectFactory.getLocalInstance(ctx).getPerfEvaObjectCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return coll;
    }

    public Map<String, String> getEvaObjAndPerfRule(Context ctx, Set id) {
        HashMap map = new HashMap();
        HashMap<String, String> resultmap = new HashMap<String, String>();
        PerfEvaObjectCollection coll = this.getEvaluObjectById(ctx, id);
        HashSet planIdSet = new HashSet();
        for (int i = 0; i < coll.size(); ++i) {
            PerfEvaObjectInfo info = coll.get(i);
            resultmap.put(info.getId().toString(), info.getPeriod().getPerfRule().getId().toString());
        }
        return resultmap;
    }

    public static class TargetRelationServiceInst {
        private static final TargetRelationService instance = new TargetRelationService();
    }
}

