/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.tool.function.Strings;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.api.bean.SHRCodingRule;
import com.kingdee.shr.base.syssetting.api.service.SHRCodingRuleApi;
import com.kingdee.shr.perfweb.app.base.distribution.DistributionDefineCollection;
import com.kingdee.shr.perfweb.app.base.distribution.DistributionDefineFactory;
import com.kingdee.shr.perfweb.app.base.distribution.DistributionDefineInfo;
import com.kingdee.shr.perfweb.app.base.distribution.DistributionFactory;
import com.kingdee.shr.perfweb.app.base.distribution.DistributionInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.CalibrationStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.ConfirmStateEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBill4OrgFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBill4OrgInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBillCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBillFacadeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBillFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBillInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSumLogSourceEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSumRevisionLogInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSumStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IEvaResultAppealBill;
import com.kingdee.shr.perfweb.app.base.evalplan.IEvaResultAppealBill4Org;
import com.kingdee.shr.perfweb.app.base.evalplan.IEvaResultSummary;
import com.kingdee.shr.perfweb.app.base.evalplan.IOrgEvaResultSummary;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.comprehensive.ISumCalResultAppealBill;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummarySchemeBaseInfo;
import com.kingdee.shr.perfweb.app.comprehensive.SumCalResultAppealBillFactory;
import com.kingdee.shr.perfweb.app.comprehensive.SumCalResultAppealBillInfo;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPlanInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.EvaResultSumRevisionLogService;
import com.kingdee.shr.perfweb.util.ExceptionUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.util.TheThirdMessageUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class EvaResultSummaryBizUtil {
    private static final String VIEW = "VIEW";
    private static final String EDIT = "EDIT";
    private static final Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.util.EvaResultSummaryBizUtil");
    public static final String ROUND_HALF_UP = "0";
    public static final String ROUND_UP = "1";
    public static final String ROUND_DOWN = "2";
    private static Map<String, Integer> ROUNDMODEL = new HashMap<String, Integer>(){
        {
            this.put(EvaResultSummaryBizUtil.ROUND_HALF_UP, 4);
            this.put(EvaResultSummaryBizUtil.ROUND_UP, 0);
            this.put(EvaResultSummaryBizUtil.ROUND_DOWN, 1);
        }
    };

    public static Map<String, String> appeal(Context ctx, String summaryId) throws EASBizException, BOSException {
        HashMap<String, String> res = new HashMap<String, String>();
        String id = summaryId;
        EvaResultSummaryCollection evaResultSummaryColl = null;
        IEvaResultSummary iEvaResultSummary = null;
        iEvaResultSummary = EvaResultSummaryFactory.getLocalInstance(ctx);
        evaResultSummaryColl = iEvaResultSummary.getEvaResultSummaryCollection("select summaryPersonEvaObject.id,summaryPersonEvaObject.perfSummarySchemeBase.allowAppeal,summaryPersonEvaObject.perfSummarySchemeBase.appealDays, id , multiPerfPlan.id, evaPlan.id, evaPlan.appealDays, evaPlan.needConfirm, evaPlan.allowAppeal, adminOrg.id, hrOrgUnit.id, isImportByHand, historyImport,  confirmState, appealState, auditDate, billState, status where id='" + id + "'");
        if (!evaResultSummaryColl.isEmpty()) {
            EvaResultSummaryInfo summaryInfo = evaResultSummaryColl.get(0);
            boolean isSumCal = summaryInfo.getSummaryPersonEvaObject() != null;
            IEvaResultAppealBill iEvaResultAppealBill = EvaResultAppealBillFactory.getLocalInstance(ctx);
            ISumCalResultAppealBill iSumCalResultAppealBill = SumCalResultAppealBillFactory.getLocalInstance(ctx);
            if (!isSumCal && iEvaResultAppealBill.exists(" where sourceBillId='" + id + "' and valid = 1")) {
                String billId = iEvaResultAppealBill.getEvaResultAppealBillInfo(" where sourceBillId='" + id + "' and valid = 1").getId().toString();
                res.put("billId", billId);
                res.put("operateState", VIEW);
                res.put("isSumCal", ROUND_HALF_UP);
            } else if (isSumCal && iSumCalResultAppealBill.exists(" where sourceBillId='" + id + "' and valid = 1")) {
                String billId = iSumCalResultAppealBill.getSumCalResultAppealBillInfo(" where sourceBillId='" + id + "' and valid = 1").getId().toString();
                res.put("billId", billId);
                res.put("operateState", VIEW);
                res.put("isSumCal", ROUND_UP);
            } else {
                boolean isAllowAppeal = false;
                int appealDays = 0;
                if (!isSumCal) {
                    PerfPlanInfo perfPlanInfo = summaryInfo.getEvaPlan();
                    isAllowAppeal = perfPlanInfo != null ? perfPlanInfo.isAllowAppeal() : false;
                    appealDays = perfPlanInfo.getAppealDays();
                } else {
                    PerfSummarySchemeBaseInfo perfSummarySchemeBase = summaryInfo.getSummaryPersonEvaObject().getPerfSummarySchemeBase();
                    isAllowAppeal = perfSummarySchemeBase != null ? perfSummarySchemeBase.isAllowAppeal() : false;
                    appealDays = perfSummarySchemeBase.getAppealDays();
                }
                if (!isAllowAppeal) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CRESULTCANNOTAPPLY, ctx));
                }
                if (appealDays != 0) {
                    Date now = new Date();
                    long days = DateUtil.dateDiff((String)"d", (Date)summaryInfo.getAuditDate(), (Date)now) + 1L;
                    if ((long)appealDays - days < 0L) {
                        throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.OVERLIMITDATE, ctx));
                    }
                }
                if (!HRBillStateEnum.AUDITED.equals((Object)summaryInfo.getBillState())) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EVARESULTUNSUDIT, ctx));
                }
                if (EvaResultSumStatusEnum.CARRY.equals((Object)summaryInfo.getStatus())) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EVARESULTZHUANED, ctx));
                }
                if (YesOrNoEnum.YES.equals((Object)summaryInfo.getIsImportByHand())) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTNEEDNOTAPPLY, ctx));
                }
                if (summaryInfo.isHistoryImport()) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.HISNEEDNOTAPPLY, ctx));
                }
                if (ConfirmStateEnum.CONFIRMED.equals((Object)summaryInfo.getConfirmState())) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RESULTHASSURECANNOTAPPLY, ctx));
                }
                MultiPerfPlanInfo multiPerfPlanInfo = summaryInfo.getMultiPerfPlan();
                if (multiPerfPlanInfo != null && multiPerfPlanInfo.getId() != null) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.A360CANNOTAPPLAY, ctx));
                }
                if (summaryInfo.getAuditDate() == null) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.NOAUDITDATECANNOTAPPLY, ctx));
                }
                if (isSumCal) {
                    SumCalResultAppealBillInfo appealBillInfo = new SumCalResultAppealBillInfo();
                    appealBillInfo.setSourceBillId(id);
                    appealBillInfo.setEvaResult(summaryInfo);
                    appealBillInfo.setHrOrgUnit(summaryInfo.getHrOrgUnit());
                    appealBillInfo.setAdminOrg(summaryInfo.getAdminOrg());
                    SHRCodingRule shrCodingRule = null;
                    String number = "NO" + System.currentTimeMillis();
                    shrCodingRule = SHRCodingRuleApi.getCodingNumber((Context)ctx, (IObjectValue)appealBillInfo, (String)summaryInfo.getHrOrgUnit().getId().toString());
                    if (shrCodingRule != null && !StringUtils.isEmpty((String)shrCodingRule.getCodingRuleNumber())) {
                        number = shrCodingRule.getCodingRuleNumber();
                    }
                    appealBillInfo.setNumber(number);
                    appealBillInfo.setValid(true);
                    String billId = iSumCalResultAppealBill.addnew(appealBillInfo).toString();
                    res.put("billId", billId);
                    res.put("operateState", EDIT);
                    res.put("isAddNew", ROUND_UP);
                    res.put("isSumCal", ROUND_UP);
                } else {
                    EvaResultAppealBillInfo appealBillInfo = new EvaResultAppealBillInfo();
                    appealBillInfo.setSourceBillId(id);
                    appealBillInfo.setProposer(summaryInfo.getPerson());
                    appealBillInfo.setApplyDate(new Date());
                    appealBillInfo.setEvaResult(summaryInfo);
                    appealBillInfo.setHrOrgUnit(summaryInfo.getHrOrgUnit());
                    appealBillInfo.setAdminOrg(summaryInfo.getAdminOrg());
                    appealBillInfo.setNumber("NO" + System.currentTimeMillis());
                    appealBillInfo.setValid(true);
                    String billId = iEvaResultAppealBill.addnew(appealBillInfo).toString();
                    res.put("billId", billId);
                    res.put("operateState", EDIT);
                    res.put("isAddNew", ROUND_UP);
                    res.put("isSumCal", ROUND_HALF_UP);
                }
            }
        }
        return res;
    }

    public static Map<String, String> appeal4Org(Context ctx, String summaryId) throws EASBizException, BOSException {
        HashMap<String, String> res = new HashMap<String, String>();
        String id = summaryId;
        OrgEvaResultSummaryCollection evaResultSummaryColl = null;
        IOrgEvaResultSummary iEvaResultSummary = null;
        iEvaResultSummary = OrgEvaResultSummaryFactory.getLocalInstance(ctx);
        evaResultSummaryColl = iEvaResultSummary.getOrgEvaResultSummaryCollection("select id , multiPerfPlan.id, evaPlan.id, evaPlan.appealDays, evaPlan.needConfirm, evaPlan.allowAppeal, adminOrg.id, hrOrgUnit.id, isImportByHand, historyImport,  confirmState, appealState, auditDate, billState, status where id='" + id + "'");
        if (!evaResultSummaryColl.isEmpty()) {
            OrgEvaResultSummaryInfo summaryInfo = evaResultSummaryColl.get(0);
            IEvaResultAppealBill4Org iEvaResultAppealBill = EvaResultAppealBill4OrgFactory.getLocalInstance(ctx);
            if (iEvaResultAppealBill.exists(" where sourceBillId='" + id + "' and valid = 1")) {
                String billId = iEvaResultAppealBill.getEvaResultAppealBill4OrgInfo(" where sourceBillId='" + id + "' and valid = 1").getId().toString();
                res.put("billId", billId);
                res.put("operateState", VIEW);
            } else {
                boolean isAllowAppeal;
                PerfPlanInfo perfPlanInfo = summaryInfo.getEvaPlan();
                boolean bl = isAllowAppeal = perfPlanInfo != null ? perfPlanInfo.isAllowAppeal() : false;
                if (!HRBillStateEnum.AUDITED.equals((Object)summaryInfo.getBillState())) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EVARESULTUNSUDIT, ctx));
                }
                if (EvaResultSumStatusEnum.CARRY.equals((Object)summaryInfo.getStatus())) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EVARESULTZHUANED, ctx));
                }
                if (YesOrNoEnum.YES.equals((Object)summaryInfo.getIsImportByHand())) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTNEEDNOTAPPLY, ctx));
                }
                if (summaryInfo.isHistoryImport()) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.HISNEEDNOTAPPLY, ctx));
                }
                if (ConfirmStateEnum.CONFIRMED.equals((Object)summaryInfo.getConfirmState())) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RESULTHASSURECANNOTAPPLY, ctx));
                }
                if (!isAllowAppeal) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CRESULTCANNOTAPPLY, ctx));
                }
                MultiPerfPlanInfo multiPerfPlanInfo = summaryInfo.getMultiPerfPlan();
                if (multiPerfPlanInfo != null && multiPerfPlanInfo.getId() != null) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.A360CANNOTAPPLAY, ctx));
                }
                if (summaryInfo.getAuditDate() == null) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.NOAUDITDATECANNOTAPPLY, ctx));
                }
                int appealDays = perfPlanInfo.getAppealDays();
                if (appealDays != 0) {
                    Date now = new Date();
                    long days = DateUtil.dateDiff((String)"d", (Date)summaryInfo.getAuditDate(), (Date)now) + 1L;
                    if ((long)appealDays - days < 0L) {
                        throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.OVERLIMITDATE, ctx));
                    }
                }
                EvaResultAppealBill4OrgInfo appealBillInfo = new EvaResultAppealBill4OrgInfo();
                appealBillInfo.setSourceBillId(id);
                appealBillInfo.setProposer(summaryInfo.getPerson());
                appealBillInfo.setApplyDate(new Date());
                appealBillInfo.setEvaResult(summaryInfo);
                appealBillInfo.setHrOrgUnit(summaryInfo.getHrOrgUnit());
                appealBillInfo.setAdminOrg(summaryInfo.getAdminOrg());
                appealBillInfo.setNumber("NO" + System.currentTimeMillis());
                appealBillInfo.setValid(true);
                String billId = iEvaResultAppealBill.addnew(appealBillInfo).toString();
                res.put("billId", billId);
                res.put("operateState", EDIT);
            }
        }
        return res;
    }

    public static Map<String, Object> confirmCheck(Context ctx, String summaryId) throws BOSException, EASBizException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        IEvaResultAppealBill iEvaResultAppealBill = null;
        iEvaResultAppealBill = EvaResultAppealBillFactory.getLocalInstance(ctx);
        EvaResultAppealBillCollection col = iEvaResultAppealBill.getEvaResultAppealBillCollection("select evaResult.evaPlan.name, evaResult.period.name  where sourceBillId='" + summaryId + "' and valid = 1 and (billState is null or billState = " + 0 + ")");
        if (col != null && col.size() > 0) {
            res.put("message", col.get(0).getEvaResult().getEvaPlan().getName() + "-" + col.get(0).getEvaResult().getPeriod().getName() + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.HASAPPEAL, ctx));
            res.put("appealBillSaved", 1);
        }
        return res;
    }

    public static void confirm(Context ctx, String summaryId) throws EASBizException, BOSException {
        EvaResultSummaryCollection evaResultSummaryColl = null;
        IEvaResultSummary iEvaResultSummary = null;
        iEvaResultSummary = EvaResultSummaryFactory.getLocalInstance(ctx);
        evaResultSummaryColl = iEvaResultSummary.getEvaResultSummaryCollection("select evaObj.id,id , multiPerfPlan.id, evaPlan.id, evaPlan.appealDays, evaPlan.needConfirm, evaPlan.allowAppeal, adminOrg.id, hrOrgUnit.id, isImportByHand, historyImport,  confirmState, appealState, auditDate, billState ,summaryPersonEvaObject.perfSummarySchemeBase.needConfirm where id='" + summaryId + "'");
        if (evaResultSummaryColl != null && !evaResultSummaryColl.isEmpty()) {
            EvaResultSummaryInfo info = evaResultSummaryColl.get(0);
            if (YesOrNoEnum.YES.equals((Object)info.getIsImportByHand())) {
                throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTNEEDNOTSAVE, ctx));
            }
            if (info.isHistoryImport()) {
                throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.HISNEEDNOTSAVE, ctx));
            }
            boolean isNeedConfirm = true;
            if (info.getEvaObj() == null && info.getSummaryPersonEvaObject() != null && info.getSummaryPersonEvaObject().getPerfSummarySchemeBase() != null) {
                isNeedConfirm = info.getSummaryPersonEvaObject().getPerfSummarySchemeBase().isNeedConfirm();
            } else {
                PerfPlanInfo perfPlanInfo = info.getEvaPlan();
                boolean bl = isNeedConfirm = perfPlanInfo != null ? perfPlanInfo.isNeedConfirm() : false;
            }
            if (!isNeedConfirm) {
                throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RESULTNEEDNOTAUDIT, ctx));
            }
            if (ConfirmStateEnum.CONFIRMED.equals((Object)info.getConfirmState())) {
                throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RESULTNEEDNOTAUDITTWICE, ctx));
            }
            IEvaResultAppealBill iEvaResultAppealBill = null;
            iEvaResultAppealBill = EvaResultAppealBillFactory.getLocalInstance(ctx);
            iEvaResultAppealBill.delete(" where sourceBillId='" + summaryId + "' and valid = 1 and (billState is null or billState = " + 0 + ")");
            if (iEvaResultAppealBill.exists(" where sourceBillId='" + summaryId + "' and valid = 1 and billState <> 3 and billState <> 4")) {
                throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EVARESULTEXISTSUBMITEDBILL, ctx));
            }
            MultiPerfPlanInfo multiPerfPlanInfo = info.getMultiPerfPlan();
            if (multiPerfPlanInfo != null && multiPerfPlanInfo.getId() != null) {
                throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.A360CANNOTAPPLAY, ctx));
            }
            info.setConfirmState(ConfirmStateEnum.CONFIRMED);
            iEvaResultSummary.save((CoreBaseInfo)info);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> excuteDistributionRef(Context ctx, EvaResultSummaryCollection collection, String distributionId, String orgPerfPeriod, String empPosOrg, String type) {
        Object next;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", "false");
        Assert.hasText((String)distributionId, (String)"distributionId can not be empty!");
        Assert.hasText((String)orgPerfPeriod, (String)"orgPerfPeriod can not be empty!");
        Assert.hasText((String)type, (String)"type can not be empty!");
        HashSet<String> hasNoAdminOrgUnitSet = new HashSet<String>();
        HashSet<String> adminOrgUnitNotInSelectSet = new HashSet<String>();
        HashSet adminOrgUnitNoSummaryInPeriodSet = new HashSet();
        HashSet adminOrgUnitNoLevelSet = new HashSet();
        HashSet adminOrgUnitLevelNotInDistributionKeySet = new HashSet();
        HashSet adminOrgUnitLevelNotInDistributionValueSet = new HashSet();
        HashSet baseDistributionErrSet = new HashSet();
        resultMap.put("hasNoAdminOrgUnitSet", hasNoAdminOrgUnitSet);
        resultMap.put("adminOrgUnitNotInSelectSet", adminOrgUnitNotInSelectSet);
        resultMap.put("adminOrgUnitNoSummaryInPeriodSet", adminOrgUnitNoSummaryInPeriodSet);
        resultMap.put("adminOrgUnitNoLevelSet", adminOrgUnitNoLevelSet);
        resultMap.put("adminOrgUnitLevelNotInDistributionKeySet", adminOrgUnitLevelNotInDistributionKeySet);
        resultMap.put("adminOrgUnitLevelNotInDistributionValueSet", adminOrgUnitLevelNotInDistributionValueSet);
        resultMap.put("baseDistributionErrSet", baseDistributionErrSet);
        HashSet<String> exclude_1_2_adminIds = new HashSet<String>();
        HashSet<String> exclude_1_2_3_adminIds = new HashSet<String>();
        HashMap<String, Object> orgEvaResultSummaryInfoMap = new HashMap<String, Object>();
        HashMap<String, DistributionDefineInfo> levelDistributionDefineMap = new HashMap<String, DistributionDefineInfo>();
        HashSet selectedOrg = new HashSet();
        if (!StringUtils.isEmpty((String)empPosOrg)) {
            Object[] split = empPosOrg.split(",");
            selectedOrg = Sets.newHashSet((Object[])split);
        }
        HashMap<String, HashSet<String>> adminSummaryMap = new HashMap<String, HashSet<String>>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String adminId;
            EvaResultSummaryInfo next2;
            block27: {
                next2 = (EvaResultSummaryInfo)iterator.next();
                AdminOrgUnitInfo adminOrg = next2.getAdminOrg();
                if (adminOrg == null) {
                    hasNoAdminOrgUnitSet.add(next2.getId().toString());
                    continue;
                }
                adminId = adminOrg.getId().toString();
                if (!CollectionUtils.isEmpty((Collection)selectedOrg)) {
                    if (selectedOrg.contains(adminId)) {
                        exclude_1_2_adminIds.add(adminId);
                        break block27;
                    } else {
                        adminOrgUnitNotInSelectSet.add(next2.getId().toString());
                        continue;
                    }
                }
                exclude_1_2_adminIds.add(adminId);
            }
            HashSet<String> summarySet = (HashSet<String>)adminSummaryMap.get(adminId);
            if (CollectionUtils.isEmpty((Collection)summarySet)) {
                summarySet = new HashSet<String>();
            }
            summarySet.add(next2.getId().toString());
            adminSummaryMap.put(adminId, summarySet);
        }
        if (CollectionUtils.isEmpty(exclude_1_2_adminIds)) {
            resultMap.put("success", "true");
            return resultMap;
        }
        OrgEvaResultSummaryCollection orgEvaResultSummaryCollection = null;
        DistributionInfo distributionInfo = null;
        try {
            String inIdSql = Strings.join((String[])exclude_1_2_adminIds.toArray(new String[exclude_1_2_adminIds.size()]), (String)"','");
            String selectSql = " where period.id ='" + orgPerfPeriod + "'  and adminOrg.id in ('" + inIdSql + "')  and billState = " + 3 + "  ";
            orgEvaResultSummaryCollection = OrgEvaResultSummaryFactory.getLocalInstance(ctx).getOrgEvaResultSummaryCollection(selectSql);
            distributionInfo = DistributionFactory.getLocalInstance(ctx).getDistributionInfo("where id='" + distributionId + "' and distributionReference='1' ");
            if (distributionInfo == null) {
                throw new NullPointerException("distributionInfo can not be null");
            }
            DistributionDefineCollection define = distributionInfo.getDefine();
            if (define != null && define.size() > 0) {
                Iterator definIt = define.iterator();
                while (definIt.hasNext()) {
                    DistributionDefineInfo next3 = (DistributionDefineInfo)definIt.next();
                    levelDistributionDefineMap.put(next3.getPerfLevel(), next3);
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            return resultMap;
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
            return resultMap;
        }
        if (orgEvaResultSummaryCollection != null && orgEvaResultSummaryCollection.size() != 0) {
            Iterator iteratorOrg = orgEvaResultSummaryCollection.iterator();
            while (iteratorOrg.hasNext()) {
                next = (OrgEvaResultSummaryInfo)iteratorOrg.next();
                String adminId = next.getAdminOrg().getId().toString();
                orgEvaResultSummaryInfoMap.put(adminId, next);
                exclude_1_2_3_adminIds.add(adminId);
            }
        }
        Iterator entryIterator = adminSummaryMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            next = entryIterator.next();
            String key = (String)next.getKey();
            Set value = (Set)next.getValue();
            if (exclude_1_2_3_adminIds.contains(key)) continue;
            adminOrgUnitNoSummaryInPeriodSet.addAll(value);
            entryIterator.remove();
        }
        if (!CollectionUtils.isEmpty(adminSummaryMap)) {
            Set keySet = adminSummaryMap.keySet();
            for (String key : keySet) {
                Set tmpSummaryIds = (Set)adminSummaryMap.get(key);
                OrgEvaResultSummaryInfo orgEvaResultSummaryInfo = (OrgEvaResultSummaryInfo)orgEvaResultSummaryInfoMap.get(key);
                String level = orgEvaResultSummaryInfo.getReviseGradeLevel();
                if (StringUtils.isEmpty((String)level)) {
                    level = orgEvaResultSummaryInfo.getLastGradeLevel();
                }
                if (StringUtils.isEmpty((String)level)) {
                    level = orgEvaResultSummaryInfo.getGradeLevel();
                }
                if (StringUtils.isEmpty((String)level)) {
                    adminOrgUnitNoLevelSet.addAll(tmpSummaryIds);
                    continue;
                }
                Set levelKeys = levelDistributionDefineMap.keySet();
                if (CollectionUtils.isEmpty(levelKeys) || !levelKeys.contains(level)) {
                    adminOrgUnitLevelNotInDistributionKeySet.addAll(tmpSummaryIds);
                    continue;
                }
                DistributionDefineInfo distributionDefineInfo = (DistributionDefineInfo)levelDistributionDefineMap.get(level);
                if (distributionDefineInfo == null || distributionDefineInfo.getRefDefine() == null) {
                    adminOrgUnitLevelNotInDistributionValueSet.addAll(tmpSummaryIds);
                    continue;
                }
                HashMap<String, String> countMap = new HashMap<String, String>();
                EvaResultSummaryCollection tmpColl = new EvaResultSummaryCollection();
                String baseDistributionId = distributionDefineInfo.getRefDefine().getId().toString();
                try {
                    tmpColl = EvaResultSummaryBizUtil.getCollectionByIds(collection, tmpSummaryIds);
                    String joinStr = Strings.join((String[])tmpSummaryIds.toArray(new String[tmpSummaryIds.size()]), (String)",");
                    List<DistributionDefineInfo> tmpDistributionInfoList = EvaResultSummaryBizUtil.getDistributionInfo(ctx, baseDistributionId, joinStr, type, "id");
                    for (DistributionDefineInfo next4 : tmpDistributionInfoList) {
                        countMap.put(next4.getId().toString(), next4.get("personCount").toString());
                    }
                    EvaResultSummaryBizUtil.excuteDistribution(ctx, tmpColl, baseDistributionId, countMap);
                    resultMap.put("success", "true");
                }
                catch (Exception e) {
                    baseDistributionErrSet.addAll(tmpSummaryIds);
                    logger.error("excuteDistributionRef::" + e.getMessage());
                    return resultMap;
                }
            }
        }
        resultMap.put("success", "true");
        return resultMap;
    }

    public static List<DistributionDefineInfo> getDistributionInfo(Context ctx, String id, String billIds, String type, String fieldName) {
        String[] ids = billIds.split(",");
        long total = ids.length;
        HashMap map = new HashMap();
        DistributionDefineCollection coll = null;
        ArrayList<DistributionDefineInfo> infoList = new ArrayList<DistributionDefineInfo>();
        BigDecimal hundredPercent = new BigDecimal("100");
        Map<Object, Object> evaResultLevelInfo = new TreeMap();
        try {
            long addTotal = 0L;
            DistributionInfo info = DistributionFactory.getLocalInstance(ctx).getDistributionInfo("where id='" + id + "'");
            coll = DistributionDefineFactory.getLocalInstance(ctx).getDistributionDefineCollection("select *, distribution.*, distribution.perfScoreLevel.perfScoreInfo.* where distribution ='" + id + "' order by index asc");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(ids));
            filter.getFilterItems().add(new FilterItemInfo(fieldName, set, CompareType.INCLUDE));
            view.setFilter(filter);
            EvaResultSummaryCollection resultCollection = EvaResultSummaryFactory.getLocalInstance(ctx).getEvaResultSummaryCollection(view);
            evaResultLevelInfo = EvaResultSummaryBizUtil.getEvaResultLevelInfo(ctx, resultCollection);
            String distributionType = info.getDistributionType().getValue();
            for (int i = 0; i < coll.size(); ++i) {
                BigDecimal up;
                BigDecimal down;
                DistributionDefineInfo defineInfo = coll.get(i);
                if (ROUND_HALF_UP.equals(distributionType)) {
                    down = defineInfo.getScaleDownLimit();
                    up = defineInfo.getScaleUpLimit();
                    int personCount = 0;
                    for (int j = 0; j < resultCollection.size(); ++j) {
                        EvaResultSummaryInfo resultInfo = resultCollection.get(j);
                        if (resultInfo.get("reviseSumScore") != null) {
                            if (resultInfo.getReviseSumScore() > down.doubleValue() && resultInfo.getReviseSumScore() <= up.doubleValue() && i != coll.size() - 1) {
                                ++personCount;
                                resultCollection.removeObject(j);
                                --j;
                                continue;
                            }
                            if (!(resultInfo.getReviseSumScore() >= down.doubleValue()) || !(resultInfo.getReviseSumScore() <= up.doubleValue()) || i != coll.size() - 1) continue;
                            ++personCount;
                            resultCollection.removeObject(j);
                            --j;
                            continue;
                        }
                        if (resultInfo.get("sumScore") == null) continue;
                        if (resultInfo.getSumScore() > down.doubleValue() && resultInfo.getSumScore() <= up.doubleValue() && i != coll.size() - 1) {
                            ++personCount;
                            resultCollection.removeObject(j);
                            --j;
                            continue;
                        }
                        if (!(resultInfo.getSumScore() >= down.doubleValue()) || !(resultInfo.getSumScore() <= up.doubleValue()) || i != coll.size() - 1) continue;
                        ++personCount;
                        resultCollection.removeObject(j);
                        --j;
                    }
                    defineInfo.put("personCount", personCount);
                } else {
                    down = defineInfo.getScaleDownLimit();
                    up = defineInfo.getScaleUpLimit();
                    BigDecimal percent = up.subtract(down).abs();
                    BigDecimal result = percent.multiply(new BigDecimal(total)).divide(hundredPercent);
                    long lastCount = total - addTotal;
                    long realAdd = 0L;
                    if (lastCount > 0L) {
                        realAdd = lastCount - result.setScale(0, ROUNDMODEL.get(type)).longValue() >= 0L ? result.setScale(0, ROUNDMODEL.get(type)).longValue() : lastCount;
                        defineInfo.put("personCount", realAdd);
                    } else {
                        realAdd = 0L;
                        defineInfo.put("personCount", realAdd);
                    }
                    if (i == coll.size() - 1) {
                        realAdd = lastCount;
                        defineInfo.put("personCount", realAdd);
                    }
                    addTotal += realAdd;
                }
                infoList.add(defineInfo);
            }
        }
        catch (EASBizException e1) {
            logger.error("", (Throwable)e1);
        }
        catch (BOSException e1) {
            logger.error("", (Throwable)e1);
        }
        Iterator iterator = infoList.iterator();
        while (iterator.hasNext()) {
            DistributionDefineInfo distributionDefineInfo;
            String perfLevel = (distributionDefineInfo = (DistributionDefineInfo)iterator.next()).getPerfLevel();
            Integer integer = (Integer)evaResultLevelInfo.get(perfLevel);
            distributionDefineInfo.put("originalCount", integer == null ? 0 : integer);
        }
        return infoList;
    }

    public static List<DistributionDefineInfo> getOrgDistributionInfo(Context ctx, String id, String billIds, String type) {
        String[] ids = billIds.split(",");
        long total = ids.length;
        HashMap map = new HashMap();
        DistributionDefineCollection coll = null;
        ArrayList<DistributionDefineInfo> infoList = new ArrayList<DistributionDefineInfo>();
        BigDecimal hundredPercent = new BigDecimal("100");
        Map<Object, Object> evaResultLevelInfo = new TreeMap();
        try {
            long addTotal = 0L;
            DistributionInfo info = DistributionFactory.getLocalInstance(ctx).getDistributionInfo("where id='" + id + "'");
            coll = DistributionDefineFactory.getLocalInstance(ctx).getDistributionDefineCollection("select *, distribution.*, distribution.perfScoreLevel.perfScoreInfo.* where distribution ='" + id + "' order by index asc");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(ids));
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            OrgEvaResultSummaryCollection resultCollection = OrgEvaResultSummaryFactory.getLocalInstance(ctx).getOrgEvaResultSummaryCollection(view);
            evaResultLevelInfo = EvaResultSummaryBizUtil.getOrgEvaResultLevelInfo(ctx, resultCollection);
            String distributionType = info.getDistributionType().getValue();
            for (int i = 0; i < coll.size(); ++i) {
                BigDecimal up;
                BigDecimal down;
                DistributionDefineInfo defineInfo = coll.get(i);
                if (ROUND_HALF_UP.equals(distributionType)) {
                    down = defineInfo.getScaleDownLimit();
                    up = defineInfo.getScaleUpLimit();
                    int personCount = 0;
                    for (int j = 0; j < resultCollection.size(); ++j) {
                        OrgEvaResultSummaryInfo resultInfo = resultCollection.get(j);
                        if (resultInfo.get("reviseSumScore") != null) {
                            if (resultInfo.getReviseSumScore() > down.doubleValue() && resultInfo.getReviseSumScore() <= up.doubleValue() && i != coll.size() - 1) {
                                ++personCount;
                                resultCollection.removeObject(j);
                                --j;
                                continue;
                            }
                            if (!(resultInfo.getReviseSumScore() >= down.doubleValue()) || !(resultInfo.getReviseSumScore() <= up.doubleValue()) || i != coll.size() - 1) continue;
                            ++personCount;
                            resultCollection.removeObject(j);
                            --j;
                            continue;
                        }
                        if (resultInfo.get("sumScore") == null) continue;
                        if (resultInfo.getSumScore() > down.doubleValue() && resultInfo.getSumScore() <= up.doubleValue() && i != coll.size() - 1) {
                            ++personCount;
                            resultCollection.removeObject(j);
                            --j;
                            continue;
                        }
                        if (!(resultInfo.getSumScore() >= down.doubleValue()) || !(resultInfo.getSumScore() <= up.doubleValue()) || i != coll.size() - 1) continue;
                        ++personCount;
                        resultCollection.removeObject(j);
                        --j;
                    }
                    defineInfo.put("personCount", personCount);
                } else {
                    down = defineInfo.getScaleDownLimit();
                    up = defineInfo.getScaleUpLimit();
                    BigDecimal percent = up.subtract(down).abs();
                    BigDecimal result = percent.multiply(new BigDecimal(total)).divide(hundredPercent);
                    long lastCount = total - addTotal;
                    long realAdd = 0L;
                    if (lastCount > 0L) {
                        realAdd = lastCount - result.longValue() >= 0L ? result.setScale(0, ROUNDMODEL.get(type)).longValue() : lastCount;
                        defineInfo.put("personCount", realAdd);
                    } else {
                        realAdd = 0L;
                        defineInfo.put("personCount", realAdd);
                    }
                    if (i == coll.size() - 1) {
                        realAdd = lastCount;
                        defineInfo.put("personCount", realAdd);
                    }
                    addTotal += realAdd;
                }
                infoList.add(defineInfo);
            }
        }
        catch (EASBizException e1) {
            logger.error("", (Throwable)e1);
        }
        catch (BOSException e1) {
            logger.error("", (Throwable)e1);
        }
        Iterator iterator = infoList.iterator();
        while (iterator.hasNext()) {
            DistributionDefineInfo distributionDefineInfo;
            String perfLevel = (distributionDefineInfo = (DistributionDefineInfo)iterator.next()).getPerfLevel();
            Integer integer = (Integer)evaResultLevelInfo.get(perfLevel);
            distributionDefineInfo.put("originalCount", integer == null ? 0 : integer);
        }
        return infoList;
    }

    private static EvaResultSummaryCollection getCollectionByIds(EvaResultSummaryCollection collection, Set<String> tmpSummaryIds) {
        EvaResultSummaryCollection result = new EvaResultSummaryCollection();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            EvaResultSummaryInfo next = (EvaResultSummaryInfo)iterator.next();
            if (tmpSummaryIds == null || !tmpSummaryIds.contains(next.getId().toString())) continue;
            result.add(next);
        }
        return result;
    }

    public static void excuteDistribution(Context ctx, EvaResultSummaryCollection collection, String distributionId, Map countMap) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        DistributionDefineCollection coll = null;
        CoreBaseCollection infoList = new CoreBaseCollection();
        CoreBaseCollection infoLogList = new CoreBaseCollection();
        BigDecimal hundredPercent = new BigDecimal("100");
        long addTotal = 0L;
        DistributionInfo info = DistributionFactory.getLocalInstance(ctx).getDistributionInfo("where id='" + distributionId + "'");
        coll = DistributionDefineFactory.getLocalInstance(ctx).getDistributionDefineCollection("select *, distribution.perfScoreLevel.perfScoreInfo.* where distribution ='" + distributionId + "' order by index asc");
        Map<Object, Object> scoreLevelMap = new HashMap();
        if (info.getPerfScoreLevel() != null) {
            scoreLevelMap = EvaResultSummaryBizUtil.getPerfScorLevelDefineMap(ctx, info.getPerfScoreLevel().getId().toString());
        }
        EvaResultSummaryCollection resultCollection = EvaResultSummaryBizUtil.sort(collection);
        String distributionType = info.getDistributionType().getValue();
        for (int i = 0; i < coll.size(); ++i) {
            Double sumScore;
            Double reviseScore;
            EvaResultSumRevisionLogInfo logInfo;
            BigDecimal up;
            BigDecimal down;
            DistributionDefineInfo defineInfo = coll.get(i);
            int count = Integer.valueOf((String)countMap.get(defineInfo.getId().toString()));
            if (ROUND_HALF_UP.equals(distributionType)) {
                down = defineInfo.getScaleDownLimit();
                up = defineInfo.getScaleUpLimit();
                for (int j = 0; j < resultCollection.size() && count > 0; ++j) {
                    double value;
                    EvaResultSummaryInfo resultInfo = resultCollection.get(j);
                    double d = value = resultInfo.get("ReviseSumScore") != null ? resultInfo.getReviseSumScore() : resultInfo.getSumScore();
                    if (value < down.doubleValue() || value > up.doubleValue()) continue;
                    logInfo = new EvaResultSumRevisionLogInfo();
                    reviseScore = null;
                    sumScore = null;
                    reviseScore = resultInfo.get("reviseSumScore") == null ? null : Double.valueOf(resultInfo.get("reviseSumScore").toString());
                    sumScore = resultInfo.get("sumScore") == null ? null : Double.valueOf(resultInfo.get("sumScore").toString());
                    try {
                        if (reviseScore == null) {
                            logInfo.put("beforeReviseSumScore", sumScore);
                            logInfo.setBeforeReviseGradeLevel(resultInfo.getGradeLevel());
                            logInfo.put("afterReviseSumScore", sumScore);
                        } else {
                            logInfo.put("beforeReviseSumScore", resultInfo.getReviseSumScore());
                            logInfo.setBeforeReviseGradeLevel(resultInfo.getReviseGradeLevel());
                            logInfo.put("afterReviseSumScore", resultInfo.getReviseSumScore());
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.toString());
                    }
                    logInfo.setSourceEnum(EvaResultSumLogSourceEnum.DISTRIBUTION);
                    logInfo.setAfterReviseGradeLevel(defineInfo.getPerfLevel());
                    logInfo.setEvaResultSummary(resultInfo);
                    resultInfo.setReviseReason(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DISTRIBUTIONUPDATE, ctx));
                    logInfo.setReviseReason(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DISTRIBUTIONUPDATE, ctx));
                    infoLogList.add((CoreBaseInfo)logInfo);
                    resultInfo.setReviseGradeLevel(defineInfo.getPerfLevel());
                    resultInfo.put("PerfScorLevelDefine", scoreLevelMap.get(defineInfo.getPerfLevel()));
                    resultInfo.setCalibrationStatus(CalibrationStatusEnum.CALIBRATED);
                    resultInfo.setCalibrater(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
                    resultInfo.setCalibrationTime(DateUtil.getTime());
                    infoList.add((CoreBaseInfo)resultInfo);
                    resultCollection.removeObject(j);
                    --count;
                    --j;
                }
                continue;
            }
            down = defineInfo.getScaleDownLimit();
            up = defineInfo.getScaleUpLimit();
            BigDecimal percent = up.subtract(down).abs();
            BigDecimal result = percent.multiply(new BigDecimal(collection.size())).divide(hundredPercent);
            for (int j = 0; j < count; ++j) {
                EvaResultSummaryInfo resultInfo = resultCollection.get(0);
                if (resultInfo == null) continue;
                logInfo = new EvaResultSumRevisionLogInfo();
                reviseScore = null;
                sumScore = null;
                reviseScore = resultInfo.get("reviseSumScore") == null ? null : Double.valueOf(resultInfo.get("reviseSumScore").toString());
                sumScore = resultInfo.get("sumScore") == null ? null : Double.valueOf(resultInfo.get("sumScore").toString());
                try {
                    if (reviseScore == null) {
                        logInfo.put("beforeReviseSumScore", sumScore);
                        logInfo.setBeforeReviseGradeLevel(resultInfo.getGradeLevel());
                        logInfo.put("afterReviseSumScore", sumScore);
                    } else {
                        logInfo.put("beforeReviseSumScore", resultInfo.getReviseSumScore());
                        logInfo.setBeforeReviseGradeLevel(resultInfo.getReviseGradeLevel());
                        logInfo.put("afterReviseSumScore", resultInfo.getReviseSumScore());
                    }
                }
                catch (Exception e) {
                    logger.error(e.toString());
                }
                logInfo.setSourceEnum(EvaResultSumLogSourceEnum.DISTRIBUTION);
                logInfo.setAfterReviseGradeLevel(defineInfo.getPerfLevel());
                resultInfo.put("PerfScorLevelDefine", scoreLevelMap.get(defineInfo.getPerfLevel()));
                logInfo.setEvaResultSummary(resultInfo);
                resultInfo.setReviseReason(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DISTRIBUTIONUPDATE, ctx));
                logInfo.setReviseReason(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DISTRIBUTIONUPDATE, ctx));
                infoLogList.add((CoreBaseInfo)logInfo);
                resultInfo.setReviseGradeLevel(defineInfo.getPerfLevel());
                resultInfo.setCalibrationStatus(CalibrationStatusEnum.CALIBRATED);
                resultInfo.setCalibrater(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
                resultInfo.setCalibrationTime(DateUtil.getTime());
                infoList.add((CoreBaseInfo)resultInfo);
                resultCollection.remove(resultInfo);
            }
        }
        EvaResultSummaryFactory.getLocalInstance(ctx).save(infoList);
        try {
            EvaResultSumRevisionLogService evaResultSumRevisionLogService = new EvaResultSumRevisionLogService();
            evaResultSumRevisionLogService.generatedEvaResultSumRevisionLog(ctx, infoLogList);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    private static EvaResultSummaryCollection sort(EvaResultSummaryCollection resultCollection) {
        EvaResultSummaryCollection result = new EvaResultSummaryCollection();
        for (int i = 0; i < resultCollection.size(); ++i) {
            EvaResultSummaryInfo info = resultCollection.get(i);
            double value = info.get("reviseSumScore") != null ? info.getReviseSumScore() : info.getSumScore();
            for (int j = resultCollection.size() - 1; j > i; --j) {
                double compareValue;
                EvaResultSummaryInfo compareInfo = resultCollection.get(j);
                double d = compareValue = compareInfo.get("reviseSumScore") != null ? compareInfo.getReviseSumScore() : compareInfo.getSumScore();
                if (!(value < compareValue)) continue;
                info = compareInfo;
                value = compareValue;
                resultCollection.swap(i, j);
            }
            resultCollection.removeObject(i);
            --i;
            result.add(info);
        }
        return result;
    }

    public static void excuteOrgDistribution(Context ctx, OrgEvaResultSummaryCollection collection, String distributionId, Map countMap) throws BOSException, EASBizException {
        DistributionDefineCollection coll = null;
        CoreBaseCollection infoList = new CoreBaseCollection();
        CoreBaseCollection infoLogList = new CoreBaseCollection();
        BigDecimal hundredPercent = new BigDecimal("100");
        long addTotal = 0L;
        DistributionInfo info = DistributionFactory.getLocalInstance(ctx).getDistributionInfo("where id='" + distributionId + "'");
        coll = DistributionDefineFactory.getLocalInstance(ctx).getDistributionDefineCollection("select *, distribution.perfScoreLevel.perfScoreInfo.* where distribution ='" + distributionId + "' order by index asc");
        Map<Object, Object> scoreLevelMap = new HashMap();
        if (info.getPerfScoreLevel() != null) {
            scoreLevelMap = EvaResultSummaryBizUtil.getPerfScorLevelDefineMap(ctx, info.getPerfScoreLevel().getId().toString());
        }
        OrgEvaResultSummaryCollection resultCollection = EvaResultSummaryBizUtil.sort(collection);
        String distributionType = info.getDistributionType().getValue();
        for (int i = 0; i < coll.size(); ++i) {
            Double sumScore;
            Double reviseScore;
            EvaResultSumRevisionLogInfo logInfo;
            BigDecimal up;
            BigDecimal down;
            DistributionDefineInfo defineInfo = coll.get(i);
            int count = Integer.valueOf((String)countMap.get(defineInfo.getId().toString()));
            if (ROUND_HALF_UP.equals(distributionType)) {
                down = defineInfo.getScaleDownLimit();
                up = defineInfo.getScaleUpLimit();
                for (int j = 0; j < resultCollection.size() && count > 0; ++j) {
                    double value;
                    OrgEvaResultSummaryInfo resultInfo = resultCollection.get(j);
                    double d = value = resultInfo.get("ReviseSumScore") != null ? resultInfo.getReviseSumScore() : resultInfo.getSumScore();
                    if (value < down.doubleValue() || value > up.doubleValue()) continue;
                    logInfo = new EvaResultSumRevisionLogInfo();
                    reviseScore = null;
                    sumScore = null;
                    reviseScore = resultInfo.get("reviseSumScore") == null ? null : Double.valueOf(resultInfo.get("reviseSumScore").toString());
                    sumScore = resultInfo.get("sumScore") == null ? null : Double.valueOf(resultInfo.get("sumScore").toString());
                    try {
                        if (reviseScore == null) {
                            logInfo.put("beforeReviseSumScore", sumScore);
                            logInfo.setBeforeReviseGradeLevel(resultInfo.getGradeLevel());
                            logInfo.put("afterReviseSumScore", sumScore);
                        } else {
                            logInfo.put("beforeReviseSumScore", resultInfo.getReviseSumScore());
                            logInfo.setBeforeReviseGradeLevel(resultInfo.getReviseGradeLevel());
                            logInfo.put("afterReviseSumScore", resultInfo.getReviseSumScore());
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.toString());
                    }
                    logInfo.setSourceEnum(EvaResultSumLogSourceEnum.DISTRIBUTION);
                    logInfo.setAfterReviseGradeLevel(defineInfo.getPerfLevel());
                    logInfo.setOrgEvaResultSummary(resultInfo);
                    resultInfo.setReviseReason(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DISTRIBUTIONUPDATE, ctx));
                    logInfo.setReviseReason(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DISTRIBUTIONUPDATE, ctx));
                    infoLogList.add((CoreBaseInfo)logInfo);
                    resultInfo.setReviseGradeLevel(defineInfo.getPerfLevel());
                    resultInfo.put("PerfScorLevelDefine", scoreLevelMap.get(defineInfo.getPerfLevel()));
                    resultInfo.setCalibrationStatus(CalibrationStatusEnum.CALIBRATED);
                    resultInfo.setCalibrater(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
                    resultInfo.setCalibrationTime(DateUtil.getTime());
                    infoList.add((CoreBaseInfo)resultInfo);
                    resultCollection.removeObject(j);
                    --count;
                    --j;
                }
                continue;
            }
            down = defineInfo.getScaleDownLimit();
            up = defineInfo.getScaleUpLimit();
            BigDecimal percent = up.subtract(down).abs();
            BigDecimal result = percent.multiply(new BigDecimal(collection.size())).divide(hundredPercent);
            for (int j = 0; j < count; ++j) {
                OrgEvaResultSummaryInfo resultInfo = resultCollection.get(0);
                logInfo = new EvaResultSumRevisionLogInfo();
                reviseScore = null;
                sumScore = null;
                reviseScore = resultInfo.get("reviseSumScore") == null ? null : Double.valueOf(resultInfo.get("reviseSumScore").toString());
                sumScore = resultInfo.get("sumScore") == null ? null : Double.valueOf(resultInfo.get("sumScore").toString());
                try {
                    if (reviseScore == null) {
                        logInfo.put("beforeReviseSumScore", sumScore);
                        logInfo.setBeforeReviseGradeLevel(resultInfo.getGradeLevel());
                        logInfo.put("afterReviseSumScore", sumScore);
                    } else {
                        logInfo.put("beforeReviseSumScore", resultInfo.getReviseSumScore());
                        logInfo.setBeforeReviseGradeLevel(resultInfo.getReviseGradeLevel());
                        logInfo.put("afterReviseSumScore", resultInfo.getReviseSumScore());
                    }
                }
                catch (Exception e) {
                    logger.error(e.toString());
                }
                logInfo.setSourceEnum(EvaResultSumLogSourceEnum.DISTRIBUTION);
                logInfo.setAfterReviseGradeLevel(defineInfo.getPerfLevel());
                resultInfo.put("PerfScorLevelDefine", scoreLevelMap.get(defineInfo.getPerfLevel()));
                logInfo.setOrgEvaResultSummary(resultInfo);
                resultInfo.setReviseReason(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DISTRIBUTIONUPDATE, ctx));
                logInfo.setReviseReason(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DISTRIBUTIONUPDATE, ctx));
                infoLogList.add((CoreBaseInfo)logInfo);
                resultInfo.setReviseGradeLevel(defineInfo.getPerfLevel());
                resultInfo.setCalibrationStatus(CalibrationStatusEnum.CALIBRATED);
                resultInfo.setCalibrater(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
                resultInfo.setCalibrationTime(DateUtil.getTime());
                infoList.add((CoreBaseInfo)resultInfo);
                resultCollection.remove(resultInfo);
            }
        }
        OrgEvaResultSummaryFactory.getLocalInstance(ctx).save(infoList);
        try {
            EvaResultSumRevisionLogService evaResultSumRevisionLogService = new EvaResultSumRevisionLogService();
            evaResultSumRevisionLogService.generatedEvaResultSumRevisionLog(ctx, infoLogList);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    private static OrgEvaResultSummaryCollection sort(OrgEvaResultSummaryCollection resultCollection) {
        OrgEvaResultSummaryCollection result = new OrgEvaResultSummaryCollection();
        for (int i = 0; i < resultCollection.size(); ++i) {
            OrgEvaResultSummaryInfo info = resultCollection.get(i);
            double value = info.get("reviseSumScore") != null ? info.getReviseSumScore() : info.getSumScore();
            for (int j = resultCollection.size() - 1; j > i; --j) {
                double compareValue;
                OrgEvaResultSummaryInfo compareInfo = resultCollection.get(j);
                double d = compareValue = compareInfo.get("reviseSumScore") != null ? compareInfo.getReviseSumScore() : compareInfo.getSumScore();
                if (!(value < compareValue)) continue;
                info = compareInfo;
                value = compareValue;
                resultCollection.swap(i, j);
            }
            resultCollection.removeObject(i);
            --i;
            result.add(info);
        }
        return result;
    }

    public static Map<String, Integer> getEvaResultLevelInfo(Context ctx, EvaResultSummaryCollection collection) {
        LinkedHashMap<String, Integer> leveStrMap = new LinkedHashMap<String, Integer>();
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                EvaResultSummaryInfo next = (EvaResultSummaryInfo)iterator.next();
                String level = StringUtils.isEmpty((String)next.getReviseGradeLevel()) ? next.getLastGradeLevel() : next.getReviseGradeLevel();
                if (StringUtils.isEmpty((String)(level = StringUtils.isEmpty((String)level) ? next.getGradeLevel() : level))) continue;
                leveStrMap.put(level, leveStrMap.get(level) == null ? 1 : (Integer)leveStrMap.get(level) + 1);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return leveStrMap;
    }

    public static Map<String, Integer> getOrgEvaResultLevelInfo(Context ctx, OrgEvaResultSummaryCollection collection) {
        LinkedHashMap<String, Integer> leveStrMap = new LinkedHashMap<String, Integer>();
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                OrgEvaResultSummaryInfo next = (OrgEvaResultSummaryInfo)iterator.next();
                String level = StringUtils.isEmpty((String)next.getReviseGradeLevel()) ? next.getLastGradeLevel() : next.getReviseGradeLevel();
                if (StringUtils.isEmpty((String)(level = StringUtils.isEmpty((String)level) ? next.getGradeLevel() : level))) continue;
                leveStrMap.put(level, leveStrMap.get(level) == null ? 1 : (Integer)leveStrMap.get(level) + 1);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return leveStrMap;
    }

    public static Map<String, String> getPerfScorLevelDefineMap(Context ctx, String perfScorLevelId) {
        HashMap<String, String> result = new HashMap<String, String>();
        PerfScorLevelDefineCollection perfScorLevelDefineCollection = null;
        try {
            perfScorLevelDefineCollection = PerfScorLevelDefineFactory.getLocalInstance(ctx).getPerfScorLevelDefineCollection();
            Iterator iterator = perfScorLevelDefineCollection.iterator();
            while (iterator.hasNext()) {
                PerfScorLevelDefineInfo next = (PerfScorLevelDefineInfo)iterator.next();
                result.put(next.getPerfLevelName(), next.getId().toString());
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void withdrawAppeal(Context ctx, String billId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)billId)) throw ExceptionUtil.EASBizException((Throwable)((Object)new SHRPerfWebBizException(SHRPerfWebBizException.THESTATEWITHDRAWFAIL)));
        IEvaResultAppealBill iEvaResult = EvaResultAppealBillFactory.getLocalInstance(ctx);
        if (iEvaResult.exists("where billState !=1 and id = '" + billId + "' ")) {
            throw ExceptionUtil.EASBizException((Throwable)((Object)new SHRPerfWebBizException(SHRPerfWebBizException.THESTATEWITHDRAWFAIL)));
        }
        try {
            EvaResultAppealBillFacadeFactory.getLocalInstance(ctx).delBillByBillID(billId);
            try {
                TheThirdMessageUtil.recycleWFAssign(ctx, billId);
                return;
            }
            catch (Exception e) {
                String message = "recycle the third message failed,billID:('" + billId + "')";
                if (!logger.isDebugEnabled()) return;
                logger.error(message, (Throwable)e);
            }
            return;
        }
        catch (EASBizException e) {
            if (!logger.isDebugEnabled()) throw ExceptionUtil.EASBizException((Throwable)((Object)new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERROCCURED)));
            logger.error("\u3010PERFWEB\u3011-withdraw appeal failed\uff1aevaObj\uff1a" + billId, (Throwable)e);
            throw ExceptionUtil.EASBizException((Throwable)((Object)new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERROCCURED)));
        }
    }
}

