/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgSourceStatus;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.app.msgcount.ClassificationStatCacheManager;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.custom.TranslateLocalUtil;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.bean.ReMsgBean;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.CurrentUserUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class NoticeUtils {
    private static Logger logger = LoggerFactory.getLogger(NoticeUtils.class);
    public static final String COMMON = "100";
    public static final String URGED = "200";
    public static final HashMap<String, String> mappers = new HashMap<String, String>(){
        {
            this.put("templateTitle", "title");
            this.put("templateContent", "body");
        }
    };

    public static void sendNoticeToPortal(Context ctx, Map<String, Map<String, String>> copyMultiMap, String receiver, String personId, String senderId, String sourceId, String url) throws BOSException, EASBizException {
        NoticeUtils.sendNoticeToPortal(ctx, copyMultiMap, receiver, personId, senderId, sourceId, url, COMMON, null);
    }

    public static void expireMessage(Context ctx, String userId) {
        try {
            ClassificationStatCacheManager manager = ClassificationStatCacheManager.get((Context)ctx);
            manager.expire(userId);
        }
        catch (Exception e) {
            logger.error("[perfweb]expireMessage have error!", (Throwable)e);
        }
    }

    public static void expireMessage(Context ctx, CoreBaseCollection core) {
        try {
            if (core == null) {
                return;
            }
            ClassificationStatCacheManager manager = ClassificationStatCacheManager.get((Context)ctx);
            int size = core.size();
            for (int i = 0; i < size; ++i) {
                BMCMessageInfo bmcMessageInfo = (BMCMessageInfo)core.get(i);
                manager.expire(bmcMessageInfo.getReceiver());
            }
        }
        catch (Exception e) {
            logger.error("[perfweb]battch expireMessage have error!", (Throwable)e);
        }
    }

    public static void sendUrgedNoticeToPortal(Context ctx, Map<String, Map<String, String>> copyMultiMap, String receiver, String personId, String senderId, String sourceId, String url) throws BOSException, EASBizException {
        NoticeUtils.sendNoticeToPortal(ctx, copyMultiMap, receiver, personId, senderId, sourceId, url, URGED, null);
    }

    public static void sendNoticesToPortal(Context ctx, List<NoticeInfo> noticeInfos, String category) throws BOSException, EASBizException {
        if (!CollectionUtils.isEmpty(noticeInfos)) {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            HashSet<String> personIds = new HashSet<String>();
            for (NoticeInfo noticeInfo : noticeInfos) {
                personIds.add(noticeInfo.getReceiverId());
            }
            Map<String, Set<String>> userMap = CurrentUserUtil.getUserInfoMapByPersonIds(ctx, personIds);
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            for (NoticeInfo noticeInfo : noticeInfos) {
                Set<String> userIds = userMap.get(noticeInfo.getReceiverId());
                if (CollectionUtils.isEmpty(userIds)) continue;
                for (String userId : userIds) {
                    BMCMessageInfo bmcMessageInfo = new BMCMessageInfo();
                    bmcMessageInfo.setType(MsgType.NOTICE);
                    bmcMessageInfo.setBizType(MsgBizType.OFFICE);
                    PersonInfo person = CurrentUserUtil.getCurrentPerson(ctx);
                    if (null != person && !StringUtils.isEmpty((CharSequence)person.getName())) {
                        bmcMessageInfo.setSender(person.getName());
                    }
                    bmcMessageInfo.setPriority(MsgPriority.HIGH);
                    bmcMessageInfo.setStatus(MsgStatus.UNREADED);
                    bmcMessageInfo.setSourceStatus(MsgSourceStatus.EMPTY);
                    bmcMessageInfo.setTitle(noticeInfo.getTitle());
                    bmcMessageInfo.setBody(noticeInfo.getContent());
                    bmcMessageInfo.setSendTime(now);
                    bmcMessageInfo.setReceiveTime(now);
                    bmcMessageInfo.setSourceID(noticeInfo.getSourceId());
                    bmcMessageInfo.setReceiver(userId);
                    bmcMessageInfo.setOrgType(OrgType.NONE);
                    bmcMessageInfo.setOrgID(null);
                    bmcMessageInfo.setReceivers(noticeInfo.getReceiverName());
                    if (StringUtils.isEmpty((CharSequence)noticeInfo.getSenderId())) {
                        bmcMessageInfo.setSenderId(bmcMessageInfo.getReceiver());
                        bmcMessageInfo.setSender("administrator");
                    } else {
                        bmcMessageInfo.setSenderId(noticeInfo.getSenderId());
                        bmcMessageInfo.setSender(noticeInfo.getSender());
                    }
                    bmcMessageInfo.setSender(noticeInfo.getSenderL1(), LocaleUtils.locale_L1);
                    bmcMessageInfo.setSender(noticeInfo.getSenderL2(), LocaleUtils.locale_L2);
                    bmcMessageInfo.setSender(noticeInfo.getSenderL3(), LocaleUtils.locale_L3);
                    bmcMessageInfo.setTitle(noticeInfo.getTitleL1(), LocaleUtils.locale_L1);
                    bmcMessageInfo.setTitle(noticeInfo.getTitleL2(), LocaleUtils.locale_L2);
                    bmcMessageInfo.setTitle(noticeInfo.getTitleL3(), LocaleUtils.locale_L3);
                    bmcMessageInfo.setBody(noticeInfo.getContentL1(), LocaleUtils.locale_L1);
                    bmcMessageInfo.setBody(noticeInfo.getContentL2(), LocaleUtils.locale_L2);
                    bmcMessageInfo.setBody(noticeInfo.getContentL3(), LocaleUtils.locale_L3);
                    bmcMessageInfo.setBizCustomizedFlag("PERFWEB");
                    bmcMessageInfo.setCategory(category);
                    if (!StringUtils.isEmpty((CharSequence)noticeInfo.getUrl())) {
                        bmcMessageInfo.put("url", (Object)noticeInfo.getUrl());
                    }
                    coreBaseCollection.add((CoreBaseInfo)bmcMessageInfo);
                }
            }
            BMCMessageFactory.getLocalInstance((Context)ctx).saveBatchData(coreBaseCollection);
            NoticeUtils.expireMessage(ctx, coreBaseCollection);
        }
    }

    public static void sendNoticeToPortal(Context ctx, Map<String, Map<String, String>> copyMultiMap, String receiver, String personId, String senderId, String sourceId, String url, String category, String bizCustomizedFlag) throws BOSException, EASBizException {
        NoticeUtils.sendNoticeToPortal(ctx, copyMultiMap, receiver, personId, senderId, sourceId, url, category, bizCustomizedFlag, mappers);
    }

    public static void sendNoticesToPortal(Context ctx, ReMsgBean bean, String category, CoreBaseCollection coreBaseCollection) throws BOSException, EASBizException {
        UserCollection userColl;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        BMCMessageInfo bmcMessageInfo = new BMCMessageInfo();
        bmcMessageInfo.setType(MsgType.NOTICE);
        bmcMessageInfo.setBizType(MsgBizType.OFFICE);
        PersonInfo person = CurrentUserUtil.getCurrentPerson(ctx);
        if (null != person && !StringUtils.isEmpty((CharSequence)person.getName())) {
            bmcMessageInfo.setSender(person.getName());
            bmcMessageInfo.setSenderId(person.getId().toString());
        }
        bmcMessageInfo.setPriority(MsgPriority.HIGH);
        bmcMessageInfo.setStatus(MsgStatus.UNREADED);
        bmcMessageInfo.setSourceStatus(MsgSourceStatus.EMPTY);
        bmcMessageInfo.setTitle(bean.getSysTitle_l1(), LocaleUtils.locale_L1);
        bmcMessageInfo.setTitle(bean.getSysTitle_l2(), LocaleUtils.locale_L2);
        bmcMessageInfo.setTitle(bean.getSysTitle_l3(), LocaleUtils.locale_L3);
        bmcMessageInfo.setBody(bean.getSysContent_l1(), LocaleUtils.locale_L1);
        bmcMessageInfo.setBody(bean.getSysContent_l2(), LocaleUtils.locale_L2);
        bmcMessageInfo.setBody(bean.getSysContent_l3(), LocaleUtils.locale_L3);
        bmcMessageInfo.setSendTime(now);
        bmcMessageInfo.setReceiveTime(now);
        bmcMessageInfo.setSourceID(String.valueOf(bean.get("sourceId")));
        bmcMessageInfo.setOrgType(OrgType.NONE);
        bmcMessageInfo.setOrgID(null);
        bmcMessageInfo.setReceivers(bean.getReceiver().getName());
        if (StringUtils.isEmpty((CharSequence)bmcMessageInfo.getSenderId())) {
            bmcMessageInfo.setSenderId(bmcMessageInfo.getReceiver());
            bmcMessageInfo.setSender("administrator");
        }
        bmcMessageInfo.setBizCustomizedFlag("PERFWEB");
        bmcMessageInfo.setCategory(category);
        if (bean.get("url") != null) {
            bmcMessageInfo.put("url", bean.get("url"));
        }
        if ((userColl = CurrentUserUtil.getUserCollByPersonId(ctx, bean.getReceiver().getId().toString())) != null && userColl.size() > 0) {
            for (int i = 0; i < userColl.size(); ++i) {
                BMCMessageInfo copyInfo = new BMCMessageInfo();
                try {
                    copyInfo = (BMCMessageInfo)bmcMessageInfo.clone();
                }
                catch (Exception e) {
                    logger.error("Exception: ", (Throwable)e);
                }
                copyInfo.setReceiver(userColl.get(i).getId().toString());
                coreBaseCollection.add((CoreBaseInfo)copyInfo);
            }
        }
    }

    public static void sendNoticeToPortal(Context ctx, Map<String, Map<String, String>> copyMultiMap, String receiver, String personId, String senderId, String sourceId, String url, String category, String bizCustomizedFlag, Map<String, String> mappers) throws BOSException, EASBizException {
        IBMCMessage ibmcMessage = BMCMessageFactory.getLocalInstance((Context)ctx);
        BMCMessageInfo bmcMessageInfo = new BMCMessageInfo();
        bmcMessageInfo.setType(MsgType.NOTICE);
        bmcMessageInfo.setBizType(MsgBizType.OFFICE);
        PersonInfo person = CurrentUserUtil.getCurrentPerson(ctx);
        if (null != person && !StringUtils.isEmpty((CharSequence)person.getName())) {
            bmcMessageInfo.setSender(person.getName());
        }
        SHRPerfWebResourceUtil.copyMultiLanValue(copyMultiMap, (CoreBaseInfo)bmcMessageInfo, mappers);
        bmcMessageInfo.setPriority(MsgPriority.HIGH);
        bmcMessageInfo.setStatus(MsgStatus.UNREADED);
        bmcMessageInfo.setSourceStatus(MsgSourceStatus.EMPTY);
        bmcMessageInfo.setSendTime(new Timestamp(System.currentTimeMillis()));
        bmcMessageInfo.setSourceID(sourceId);
        bmcMessageInfo.setOrgType(OrgType.NONE);
        bmcMessageInfo.setOrgID(null);
        bmcMessageInfo.setReceivers(receiver);
        if (StringUtils.isEmpty((CharSequence)senderId)) {
            bmcMessageInfo.setSenderId(bmcMessageInfo.getReceiver());
        } else {
            bmcMessageInfo.setSenderId(senderId);
        }
        bmcMessageInfo.setSender("administrator");
        bmcMessageInfo.setSender(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SYSTEMAUTOSENT, LocaleUtils.locale_l1), LocaleUtils.locale_l1);
        bmcMessageInfo.setSender(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SYSTEMAUTOSENT, LocaleUtils.locale_l2), LocaleUtils.locale_l2);
        bmcMessageInfo.setSender(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SYSTEMAUTOSENT, LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        bmcMessageInfo.setBizCustomizedFlag("PERFWEB");
        if (!StringUtils.isEmpty((CharSequence)url)) {
            bmcMessageInfo.put("url", (Object)url);
        }
        bmcMessageInfo.setCategory(category);
        UserCollection userColl = CurrentUserUtil.getUserCollByPersonId(ctx, personId);
        if (userColl != null && userColl.size() > 0) {
            for (int i = 0; i < userColl.size(); ++i) {
                bmcMessageInfo.setId(null);
                BMCMessageInfo bmcMsgInfo = bmcMessageInfo;
                bmcMsgInfo.setReceiver(userColl.get(i).getId().toString());
                ibmcMessage.addnew((CoreBaseInfo)bmcMsgInfo);
                NoticeUtils.expireMessage(ctx, bmcMsgInfo.getReceiver());
            }
        }
    }

    public static void sendNoticeToPortals(Context ctx, Map<String, Map<String, String>> copyMultiMap, String receiver, String personId, String senderId, String sourceId, String url, String category, CoreBaseCollection coreColl) throws BOSException, EASBizException {
        BMCMessageInfo bmcMessageInfo = new BMCMessageInfo();
        bmcMessageInfo.setType(MsgType.NOTICE);
        bmcMessageInfo.setBizType(MsgBizType.OFFICE);
        PersonInfo person = CurrentUserUtil.getCurrentPerson(ctx);
        if (null != person && !StringUtils.isEmpty((CharSequence)person.getName())) {
            bmcMessageInfo.setSender(person.getName());
        }
        bmcMessageInfo.setPriority(MsgPriority.HIGH);
        bmcMessageInfo.setStatus(MsgStatus.UNREADED);
        bmcMessageInfo.setSourceStatus(MsgSourceStatus.EMPTY);
        SHRPerfWebResourceUtil.copyMultiLanValue(copyMultiMap, (CoreBaseInfo)bmcMessageInfo, mappers);
        bmcMessageInfo.setSendTime(new Timestamp(System.currentTimeMillis()));
        bmcMessageInfo.setSourceID(sourceId);
        bmcMessageInfo.setOrgType(OrgType.NONE);
        bmcMessageInfo.setOrgID(" ");
        bmcMessageInfo.setReceivers(receiver);
        if (StringUtils.isEmpty((CharSequence)senderId)) {
            bmcMessageInfo.setSenderId(bmcMessageInfo.getReceiver());
        } else {
            bmcMessageInfo.setSenderId(senderId);
        }
        bmcMessageInfo.setSender("administrator");
        bmcMessageInfo.setBizCustomizedFlag("PERFWEB");
        if (!StringUtils.isEmpty((CharSequence)url)) {
            bmcMessageInfo.put("url", (Object)url);
        }
        bmcMessageInfo.setCategory(category);
        UserCollection userColl = CurrentUserUtil.getUserCollByPersonId(ctx, personId);
        if (userColl != null && userColl.size() > 0) {
            for (int i = 0; i < userColl.size(); ++i) {
                bmcMessageInfo.setId(null);
                BMCMessageInfo bmcMsgInfo = bmcMessageInfo;
                bmcMsgInfo.setReceiver(userColl.get(i).getId().toString());
                coreColl.add((CoreBaseInfo)bmcMsgInfo);
            }
        }
    }

    public static BMCMessageInfo assembleBMCMessageInfo(Context ctx, String title, String body, String receiver, String personId, String senderId, String sourceId) {
        BMCMessageInfo bmcMessageInfo = new BMCMessageInfo();
        bmcMessageInfo.setType(MsgType.NOTICE);
        bmcMessageInfo.setBizType(MsgBizType.OFFICE);
        bmcMessageInfo.setSender(CurrentUserUtil.getCurrentPerson(ctx).getName());
        bmcMessageInfo.setPriority(MsgPriority.HIGH);
        bmcMessageInfo.setStatus(MsgStatus.UNREADED);
        bmcMessageInfo.setSourceStatus(MsgSourceStatus.EMPTY);
        bmcMessageInfo.setTitle(title);
        bmcMessageInfo.setTitle(title, LocaleUtils.locale_l1);
        bmcMessageInfo.setTitle(title, LocaleUtils.locale_l2);
        bmcMessageInfo.setTitle(TranslateLocalUtil.getTraditional((String)title), LocaleUtils.locale_l3);
        bmcMessageInfo.setBody(body);
        bmcMessageInfo.setBody(body, LocaleUtils.locale_l1);
        bmcMessageInfo.setBody(body, LocaleUtils.locale_l2);
        bmcMessageInfo.setBody(TranslateLocalUtil.getTraditional((String)body), LocaleUtils.locale_l3);
        bmcMessageInfo.setSendTime(new Timestamp(System.currentTimeMillis()));
        bmcMessageInfo.setSourceID(sourceId);
        UserInfo userInfo = CurrentUserUtil.getUserInfoByPersonId(ctx, personId);
        if (userInfo != null) {
            bmcMessageInfo.setReceiver(userInfo.getId().toString());
        }
        bmcMessageInfo.setOrgType(OrgType.NONE);
        bmcMessageInfo.setOrgID(null);
        bmcMessageInfo.setReceivers(receiver);
        bmcMessageInfo.setSenderId(senderId);
        bmcMessageInfo.setBizCustomizedFlag("PERFWEB");
        bmcMessageInfo.setSender(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SYSTEMAUTOSENT, LocaleUtils.locale_l1), LocaleUtils.locale_l1);
        bmcMessageInfo.setSender(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SYSTEMAUTOSENT, LocaleUtils.locale_l2), LocaleUtils.locale_l2);
        bmcMessageInfo.setSender(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SYSTEMAUTOSENT, LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        return bmcMessageInfo;
    }

    public static void setCombineNoticeInfoMap(Map<String, CombineNoticeInfo> map, CombineNoticeInfo info, String evaObjName) {
        if (map == null || info == null || evaObjName == null) {
            return;
        }
        String key = info.getPlanId() + info.getPeriodId() + info.getPersonId() + info.getNodeInstId();
        CombineNoticeInfo existInfo = map.get(key);
        if (existInfo == null) {
            ArrayList<String> evaObjs = new ArrayList<String>();
            evaObjs.add(evaObjName);
            info.setEvaObjs(evaObjs);
            map.put(key, info);
        } else {
            List<String> evaObjs = existInfo.getEvaObjs();
            if (evaObjs == null) {
                evaObjs = new ArrayList<String>();
                existInfo.setEvaObjs(evaObjs);
            }
            evaObjs.add(evaObjName);
            map.put(key, existInfo);
        }
    }

    public static class CombineNoticeInfo {
        private String planId;
        private String periodId;
        private String planName;
        private String periodName;
        private String pStartDate;
        private String pEndDate;
        private String personId;
        private String senderId;
        private String personName;
        private List<String> evaObjs;
        private String url;
        private String evaObjId;
        private String evaObjName;
        private String nodeInstId;

        public String getEvaObjStrs(Context ctx, int length) {
            String etcMl = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ETC, ctx);
            int size = this.evaObjs.size();
            length = length > size ? size : length;
            StringBuffer evaObjNames = new StringBuffer();
            if (this.evaObjs != null && size > 0) {
                for (int count = 0; count < length; ++count) {
                    evaObjNames.append(this.evaObjs.get(count));
                    if (count == length - 1 && count > 0) {
                        evaObjNames.append(etcMl);
                        break;
                    }
                    if (count >= this.evaObjs.size() - 1) continue;
                    evaObjNames.append("\u3001");
                }
            }
            return evaObjNames.toString();
        }

        public String getPlanId() {
            return this.planId;
        }

        public void setPlanId(String planId) {
            this.planId = planId;
        }

        public String getPeriodId() {
            return this.periodId;
        }

        public void setPeriodId(String periodId) {
            this.periodId = periodId;
        }

        public String getPlanName() {
            return this.planName;
        }

        public void setPlanName(String planName) {
            this.planName = planName;
        }

        public String getPeriodName() {
            return this.periodName;
        }

        public void setPeriodName(String periodName) {
            this.periodName = periodName;
        }

        public String getpStartDate() {
            return this.pStartDate;
        }

        public void setpStartDate(String pStartDate) {
            this.pStartDate = pStartDate;
        }

        public String getpEndDate() {
            return this.pEndDate;
        }

        public void setpEndDate(String pEndDate) {
            this.pEndDate = pEndDate;
        }

        public String getPersonId() {
            return this.personId;
        }

        public void setPersonId(String personId) {
            this.personId = personId;
        }

        public String getSenderId() {
            return this.senderId;
        }

        public void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        public String getPersonName() {
            return this.personName;
        }

        public void setPersonName(String personName) {
            this.personName = personName;
        }

        public List<String> getEvaObjs() {
            return this.evaObjs;
        }

        public void setEvaObjs(List<String> evaObjs) {
            this.evaObjs = evaObjs;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getEvaObjId() {
            return this.evaObjId;
        }

        public void setEvaObjId(String evaObjId) {
            this.evaObjId = evaObjId;
        }

        public String getEvaObjName(Context ctx) {
            String etcMl = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ETC, ctx);
            if (this.evaObjs != null && this.evaObjs.size() > 1) {
                return this.evaObjName + etcMl;
            }
            return this.evaObjName;
        }

        public void setEvaObjName(String evaObjName) {
            this.evaObjName = evaObjName;
        }

        public String getNodeInstId() {
            if (this.nodeInstId == null) {
                return "";
            }
            return this.nodeInstId;
        }

        public void setNodeInstId(String nodeInstId) {
            this.nodeInstId = nodeInstId;
        }
    }

    public static final class NoticeInfo {
        private String title;
        private String titleL1;
        private String titleL2;
        private String titleL3;
        private String content;
        private String contentL1;
        private String contentL2;
        private String contentL3;
        private String receiverId;
        private String receiverName;
        private String senderId;
        private String sender;
        private String senderL1;
        private String senderL2;
        private String senderL3;
        private String sourceId;
        private String url;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getReceiverId() {
            return this.receiverId;
        }

        public void setReceiverId(String receiverId) {
            this.receiverId = receiverId;
        }

        public String getReceiverName() {
            return this.receiverName;
        }

        public void setReceiverName(String receiverName) {
            this.receiverName = receiverName;
        }

        public String getSenderId() {
            return this.senderId;
        }

        public void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        public String getSender() {
            return this.sender;
        }

        public void setSender(String sender) {
            this.sender = sender;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getTitleL1() {
            return this.titleL1;
        }

        public void setTitleL1(String titleL1) {
            this.titleL1 = titleL1;
        }

        public String getTitleL2() {
            return this.titleL2;
        }

        public void setTitleL2(String titleL2) {
            this.titleL2 = titleL2;
        }

        public String getTitleL3() {
            return this.titleL3;
        }

        public void setTitleL3(String titleL3) {
            this.titleL3 = titleL3;
        }

        public String getContentL1() {
            return this.contentL1;
        }

        public void setContentL1(String contentL1) {
            this.contentL1 = contentL1;
        }

        public String getContentL2() {
            return this.contentL2;
        }

        public void setContentL2(String contentL2) {
            this.contentL2 = contentL2;
        }

        public String getContentL3() {
            return this.contentL3;
        }

        public void setContentL3(String contentL3) {
            this.contentL3 = contentL3;
        }

        public String getSenderL1() {
            return this.senderL1;
        }

        public void setSenderL1(String senderL1) {
            this.senderL1 = senderL1;
        }

        public String getSenderL2() {
            return this.senderL2;
        }

        public void setSenderL2(String senderL2) {
            this.senderL2 = senderL2;
        }

        public String getSenderL3() {
            return this.senderL3;
        }

        public void setSenderL3(String senderL3) {
            this.senderL3 = senderL3;
        }
    }
}

