/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PerfPersonInfoUtils {
    private static Logger logger = LoggerFactory.getLogger(PerfPersonInfoUtils.class);

    public static Map<String, String> getPersonNameMapByIds(Context ctx, Set<String> personIds) {
        if (CollectionUtils.isEmpty(personIds)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> personMap = new HashMap<String, String>();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", personIds, CompareType.INCLUDE));
        SelectorItemCollection selectos = new SelectorItemCollection();
        selectos.add(new SelectorItemInfo("id"));
        selectos.add(new SelectorItemInfo("name"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectos);
        try {
            PersonCollection persons = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(evi);
            if (persons != null && !persons.isEmpty()) {
                for (PersonInfo personInfo : persons) {
                    personMap.put(personInfo.getId().toString(), personInfo.getNumber());
                }
            }
        }
        catch (BOSException e) {
            logger.error("get participate person info err", (Throwable)e);
        }
        return personMap;
    }

    public static List<Map<String, Object>> getPersonF7SelectedInfos(Context ctx, Set<String> personIds) {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.emp.app.PersonWebListQuery"));
        SelectorItemCollection selectos = new SelectorItemCollection();
        selectos.add(new SelectorItemInfo("number"));
        selectos.add(new SelectorItemInfo("name"));
        selectos.add(new SelectorItemInfo("empPosOrgRela.assignType"));
        selectos.add(new SelectorItemInfo("position.name"));
        selectos.add(new SelectorItemInfo("cell"));
        selectos.add(new SelectorItemInfo("email"));
        selectos.add(new SelectorItemInfo("adminOrgUnit.name"));
        selectos.add(new SelectorItemInfo("employeeType.name"));
        selectos.add(new SelectorItemInfo("affairActionReason.name"));
        selectos.add(new SelectorItemInfo("empPosOrgRela.id"));
        selectos.add(new SelectorItemInfo("affairActionReason.name"));
        selectos.add(new SelectorItemInfo("position.id"));
        selectos.add(new SelectorItemInfo("id"));
        FilterInfo filterInfo = new FilterInfo();
        Date now = new Date();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", personIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("empPosOrgRela.assignType", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("EFFDT", (Object)now, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)now, CompareType.GREATER));
        filterInfo.getFilterItems().add(new FilterItemInfo("pp.EFFDT", (Object)now, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("pp.LEFFDT", (Object)now, CompareType.GREATER));
        filterInfo.getFilterItems().add(new FilterItemInfo("empPosOrgRela.isInner", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("employeeType.inService", (Object)2, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("employeeType.inService", (Object)3, CompareType.NOTEQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectos);
        exec.setObjectView(evi);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        ArrayList<Map<String, Object>> personList = new ArrayList<Map<String, Object>>();
        try {
            IRowSet rowSet = exec.executeQuery();
            IRowSetMetaData md = rowSet.getRowSetMetaData();
            while (rowSet.next()) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                int count = md.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    String columnName = md.getColumnName(i);
                    Object value = rowSet.getObject(i);
                    item.put(columnName, value);
                }
                personList.add(item);
            }
        }
        catch (BOSException e) {
            logger.error("query person info bosErr", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("query person info sqlErr", (Throwable)e);
        }
        return personList;
    }
}

