/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentUserUtil {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.utils.CurrentUserUtil");

    public static PersonInfo getCurrentPerson(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        PersonInfo personInfo = null;
        try {
            if (null != userInfo.getPerson()) {
                String personId = userInfo.getPerson().getId().toString();
                IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                PersonCollection personCollection = iPerson.getPersonCollection("select id,name,number,email,cell where id='" + personId + "'");
                if (null != personCollection.get(0)) {
                    personInfo = personCollection.get(0);
                }
            }
        }
        catch (Exception e) {
            logger.error("get current user info err : " + e.getMessage());
        }
        return personInfo;
    }

    public static UserInfo getUserInfoByPersonId(Context ctx, String person) {
        if (StringUtils.isEmpty((CharSequence)person)) {
            return null;
        }
        UserInfo userInfo = null;
        try {
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            UserCollection userColl = iUser.getUserCollection("select id,name,number where person='" + person + "' and isDelete=0 and isForbidden=0");
            if (userColl != null && userColl.size() > 0) {
                userInfo = userColl.get(0);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return userInfo;
    }

    public static UserCollection getUserCollByPersonId(Context ctx, String person) {
        UserCollection userColl = null;
        if (StringUtils.isEmpty((CharSequence)person)) {
            return null;
        }
        try {
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            userColl = iUser.getUserCollection("select id,name,number where person='" + person + "' and isDelete=0 and isForbidden=0");
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return userColl;
    }

    public static Map<String, Set<String>> getUserInfoMapByPersonIds(Context ctx, Set<String> personIds) {
        HashMap<String, Set<String>> userMap = new HashMap<String, Set<String>>();
        try {
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person", personIds, CompareType.INCLUDE));
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("id"));
            selectorItemCollection.add(new SelectorItemInfo("person.id"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            evi.setSelector(selectorItemCollection);
            UserCollection userColl = iUser.getUserCollection(evi);
            if (userColl != null && userColl.size() > 0) {
                for (int i = 0; i < userColl.size(); ++i) {
                    UserInfo userInfo = userColl.get(i);
                    String personId = userInfo.getPerson().getId().toString();
                    HashSet<String> userIds = (HashSet<String>)userMap.get(personId);
                    if (userIds == null) {
                        userIds = new HashSet<String>();
                    }
                    userIds.add(userInfo.getId().toString());
                    userMap.put(personId, userIds);
                }
            }
        }
        catch (BOSException e) {
            logger.error("get userInfo by personIds failed", (Throwable)e);
        }
        return userMap;
    }

    public static PersonInfo getPersonById(Context ctx, String person) {
        PersonInfo personInfo = null;
        if (StringUtils.isEmpty((CharSequence)person)) {
            return null;
        }
        try {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PersonCollection personColl = iPerson.getPersonCollection("select id,name,number,email,cell,passportNO,idCardNO where id='" + person + "'");
            if (personColl != null && personColl.size() > 0) {
                personInfo = personColl.get(0);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return personInfo;
    }

    public static UserInfo getUserById(Context ctx, String userId) {
        UserInfo userInfo = null;
        try {
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            UserCollection userColl = iUser.getUserCollection(" where id='" + userId + "'");
            if (null != userColl && userColl.size() > 0) {
                userInfo = userColl.get(0);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return userInfo;
    }
}

