/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfGoalsGroup;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsGroupCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsGroupFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.IMultiPerfRelationship;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfRelationshipCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfRelationshipFactory;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberGenerator {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.utils.NumberGenerator");

    public static synchronized String generateGroupNumber(Context context) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        String nowStr = sdf.format(now);
        String refStr = nowStr.substring(0, 4) + nowStr.substring(5, 7) + nowStr.subSequence(8, 10);
        String targetNumber = "";
        try {
            IPerfGoalsGroup iperfGroup = null;
            iperfGroup = context == null ? PerfGoalsGroupFactory.getRemoteInstance() : PerfGoalsGroupFactory.getLocalInstance(context);
            PerfGoalsGroupCollection perfGroupColl = iperfGroup.getPerfGoalsGroupCollection(" where number like '" + refStr + "%' order by number desc");
            if (perfGroupColl != null && perfGroupColl.size() > 0) {
                String tempNumber = perfGroupColl.get(0).getNumber();
                String middleNumber = tempNumber.substring(0, 8);
                tempNumber = tempNumber.substring(8, tempNumber.length());
                int num = Integer.parseInt(tempNumber);
                if (++num < 10) {
                    targetNumber = middleNumber + "00" + num;
                } else if (num >= 10 && num < 100) {
                    targetNumber = middleNumber + "0" + num;
                } else if (num >= 100) {
                    targetNumber = middleNumber + num;
                }
            } else {
                targetNumber = refStr + "001";
            }
        }
        catch (BOSException e) {
            logger.error("generate the target group coding error, detailed information:" + e.getMessage());
        }
        return targetNumber;
    }

    public static synchronized String generateMultiGroupNumber() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        String nowStr = sdf.format(now);
        String refStr = nowStr.substring(0, 4) + nowStr.substring(5, 7) + nowStr.subSequence(8, 10);
        String targetNumber = "";
        try {
            IMultiPerfRelationship iMultiPerfRelationship = MultiPerfRelationshipFactory.getRemoteInstance();
            MultiPerfRelationshipCollection multiPerfRelationshipCollection = iMultiPerfRelationship.getMultiPerfRelationshipCollection(" where number like '" + refStr + "%' order by number desc");
            if (multiPerfRelationshipCollection != null && multiPerfRelationshipCollection.size() > 0) {
                String tempNumber = multiPerfRelationshipCollection.get(0).getNumber();
                String middleNumber = tempNumber.substring(0, 8);
                tempNumber = tempNumber.substring(8, tempNumber.length());
                int num = Integer.parseInt(tempNumber);
                if (++num < 10) {
                    targetNumber = middleNumber + "00" + num;
                } else if (num >= 10 && num < 100) {
                    targetNumber = middleNumber + "0" + num;
                } else if (num >= 100) {
                    targetNumber = middleNumber + num;
                }
            } else {
                targetNumber = refStr + "001";
            }
        }
        catch (BOSException e) {
            logger.error("relationship group coding error generated 360 degrees, detailed information:" + e.getMessage());
        }
        return targetNumber;
    }

    public static synchronized List<String> generateMultiGroupNumber(Context ctx, int count) {
        if (count <= 0) {
            logger.error("the param count is: " + count);
            return new ArrayList<String>();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        String nowStr = sdf.format(now);
        String refStr = nowStr.substring(0, 4) + nowStr.substring(5, 7) + nowStr.subSequence(8, 10);
        String targetNumber = "";
        ArrayList<String> targetNumbers = new ArrayList<String>(count);
        try {
            IMultiPerfRelationship iMultiPerfRelationship = MultiPerfRelationshipFactory.getLocalInstance(ctx);
            MultiPerfRelationshipCollection multiPerfRelationshipCollection = iMultiPerfRelationship.getMultiPerfRelationshipCollection(" where number like '" + refStr + "%' order by number desc");
            for (int i = 0; i < count; ++i) {
                String tempNumber = i == 0 ? (multiPerfRelationshipCollection != null && multiPerfRelationshipCollection.size() > 0 ? multiPerfRelationshipCollection.get(0).getNumber() : refStr + "001") : targetNumber;
                String middleNumber = tempNumber.substring(0, 8);
                tempNumber = tempNumber.substring(8);
                int num = Integer.parseInt(tempNumber);
                targetNumber = ++num < 10 ? middleNumber + "00" + num : (num < 100 ? middleNumber + "0" + num : middleNumber + num);
                targetNumbers.add(targetNumber);
            }
        }
        catch (BOSException e) {
            logger.error("relationship group coding error generated 360 degrees, detailed information:" + e.getMessage());
        }
        return targetNumbers;
    }

    public static synchronized String generateMultiCopyRelationshipName(Context ctx, String multiPeriod, String soureName) throws BOSException {
        String targetName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.COPYGOALSGROUPWITHSUFFIX, ctx, new Object[]{soureName});
        int count = 1;
        while (true) {
            MultiPerfRelationshipCollection coll;
            if ((coll = MultiPerfRelationshipFactory.getRemoteInstance().getMultiPerfRelationshipCollection(" where name= '" + targetName + "(" + count + ")' and multiPeriod= '" + multiPeriod + "'")) == null || coll.size() == 0) break;
            ++count;
        }
        targetName = targetName + "(" + count + ")";
        return targetName;
    }
}

