/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.emp.IPersonPhoto;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhotoUtils {
    private static Logger logger = LoggerFactory.getLogger(PhotoUtils.class);
    public static final String REFRESH_IMAGE = "1";
    private static final String perfImagesPath = File.separator + "addon" + File.separator + "perfweb" + File.separator + "web" + File.separator + "images" + File.separator + "person" + File.separator;

    public static String showCutImage(HttpServletRequest request, HttpServletResponse response) throws WfBizException, IOException, BOSException {
        String imgPath = "";
        String personId = (String)request.getAttribute("personId");
        String personNumber = (String)request.getAttribute("personNumber");
        if (personId != null && personId.length() > 0) {
            IPersonPhoto personPhoto = PersonPhotoFactory.getRemoteInstance();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            CoreBaseCollection coll = personPhoto.getCollection(entityViewInfo);
            PersonPhotoInfo personPhotoInfo = null;
            PhotoUtils.checkFileDir();
            if (coll.size() > 0) {
                personPhotoInfo = (PersonPhotoInfo)coll.get(0);
                request.setAttribute("id", (Object)personPhotoInfo.getId());
                request.setAttribute("personId", (Object)personId);
                if (personPhotoInfo.getImageData() != null) {
                    byte[] fileContent = personPhotoInfo.getImageData();
                    String ContentType = personPhotoInfo.getImageContentType();
                    String type = "jpg";
                    if (!StringUtils.isEmpty((String)ContentType)) {
                        int start = ContentType.indexOf("/") + 1;
                        int end = ContentType.length();
                        type = ContentType.substring(start, end).toLowerCase();
                    }
                    imgPath = PhotoUtils.getImagePathByPersonNumber(personNumber, type);
                    PhotoUtils.byte2image(fileContent, imgPath);
                    imgPath = perfImagesPath + personNumber + "." + type;
                }
            }
        }
        return imgPath;
    }

    public static String getPhotoPath(Context ctx, String personId, String personNumber) {
        return PhotoUtils.getPhotoPath(ctx, personId, personNumber, REFRESH_IMAGE);
    }

    public static String getPhotoPath(Context ctx, String personId, String personNumber, String refreshPersonHeadPic) {
        String imgPath = "";
        if ("ORG".equals(personId)) {
            return imgPath;
        }
        try {
            if (personId != null && personId.length() > 0) {
                IPersonPhoto personPhoto = PersonPhotoFactory.getLocalInstance((Context)ctx);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                entityViewInfo.setFilter(filterInfo);
                CoreBaseCollection coll = personPhoto.getCollection(entityViewInfo);
                PersonPhotoInfo personPhotoInfo = null;
                if (coll.size() > 0 && (personPhotoInfo = (PersonPhotoInfo)coll.get(0)).getImageData() != null) {
                    byte[] fileContent = personPhotoInfo.getImageData();
                    String ContentType = personPhotoInfo.getImageContentType();
                    String type = "jpg";
                    if (!StringUtils.isEmpty((String)ContentType)) {
                        int start = ContentType.indexOf("/") + 1;
                        int end = ContentType.length();
                        type = ContentType.substring(start, end).toLowerCase();
                    }
                    imgPath = PhotoUtils.getImagePathByPersonNumber(personNumber, type);
                    PhotoUtils.byte2image(fileContent, imgPath, refreshPersonHeadPic);
                    imgPath = perfImagesPath + personNumber + "." + type;
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return imgPath;
    }

    public static Map<String, String> getImages(Map<String, String> persons) throws WfBizException, IOException, BOSException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Set<String> personIds = persons.keySet();
        if (personIds != null && personIds.size() > 0) {
            IPersonPhoto personPhoto = PersonPhotoFactory.getRemoteInstance();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person", personIds, CompareType.INCLUDE));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            CoreBaseCollection coll = personPhoto.getCollection(entityViewInfo);
            if (coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    String personId;
                    String personNumber;
                    File file;
                    String imgPath = "";
                    PersonPhotoInfo personPhotoInfo = (PersonPhotoInfo)coll.get(i);
                    if (personPhotoInfo.getImageData() == null) continue;
                    String ContentType = personPhotoInfo.getImageContentType();
                    String type = "jpg";
                    if (!StringUtils.isEmpty((String)ContentType)) {
                        int start = ContentType.indexOf("/") + 1;
                        int end = ContentType.length();
                        type = ContentType.substring(start, end).toLowerCase();
                    }
                    if (!(file = new File(SHRCheck.checkFilePath((String)(imgPath = PhotoUtils.getImagePathByPersonNumber(personNumber = persons.get(personId = personPhotoInfo.getPerson().getId().toString()), type))))).exists()) {
                        byte[] fileContent = personPhotoInfo.getImageData();
                        PhotoUtils.byte2image(fileContent, imgPath);
                    }
                    imgPath = perfImagesPath + personNumber + "." + type;
                    resultMap.put(personId, imgPath);
                }
            }
        }
        return resultMap;
    }

    public static Map<String, String> getBase64Images(Context ctx, Map<String, String> persons) throws WfBizException, IOException, BOSException {
        return PhotoUtils.getBase64Images(ctx, persons, 0, 0, false);
    }

    public static Map<String, String> getBase64Images(Context ctx, Map<String, String> persons, int width, int height, boolean isZip) throws WfBizException, IOException, BOSException {
        ConcurrentHashMap<String, String> resultMap = new ConcurrentHashMap<String, String>();
        Set<String> personIds = persons.keySet();
        if (personIds != null && personIds.size() > 0) {
            IPersonPhoto personPhoto = PersonPhotoFactory.getLocalInstance((Context)ctx);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person", personIds, CompareType.INCLUDE));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            CoreBaseCollection coll = personPhoto.getCollection(entityViewInfo);
            if (coll.size() > 0) {
                ExecutorService es = Executors.newFixedThreadPool(coll.size());
                for (int i = 0; i < coll.size(); ++i) {
                    PersonPhotoInfo personPhotoInfo = (PersonPhotoInfo)coll.get(i);
                    String personId = personPhotoInfo.getPerson().getId().toString();
                    if (personPhotoInfo.getImageData() == null) continue;
                    byte[] fileContent = personPhotoInfo.getImageData();
                    es.submit(new ImageEncoderService(width, height, personId, fileContent, resultMap, isZip));
                }
                es.shutdown();
                try {
                    while (!es.awaitTermination(20L, TimeUnit.MILLISECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    logger.error("InterruptedException: ", (Throwable)e);
                }
            }
        }
        return resultMap;
    }

    private static String getImagePathByPersonNumber(String personNumber, String type) {
        return System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "easweb.ear" + File.separator + "shr_web.war" + File.separator + "addon" + File.separator + "perfweb" + File.separator + "web" + File.separator + "images" + File.separator + "person" + File.separator + personNumber + "." + type;
    }

    protected static void writeResponse(HttpServletResponse response, String contentType, byte[] result) {
        try {
            response.setHeader("cache-control", "no-cache");
            response.setHeader("charset", "UTF-8");
            response.setContentType(contentType);
            response.getOutputStream().write(result);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public static void byte2image(byte[] data, String path) {
        PhotoUtils.byte2image(data, path, REFRESH_IMAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void byte2image(byte[] data, String path, String refreshPersonHeadPic) {
        if (data.length < 3 || path.equals("")) {
            return;
        }
        FileImageOutputStream imageOutput = null;
        try {
            File file = new File(SHRCheck.checkFilePath((String)path));
            if (file.exists()) {
                if (REFRESH_IMAGE.equals(refreshPersonHeadPic)) {
                    file.delete();
                } else {
                    return;
                }
            }
            imageOutput = new FileImageOutputStream(new File(SHRCheck.checkFilePath((String)path)));
            imageOutput.write(data, 0, data.length);
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            try {
                if (imageOutput != null) {
                    imageOutput.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            if (imageOutput != null) {
                try {
                    imageOutput.close();
                }
                catch (IOException e) {
                    logger.error("IOException: ", (Throwable)e);
                }
            }
        }
    }

    private static void checkFileDir() {
        String path = PhotoUtils.getImagePathByPersonDir();
        File file = new File(SHRCheck.checkFilePath((String)path));
        if (!file.exists()) {
            file.mkdir();
        }
    }

    private static String getImagePathByPersonDir() {
        return System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "easweb.ear" + File.separator + "shr_web.war" + File.separator + "addon" + File.separator + "perfweb" + File.separator + "web" + File.separator + "images" + File.separator + "person";
    }

    public static byte[] compressImg(byte[] buf, int width, int height) {
        ByteArrayInputStream sbs = new ByteArrayInputStream(buf);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            Image bi = ImageIO.read(sbs);
            ImageIcon icon = new ImageIcon(bi);
            if (icon.getIconHeight() * icon.getIconWidth() > width * height) {
                int h1;
                int w = width;
                int h = height;
                int w1 = icon.getIconWidth();
                if (w1 / w > (h1 = icon.getIconHeight()) / h) {
                    height = h1 * w / w1;
                } else {
                    width = w1 * h / h1;
                }
                bi = bi.getScaledInstance(width, height, 2);
                BufferedImage mBufferedImage = new BufferedImage(width, height, 1);
                Graphics2D g2 = mBufferedImage.createGraphics();
                g2.drawImage(bi, 0, 0, width, height, Color.WHITE, null);
                g2.dispose();
                ImageIO.write((RenderedImage)mBufferedImage, "jpg", bos);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return bos.toByteArray();
    }

    private static class ImageEncoderService
    implements Runnable {
        private int width;
        private int height;
        private boolean isZip;
        private String personId;
        private byte[] fileContent;
        private ConcurrentMap<String, String> resultMap;

        public ImageEncoderService(int width, int height, String personId, byte[] fileContent, ConcurrentMap<String, String> resultMap, boolean isZip) {
            this.width = width;
            this.height = height;
            this.isZip = isZip;
            this.personId = personId;
            this.fileContent = fileContent;
            this.resultMap = resultMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.width != 0 || this.height != 0) {
                this.fileContent = PhotoUtils.compressImg(this.fileContent, this.width, this.height);
            }
            if (this.isZip) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                GZIPOutputStream gzip = null;
                try {
                    gzip = new GZIPOutputStream(out);
                    gzip.write(this.fileContent);
                }
                catch (IOException e) {
                    logger.error("IOException: ", (Throwable)e);
                }
                finally {
                    if (gzip != null) {
                        try {
                            gzip.close();
                        }
                        catch (IOException e) {
                            logger.error("IOException: ", (Throwable)e);
                        }
                    }
                }
                this.fileContent = out.toByteArray();
            }
            this.resultMap.put(this.personId, Base64.encodeBase64String((byte[])this.fileContent));
        }
    }
}

