/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.IHierarchy;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.IPositionHierarchy;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.IEmpPosOrgRelation;
import com.kingdee.util.DateTimeUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ProcessorUtils {
    private static Logger logger = LoggerFactory.getLogger(ProcessorUtils.class);

    public static PersonCollection getSupervisor(Context ctx, String position, String hierarchyId) {
        try {
            PersonCollection personColl = new PersonCollection();
            IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
            IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
            PositionHierarchyCollection positionHierColl = null;
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarInfo.getId().toString(), position, false));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarchyId, position, false));
            }
            personColl.addCollection(ProcessorUtils.getPersonCOllByPM(ctx, positionHierColl, false));
            return personColl;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static PersonCollection getPrimarySubordinate(Context ctx, String position, String hierarchyId) {
        try {
            PersonCollection personColl = new PersonCollection();
            IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
            IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
            PositionHierarchyCollection positionHierColl = null;
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarInfo.getId().toString(), position, true));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarchyId, position, true));
            }
            personColl.addCollection(ProcessorUtils.getPersonCOllByPM(ctx, positionHierColl, true));
            return personColl;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static PositionMemberCollection getPrimarySubordinatePositionMember(Context ctx, String position, String hierarchyId) {
        try {
            PersonCollection personColl = new PersonCollection();
            IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
            IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
            PositionHierarchyCollection positionHierColl = null;
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarInfo.getId().toString(), position, true));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarchyId, position, true));
            }
            return ProcessorUtils.getPositionMemberCollByPositionHier(ctx, positionHierColl, true);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static String getSupervisorPosition(Context ctx, String position, String hierarchyId) {
        try {
            IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
            IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
            PositionHierarchyCollection positionHierColl = null;
            PositionInfo positionInfo = null;
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarInfo.getId().toString(), position, false));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarchyId, position, false));
            }
            if (null != positionHierColl && positionHierColl.size() > 0 && null != (positionInfo = positionHierColl.get(0).getParent())) {
                return positionInfo.getId().toString();
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return null;
    }

    public static String getIndirectSuperiorPosition(Context ctx, String position, String hierarchyId) {
        String supervisorPos = ProcessorUtils.getSupervisorPosition(ctx, position, hierarchyId);
        String indirectSuperiorPos = ProcessorUtils.getSupervisorPosition(ctx, supervisorPos, null);
        return indirectSuperiorPos;
    }

    public static String getPrimarySubordinatePosition(Context ctx, String position, String hierarchyId) {
        try {
            IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
            IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
            PositionHierarchyCollection positionHierColl = null;
            PositionInfo positionInfo = null;
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarInfo.getId().toString(), position, true));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarchyId, position, true));
            }
            if (null != positionHierColl && positionHierColl.size() > 0) {
                positionInfo = positionHierColl.get(0).getChild();
            }
            if (positionInfo != null) {
                return positionInfo.getId().toString();
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return null;
    }

    private static EntityViewInfo getPHEntityViewInfo(String hierarchyId, String positionId, boolean isParent) {
        FilterItemInfo filterItem;
        FilterInfo filter = new FilterInfo();
        if (!isParent) {
            filterItem = new FilterItemInfo("child.id", (Object)positionId.toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("parent.id", (Object)positionId.toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        FilterItemInfo filterItemHier = new FilterItemInfo("hierarchy.id", (Object)hierarchyId.toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItemHier);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        if (!isParent) {
            viewInfo.getSelector().add(new SelectorItemInfo("parent.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("parent.name"));
        } else {
            viewInfo.getSelector().add(new SelectorItemInfo("child.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("child.name"));
        }
        return viewInfo;
    }

    private static EntityViewInfo getPHEntityViewInfo(String hierarchyId, Set<String> positionIds, boolean isParent) {
        FilterItemInfo filterItem;
        FilterInfo filter = new FilterInfo();
        if (!isParent) {
            filterItem = new FilterItemInfo("child.id", positionIds, CompareType.INCLUDE);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("parent.id", positionIds, CompareType.INCLUDE);
            filter.getFilterItems().add(filterItem);
        }
        FilterItemInfo filterItemHier = new FilterItemInfo("hierarchy.id", (Object)hierarchyId.toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItemHier);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        if (!isParent) {
            viewInfo.getSelector().add(new SelectorItemInfo("parent.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("parent.name"));
        } else {
            viewInfo.getSelector().add(new SelectorItemInfo("child.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("child.name"));
        }
        return viewInfo;
    }

    private static PersonCollection getPersonCOllByPM(Context ctx, PositionHierarchyCollection positionHierColl, boolean isFindByParent) throws BOSException {
        PersonCollection personColl = new PersonCollection();
        PositionInfo positionInfo = null;
        IPositionMember iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        for (int k = 0; k < positionHierColl.size(); ++k) {
            positionInfo = !isFindByParent ? positionHierColl.get(k).getParent() : positionHierColl.get(k).getChild();
            PositionMemberCollection superPMColl = iPosiMember.getPositionMemberCollection(ProcessorUtils.getOtherPMEntityViewInfo(positionInfo));
            for (int j = 0; j < superPMColl.size(); ++j) {
                personColl.add(superPMColl.get(j).getPerson());
            }
        }
        return personColl;
    }

    private static EntityViewInfo getOtherPMEntityViewInfo(PositionInfo positionInfo) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("position.id", (Object)positionInfo.getId().toString().trim());
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.number"));
        return viewInfo;
    }

    private static EntityViewInfo getOtherEmpPosRelEntityViewInfo(PositionInfo positionInfo) {
        FilterInfo filter = new FilterInfo();
        String time = "2199-12-31 00:00:00";
        Date date = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = formatter.parse(time);
        }
        catch (ParseException e) {
            logger.error("ParseException: ", (Throwable)e);
        }
        filter.getFilterItems().add(new FilterItemInfo("Position.id", (Object)positionInfo.getId().toString().trim()));
        filter.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)date));
        filter.getFilterItems().add(new FilterItemInfo("person.employeeType.isInCount", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.employeeType.isOnTheStrength", (Object)1, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.number"));
        return viewInfo;
    }

    public static String getPrimaryPosition(Context ctx, String person) {
        try {
            IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
            PositionMemberCollection positionMemberColl = iPositionMember.getPositionMemberCollection(" where person='" + person + "' and isPrimary=1");
            if (null != positionMemberColl && positionMemberColl.size() > 0) {
                return positionMemberColl.get(0).getPosition().getId().toString();
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return null;
    }

    public static PersonCollection getPersonCollByPosition(Context ctx, String position) {
        PersonCollection personColl = new PersonCollection();
        try {
            IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
            PositionCollection positionColl = iPosition.getPositionCollection(" where id='" + position + "'");
            if (null != positionColl && positionColl.size() > 0) {
                IEmpPosOrgRelation iPosiMember = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx);
                EmpPosOrgRelationCollection superPMColl = iPosiMember.getEmpPosOrgRelationCollection(ProcessorUtils.getOtherEmpPosRelEntityViewInfo(positionColl.get(0)));
                for (int j = 0; j < superPMColl.size(); ++j) {
                    personColl.add(superPMColl.get(j).getPerson());
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return personColl;
    }

    public static PersonCollection getPersonCollByPositionForEvaluation(Context ctx, String position) {
        PersonCollection personColl = new PersonCollection();
        try {
            IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
            PositionCollection positionColl = iPosition.getPositionCollection(" where id='" + position + "'");
            if (null != positionColl && positionColl.size() > 0) {
                IEmpPosOrgRelation iPosiMember = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx);
                EmpPosOrgRelationCollection superPMColl = iPosiMember.getEmpPosOrgRelationCollection(ProcessorUtils.getOtherEmpPosRelEntityViewInfoForEvaluation(positionColl.get(0)));
                for (int j = 0; j < superPMColl.size(); ++j) {
                    personColl.add(superPMColl.get(j).getPerson());
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return personColl;
    }

    public static PositionMemberCollection getPositionMemberCollByPositions(Context ctx, Set<String> positions) {
        PositionMemberCollection personColl = new PositionMemberCollection();
        try {
            IEmpPosOrgRelation iEmpPosOrgRelation = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx);
            EmpPosOrgRelationCollection coll = iEmpPosOrgRelation.getEmpPosOrgRelationCollection(ProcessorUtils.getOtherEmpPosRelEntityViewInfoForEvaluation(positions));
            if (coll != null && !coll.isEmpty()) {
                for (EmpPosOrgRelationInfo info : coll) {
                    PositionMemberInfo memberInfo = new PositionMemberInfo();
                    memberInfo.setPerson(info.getPerson());
                    memberInfo.setPosition(info.getPosition());
                    personColl.add(memberInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error("getPositionMemberCollByPositions by positions err: ", (Throwable)e);
        }
        return personColl;
    }

    public static PositionMemberCollection getSupervisorForEvaluation(Context ctx, String position, String hierarchyId) {
        try {
            IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
            IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
            PositionHierarchyCollection positionHierColl = null;
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarInfo.getId().toString(), position, false));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarchyId, position, false));
            }
            return ProcessorUtils.getPositionMemberCollByPositionHier(ctx, positionHierColl, false);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static PositionMemberCollection getColleagueBySupervisorForEvaluation(Context ctx, String position, String hierarchyId) {
        try {
            IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
            IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
            PositionHierarchyCollection positionHierColl = null;
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarInfo.getId().toString(), position, false));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarchyId, position, false));
            }
            return ProcessorUtils.getPositionMemberCollByPositionHier(ctx, positionHierColl, true);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static PositionMemberCollection getOrgColleagueBySupervisorForEvaluation(Context ctx, String position) {
        try {
            String supervisorPosition = ProcessorUtils.getSupervisorPosition(ctx, position, null);
            return ProcessorUtils.getPrimarySubordinatePositionMember(ctx, supervisorPosition, null);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static PositionMemberCollection getColleagueBySupervisorForEvaluation(Context ctx, Set<String> positions, String hierarchyId) {
        try {
            IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
            IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
            PositionHierarchyCollection positionHierColl = null;
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarInfo.getId().toString(), positions, false));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarchyId, positions, false));
            }
            PositionMemberCollection members = ProcessorUtils.getPositionMemberCollByPositionHier(ctx, positionHierColl, false);
            if (members == null || members.size() == 0) {
                return null;
            }
            HashSet<String> parentPositionIds = new HashSet<String>();
            int memberSize = members.size();
            for (int i = 0; i < memberSize; ++i) {
                PositionMemberInfo positionMemberInfo = members.get(i);
                if (positionMemberInfo.getPosition() == null) continue;
                parentPositionIds.add(positionMemberInfo.getPosition().getId().toString());
            }
            if (!CollectionUtils.isEmpty(parentPositionIds)) {
                return ProcessorUtils.getPrimarySubordinateForEvaluation(ctx, parentPositionIds, null);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return null;
    }

    public static Map<String, List<PositionMemberInfo>> getSupervisorForEvaluation(Context ctx, Set<String> position) {
        HashMap<String, List<PositionMemberInfo>> resultMap = new HashMap<String, List<PositionMemberInfo>>();
        try {
            PositionMemberCollection members;
            IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
            IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
            HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
            PositionHierarchyCollection hierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarInfo.getId().toString(), position, false));
            if (hierColl != null && (members = ProcessorUtils.getPositionMemberCollByPositionHier(ctx, hierColl, false)) != null) {
                HashMap<String, ArrayList<PositionMemberInfo>> memberMap = new HashMap<String, ArrayList<PositionMemberInfo>>();
                for (PositionMemberInfo memberInfo : members) {
                    String positionId = memberInfo.getPosition().getId().toString();
                    ArrayList<PositionMemberInfo> list = (ArrayList<PositionMemberInfo>)memberMap.get(positionId);
                    if (list == null) {
                        list = new ArrayList<PositionMemberInfo>();
                    }
                    list.add(memberInfo);
                    memberMap.put(positionId, list);
                }
                for (PositionHierarchyInfo hierarchyInfo : hierColl) {
                    String currentPositionId = hierarchyInfo.getChild().getId().toString();
                    ArrayList values = (ArrayList)resultMap.get(currentPositionId);
                    if (values == null) {
                        values = new ArrayList();
                    }
                    resultMap.get(currentPositionId);
                    String parentPositionId = hierarchyInfo.getParent().getId().toString();
                    if (memberMap.containsKey(parentPositionId)) {
                        values.addAll((Collection)memberMap.get(parentPositionId));
                    }
                    if (values == null) continue;
                    resultMap.put(currentPositionId, values);
                }
            }
        }
        catch (Exception e) {
            logger.error("getSupervisorForEvaluation err: ", (Throwable)e);
        }
        return resultMap;
    }

    public static PositionMemberCollection getSupervisorForEvaluation(Context ctx, Set<String> position, String hierarchyId) {
        try {
            IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
            IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
            PositionHierarchyCollection positionHierColl = null;
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarInfo.getId().toString(), position, false));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarchyId, position, false));
            }
            return ProcessorUtils.getPositionMemberCollByPositionHier(ctx, positionHierColl, false);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static PositionMemberCollection getIndirectSuperiorForEvaluation(Context ctx, String position, String hierarchyId) {
        PositionMemberCollection coll = ProcessorUtils.getSupervisorForEvaluation(ctx, position, null);
        if (coll != null && coll.size() > 0) {
            HashSet<String> supervisorPos = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                supervisorPos.add(coll.get(i).getPosition().getId().toString());
            }
            return ProcessorUtils.getSupervisorForEvaluation(ctx, supervisorPos, null);
        }
        return null;
    }

    public static PositionMemberCollection getIndirectSuperiorForEvaluation(Context ctx, Set<String> positions, String hierarchyId) {
        PositionMemberCollection coll = ProcessorUtils.getSupervisorForEvaluation(ctx, positions, null);
        if (coll != null && coll.size() > 0) {
            HashSet<String> supervisorPos = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                supervisorPos.add(coll.get(i).getPosition().getId().toString());
            }
            return ProcessorUtils.getSupervisorForEvaluation(ctx, supervisorPos, null);
        }
        return null;
    }

    public static PositionMemberCollection getPrimarySubordinateForEvaluation(Context ctx, String position, String hierarchyId) {
        try {
            IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
            IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
            PositionHierarchyCollection positionHierColl = null;
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarInfo.getId().toString(), position, true));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarchyId, position, true));
            }
            return ProcessorUtils.getPositionMemberCollByPositionHier(ctx, positionHierColl, true);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static PositionMemberCollection getPrimarySubordinateForEvaluation(Context ctx, Set<String> position, String hierarchyId) {
        try {
            IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
            IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
            PositionHierarchyCollection positionHierColl = null;
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarInfo.getId().toString(), position, true));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(ProcessorUtils.getPHEntityViewInfo(hierarchyId, position, true));
            }
            return ProcessorUtils.getPositionMemberCollByPositionHier(ctx, positionHierColl, true);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static PositionMemberCollection getIndirectSubordinateForEvaluation(Context ctx, String position, String hierarchyId) {
        PositionMemberCollection coll = ProcessorUtils.getPrimarySubordinateForEvaluation(ctx, position, null);
        if (coll != null && coll.size() > 0) {
            HashSet<String> subPos = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                subPos.add(coll.get(i).getPosition().getId().toString());
            }
            return ProcessorUtils.getPrimarySubordinateForEvaluation(ctx, subPos, null);
        }
        return null;
    }

    public static PositionMemberCollection getIndirectSubordinateForEvaluation(Context ctx, Set<String> positions, String hierarchyId) {
        PositionMemberCollection coll = ProcessorUtils.getPrimarySubordinateForEvaluation(ctx, positions, null);
        if (coll != null && coll.size() > 0) {
            HashSet<String> subPos = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                subPos.add(coll.get(i).getPosition().getId().toString());
            }
            return ProcessorUtils.getPrimarySubordinateForEvaluation(ctx, subPos, null);
        }
        return null;
    }

    private static EntityViewInfo getOtherEmpPosRelEntityViewInfoForEvaluation(PositionInfo positionInfo) {
        FilterInfo filter = new FilterInfo();
        Timestamp sysDate = DateUtil.getTime();
        filter.getFilterItems().add(new FilterItemInfo("Position.id", (Object)positionInfo.getId().toString().trim()));
        filter.getFilterItems().add(new FilterItemInfo("EFFDT", (Object)sysDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)sysDate, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("person.employeeType.isInCount", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.employeeType.isOnTheStrength", (Object)1, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.number"));
        return viewInfo;
    }

    private static EntityViewInfo getOtherEmpPosRelEntityViewInfoForEvaluation(Set<String> positions) {
        FilterInfo filter = new FilterInfo();
        Timestamp sysDate = DateUtil.getTime();
        filter.getFilterItems().add(new FilterItemInfo("Position.id", positions, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("EFFDT", (Object)sysDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)sysDate, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("person.employeeType.isInCount", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.employeeType.isOnTheStrength", (Object)1, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        return viewInfo;
    }

    private static PositionMemberCollection getPositionMemberCollByPositionHier(Context ctx, PositionHierarchyCollection positionHierColl, boolean isFindByParent) throws BOSException {
        HashSet<String> positionInfos = new HashSet<String>();
        for (int k = 0; k < positionHierColl.size(); ++k) {
            PositionHierarchyInfo hierarchyInfo = positionHierColl.get(k);
            if (!isFindByParent) {
                positionInfos.add(hierarchyInfo.getParent().getId().toString());
                continue;
            }
            positionInfos.add(hierarchyInfo.getChild().getId().toString());
        }
        return ProcessorUtils.getPositionMemberCollByPositions(ctx, positionInfos);
    }

    private static EntityViewInfo getOtherPMEntityViewInfo(Set<String> positionInfos) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("position.id", positionInfos, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("person.employeeType.isInCount", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.employeeType.isOnTheStrength", (Object)1, CompareType.EQUALS));
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)curDate, CompareType.LESS_EQUALS));
        filter.setMaskString("#0 and (#1 or #2) and #3");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        return viewInfo;
    }
}

