/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.IMultiEvaTask;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaTaskCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaTaskCombineTypeEnum;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaTaskFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaTaskInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaTaskStatusEnum;
import com.kingdee.shr.perfweb.app.quescloud.QuestionnaireInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.multiEvalution.commontask.utils.QuesServerInstance;
import com.kingdee.shr.perfweb.multiEvalution.quescloud.QuesCloudRequest;
import com.kingdee.shr.perfweb.multiEvalution.quescloud.result.QuesCloudResult;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuesCloudRequestUtil {
    private static Logger logger = LoggerFactory.getLogger(QuesCloudRequestUtil.class);

    public static List<QuestionnaireInfo> getQuestionnairesByIds(Context ctx, Set<String> ids) throws EASBizException {
        QuesCloudRequest request;
        QuesCloudResult result;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (ids != null && ids.size() > 0) {
            params.put("id", QuesCloudRequestUtil.joinStr(ids));
        }
        if ((result = (request = new QuesCloudRequest(ctx, "questionnairesByIds", params)).buildRequest().doPost()) != null && result.isSuccess() && result.getData() != null) {
            return JSONObject.parseArray((String)result.getData().toString(), QuestionnaireInfo.class);
        }
        return null;
    }

    public static Map<String, String> getEvaObjQuestionnaireCommitteds(Context ctx, Set<String> evaObjs) throws EASBizException {
        return QuesCloudRequestUtil.getEvaObjQuestionnaireCommitteds(ctx, evaObjs, false);
    }

    public static Map<String, String> getEvaObjQuestionnaireCommitteds(Context ctx, Set<String> evaObjs, boolean showPercent) throws EASBizException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (evaObjs != null && evaObjs.size() > 0) {
            try {
                IMultiEvaTask iMultiEvaTask = MultiEvaTaskFactory.getLocalInstance(ctx);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("businessId", evaObjs, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"4", CompareType.NOTEQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("isEffect", (Object)"1", CompareType.EQUALS));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filterInfo);
                HashMap<String, HashSet<String>> taskMap = new HashMap<String, HashSet<String>>();
                MultiEvaTaskCollection taskCollection = iMultiEvaTask.getMultiEvaTaskCollection(evi);
                HashSet<String> submittedSet = new HashSet<String>();
                if (taskCollection != null && taskCollection.size() > 0) {
                    StringBuffer allTaskIds = new StringBuffer();
                    for (int i = 0; i < taskCollection.size(); ++i) {
                        MultiEvaTaskInfo taskInfo = taskCollection.get(i);
                        HashSet<String> taskIds = (HashSet<String>)taskMap.get(taskInfo.getBusinessId());
                        if (taskIds == null) {
                            taskIds = new HashSet<String>();
                        }
                        taskIds.add(taskInfo.getId().toString());
                        taskMap.put(taskInfo.getBusinessId(), taskIds);
                        allTaskIds.append(taskInfo.getId().toString()).append(",");
                    }
                    if (allTaskIds.length() > 1) {
                        allTaskIds.setLength(allTaskIds.length() - 1);
                    }
                    if (allTaskIds.length() > 0) {
                        String submittedStr;
                        Map submitteds;
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("data", allTaskIds.toString());
                        long startTime = System.currentTimeMillis();
                        QuesCloudRequest request = new QuesCloudRequest(ctx, "quescloud/questionnaiere/isscored", params);
                        QuesCloudResult result = request.buildRequest().doPost();
                        long endTime = System.currentTimeMillis();
                        if (result != null && result.isSuccess() && (submitteds = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)result.getData()), Map.class)) != null && submitteds.get("data") != null && !org.apache.commons.lang.StringUtils.isEmpty((String)(submittedStr = (String)submitteds.get("data")))) {
                            submittedSet.addAll(Arrays.asList(submittedStr.split(",")));
                        }
                    }
                }
                for (Map.Entry entry : taskMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Set value = (Set)entry.getValue();
                    int totalSize = value.size();
                    value.removeAll(submittedSet);
                    int unsubmitted = value.size();
                    int submitted = totalSize - unsubmitted;
                    if (showPercent) {
                        String percent = "\uff08" + BigDecimal.valueOf(submitted).divide(BigDecimal.valueOf(totalSize), 2, 4).multiply(BigDecimal.valueOf(100L)) + "%\uff09";
                        resultMap.put(key, totalSize - unsubmitted + "/" + totalSize + percent);
                        continue;
                    }
                    resultMap.put(key, submitted + "/" + totalSize);
                }
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
                throw new SHRPerfWebBizException(SHRPerfWebBizException.REQQUESCLOUDSERVICEERR);
            }
        }
        return resultMap;
    }

    public static Set<String> getQuestionnaireCommitteds(Context ctx, Set<String> taskIds) throws EASBizException {
        HashSet<String> submittedSet = new HashSet<String>();
        if (taskIds != null && taskIds.size() > 0) {
            String submittedStr;
            Map submitteds;
            StringBuffer allTaskIds = new StringBuffer();
            for (String taskId : taskIds) {
                allTaskIds.append(taskId).append(",");
            }
            if (allTaskIds.length() > 1) {
                allTaskIds.setLength(allTaskIds.length() - 1);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("data", allTaskIds.toString());
            long startTime = System.currentTimeMillis();
            QuesCloudRequest request = new QuesCloudRequest(ctx, "quescloud/questionnaiere/isscored", params);
            QuesCloudResult result = request.buildRequest().doPost();
            long endTime = System.currentTimeMillis();
            if (result != null && result.isSuccess() && (submitteds = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)result.getData()), Map.class)) != null && submitteds.get("data") != null && !org.apache.commons.lang.StringUtils.isEmpty((String)(submittedStr = (String)submitteds.get("data")))) {
                submittedSet.addAll(Arrays.asList(submittedStr.split(",")));
            }
        }
        return submittedSet;
    }

    public static void invalidQuestionnaireLoginurl(Context ctx, Set<String> taskIds, boolean isCancel) throws EASBizException {
        if (taskIds != null && taskIds.size() > 0) {
            QuesCloudRequest request;
            QuesCloudResult result;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("data", QuesCloudRequestUtil.joinStr(taskIds));
            if (isCancel) {
                params.put("opType", "CANCLE");
            }
            if ((result = (request = new QuesCloudRequest(ctx, "quescloud/invalidateloginurl", params)).buildRequest().doPost()) == null || !result.isSuccess()) {
                logger.error("", (Object)result);
                throw new SHRPerfWebBizException(SHRPerfWebBizException.REQQUESCLOUDINVALIDLOGINURLERR);
            }
        }
    }

    public static Map<String, String> getTaskStatus(Context ctx, Set<String> taskIds) throws EASBizException {
        Map resData = null;
        if (taskIds != null && taskIds.size() > 0) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("data", QuesCloudRequestUtil.joinStr(taskIds));
            QuesCloudRequest request = new QuesCloudRequest(ctx, "quescloud/questionnaiere/gettaskstatus", params);
            QuesCloudResult result = request.buildRequest().doPost();
            if (result == null || !result.isSuccess()) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.QUERYQUESCLOUDTASKSTATEERR);
            }
            resData = (Map)JSONObject.parseObject((String)result.getData().toString(), Map.class);
        }
        return resData;
    }

    public static Map<String, String> getSubmittedTaskTime(Context ctx, Set<String> taskIds) throws EASBizException {
        Map resData = null;
        if (taskIds != null && taskIds.size() > 0) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("data", QuesCloudRequestUtil.joinStr(taskIds));
            QuesCloudRequest request = new QuesCloudRequest(ctx, "quescloud/questionnaiere/getsubmittime", params);
            QuesCloudResult result = request.buildRequest().doPost();
            if (result == null || !result.isSuccess()) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.REQQUESCLOUDSUBMITEEDTASKERR);
            }
            resData = (Map)JSONObject.parseObject((String)result.getData().toString(), Map.class);
        }
        return resData;
    }

    public static Map<String, Object> getAvailiableSite(Context ctx, final String serviceId) throws EASBizException {
        QuesCloudRequest request = new QuesCloudRequest(ctx, "ctrl/site"){

            @Override
            protected String getServiceRequestURL(Integer page, Integer rows, Map<String, Object> params) {
                if (params.containsKey("eid")) {
                    try {
                        return this.url + "/" + params.get("eid") + "/7?nonce=" + URLEncoder.encode(serviceId, "UTF8");
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.error("UnsupportedEncodingException: ", (Throwable)e);
                    }
                }
                return this.url;
            }
        };
        QuesCloudResult result = request.buildRequest("2").doGet();
        if (result == null || !result.isSuccess()) {
            if (result != null && "404".equals(result.getCode())) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.REQCLOUDSERVICEERR);
            }
            throw new SHRPerfWebBizException(SHRPerfWebBizException.REQQUESCLOUDREMAINPOINTSERR);
        }
        if (result != null && result.getData() == null) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.CLOUDSERVICERETURNERR, new Object[]{String.valueOf(result.getErrorMessage())});
        }
        Map resultMap = (Map)JSONObject.parseObject((String)result.getData().toString(), Map.class);
        if (String.valueOf(resultMap.get("strategyType")).equals("1")) {
            resultMap.put("availableSite", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.UNLIMITEDSITE, ctx));
        }
        return resultMap;
    }

    private static String joinStr(Set<String> taskIds) {
        return QuesCloudRequestUtil.joinStr(taskIds, ",");
    }

    private static String joinStr(Set<String> taskIds, String joinStr) {
        StringBuffer sb = new StringBuffer();
        if (taskIds != null && taskIds.size() > 0) {
            for (String taskId : taskIds) {
                sb.append(taskId).append(joinStr);
            }
            if (sb.length() > 1) {
                sb.setLength(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    public static String mergeShortUrl(Context ctx, String shortUrl) throws EASBizException {
        Map<String, String> quesCloudConfig;
        try {
            quesCloudConfig = QuesServerInstance.getServerInfo(ctx);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.GETQUESCLOUDSERVERCONFIGERR);
        }
        String baseUrl = quesCloudConfig.get(QuesServerInstance.CLOUD_SERVERURL);
        if (StringUtils.isEmpty((String)baseUrl)) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.QUESCLOUDSERVERCONFIGREQUIRED);
        }
        String avoidLoginUrl = baseUrl + "avoidlogin?shorturl=$1&from=PERFWEB";
        try {
            avoidLoginUrl = avoidLoginUrl.replace("$1", URLEncoder.encode(shortUrl, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("get quescloud short url err, e={}", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.GETQUESCLOUDLOGINURLERR);
        }
        return avoidLoginUrl;
    }

    public static String mergeTaskUrl(String baseUrl, String shortUrl) throws EASBizException {
        String url = baseUrl + "avoidlogin?shorturl=$1&from=PERFWEB";
        try {
            url = url.replace("$1", URLEncoder.encode(shortUrl, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("get quescloud short url err, e={}", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.GETQUESCLOUDLOGINURLERR);
        }
        return url;
    }

    public static void formatMutiassessmentDealtData(Context ctx, List rows) {
        List data = rows;
        HashSet<String> batchTaskIds = new HashSet<String>();
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            Map record = (Map)data.get(i);
            String batchTaskId = (String)record.get("batchTaskId");
            record.put("id", batchTaskId);
            batchTaskIds.add(batchTaskId);
        }
        MultiEvaTaskCollection tasks = QuesCloudRequestUtil.getMultiEvaTasks(ctx, batchTaskIds);
        HashMap<String, Integer> todoCountMap = new HashMap<String, Integer>();
        HashMap<String, Integer> submmitMap = new HashMap<String, Integer>();
        HashMap<String, String> shortUrlMap = new HashMap<String, String>();
        HashMap<String, AdminOrgUnitInfo> companyMap = new HashMap<String, AdminOrgUnitInfo>();
        HashMap<String, AdminOrgUnitInfo> departmentMap = new HashMap<String, AdminOrgUnitInfo>();
        HashMap<String, String> relationMap = new HashMap<String, String>();
        if (tasks != null && !tasks.isEmpty()) {
            Integer count;
            Iterator it = tasks.iterator();
            while (it.hasNext()) {
                String shortUrl;
                Integer n;
                Integer n2;
                AdminOrgUnitInfo adminOrgUnitInfo;
                MultiEvaTaskInfo taskInfo = (MultiEvaTaskInfo)it.next();
                String batchTaskId = taskInfo.getBatchTaskId();
                MultiEvaTaskCombineTypeEnum combineTypeEnum = taskInfo.getCombineType();
                if (MultiEvaTaskCombineTypeEnum.DEFAULT.equals((Object)combineTypeEnum) || MultiEvaTaskCombineTypeEnum.RELATIONANDCOMPANY.equals((Object)combineTypeEnum) || MultiEvaTaskCombineTypeEnum.RELATIONANDDEPARTMENT.equals((Object)combineTypeEnum)) {
                    relationMap.put(batchTaskId, taskInfo.getMultiPerfRelationReport().getRelationDetail().getEvaluationPersonName());
                }
                if (MultiEvaTaskCombineTypeEnum.COMPANY.equals((Object)combineTypeEnum) || MultiEvaTaskCombineTypeEnum.RELATIONANDCOMPANY.equals((Object)combineTypeEnum)) {
                    adminOrgUnitInfo = taskInfo.getMultiPerfRelationReport().getPerfEvaObj().getAdminOrgUnit();
                    companyMap.put(batchTaskId, adminOrgUnitInfo.getCompany());
                } else if (MultiEvaTaskCombineTypeEnum.DEPARTMENT.equals((Object)combineTypeEnum) || MultiEvaTaskCombineTypeEnum.RELATIONANDDEPARTMENT.equals((Object)combineTypeEnum)) {
                    adminOrgUnitInfo = taskInfo.getMultiPerfRelationReport().getPerfEvaObj().getAdminOrgUnit();
                    companyMap.put(batchTaskId, adminOrgUnitInfo.getCompany());
                    departmentMap.put(batchTaskId, adminOrgUnitInfo.getDepartment());
                }
                if (MultiEvaTaskStatusEnum.AWAIT_SUBMIT.equals((Object)taskInfo.getStatus())) {
                    count = (Integer)todoCountMap.get(batchTaskId);
                    if (count == null) {
                        count = 0;
                    }
                    n2 = count;
                    n = count = Integer.valueOf(count + 1);
                    todoCountMap.put(batchTaskId, count);
                } else if (MultiEvaTaskStatusEnum.SUBMITTED.equals((Object)taskInfo.getStatus())) {
                    count = (Integer)submmitMap.get(batchTaskId);
                    if (count == null) {
                        count = 0;
                    }
                    n2 = count;
                    n = count = Integer.valueOf(count + 1);
                    submmitMap.put(batchTaskId, count);
                }
                if (StringUtils.isEmpty((String)(shortUrl = taskInfo.getCombineShortUrl()))) continue;
                shortUrlMap.put(batchTaskId, shortUrl);
            }
            int size2 = data.size();
            for (int i = 0; i < size2; ++i) {
                String relationName;
                AdminOrgUnitInfo departmentInfo;
                AdminOrgUnitInfo companyInfo;
                Map record = (Map)data.get(i);
                String batchTaskId = (String)record.get("batchTaskId");
                count = (Integer)todoCountMap.get(batchTaskId);
                if (count == null) {
                    count = 0;
                }
                record.put("perfEvaObj.count", count);
                Integer submitCount = (Integer)submmitMap.get(batchTaskId);
                if (submitCount == null) {
                    submitCount = 0;
                }
                record.put("perfEvaObj.submits", submitCount);
                String combineShortUrl = (String)shortUrlMap.get(batchTaskId);
                if (!StringUtils.isEmpty((String)combineShortUrl)) {
                    try {
                        record.put("combineShortUrl", QuesCloudRequestUtil.mergeShortUrl(ctx, combineShortUrl));
                    }
                    catch (EASBizException e) {
                        logger.error("merge shortUrl err", (Throwable)e);
                    }
                }
                if ((companyInfo = (AdminOrgUnitInfo)companyMap.get(batchTaskId)) != null) {
                    record.put("company.id", companyInfo.getId().toString());
                    record.put("company.name", companyInfo.getName(ctx.getLocale()));
                }
                if ((departmentInfo = (AdminOrgUnitInfo)departmentMap.get(batchTaskId)) != null) {
                    record.put("department.id", departmentInfo.getId().toString());
                    record.put("department.name", departmentInfo.getName(ctx.getLocale()));
                }
                if (StringUtils.isEmpty((String)(relationName = (String)relationMap.get(batchTaskId)))) continue;
                record.put("relationDetail.evaluationPersonName", relationName);
            }
        }
    }

    public static MultiEvaTaskCollection getMultiEvaTasks(Context ctx, Set<String> batchTaskIds) {
        HashSet<String> status = new HashSet<String>();
        status.add("1");
        status.add("3");
        HashSet<String> paperStatus = new HashSet<String>();
        paperStatus.add("200");
        paperStatus.add("600");
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("receiver", (Object)HRFilterUtils.getCurrentPersonId((Context)ctx)));
        filterItems.add(new FilterItemInfo("status", status, CompareType.INCLUDE));
        filterItems.add(new FilterItemInfo("isEffect", (Object)1, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("multiPerfRelationReport.perfEvaObj.paperStatus", paperStatus, CompareType.INCLUDE));
        filterItems.add(new FilterItemInfo("batchTaskId", batchTaskIds, CompareType.INCLUDE));
        try {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("status"));
            selectors.add(new SelectorItemInfo("batchTaskId"));
            selectors.add(new SelectorItemInfo("questionnaier"));
            selectors.add(new SelectorItemInfo("questionnaierVersion"));
            selectors.add(new SelectorItemInfo("multiPerfRelationReport.relationDetail.id"));
            selectors.add(new SelectorItemInfo("multiPerfRelationReport.relationDetail.evaluationPersonName"));
            selectors.add(new SelectorItemInfo("multiPerfRelationReport.perfEvaObj.multiPeriod.id"));
            selectors.add(new SelectorItemInfo("combineShortUrl"));
            selectors.add(new SelectorItemInfo("multiPerfRelationReport.perfEvaObj.adminOrgUnit.id"));
            selectors.add(new SelectorItemInfo("multiPerfRelationReport.perfEvaObj.adminOrgUnit.company.id"));
            selectors.add(new SelectorItemInfo("multiPerfRelationReport.perfEvaObj.adminOrgUnit.company.name"));
            selectors.add(new SelectorItemInfo("multiPerfRelationReport.perfEvaObj.adminOrgUnit.department.id"));
            selectors.add(new SelectorItemInfo("multiPerfRelationReport.perfEvaObj.adminOrgUnit.department.name"));
            selectors.add(new SelectorItemInfo("combineType"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            evi.setSelector(selectors);
            MultiEvaTaskCollection multiEvaTaskCollection = MultiEvaTaskFactory.getLocalInstance(ctx).getMultiEvaTaskCollection(evi);
            return multiEvaTaskCollection;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            logger.error("query multiEvaTask err: ", (Throwable)e);
            return null;
        }
    }

    public static String getBaseUrl(Context ctx) throws EASBizException {
        Map<String, String> quesCloudConfig;
        try {
            quesCloudConfig = QuesServerInstance.getServerInfo(ctx);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.GETQUESCLOUDSERVERCONFIGERR);
        }
        String baseUrl = quesCloudConfig.get(QuesServerInstance.CLOUD_SERVERURL);
        if (StringUtils.isEmpty((String)baseUrl)) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.QUESCLOUDSERVERCONFIGREQUIRED);
        }
        return baseUrl;
    }

    public static String getCombineShortUrl(Context ctx, String taskId) throws EASBizException {
        String url = "quescloud/questionnaier/getCombineShortUrl?taskId=" + taskId;
        QuesCloudRequest request = new QuesCloudRequest(ctx, url);
        QuesCloudResult result = request.buildRequest().doGet();
        if (result != null && result.isSuccess() && result.getData() != null) {
            Map resultMap = (Map)JSONObject.parseObject((String)result.getData().toString(), Map.class);
            return (String)resultMap.get("shortUrl");
        }
        return null;
    }

    public static Map<String, String> getCombineShortUrl(Context ctx, Set<String> taskIds) throws EASBizException {
        String url = "quescloud/questionnaier/getCombineShortUrl?taskId=" + org.apache.commons.lang3.StringUtils.join(taskIds, (String)",");
        QuesCloudRequest request = new QuesCloudRequest(ctx, url);
        QuesCloudResult result = request.buildRequest().doGet();
        if (result != null && result.isSuccess() && result.getData() != null) {
            Map resultMap = (Map)JSONObject.parseObject((String)result.getData().toString(), Map.class);
            return (Map)resultMap.get("shortUrl");
        }
        return null;
    }

    public static void resetEvalute(Context ctx, Set<String> taskIds) throws EASBizException {
        if (taskIds != null && taskIds.size() > 0) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("data", QuesCloudRequestUtil.joinStr(taskIds));
            QuesCloudRequest request = new QuesCloudRequest(ctx, "quescloud/resetEvalute", params);
            QuesCloudResult result = request.buildRequest().doPost();
            if (result == null || !result.isSuccess()) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.QUESCLOUDRESETEVALUATEERR, new Object[]{result != null ? result.getErrorMessage() : ""});
            }
        }
    }
}

