/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.workflow.serviceImpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EmailSendFacadeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IEmailSendFacade;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjRelationObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjRelationObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjRelationObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IWFNodeDef;
import com.kingdee.shr.perfweb.app.base.evalrule.PWFLevelDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PWFLevelDefInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefInfo;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.workflow.AsignmentPoolInfo;
import com.kingdee.shr.perfweb.app.workflow.CanEditEnum;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstInfo;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.app.workflow.IGradeTargetInst;
import com.kingdee.shr.perfweb.app.workflow.IGradeTaskNodeInst;
import com.kingdee.shr.perfweb.app.workflow.IWholeComment;
import com.kingdee.shr.perfweb.app.workflow.IsEffectiveEnum;
import com.kingdee.shr.perfweb.app.workflow.IsVisibleEnum;
import com.kingdee.shr.perfweb.app.workflow.PerfWorkFlowFacadeControllerBean;
import com.kingdee.shr.perfweb.app.workflow.ScoreStatusEnum;
import com.kingdee.shr.perfweb.app.workflow.TaskStatusEnum;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentCollection;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentFactory;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentInfo;
import com.kingdee.shr.perfweb.bizmanage.utils.GetBizManageEntityUtils;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PersonInchargeUtils;
import com.kingdee.shr.perfweb.util.ServerResponseConst;
import com.kingdee.shr.perfweb.util.WorkFlowUtils;
import com.kingdee.shr.perfweb.utils.CurrentUserUtil;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.shr.perfweb.utils.PerfDateUtils;
import com.kingdee.shr.perfweb.utils.PerfWorkFlowUtils;
import com.kingdee.shr.perfweb.utils.ProcessorUtils;
import com.kingdee.shr.perfweb.workflow.service.PerfWorkFlowService;
import com.kingdee.shr.perfweb.workflowext.CustomerPerfwebWorkFlowFactory;
import com.kingdee.shr.perfweb.workflowext.ICustomerPerfwebWorkFlow;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class WorkFlowEngine
implements PerfWorkFlowService {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.workflow.serviceImpl.WorkFlowEngine");

    private WorkFlowEngine() {
    }

    public static WorkFlowEngine getInstance() {
        return WorkFlowEngineInst.instance;
    }

    @Override
    public String createAsignmentPool(Context ctx, String evaObj, String period) {
        String result = ServerResponseConst.FAILED;
        try {
            result = PerfWorkFlowFacadeControllerBean.getInstance().createAsignmentPool(ctx, evaObj, period, "0");
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return result;
    }

    @Override
    public void createAreaInst(Context ctx, String gradeNodeInst, String evaObj) throws BOSException {
        new PerfWorkFlowFacadeControllerBean().createAreaInst(ctx, gradeNodeInst, evaObj, null);
    }

    @Override
    public void createTargetInst(Context ctx, String gradeTaskNode, String evaObj, String workFlow) throws BOSException {
        new PerfWorkFlowFacadeControllerBean().createTargetInst(ctx, gradeTaskNode, evaObj, workFlow);
    }

    @Override
    public Map<String, PersonCollection> getDirectSuperior(Context ctx, Set<?> personIdSet) {
        Map map = WorkFlowUtils.getSupervisor(ctx, personIdSet, false);
        return map;
    }

    @Override
    public PersonCollection getIndirectSuperior(Context ctx, String person) {
        return WorkFlowUtils.getIndirectorSuperior(ctx, person);
    }

    @Override
    public List<Map<String, String>> getNodeHandler(Context ctx, String evaObj, String position, String nodeId) {
        List<Map<String, String>> hanlerList = new ArrayList<Map<String, String>>();
        try {
            IWFNodeDef iwfNode;
            WFNodeDefCollection wfnodeDefColl;
            IPerfEvaObject iPerfEvaObj = PerfEvaObjectFactory.getLocalInstance(ctx);
            IPerson iperson = PersonFactory.getLocalInstance((Context)ctx);
            PerfEvaObjectCollection perfEvaObjColl = iPerfEvaObj.getPerfEvaObjectCollection("select *,evaluOrgAdmin.id,evaluOrgAdmin.responPosition.id where id='" + evaObj + "'");
            PerfEvaObjectInfo evaObjInfo = new PerfEvaObjectInfo();
            if (perfEvaObjColl != null && perfEvaObjColl.size() > 0) {
                evaObjInfo = perfEvaObjColl.get(0);
            }
            boolean isOrg = OrgAssessmentUtils.isOrgAssessment(evaObjInfo);
            String person = null;
            String positionId = null;
            if (isOrg) {
                person = "ORG";
                if (evaObjInfo.getEvaluOrgAdmin() != null && evaObjInfo.getEvaluOrgAdmin().getResponPosition() != null) {
                    positionId = evaObjInfo.getEvaluOrgAdmin().getResponPosition().getId().toString();
                }
            } else {
                PerfFileInfo perfFileInfo = GetBizManageEntityUtils.getPerfFileInfo(ctx, evaObjInfo.getPerfFile().getId().toString());
                if (perfFileInfo != null) {
                    person = perfFileInfo.getPerson().getId().toString();
                    positionId = perfFileInfo.getPosition().getId().toString();
                }
            }
            if ((wfnodeDefColl = (iwfNode = WFNodeDefFactory.getLocalInstance(ctx)).getWFNodeDefCollection("where id='" + nodeId + "'")) != null && wfnodeDefColl.size() > 0) {
                WFNodeDefInfo nodeInfo = wfnodeDefColl.get(0);
                String handleType = nodeInfo.getHandleType().getValue();
                String nodeHandler = nodeInfo.getNodeHandler();
                if (handleType.equals("0")) {
                    if (nodeHandler.equals("100") || nodeHandler.equals("700")) {
                        if (isOrg) {
                            List<Map<String, String>> orgResponser = OrgAssessmentUtils.getOrgResponserByEvaObject(ctx, evaObj);
                            if (null != orgResponser) {
                                for (Map<String, String> responser : orgResponser) {
                                    HashMap<String, String> handlerMap = new HashMap<String, String>();
                                    handlerMap.put("person", responser.get("person"));
                                    handlerMap.put("personName", responser.get("personName"));
                                    handlerMap.put("personNumber", responser.get("personNumber"));
                                    if (StringUtils.isEmpty((CharSequence)positionId)) {
                                        positionId = ProcessorUtils.getPrimaryPosition(ctx, responser.get("person"));
                                    }
                                    handlerMap.put("processorPosition", positionId);
                                    hanlerList.add(handlerMap);
                                }
                            }
                        } else {
                            HashMap<String, String> handlerMap = new HashMap<String, String>();
                            handlerMap.put("person", person);
                            handlerMap.put("personNumber", evaObjInfo.getNumber());
                            handlerMap.put("personName", evaObjInfo.getName());
                            handlerMap.put("processorPosition", positionId);
                            hanlerList.add(handlerMap);
                        }
                    } else if (nodeHandler.equals("200")) {
                        PersonCollection personColl = this.getSupervisor(ctx, position);
                        String processorPosition = ProcessorUtils.getSupervisorPosition(ctx, position, null);
                        WorkFlowUtils.setValueForHandlerList(ctx, personColl, hanlerList, processorPosition, isOrg, null);
                    } else if (nodeHandler.equals("300")) {
                        String processorPosition = ProcessorUtils.getIndirectSuperiorPosition(ctx, position, null);
                        String supervisorPos = ProcessorUtils.getSupervisorPosition(ctx, position, null);
                        PersonCollection personColl = this.getSupervisor(ctx, supervisorPos);
                        WorkFlowUtils.setValueForHandlerList(ctx, personColl, hanlerList, processorPosition, isOrg, null);
                    } else if (nodeHandler.equals("400")) {
                        PositionMemberCollection pmColl = this.getPrimarySubordinatePM(ctx, position);
                        if (pmColl != null && !pmColl.isEmpty()) {
                            HashMap<String, PersonCollection> personMap = new HashMap<String, PersonCollection>();
                            for (PositionMemberInfo memberInfo : pmColl) {
                                String posId = memberInfo.getPosition().getId().toString();
                                PersonCollection persons = (PersonCollection)personMap.get(posId);
                                if (persons == null) {
                                    persons = new PersonCollection();
                                }
                                persons.add(memberInfo.getPerson());
                                personMap.put(posId, persons);
                            }
                            for (Map.Entry items : personMap.entrySet()) {
                                WorkFlowUtils.setValueForHandlerList(ctx, (PersonCollection)items.getValue(), hanlerList, (String)items.getKey(), isOrg, null);
                            }
                        } else {
                            WorkFlowUtils.setValueForHandlerList(ctx, null, hanlerList, null, isOrg, null);
                        }
                    } else if (nodeHandler.equals("500")) {
                        PersonCollection personColl = null;
                        if (isOrg) {
                            PositionCollection parentPosition = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection("select parent.id where id = '" + position + "'");
                            if (parentPosition != null && parentPosition.size() > 0 && parentPosition.get(0).getParent() != null) {
                                String parentPositionId = parentPosition.get(0).getParent().getId().toString();
                                personColl = this.getPrimarySubordinate(ctx, parentPositionId);
                            }
                        } else {
                            PositionCollection parentPosition = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection("select parent.id where id = '" + position + "'");
                            if (parentPosition != null && parentPosition.size() > 0 && parentPosition.get(0).getParent() != null) {
                                String parentPositionId = parentPosition.get(0).getParent().getId().toString();
                                personColl = this.getPrimarySubordinate(ctx, parentPositionId);
                                PersonCollection toRemovePersonColl = iperson.getPersonCollection("select id,number,name where id='" + evaObjInfo.getPerson().getId().toString() + "'");
                                if (null != toRemovePersonColl && toRemovePersonColl.size() > 0) {
                                    personColl.remove(toRemovePersonColl.get(0));
                                }
                            }
                        }
                        WorkFlowUtils.setValueForHandlerList(ctx, personColl, hanlerList, position, isOrg, null);
                    } else if (nodeHandler.equals("600")) {
                        ICustomerPerfwebWorkFlow instance = CustomerPerfwebWorkFlowFactory.getInstance(ctx, 0);
                        hanlerList = instance.getCustomerNodeHandler(ctx, evaObj, nodeId);
                        if (null == hanlerList || hanlerList.isEmpty()) {
                            hanlerList = new ArrayList();
                            WorkFlowUtils.setValueForHandlerList(ctx, null, hanlerList, null, isOrg, null);
                        }
                    } else if (nodeHandler.equals("800")) {
                        PersonCollection personColl = this.getChargers(ctx, evaObjInfo);
                        WorkFlowUtils.setValueForHandlerList(ctx, personColl, hanlerList, null, isOrg, false);
                    }
                } else if (handleType.equals("4")) {
                    if (nodeHandler.equals("910")) {
                        PersonCollection personColl = this.getBelongDepartment(ctx, evaObjInfo);
                        WorkFlowUtils.setValueForHandlerList(ctx, personColl, hanlerList, null, isOrg, false);
                    } else if (nodeHandler.equals("920")) {
                        PersonCollection personColl = this.getSuperDepartment(ctx, evaObjInfo);
                        WorkFlowUtils.setValueForHandlerList(ctx, personColl, hanlerList, null, isOrg, false);
                    } else if (nodeHandler.equals("930")) {
                        PersonCollection personColl = this.getIndiSuperDepartment(ctx, evaObjInfo);
                        WorkFlowUtils.setValueForHandlerList(ctx, personColl, hanlerList, null, isOrg, false);
                    }
                } else if (handleType.equals("1")) {
                    if (!StringUtils.isEmpty((CharSequence)nodeHandler)) {
                        String[] personIds;
                        for (String personId : personIds = nodeHandler.split(",")) {
                            PersonCollection personColl = iperson.getPersonCollection("select id,number,name where id='" + personId + "'");
                            WorkFlowUtils.setValueForHandlerList(ctx, personColl, hanlerList, null, isOrg, false);
                        }
                    }
                } else if (handleType.equals("2")) {
                    String[] positionIds;
                    for (String pos : positionIds = nodeHandler.split(",")) {
                        PersonCollection personColl = ProcessorUtils.getPersonCollByPosition(ctx, pos);
                        WorkFlowUtils.setValueForHandlerList(ctx, personColl, hanlerList, pos, isOrg, null);
                    }
                } else if (handleType.equals("3")) {
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("evaObj", (Object)evaObj, CompareType.EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("relationType", (Object)nodeHandler, CompareType.EQUALS));
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    selectors.add(new SelectorItemInfo("handler.id"));
                    selectors.add(new SelectorItemInfo("handler.number"));
                    selectors.add(new SelectorItemInfo("handler.name"));
                    selectors.add(new SelectorItemInfo("handlerPosition.id"));
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(filterInfo);
                    evi.setSelector(selectors);
                    PerfEvaObjRelationObjectCollection objectColls = PerfEvaObjRelationObjectFactory.getLocalInstance(ctx).getPerfEvaObjRelationObjectCollection(evi);
                    if (objectColls != null && !objectColls.isEmpty()) {
                        HashMap<String, PersonCollection> personMap = new HashMap<String, PersonCollection>();
                        Iterator it = objectColls.iterator();
                        while (it.hasNext()) {
                            PerfEvaObjRelationObjectInfo info = (PerfEvaObjRelationObjectInfo)it.next();
                            String handlerPosition = info.getHandlerPosition().getId().toString();
                            PersonCollection persons = (PersonCollection)personMap.get(handlerPosition);
                            if (persons == null) {
                                persons = new PersonCollection();
                            }
                            persons.add(info.getHandler());
                            personMap.put(handlerPosition, persons);
                        }
                        for (Map.Entry entry : personMap.entrySet()) {
                            WorkFlowUtils.setValueForHandlerList(ctx, (PersonCollection)entry.getValue(), hanlerList, (String)entry.getKey(), isOrg, false);
                        }
                    } else {
                        WorkFlowUtils.setValueForHandlerList(ctx, null, hanlerList, null, isOrg, null);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return hanlerList;
    }

    public PersonCollection getChargers(Context ctx, PerfEvaObjectInfo evaObjectInfo) throws BOSException {
        PersonCollection personCollection = new PersonCollection();
        HashSet<String> evals = new HashSet<String>();
        evals.add(evaObjectInfo.getId().toString());
        Map<String, Set<String>> personInchargeByids = null;
        Map<String, Set<PersonInfo>> resultMap = null;
        try {
            personInchargeByids = PersonInchargeUtils.getPersonInchargeByids(ctx, evals, true);
            resultMap = PersonInchargeUtils.transferInformation(ctx, personInchargeByids);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        Set<PersonInfo> personInfos = resultMap.get(evaObjectInfo.getId().toString());
        for (PersonInfo personInfo : personInfos) {
            personCollection.add(personInfo);
        }
        return personCollection;
    }

    public PersonCollection getBelongDepartment(Context ctx, PerfEvaObjectInfo evaObjectInfo) throws BOSException {
        PerfEvaObjectInfo info;
        AdminOrgUnitInfo department;
        PersonCollection personCollection = new PersonCollection();
        HashSet<String> evals = new HashSet<String>();
        IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)evaObjectInfo.getId().toString(), CompareType.EQUALS));
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("perfFile.adminOrgUnit.*"));
        selectorItemCollection.add(new SelectorItemInfo("evaluOrgAdmin.*"));
        selectorItemCollection.add(new SelectorItemInfo("*"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectorItemCollection);
        PerfEvaObjectCollection perfEvaObjectCollection = iPerfEvaObject.getPerfEvaObjectCollection(evi);
        List<PersonInfo> personInfos = null;
        if (perfEvaObjectCollection.size() > 0 && (department = (info = perfEvaObjectCollection.get(0)).getIsOrg().getValue() == 0 ? info.getPerfFile().getAdminOrgUnit() : info.getEvaluOrgAdmin()).getResponPosition() != null) {
            String responPosition = department.getResponPosition().getId().toString();
            evals.add(responPosition);
            Map<String, List<PersonInfo>> positionMembers = PersonInchargeUtils.getPositionMembers(ctx, evals);
            personInfos = positionMembers.get(responPosition);
        }
        if (personInfos != null && personInfos.size() > 0) {
            for (PersonInfo personInfo : personInfos) {
                personCollection.add(personInfo);
            }
        }
        return personCollection;
    }

    public PersonCollection getSuperDepartment(Context ctx, PerfEvaObjectInfo evaObjectInfo) throws BOSException {
        PerfEvaObjectInfo info;
        AdminOrgUnitInfo superDepartent;
        PersonCollection personCollection = new PersonCollection();
        HashSet<String> evals = new HashSet<String>();
        IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)evaObjectInfo.getId().toString(), CompareType.EQUALS));
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("perfFile.adminOrgUnit.parent.*"));
        selectorItemCollection.add(new SelectorItemInfo("perfFile.adminOrgUnit.*"));
        selectorItemCollection.add(new SelectorItemInfo("evaluOrgAdmin.*"));
        selectorItemCollection.add(new SelectorItemInfo("evaluOrgAdmin.parent.*"));
        selectorItemCollection.add(new SelectorItemInfo("*"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectorItemCollection);
        PerfEvaObjectCollection perfEvaObjectCollection = iPerfEvaObject.getPerfEvaObjectCollection(evi);
        List<PersonInfo> personInfos = null;
        if (perfEvaObjectCollection.size() > 0 && (superDepartent = (info = perfEvaObjectCollection.get(0)).getIsOrg().getValue() == 0 ? info.getPerfFile().getAdminOrgUnit() : info.getEvaluOrgAdmin()) != null && superDepartent.getParent() != null && superDepartent.getParent().getResponPosition() != null) {
            String responPosition = superDepartent.getParent().getResponPosition().getId().toString();
            evals.add(responPosition);
            Map<String, List<PersonInfo>> positionMembers = PersonInchargeUtils.getPositionMembers(ctx, evals);
            personInfos = positionMembers.get(responPosition);
        }
        if (personInfos != null && personInfos.size() > 0) {
            for (PersonInfo personInfo : personInfos) {
                personCollection.add(personInfo);
            }
        }
        return personCollection;
    }

    public PersonCollection getIndiSuperDepartment(Context ctx, PerfEvaObjectInfo evaObjectInfo) throws BOSException {
        PerfEvaObjectInfo info;
        AdminOrgUnitInfo indiSuperDepartent;
        PersonCollection personCollection = new PersonCollection();
        HashSet<String> evals = new HashSet<String>();
        IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)evaObjectInfo.getId().toString(), CompareType.EQUALS));
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("perfFile.adminOrgUnit.parent.parent.*"));
        selectorItemCollection.add(new SelectorItemInfo("perfFile.adminOrgUnit.*"));
        selectorItemCollection.add(new SelectorItemInfo("perfFile.adminOrgUnit.parent.*"));
        selectorItemCollection.add(new SelectorItemInfo("evaluOrgAdmin.*"));
        selectorItemCollection.add(new SelectorItemInfo("evaluOrgAdmin.parent.*"));
        selectorItemCollection.add(new SelectorItemInfo("evaluOrgAdmin.parent.parent.*"));
        selectorItemCollection.add(new SelectorItemInfo("*"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectorItemCollection);
        PerfEvaObjectCollection perfEvaObjectCollection = iPerfEvaObject.getPerfEvaObjectCollection(evi);
        List<PersonInfo> personInfos = null;
        if (perfEvaObjectCollection.size() > 0 && (indiSuperDepartent = (info = perfEvaObjectCollection.get(0)).getIsOrg().getValue() == 0 ? info.getPerfFile().getAdminOrgUnit() : info.getEvaluOrgAdmin()) != null && indiSuperDepartent.getParent() != null && indiSuperDepartent.getParent().getParent() != null && indiSuperDepartent.getParent().getParent().getResponPosition() != null) {
            String responPosition = indiSuperDepartent.getParent().getParent().getResponPosition().getId().toString();
            evals.add(responPosition);
            Map<String, List<PersonInfo>> positionMembers = PersonInchargeUtils.getPositionMembers(ctx, evals);
            personInfos = positionMembers.get(responPosition);
        }
        if (personInfos != null && personInfos.size() > 0) {
            for (PersonInfo personInfo : personInfos) {
                personCollection.add(personInfo);
            }
        }
        return personCollection;
    }

    public PersonCollection getNodeHandlerPerons(Context ctx, PerfEvaObjectInfo evaObjInfo, String position, WFNodeDefInfo nodeInfo) {
        PersonCollection personColl = new PersonCollection();
        String evaObj = evaObjInfo.getId().toString();
        String nodeId = nodeInfo.getId().toString();
        try {
            IPerson iperson = PersonFactory.getLocalInstance((Context)ctx);
            PersonInfo personInfo = evaObjInfo.getPerfFile().getPerson();
            String person = personInfo.getId().toString();
            String handleType = nodeInfo.getHandleType().getValue();
            String nodeHandler = nodeInfo.getNodeHandler();
            if (handleType.equals("0")) {
                if (nodeHandler.equals("100")) {
                    personColl.add(personInfo);
                } else if (nodeHandler.equals("200")) {
                    personColl = this.getSupervisor(ctx, position);
                    WorkFlowUtils.filterValidNodeHandler(ctx, personColl);
                } else if (nodeHandler.equals("300")) {
                    String supervisorPos = ProcessorUtils.getSupervisorPosition(ctx, position, null);
                    personColl = this.getSupervisor(ctx, supervisorPos);
                    WorkFlowUtils.filterValidNodeHandler(ctx, personColl);
                } else if (nodeHandler.equals("400")) {
                    personColl = this.getPrimarySubordinate(ctx, position);
                    WorkFlowUtils.filterValidNodeHandler(ctx, personColl);
                } else if (nodeHandler.equals("500")) {
                    personColl = this.getColleague(ctx, position);
                    PersonCollection toRemovePersonColl = iperson.getPersonCollection("select id,name,number where id='" + person + "'");
                    if (null != toRemovePersonColl && toRemovePersonColl.size() > 0) {
                        personColl.remove(toRemovePersonColl.get(0));
                    }
                    WorkFlowUtils.filterValidNodeHandler(ctx, personColl);
                } else if (nodeHandler.equals("600")) {
                    ICustomerPerfwebWorkFlow instance = CustomerPerfwebWorkFlowFactory.getInstance(ctx, 0);
                    List<Map<String, String>> hanlerList = instance.getCustomerNodeHandler(ctx, evaObj, nodeId);
                    if (!CollectionUtils.isEmpty(hanlerList)) {
                        for (Map<String, String> item : hanlerList) {
                            PersonInfo personInfo1 = new PersonInfo();
                            personInfo1.setId(BOSUuid.read((String)item.get("person")));
                            personInfo1.setNumber(item.get("personNumber"));
                            personInfo1.setName(item.get("personName"));
                            personColl.add(personInfo1);
                        }
                    }
                } else if (nodeHandler.equals("800")) {
                    personColl = this.getChargers(ctx, evaObjInfo);
                    WorkFlowUtils.filterValidNodeHandler(ctx, personColl);
                }
            } else if (handleType.equals("4")) {
                if (nodeHandler.equals("910")) {
                    personColl = this.getBelongDepartment(ctx, evaObjInfo);
                } else if (nodeHandler.equals("920")) {
                    personColl = this.getSuperDepartment(ctx, evaObjInfo);
                } else if (nodeHandler.equals("930")) {
                    personColl = this.getIndiSuperDepartment(ctx, evaObjInfo);
                }
            } else if (handleType.equals("1")) {
                if (!StringUtils.isEmpty((CharSequence)nodeHandler)) {
                    String[] personIds = nodeHandler.split(",");
                    if (personIds == null || personIds.length == 0) {
                        return null;
                    }
                    HashSet<String> personSet = new HashSet<String>();
                    personSet.addAll(Arrays.asList(personIds));
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", personSet, CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("employeeType.isInCount", (Object)1, CompareType.EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("employeeType.isOnTheStrength", (Object)1, CompareType.EQUALS));
                    filterInfo.setMaskString("#0 and (#1 or #2)");
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    selectors.add(new SelectorItemInfo("id"));
                    selectors.add(new SelectorItemInfo("number"));
                    selectors.add(new SelectorItemInfo("name"));
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(filterInfo);
                    evi.setSelector(selectors);
                    personColl = iperson.getPersonCollection(evi);
                }
            } else if (handleType.equals("2")) {
                String[] positionIds;
                for (String pos : positionIds = nodeHandler.split(",")) {
                    personColl = ProcessorUtils.getPersonCollByPosition(ctx, pos);
                    WorkFlowUtils.filterValidNodeHandler(ctx, personColl);
                }
            } else if (handleType.equals("3")) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("evaObj", (Object)evaObj, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("relationType", (Object)nodeHandler, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("handler.employeeType.isInCount", (Object)1, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("handler.employeeType.isOnTheStrength", (Object)1, CompareType.EQUALS));
                filterInfo.setMaskString("#0 and #1 and (#2 or #3)");
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("handler.id"));
                selectors.add(new SelectorItemInfo("handler.number"));
                selectors.add(new SelectorItemInfo("handler.name"));
                selectors.add(new SelectorItemInfo("handlerPosition.id"));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filterInfo);
                evi.setSelector(selectors);
                PerfEvaObjRelationObjectCollection objectColls = PerfEvaObjRelationObjectFactory.getLocalInstance(ctx).getPerfEvaObjRelationObjectCollection(evi);
                if (objectColls != null && !objectColls.isEmpty()) {
                    Iterator it = objectColls.iterator();
                    while (it.hasNext()) {
                        PerfEvaObjRelationObjectInfo info = (PerfEvaObjRelationObjectInfo)it.next();
                        personColl.add(info.getHandler());
                    }
                }
            }
        }
        catch (BOSException e) {
            logger.error("get node handler bos err: ", (Throwable)e);
        }
        catch (SHRPerfWebBizException e) {
            logger.error("get node handler eas err: ", (Throwable)((Object)e));
        }
        return personColl;
    }

    @Override
    public boolean judgeCurrentNodeLevelIsCompleted(Context ctx, String evaObj, String wfLevelDef) {
        boolean flag = true;
        GradeTaskNodeInstCollection gradeTaskNodeInstColl = GetEntityInfoUtils.getGradeTaskNodeInstCollection(ctx, evaObj, wfLevelDef);
        if (gradeTaskNodeInstColl != null && gradeTaskNodeInstColl.size() > 0) {
            for (int i = 0; i < gradeTaskNodeInstColl.size(); ++i) {
                GradeTaskNodeInstInfo gradeTaskNodeInfo = gradeTaskNodeInstColl.get(i);
                String scoreStatus = gradeTaskNodeInfo.getScoreStatus().getValue();
                if (!scoreStatus.equals("1")) continue;
                return false;
            }
        }
        return flag;
    }

    public boolean judgeCurrentNodeIsLastNode(Context ctx, String evaObj, String wfLevelDef, int level) {
        PWorkFlowDefInfo wflowInfo;
        boolean flag = false;
        PWFLevelDefInfo wfLevelDefInfo = GetEntityInfoUtils.getPWFLevelDefInfoById(ctx, wfLevelDef);
        if (wfLevelDefInfo.getId() != null && (wflowInfo = GetEntityInfoUtils.getPWorkFlowDefInfoById(ctx, wfLevelDefInfo.getWorkflow())) != null && wflowInfo.getSeries() == level && this.judgeCurrentNodeLevelIsCompleted(ctx, evaObj, wfLevelDef)) {
            flag = true;
        }
        return flag;
    }

    public boolean judgeIsAllNodeSubmited(Context ctx, String evaObj, String workFlow) {
        boolean flag = false;
        int total = 0;
        int submitCount = 0;
        GradeTaskNodeInstCollection gradeTaskNodeInstColl = GetEntityInfoUtils.getGradeTaskNodeInstCollByEvaObj(ctx, evaObj, workFlow);
        if (null != gradeTaskNodeInstColl && gradeTaskNodeInstColl.size() > 0) {
            total = gradeTaskNodeInstColl.size();
            for (int i = 0; i < total; ++i) {
                GradeTaskNodeInstInfo gradeTaskNostInstInfo = gradeTaskNodeInstColl.get(i);
                String scoreStatus = gradeTaskNostInstInfo.getScoreStatus().getValue();
                if (!scoreStatus.equals("2") && !scoreStatus.equals("3") && !scoreStatus.equals("4")) continue;
                ++submitCount;
            }
        }
        if (total == submitCount && submitCount > 0) {
            flag = true;
        }
        return flag;
    }

    public boolean judgeIsAllNodeSubmitedIgnoreWorkflow(Context ctx, String evaObj) {
        boolean flag = false;
        int total = 0;
        int submitCount = 0;
        GradeTaskNodeInstCollection gradeTaskNodeInstColl = GetEntityInfoUtils.getGradeTaskNodeInstCollByEvaObj(ctx, evaObj);
        if (null != gradeTaskNodeInstColl && gradeTaskNodeInstColl.size() > 0) {
            total = gradeTaskNodeInstColl.size();
            for (int i = 0; i < total; ++i) {
                GradeTaskNodeInstInfo gradeTaskNostInstInfo = gradeTaskNodeInstColl.get(i);
                String scoreStatus = gradeTaskNostInstInfo.getScoreStatus().getValue();
                if (!scoreStatus.equals("2") && !scoreStatus.equals("3") && !scoreStatus.equals("4")) continue;
                ++submitCount;
            }
        }
        if (total == submitCount && submitCount > 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    public PWFLevelDefCollection findPWFLevelDefCollByCurrentNodeId(String wfid) {
        return null;
    }

    @Override
    public void createNodeInst(Context ctx, PerfEvaObjectInfo evaObjInfo, AsignmentPoolInfo asignmentInfo, WFNodeDefInfo wfNodeInfo, String handler, String handlerName, String createType, int isSelf, String processorPosition) throws BOSException {
        PerfWorkFlowFacadeControllerBean.getInstance().createNodeInst(ctx, evaObjInfo, asignmentInfo, wfNodeInfo, handler, handlerName, createType, isSelf, processorPosition);
    }

    @Override
    public PersonCollection getSupervisor(Context ctx, String position) {
        return ProcessorUtils.getSupervisor(ctx, position, null);
    }

    @Override
    public PersonCollection getPrimarySubordinate(Context ctx, String position) {
        return ProcessorUtils.getPrimarySubordinate(ctx, position, null);
    }

    public PositionMemberCollection getPrimarySubordinatePM(Context ctx, String position) {
        return ProcessorUtils.getPrimarySubordinatePositionMember(ctx, position, null);
    }

    @Override
    public PersonCollection getColleague(Context ctx, String position) {
        return ProcessorUtils.getPersonCollByPosition(ctx, position);
    }

    @Override
    public PersonCollection getPersonCollByPosition(Context ctx, String position) {
        PersonCollection personColl = new PersonCollection();
        Date now = new Date();
        String currentDate = PerfDateUtils.formatDate(now, "yyyy-MM-dd");
        try {
            IPerson iperson = PersonFactory.getLocalInstance((Context)ctx);
            String selectPersonCollSQL = "select FPersonID from T_HR_EmpOrgRelation where FPositionID='" + position + "'  and FAssignType=" + 1 + " and FEFFDT<={ts'" + currentDate + "'} and FLEFFDT>={ts'" + currentDate + "'}";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectPersonCollSQL);
            while (rs.next()) {
                PersonInfo personInfo = iperson.getPersonInfo((IObjectPK)new ObjectUuidPK(rs.getString("FPersonID")));
                personColl.add(personInfo);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return personColl;
    }

    @Override
    public Set<String> activeNodeInst(Context ctx, String evaObj, int level, String workFlow) {
        return this.activeNodeInst(ctx, evaObj, level, workFlow, false);
    }

    @Override
    public Set<String> activeNodeInst(Context ctx, String evaObj, int level, String workFlow, boolean isAutoSubmit) {
        try {
            int lastlevel;
            CoreBaseCollection coreBaseColl = new CoreBaseCollection();
            CoreBaseCollection wholeCommentColl = new CoreBaseCollection();
            IGradeTaskNodeInst iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance(ctx);
            IGradeTargetInst iGradeTargetInst = GradeTargetInstFactory.getLocalInstance(ctx);
            IWholeComment iWholeComment = WholeCommentFactory.getLocalInstance(ctx);
            PerfEvaObjectInfo evaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
            WFNodeDefCollection wfNodeDefColl = null;
            GradeTaskNodeInstCollection gradeTaskNodeInstColl = null;
            if (evaObjectInfo.getCanAdjustEvaluer().getValue() == 0) {
                wfNodeDefColl = GetEntityInfoUtils.getCarrayToNextNodeColl(ctx, evaObjectInfo.getWorkFlow().getId().toString(), level - 1);
                gradeTaskNodeInstColl = GetEntityInfoUtils.getGradeTaskNodeInstCollByEvaObjAndNodeLevel(ctx, evaObj, level, evaObjectInfo.getWorkFlow().getId().toString());
            } else {
                wfNodeDefColl = GetEntityInfoUtils.getCarrayToNextNodeColl(ctx, workFlow, level - 1);
                gradeTaskNodeInstColl = GetEntityInfoUtils.getGradeTaskNodeInstCollByEvaObjAndNodeLevel(ctx, evaObj, level, workFlow);
            }
            String wholeGrade = "";
            if (null != wfNodeDefColl && wfNodeDefColl.size() > 0) {
                wholeGrade = this.getWFNodeWholeGrade(ctx, evaObj, wfNodeDefColl.get(0));
            }
            HashMap<String, GradeTaskNodeInstInfo> lastTaskNodeMap = new HashMap<String, GradeTaskNodeInstInfo>();
            if (isAutoSubmit && (lastlevel = level - 1) != 0) {
                GradeTaskNodeInstCollection lastGradeTaskNodeInstColl = null;
                lastGradeTaskNodeInstColl = evaObjectInfo.getCanAdjustEvaluer().getValue() == 0 ? GetEntityInfoUtils.getGradeTaskNodeInstCollByEvaObjAndNodeLevel(ctx, evaObj, lastlevel, evaObjectInfo.getWorkFlow().getId().toString()) : GetEntityInfoUtils.getGradeTaskNodeInstCollByEvaObjAndNodeLevel(ctx, evaObj, lastlevel, workFlow);
                Iterator iterator = lastGradeTaskNodeInstColl.iterator();
                while (iterator.hasNext()) {
                    GradeTaskNodeInstInfo lastTaskNode = (GradeTaskNodeInstInfo)iterator.next();
                    if (lastTaskNode.getNodeHandler() == null) continue;
                    lastTaskNodeMap.put(lastTaskNode.getNodeHandler().getId().toString(), lastTaskNode);
                }
            }
            if (gradeTaskNodeInstColl != null && gradeTaskNodeInstColl.size() > 0) {
                ArrayList<GradeTaskNodeInstInfo> autoSubmitNode = new ArrayList<GradeTaskNodeInstInfo>();
                for (int i = 0; i < gradeTaskNodeInstColl.size(); ++i) {
                    String isNeedEmailNotify;
                    WFNodeDefInfo wfNodeDefInfo;
                    GradeTaskNodeInstInfo gradeTNodeInstInfo = gradeTaskNodeInstColl.get(i);
                    if (gradeTNodeInstInfo.getTaskStatus().getValue().equals("3") || gradeTNodeInstInfo.getTaskStatus().getValue().equals("4")) continue;
                    if (isAutoSubmit && gradeTNodeInstInfo.getNodeHandler() != null && lastTaskNodeMap.containsKey(gradeTNodeInstInfo.getNodeHandler().getId().toString())) {
                        autoSubmitNode.add(gradeTNodeInstInfo);
                        continue;
                    }
                    gradeTNodeInstInfo.setIsVisible(IsVisibleEnum.VISIBLE);
                    gradeTNodeInstInfo.setCanEdit(CanEditEnum.CANEDIT);
                    gradeTNodeInstInfo.setIsEffective(IsEffectiveEnum.EFFECTIVE);
                    String scoreStatus = gradeTNodeInstInfo.getScoreStatus().getValue();
                    if (!scoreStatus.equals("3") && !scoreStatus.equals("4")) {
                        gradeTNodeInstInfo.setTaskStatus(TaskStatusEnum.DEALING);
                    }
                    if (scoreStatus.equals("2")) {
                        gradeTNodeInstInfo.setTaskStatus(TaskStatusEnum.COMPLETED);
                        gradeTNodeInstInfo.setCanEdit(CanEditEnum.DISABLED);
                    }
                    gradeTNodeInstInfo.setWeightAccuType(null);
                    coreBaseColl.add((CoreBaseInfo)gradeTNodeInstInfo);
                    WholeCommentInfo wholeCommentInfo = GetEntityInfoUtils.getWholeCommentInfo(ctx, gradeTNodeInstInfo.getId().toString());
                    if (!StringUtils.isEmpty((CharSequence)wholeGrade)) {
                        wholeCommentInfo.setGrade(wholeGrade);
                        gradeTNodeInstInfo.setNodeGrade(wholeGrade);
                    }
                    wholeCommentColl.add((CoreBaseInfo)wholeCommentInfo);
                    if (wholeCommentColl.size() > 0 && wholeCommentColl.size() % 50 == 0) {
                        iWholeComment.updateBatchData(wholeCommentColl);
                        wholeCommentColl.clear();
                    }
                    if (coreBaseColl.size() > 0 && coreBaseColl.size() % 50 == 0) {
                        iGradeTaskNodeInst.updateBatchData(coreBaseColl);
                        coreBaseColl.clear();
                    }
                    String wfNode = "";
                    if (gradeTNodeInstInfo.getWfNode() != null && gradeTNodeInstInfo.getWfNode().getId() != null) {
                        wfNode = gradeTNodeInstInfo.getWfNode().getId().toString();
                    }
                    if ((wfNodeDefInfo = GetEntityInfoUtils.getWFNodeDefInfo(ctx, wfNode)).getEmailNotification() == null || !(isNeedEmailNotify = wfNodeDefInfo.getEmailNotification().getValue()).equals("1")) continue;
                    String shrUrl = GetEntityInfoUtils.getSHRUrl(ctx);
                    PerfEvaObjectInfo evaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
                    IEmailSendFacade iEmailSendFacade = EmailSendFacadeFactory.getLocalInstance(ctx);
                    String handler = "";
                    if (null == gradeTNodeInstInfo.getNodeHandler() || gradeTNodeInstInfo.getNodeHandler().getId() == null) continue;
                    handler = gradeTNodeInstInfo.getNodeHandler().getId().toString();
                }
                if (wholeCommentColl.size() > 0) {
                    iWholeComment.updateBatchData(wholeCommentColl);
                    wholeCommentColl.clear();
                }
                if (coreBaseColl.size() > 0) {
                    iGradeTaskNodeInst.updateBatchData(coreBaseColl);
                    coreBaseColl.clear();
                }
                if (isAutoSubmit && autoSubmitNode.size() > 0) {
                    HashSet<String> autoSubmitNodeIds = new HashSet<String>();
                    CoreBaseCollection autoSubmitColls = new CoreBaseCollection();
                    for (GradeTaskNodeInstInfo autoSubmitNodeInst : autoSubmitNode) {
                        WholeCommentCollection nextWholeCommentColls;
                        GradeTargetInstCollection nextTargetColls;
                        GradeTaskNodeInstInfo lastTaskNode = (GradeTaskNodeInstInfo)lastTaskNodeMap.get(autoSubmitNodeInst.getNodeHandler().getId().toString());
                        autoSubmitNodeInst.setNodeGrade(lastTaskNode.getNodeGrade());
                        autoSubmitNodeInst.setScoreStatus(ScoreStatusEnum.UNSUBMIT);
                        autoSubmitNodeInst.setHandleTime(new Date());
                        autoSubmitNodeInst.setTaskStatus(TaskStatusEnum.DEALING);
                        autoSubmitNodeInst.setIsEffective(IsEffectiveEnum.EFFECTIVE);
                        autoSubmitNodeInst.setIsVisible(IsVisibleEnum.VISIBLE);
                        autoSubmitNodeIds.add(autoSubmitNodeInst.getId().toString());
                        autoSubmitColls.add((CoreBaseInfo)autoSubmitNodeInst);
                        HashMap<String, GradeTargetInstInfo> currentTargetMap = new HashMap<String, GradeTargetInstInfo>();
                        GradeTargetInstCollection currentTargetColls = iGradeTargetInst.getGradeTargetInstCollection("where gradeTaskNode ='" + lastTaskNode.getId().toString() + "' and evaObj='" + evaObj + "'");
                        if (!currentTargetColls.isEmpty()) {
                            Iterator iterator = currentTargetColls.iterator();
                            while (iterator.hasNext()) {
                                GradeTargetInstInfo currentTarget = (GradeTargetInstInfo)iterator.next();
                                currentTargetMap.put(currentTarget.getTarget(), currentTarget);
                            }
                        }
                        if (!(nextTargetColls = iGradeTargetInst.getGradeTargetInstCollection("where gradeTaskNode ='" + autoSubmitNodeInst.getId().toString() + "' and evaObj='" + evaObj + "'")).isEmpty()) {
                            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                            Iterator iterator = nextTargetColls.iterator();
                            while (iterator.hasNext()) {
                                GradeTargetInstInfo nextTarget = (GradeTargetInstInfo)iterator.next();
                                GradeTargetInstInfo currentTarget = (GradeTargetInstInfo)currentTargetMap.get(nextTarget.getTarget());
                                nextTarget.setComment(currentTarget.getComment());
                                nextTarget.setGradeRank(currentTarget.getGradeRank());
                                nextTarget.setRema(currentTarget.getRema());
                                nextTarget.setTargetScore(currentTarget.getTargetScore());
                                nextTarget.setScoreStatus(currentTarget.getScoreStatus());
                                nextTarget.setIsRejection(currentTarget.getIsRejection());
                                coreBaseCollection.add((CoreBaseInfo)nextTarget);
                            }
                            iGradeTargetInst.save(coreBaseCollection);
                        }
                        HashMap<String, WholeCommentInfo> currentWholeCommentMap = new HashMap<String, WholeCommentInfo>();
                        WholeCommentCollection currentWholeComments = iWholeComment.getWholeCommentCollection("select gradeTaskNodeInst.NodeHandler, score, grade, weight, comment where gradeTaskNodeInst ='" + lastTaskNode.getId().toString() + "' and evaObj='" + evaObj + "'");
                        if (!currentWholeComments.isEmpty()) {
                            Iterator iterator = currentWholeComments.iterator();
                            while (iterator.hasNext()) {
                                WholeCommentInfo currentWholeComment = (WholeCommentInfo)iterator.next();
                                if (currentWholeComment.getGradeTaskNodeInst().getNodeHandler() == null) continue;
                                String nodeHandler = currentWholeComment.getGradeTaskNodeInst().getNodeHandler().getId().toString();
                                currentWholeCommentMap.put(nodeHandler, currentWholeComment);
                            }
                        }
                        if ((nextWholeCommentColls = iWholeComment.getWholeCommentCollection("select gradeTaskNodeInst.NodeHandler, score, grade, weight, comment where gradeTaskNodeInst ='" + autoSubmitNodeInst.getId().toString() + "' and evaObj='" + evaObj + "'")).isEmpty()) continue;
                        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                        Iterator iterator = nextWholeCommentColls.iterator();
                        while (iterator.hasNext()) {
                            WholeCommentInfo nextWholeComment = (WholeCommentInfo)iterator.next();
                            if (nextWholeComment.getGradeTaskNodeInst().getNodeHandler() == null) continue;
                            String nodeHandler = nextWholeComment.getGradeTaskNodeInst().getNodeHandler().getId().toString();
                            WholeCommentInfo currentWholeComment = (WholeCommentInfo)currentWholeCommentMap.get(nodeHandler);
                            nextWholeComment.setComment(currentWholeComment.getComment());
                            nextWholeComment.setGrade(currentWholeComment.getGrade());
                            nextWholeComment.setScore(currentWholeComment.getScore());
                            nextWholeComment.setComment(currentWholeComment.getComment());
                            coreBaseCollection.add((CoreBaseInfo)nextWholeComment);
                        }
                        iWholeComment.save(coreBaseCollection);
                    }
                    iGradeTaskNodeInst.save(autoSubmitColls);
                    return autoSubmitNodeIds;
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return null;
    }

    public boolean isNodeHandUp(Context ctx, String evaObj, int level) {
        boolean flag = true;
        try {
            GradeTaskNodeInstCollection gradeTaskNodeColl = GetEntityInfoUtils.getCurrentGradeTaskNodeInstUnsubmitColl(ctx, evaObj, level);
            int hasHandlerNodeSize = 0;
            int gradeTaskNodeInstCollSize = 0;
            if (null != gradeTaskNodeColl && gradeTaskNodeColl.size() > 0) {
                gradeTaskNodeInstCollSize = gradeTaskNodeColl.size();
                for (int i = 0; i < gradeTaskNodeInstCollSize; ++i) {
                    UserInfo userInfo;
                    GradeTaskNodeInstInfo gradeTaskNodeInstInfo = gradeTaskNodeColl.get(i);
                    if (null == gradeTaskNodeInstInfo.get("nodeHandler") || null == gradeTaskNodeInstInfo.getNodeHandler().getId() || null == (userInfo = CurrentUserUtil.getUserInfoByPersonId(ctx, gradeTaskNodeInstInfo.getNodeHandler().getId().toString()))) continue;
                    ++hasHandlerNodeSize;
                }
            }
            if (hasHandlerNodeSize > 0 || gradeTaskNodeInstCollSize == 0) {
                flag = false;
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return flag;
    }

    public String getWFNodeWholeGrade(Context ctx, String evaObj, WFNodeDefInfo nodeDefInfo) {
        String wholeGrade = "";
        String scoreControl = nodeDefInfo.getScoreControl().getValue();
        GradeTaskNodeInstCollection gradeTaskNodeInstColl = GetEntityInfoUtils.getSpecifiedNodeEffectiveGradeTaskNodeInstColl(ctx, evaObj, nodeDefInfo.getId().toString());
        if (null != gradeTaskNodeInstColl && gradeTaskNodeInstColl.size() > 0) {
            if (scoreControl.equals("1")) {
                WholeCommentInfo wholeCommentInfo = GetEntityInfoUtils.getWholeCommentInfo(ctx, gradeTaskNodeInstColl.get(0).getId().toString());
                wholeGrade = wholeCommentInfo.getGrade();
            } else if (scoreControl.equals("0")) {
                int size = gradeTaskNodeInstColl.size();
                float sumScore = 0.0f;
                PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfoByEvaObj(ctx, evaObj);
                for (int i = 0; i < size; ++i) {
                    String grade = GetEntityInfoUtils.getWholeCommentInfo(ctx, gradeTaskNodeInstColl.get(i).getId().toString()).getGrade();
                    try {
                        float score = PerfWorkFlowUtils.getDefaultScoreByPerfRate(ctx, ruleInfo.getId().toString(), grade, "1");
                        sumScore += score;
                        continue;
                    }
                    catch (BOSException e) {
                        logger.error("BOSException: ", (Throwable)e);
                    }
                }
                sumScore /= (float)size;
                try {
                    wholeGrade = PerfWorkFlowUtils.getLevelByPerfScore(ctx, ruleInfo.getId().toString(), sumScore, "1");
                }
                catch (BOSException e) {
                    logger.error("BOSException: ", (Throwable)e);
                }
            }
        }
        return wholeGrade;
    }

    public String getMatrixWFNodeWholeGrade(Context ctx, String evaObj, WFNodeDefInfo nodeDefInfo) {
        String wholeGrade = null;
        GradeTaskNodeInstCollection gradeTaskNodeInstColl = GetEntityInfoUtils.getMatrixSpecifiedNodeEffectiveGradeTaskNodeInstColl(ctx, evaObj, nodeDefInfo.getId().toString());
        if (null != gradeTaskNodeInstColl && gradeTaskNodeInstColl.size() > 0) {
            int size = gradeTaskNodeInstColl.size();
            if (size == 1) {
                WholeCommentInfo wholeCommentInfo = GetEntityInfoUtils.getWholeCommentInfo(ctx, gradeTaskNodeInstColl.get(0).getId().toString());
                wholeGrade = wholeCommentInfo.getGrade();
            } else {
                float sumScore = 0.0f;
                PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfoByEvaObj(ctx, evaObj);
                for (int i = 0; i < size; ++i) {
                    float score = gradeTaskNodeInstColl.get(i).getNodeSumScore();
                    sumScore += score;
                }
                try {
                    wholeGrade = PerfWorkFlowUtils.getLevelByPerfScore(ctx, ruleInfo.getId().toString(), sumScore, "1");
                }
                catch (BOSException e) {
                    logger.error("BOSException: ", (Throwable)e);
                }
            }
        }
        return wholeGrade;
    }

    public void createNodeInstForMatrix(Context ctx, PerfEvaObjectInfo evaObjInfo, AsignmentPoolInfo asignmentInfo, WFNodeDefInfo wfNodeInfo, String person, String personName, String createType, int isSelf, String processorPosition) {
    }

    private static class WorkFlowEngineInst {
        private static final WorkFlowEngine instance = new WorkFlowEngine();

        private WorkFlowEngineInst() {
        }
    }
}

