/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.preentry.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.BillEntryJobProcessCollection;
import com.kingdee.eas.hr.base.BillEntryJobProcessFactory;
import com.kingdee.eas.hr.base.BillEntryJobProcessInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.emp.CheckInState;
import com.kingdee.eas.hr.emp.app.util.EmpPostRankUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpCheckCredentialsTypeUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptBizManageTool;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelFactory;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.baseconfig.StructureConfigFactory;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.shr.preentry.EnrollCheckBaseItemRelHRCollection;
import com.kingdee.shr.preentry.EnrollCheckBaseItemRelHRFactory;
import com.kingdee.shr.preentry.EnrollCheckListFactory;
import com.kingdee.shr.preentry.EnrollCheckListInfo;
import com.kingdee.shr.preentry.EnrollPersonCheckListFactory;
import com.kingdee.shr.preentry.EnrollPersonCheckListInfo;
import com.kingdee.shr.preentry.FileStateEnum;
import com.kingdee.shr.preentry.IPreEntry;
import com.kingdee.shr.preentry.IPreEntryBizDiary;
import com.kingdee.shr.preentry.IPreEntryPerson;
import com.kingdee.shr.preentry.IPreMessageRecord;
import com.kingdee.shr.preentry.PEPersonContactCollection;
import com.kingdee.shr.preentry.PEPersonContactFactory;
import com.kingdee.shr.preentry.PEPersonContactInfo;
import com.kingdee.shr.preentry.PreEntryBizDiaryFactory;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.shr.preentry.PreEntryPageDataSetCollection;
import com.kingdee.shr.preentry.PreEntryPageDataSetFactory;
import com.kingdee.shr.preentry.PreEntryPageDataSetInfo;
import com.kingdee.shr.preentry.PreEntryPersonFactory;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.shr.preentry.PreMessageRecordFactory;
import com.kingdee.shr.preentry.PreentryException;
import com.kingdee.shr.preentry.app.AbstractPreEntryControllerBean;
import com.kingdee.shr.preentry.app.PreEntryOperationEnum;
import com.kingdee.shr.preentry.service.LogDataSuperviseService;
import com.kingdee.shr.preentry.util.PreEntryUtil;
import com.kingdee.shr.shareservice.ActivityProcessExecuteFacadeFactory;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreEntryControllerBean
extends AbstractPreEntryControllerBean {
    public static final Logger logger = LoggerFactory.getLogger(PreEntryControllerBean.class);
    private String PRE_ENTRY_OPERATION = "PreEntryOperationEnum";
    private String ISNEEdCODING = "isNeedCoding";
    private String FROM_BILL = "IS_FROM_PREENTRY";
    public static final String rootHRO = "00000000-0000-0000-0000-000000000000CCE7AED4";
    private LogDataSuperviseService service = new LogDataSuperviseService();

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK entryPK = null;
        IPreEntryPerson preEntryPerson = PreEntryPersonFactory.getLocalInstance(ctx);
        IPreEntry preEntry = PreEntryFactory.getLocalInstance(ctx);
        if (StringUtils.isEmpty((String)model.getString("id"))) {
            PreEntryInfo preEntity = (PreEntryInfo)model;
            PreEntryPersonInfo info = (PreEntryPersonInfo)model.get("talent");
            info.setName(preEntity.getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            info.setName(preEntity.getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            info.setName(preEntity.getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            if (!StringUtils.isEmpty((String)preEntity.getLastName())) {
                info.setLastName(preEntity.getLastName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                info.setLastName(preEntity.getLastName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                info.setLastName(preEntity.getLastName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            }
            if (!StringUtils.isEmpty((String)preEntity.getMiddleName())) {
                info.setMiddleName(preEntity.getMiddleName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                info.setMiddleName(preEntity.getMiddleName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                info.setMiddleName(preEntity.getMiddleName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            }
            if (!StringUtils.isEmpty((String)preEntity.getFirstName())) {
                info.setFirstName(preEntity.getFirstName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                info.setFirstName(preEntity.getFirstName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                info.setFirstName(preEntity.getFirstName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            }
            if (info.isIdCardLongEffect()) {
                info.setIdCardEndDate(null);
            }
            if (!StringUtils.isEmpty((String)info.getIdCardNO())) {
                String idCardNo = IDCardCommonUtil.upperIdCardNo((String)info.getIdCardNO());
                info.setIdCardNO(idCardNo);
            }
            if (info.getBirthday() != null && info.getAge() == 0) {
                int age = this.calculateAge(info.getBirthday());
                info.setAge(age);
            }
            if (info.getPerson() == null || info.getPerson().getId() == null) {
                PersonInfo person = new PersonInfo();
                String personId = BOSUuid.create((BOSObjectType)person.getBOSType()).toString();
                person.setId(BOSUuid.read((String)personId));
                info.setPerson(person);
            }
            String personId = "";
            IObjectPK personPK = null;
            PreEntryPersonInfo prePerson = null;
            if (info.getId() != null && !StringUtils.isEmpty((String)info.getId().toString())) {
                prePerson = preEntryPerson.getPreEntryPersonInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            }
            info.put(this.FROM_BILL, true);
            personPK = prePerson == null ? preEntryPerson.addnew(info) : preEntryPerson.save((CoreBaseInfo)info);
            personId = personPK.toString();
            if (preEntity.getAdminOrg() != null) {
                this.addEnrollCheckList(ctx, info, preEntity.getAdminOrg().getId().toString());
            }
            info.put("id", personId);
            preEntity.setTalent(info);
            preEntity.put(this.PRE_ENTRY_OPERATION, (Object)PreEntryOperationEnum.AddNew);
            preEntity.put(this.ISNEEdCODING, "true");
            if (StringUtils.isEmpty((String)preEntity.getNumber())) {
                String number = this.getCodingRuleNumber(ctx, preEntity);
                if (StringUtils.isEmpty((String)number)) {
                    number = "YRZ_" + System.currentTimeMillis();
                }
                preEntity.setNumber(number);
            }
            if (preEntity.getApplyDate() == null) {
                preEntity.setApplyDate(new Date());
            }
            if (preEntity.getApplier() == null) {
                preEntity.setApplier(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
            }
            String id = "";
            if (preEntry.exists("where talent.id = '" + personId + "'")) {
                id = preEntry.getPreEntryInfo("where talent.id = '" + personId + "'").getId().toString();
                this.update(ctx, (IObjectPK)new ObjectUuidPK(), preEntity);
            } else {
                entryPK = this.addnew(ctx, preEntity);
                id = entryPK.toString();
            }
            model.put("id", (Object)id);
            this.checkCredentialsType(ctx, preEntity);
            this.checkJobLevelGradeRange(ctx, preEntity);
            String cellPhone = preEntity.getCellPhone();
            String email = preEntity.getEmail();
            String ncell = preEntity.getNCell();
            String globalRoaming = preEntity.getGlobalRoaming();
            PEPersonContactCollection pecontactCol = PEPersonContactFactory.getLocalInstance(ctx).getPEPersonContactCollection("where talent.id = '" + personId + "'");
            if (pecontactCol.size() > 0) {
                PEPersonContactInfo pecontact = pecontactCol.get(0);
                pecontact.setEmail(email);
                pecontact.setMobile(cellPhone);
                pecontact.setGlobalRoaming(globalRoaming);
                pecontact.setNCell(ncell);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("mobile"));
                sic.add(new SelectorItemInfo("email"));
                sic.add(new SelectorItemInfo("nCell"));
                sic.add(new SelectorItemInfo("globalRoaming"));
                PEPersonContactFactory.getLocalInstance(ctx).updatePartial(pecontact, sic);
            } else {
                PEPersonContactInfo pecontact = new PEPersonContactInfo();
                pecontact.setMobile(cellPhone);
                pecontact.setEmail(email);
                pecontact.setGlobalRoaming(globalRoaming);
                pecontact.setNCell(ncell);
                pecontact.setTalent(info);
                PEPersonContactFactory.getLocalInstance(ctx).addnew(pecontact);
            }
        } else {
            PEPersonContactInfo pecontact;
            PreEntryPersonInfo info = (PreEntryPersonInfo)model.get("talent");
            CoreBaseInfo coreBaseinfo = (CoreBaseInfo)model.get("talent");
            ObjectUuidPK preEntryPersonpk = new ObjectUuidPK(info.getId().toString());
            PreEntryPersonInfo talentInfo = PreEntryPersonFactory.getLocalInstance(ctx).getPreEntryPersonInfo((IObjectPK)preEntryPersonpk);
            PreEntryInfo preEntity = (PreEntryInfo)model;
            PreEntryInfo oldPreEntry = this.getPreEntryInfo(ctx, (IObjectPK)new ObjectUuidPK(preEntity.getId()));
            talentInfo.setName(preEntity.getName(), LocaleUtils.locale_l1);
            talentInfo.setName(preEntity.getName(), LocaleUtils.locale_l2);
            talentInfo.setName(preEntity.getName(), LocaleUtils.locale_l3);
            this.setTalentFieldValue(ctx, talentInfo, info, preEntity);
            if (coreBaseinfo.containsKey("idCardAddress")) {
                talentInfo.setIdCardAddress(info.getIdCardAddress());
            }
            if (coreBaseinfo.containsKey("idCardBeginDate")) {
                talentInfo.setIdCardBeginDate(info.getIdCardBeginDate());
            }
            if (coreBaseinfo.containsKey("idCardEndDate")) {
                talentInfo.setIdCardEndDate(info.getIdCardEndDate());
            }
            if (coreBaseinfo.containsKey("idCardLongEffect")) {
                talentInfo.setIdCardLongEffect(info.isIdCardLongEffect());
            }
            if (coreBaseinfo.containsKey("idCardIssueOrg")) {
                talentInfo.setIdCardIssueOrg(info.getIdCardIssueOrg());
            }
            if (coreBaseinfo.containsKey("folk")) {
                talentInfo.setFolk(info.getFolk());
            }
            if (coreBaseinfo.containsKey("constellation")) {
                talentInfo.setConstellation(info.getConstellation());
            }
            if (coreBaseinfo.containsKey("zodiac")) {
                talentInfo.setZodiac(info.getZodiac());
            }
            if (!StringUtils.isEmpty((String)info.getIdCardNO())) {
                String idCardNo = IDCardCommonUtil.upperIdCardNo((String)info.getIdCardNO());
                info.setIdCardNO(idCardNo);
            }
            if (coreBaseinfo.containsKey("idCardNO")) {
                talentInfo.setIdCardNO(info.getIdCardNO());
            }
            if (coreBaseinfo.containsKey("passportNO")) {
                talentInfo.setPassportNO(info.getPassportNO());
            }
            if (coreBaseinfo.containsKey("gender")) {
                talentInfo.setGender(info.getGender());
            }
            if (coreBaseinfo.containsKey("birthday")) {
                talentInfo.setBirthday(info.getBirthday());
                if (info.getBirthday() != null && info.getAge() == 0) {
                    int age = this.calculateAge(info.getBirthday());
                    info.setAge(age);
                }
            }
            if (coreBaseinfo.containsKey("age")) {
                talentInfo.setAge(info.getAge());
            }
            if (info.isIdCardLongEffect()) {
                talentInfo.setIdCardEndDate(null);
            }
            if (talentInfo.getPerson() == null || talentInfo.getPerson().getId() == null) {
                PersonInfo person = new PersonInfo();
                String personId = BOSUuid.create((BOSObjectType)person.getBOSType()).toString();
                person.setId(BOSUuid.read((String)personId));
                talentInfo.setPerson(person);
            }
            talentInfo.put(this.FROM_BILL, true);
            PreEntryPersonFactory.getLocalInstance(ctx).update((IObjectPK)preEntryPersonpk, talentInfo);
            String preEntryId = model.getString("id");
            entryPK = new ObjectUuidPK(preEntryId);
            if (StringUtils.isEmpty((String)preEntity.getNumber())) {
                String number = this.getCodingRuleNumber(ctx, preEntity);
                if (StringUtils.isEmpty((String)number)) {
                    number = "YRZ_" + System.currentTimeMillis();
                }
                preEntity.setNumber(number);
            }
            if (preEntity.getApplyDate() == null) {
                preEntity.setApplyDate(new Date());
            }
            if (preEntity.getApplier() == null) {
                preEntity.setApplier(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
            }
            this.update(ctx, entryPK, preEntity);
            this.checkCredentialsType(ctx, preEntity);
            this.checkJobLevelGradeRange(ctx, preEntity);
            String talentid = info.getId().toString();
            String cellPhone = preEntity.getCellPhone();
            String email = preEntity.getEmail();
            String ncell = preEntity.getNCell();
            String globalRoaming = preEntity.getGlobalRoaming();
            PEPersonContactCollection pecontactCol = PEPersonContactFactory.getLocalInstance(ctx).getPEPersonContactCollection("where talent.id = '" + talentid + "'");
            if (pecontactCol.size() > 0) {
                pecontact = pecontactCol.get(0);
                pecontact.setMobile(cellPhone);
                pecontact.setEmail(email);
                pecontact.setGlobalRoaming(globalRoaming);
                pecontact.setNCell(ncell);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("mobile"));
                sic.add(new SelectorItemInfo("email"));
                sic.add(new SelectorItemInfo("nCell"));
                sic.add(new SelectorItemInfo("globalRoaming"));
                PEPersonContactFactory.getLocalInstance(ctx).updatePartial(pecontact, sic);
            } else {
                pecontact = new PEPersonContactInfo();
                pecontact.setMobile(cellPhone);
                pecontact.setEmail(email);
                pecontact.setGlobalRoaming(globalRoaming);
                pecontact.setNCell(ncell);
                pecontact.setTalent(info);
                PEPersonContactFactory.getLocalInstance(ctx).addnew(pecontact);
            }
            IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "updateRecByPreService");
            HashMap<String, String> billParam = new HashMap<String, String>();
            billParam.put("preEntryId", entryPK.toString());
            imsf.process(ctx, billParam);
        }
        return entryPK;
    }

    @Override
    public IObjectPK addnew(Context ctx, PreEntryInfo model) throws BOSException, EASBizException {
        try {
            ServiceContext svcCtx = this.createServiceContext(new MetaDataPK("3a53cf78-ca6f-491d-9f9f-9f80bde1df87"), new Object[]{ctx, model});
            this.invokeServiceBefore(svcCtx);
            if (!svcCtx.invokeBreak()) {
                IObjectPK retValue = this._addnew(ctx, (IObjectValue)model);
                svcCtx.setMethodReturnValue((Object)retValue);
                model.put("id", retValue.toString());
            }
            this.invokeServiceAfter(svcCtx);
            this.addLogService(ctx, model);
            this.addBarcodePhoto(ctx, model);
            IObjectPK iObjectPK = (IObjectPK)svcCtx.getMethodReturnValue();
            return iObjectPK;
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
        finally {
            super.cleanUpServiceState();
        }
    }

    private void addBarcodePhoto(Context ctx, PreEntryInfo model) {
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PreEntryInfo peInfo = (PreEntryInfo)model;
        peInfo.setIsLatest(true);
        peInfo.setCheckInState(CheckInState.NOT_CHECKED_IN);
        return super._addnew(ctx, model);
    }

    protected void setNumberFromCodingRule(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
        PreEntryInfo peInfo = (PreEntryInfo)model;
        if (peInfo.get("isNeedCoding") == null) {
            super.setNumberFromCodingRule(ctx, model);
        }
    }

    public String getCodingRuleNumber(Context ctx, PreEntryInfo peInfo) {
        String number = "";
        String orgId = this.getOrgIdByCU(ctx);
        boolean hasCodingRule = this.hasCodingRule(ctx, (IObjectValue)peInfo, orgId);
        if (hasCodingRule) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                number = iCodingRuleManager.getNumber((IObjectValue)peInfo, orgId);
                while (this.exists(ctx, "where number = '" + number + "'")) {
                    number = iCodingRuleManager.getNumber((IObjectValue)peInfo, orgId);
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return number;
    }

    private boolean hasCodingRule(Context ctx, IObjectValue model, String orgId) {
        try {
            ObjectUuidPK pk;
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (orgId != null && orgId.trim().length() > 0 && iCodingRuleManager.isExist(model, orgId)) {
                return true;
            }
            String companyId = null;
            ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
            CtrlUnitInfo rootCU = iCtrlUnit.getCtrlUnitInfo((IObjectPK)(pk = new ObjectUuidPK(rootHRO)));
            companyId = rootCU != null ? rootCU.getId().toString() : null;
            return companyId != null && companyId.trim().length() > 0 && iCodingRuleManager.isExist(model, companyId);
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    private String getOrgIdByCU(Context ctx) {
        String orgId;
        OrgUnitInfo mainOrg = (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        String string = orgId = mainOrg == null ? "" : mainOrg.getString("id");
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = rootHRO;
        }
        return orgId;
    }

    private void syncCellphoneEmail(Context ctx, PreEntryInfo oldPreEntryInfo, PreEntryInfo model) {
    }

    private void addLogService(Context ctx, PreEntryInfo model) {
        String userName;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String string = userName = ContextUtil.getCurrentUserInfo((Context)ctx) != null ? ContextUtil.getCurrentUserInfo((Context)ctx).getName() : "";
        if (StringUtils.isEmpty((String)userName)) {
            map.put("Handler", ctx.getUserName());
        } else {
            map.put("Handler", userName);
        }
        map.put("PreEntryInfo", model);
        map.put(this.PRE_ENTRY_OPERATION, model.get("PreEntryOperationEnum"));
        this.service.insertPreInfoLoge(ctx, map);
    }

    private void updateLogService(Context ctx, PreEntryInfo oldInfo, PreEntryInfo model) {
        String userName;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String string = userName = ContextUtil.getCurrentUserInfo((Context)ctx) != null ? ContextUtil.getCurrentUserInfo((Context)ctx).getName() : "";
        if (StringUtils.isEmpty((String)userName)) {
            map.put("Handler", ctx.getUserName());
        } else {
            map.put("Handler", userName);
        }
        map.put("OldPreEntryInfo", oldInfo);
        map.put("PreEntryInfo", model);
        map.put(this.PRE_ENTRY_OPERATION, model.get("PreEntryOperationEnum") != null ? model.get("PreEntryOperationEnum") : PreEntryOperationEnum.UpdatePreEntryRec);
        this.service.insertPreInfoLoge(ctx, map);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PreEntryInfo preEntryInfo = (PreEntryInfo)model;
        PositionInfo positionInfo = preEntryInfo.getPosition();
        if (positionInfo != null && !StringUtils.isEmpty((String)positionInfo.getId().toString())) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("adminOrgUnit"));
            positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(positionInfo.getId().toString()), selectors);
            preEntryInfo.setAdminOrg(positionInfo.getAdminOrgUnit());
        }
        PreEntryInfo oldPreEntryInfo = this.getPreEntryInfo(ctx, "where id ='" + preEntryInfo.getId().toString() + "'");
        this.updateLogService(ctx, oldPreEntryInfo, preEntryInfo);
        super._update(ctx, pk, model);
        if (ApproveTypeEnum.WORKFLOW.equals((Object)preEntryInfo.getApproveType())) {
            this.updatePreEntryPersonInWF(ctx, pk, model);
        }
    }

    protected void updatePreEntryPersonInWF(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        int errorCode;
        Map result;
        PEPersonContactInfo pecontact;
        PreEntryPersonInfo info = (PreEntryPersonInfo)model.get("talent");
        CoreBaseInfo coreBaseinfo = (CoreBaseInfo)model.get("talent");
        ObjectUuidPK preEntryPersonpk = new ObjectUuidPK(info.getId().toString());
        PreEntryPersonInfo talentInfo = PreEntryPersonFactory.getLocalInstance(ctx).getPreEntryPersonInfo((IObjectPK)preEntryPersonpk);
        PreEntryInfo preEntity = (PreEntryInfo)model;
        PreEntryInfo oldPreEntry = this.getPreEntryInfo(ctx, (IObjectPK)new ObjectUuidPK(preEntity.getId()));
        talentInfo.setName(preEntity.getName(), LocaleUtils.locale_l1);
        talentInfo.setName(preEntity.getName(), LocaleUtils.locale_l2);
        talentInfo.setName(preEntity.getName(), LocaleUtils.locale_l3);
        if (coreBaseinfo.containsKey("idCardAddress")) {
            talentInfo.setIdCardAddress(info.getIdCardAddress());
        }
        if (coreBaseinfo.containsKey("idCardBeginDate")) {
            talentInfo.setIdCardBeginDate(info.getIdCardBeginDate());
        }
        if (coreBaseinfo.containsKey("idCardEndDate")) {
            talentInfo.setIdCardEndDate(info.getIdCardEndDate());
        }
        if (coreBaseinfo.containsKey("idCardLongEffect")) {
            talentInfo.setIdCardLongEffect(info.isIdCardLongEffect());
        }
        if (coreBaseinfo.containsKey("idCardIssueOrg")) {
            talentInfo.setIdCardIssueOrg(info.getIdCardIssueOrg());
        }
        if (coreBaseinfo.containsKey("folk")) {
            talentInfo.setFolk(info.getFolk());
        }
        if (coreBaseinfo.containsKey("constellation")) {
            talentInfo.setConstellation(info.getConstellation());
        }
        if (coreBaseinfo.containsKey("zodiac")) {
            talentInfo.setZodiac(info.getZodiac());
        }
        if (!StringUtils.isEmpty((String)info.getIdCardNO())) {
            String idCardNo = IDCardCommonUtil.upperIdCardNo((String)info.getIdCardNO());
            info.setIdCardNO(idCardNo);
        }
        if (coreBaseinfo.containsKey("idCardNO")) {
            talentInfo.setIdCardNO(info.getIdCardNO());
        }
        if (coreBaseinfo.containsKey("passportNO")) {
            talentInfo.setPassportNO(info.getPassportNO());
        }
        if (coreBaseinfo.containsKey("gender")) {
            talentInfo.setGender(info.getGender());
        }
        if (coreBaseinfo.containsKey("birthday")) {
            talentInfo.setBirthday(info.getBirthday());
        }
        if (info.isIdCardLongEffect()) {
            talentInfo.setIdCardEndDate(null);
        }
        if (talentInfo.getPerson() == null || talentInfo.getPerson().getId() == null) {
            PersonInfo person = new PersonInfo();
            String personId = BOSUuid.create((BOSObjectType)person.getBOSType()).toString();
            person.setId(BOSUuid.read((String)personId));
            talentInfo.setPerson(person);
        }
        talentInfo.put(this.FROM_BILL, true);
        PreEntryPersonFactory.getLocalInstance(ctx).update((IObjectPK)preEntryPersonpk, talentInfo);
        String preEntryId = model.getString("id");
        String talentid = info.getId().toString();
        String cellPhone = preEntity.getCellPhone();
        String email = preEntity.getEmail();
        String ncell = preEntity.getNCell();
        String globalRoaming = preEntity.getGlobalRoaming();
        PEPersonContactCollection pecontactCol = PEPersonContactFactory.getLocalInstance(ctx).getPEPersonContactCollection("where talent.id = '" + talentid + "'");
        if (pecontactCol.size() > 0) {
            pecontact = pecontactCol.get(0);
            pecontact.setMobile(cellPhone);
            pecontact.setEmail(email);
            pecontact.setGlobalRoaming(globalRoaming);
            pecontact.setNCell(ncell);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("mobile"));
            sic.add(new SelectorItemInfo("email"));
            sic.add(new SelectorItemInfo("nCell"));
            sic.add(new SelectorItemInfo("globalRoaming"));
            PEPersonContactFactory.getLocalInstance(ctx).updatePartial(pecontact, sic);
        } else {
            pecontact = new PEPersonContactInfo();
            pecontact.setMobile(cellPhone);
            pecontact.setEmail(email);
            pecontact.setGlobalRoaming(globalRoaming);
            pecontact.setNCell(ncell);
            pecontact.setTalent(info);
            PEPersonContactFactory.getLocalInstance(ctx).addnew(pecontact);
        }
        IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "updateRecByPreService");
        HashMap<String, String> billParam = new HashMap<String, String>();
        billParam.put("preEntryId", pk.toString());
        imsf.process(ctx, billParam);
        if (!preEntity.isIsSSC() && preEntity.isIsSendLogin() && this.isTelChange(oldPreEntry, preEntity) && (result = this.synPreEntryResumeInit(ctx, preEntity)) != null && result.get("errcode") != null && (errorCode = ((Integer)result.get("errcode")).intValue()) != 0 && !"0".equals(errorCode) && 2 != errorCode && !"2".equals(errorCode)) {
            logger.error("PreEntryControllerBean._save()--->" + new PreentryException(PreentryException.SYNC_TSP_ERROR, new Object[]{errorCode}).getMessage());
        }
    }

    private void addEnrollCheckList(Context ctx, PreEntryPersonInfo model, String adminOrgId) {
        PreEntryPersonInfo pePerson = model;
        try {
            ArrayList<String> resultList = new ArrayList<String>();
            HROrgUnitInfo hrOrgUnitInfo = SHREmpOptBizManageTool.getManageHROByAdminOrg((Context)ctx, (String)adminOrgId);
            EnrollCheckBaseItemRelHRCollection enrollCheckBaseItemRelHRCol = EnrollCheckBaseItemRelHRFactory.getLocalInstance(ctx).getEnrollCheckBaseItemRelHRCollection("where hrOrgUse = '" + hrOrgUnitInfo.getId().toString() + "' and state=" + 100);
            for (int i = 0; i < enrollCheckBaseItemRelHRCol.size(); ++i) {
                EnrollCheckListInfo enrollCheckListInfo;
                if (enrollCheckBaseItemRelHRCol.get(i).getBaseInfoId() == null || (enrollCheckListInfo = EnrollCheckListFactory.getLocalInstance(ctx).getEnrollCheckListInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)enrollCheckBaseItemRelHRCol.get(i).getBaseInfoId())))).getBillType().getValue() != 1) continue;
                EnrollPersonCheckListInfo personCheckList = new EnrollPersonCheckListInfo();
                personCheckList.setTalent(pePerson);
                personCheckList.setCheckItem(enrollCheckListInfo);
                personCheckList.setChecked(false);
                String iopk = EnrollPersonCheckListFactory.getLocalInstance(ctx).addnew(personCheckList).toString();
                if (StringUtils.isEmpty((String)iopk)) continue;
                resultList.add(iopk);
            }
            int n = resultList.size();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK objectPK = this._save(ctx, model);
        this._setSubmited(ctx, ((PreEntryInfo)model).getId());
        return objectPK;
    }

    protected String getEntryEffectDateField() {
        return "preEnterDate";
    }

    protected void _auditEntryEffect(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            return;
        }
        PreEntryInfo preEntryInfo = this.getPreEntryInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        this._entryEffectCommon(ctx, billID);
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        if (ApproveTypeEnum.DIRECT.equals((Object)preEntryInfo.getApproveType())) {
            this.saveMultiApproveInfo(ctx, billID);
        }
    }

    private void saveMultiApproveInfo(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"0_HRBillBaseControllerBean", (Locale)ctx.getLocale()));
        info.setBillId(billID);
        info.setBosTypeStr(billID.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    protected void _entryEffectCommon(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (this.exists(ctx, (IObjectPK)new ObjectUuidPK(billId))) {
            PreEntryInfo preEntry = this.getPreEntryInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
            this.synPreEntryResumeInit(ctx, preEntry);
        }
    }

    private Map synPreEntryResumeInit(Context ctx, PreEntryInfo preEntry) {
        if (preEntry.isIsSendLogin()) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("method", "syncPreEntryResumeInit");
            param.put("preEntryInfo", preEntry);
            try {
                logger.error("====preEntityID =33333==" + preEntry.getId() + "  preEntity.isIsSSC = " + !preEntry.isIsSSC() + " ========preEntity.isIsSendLogin()=" + preEntry.isIsSendLogin() + "===preEntry==" + preEntry);
                Map resultMap = (Map)OSFAppUtil.callService((Context)ctx, (String)"shrCallTSPService", param);
                logger.error("====preEntityID =44444==" + preEntry.getId() + "  preEntity.isIsSSC = " + !preEntry.isIsSSC() + " ========resultMap=" + resultMap);
                return resultMap;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        return null;
    }

    protected SelectorItemCollection getEntrySelector() throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("talent.id"));
        selectors.add(new SelectorItemInfo("talent.fileState"));
        return selectors;
    }

    @Override
    protected void _billEffect(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        PreEntryInfo preEntryInfo = this.getPreEntryInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        HROrgUnitInfo hro = preEntryInfo.getHrOrgUnit();
        if (hro == null) {
            hro = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(rootHRO));
        }
        if (ContextUtil.getCurrentUserInfo((Context)ctx) == null) {
            UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUser("administrator");
            ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)user);
        }
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            ContextUtil.setCurrentHRUnit((Context)ctx, (HROrgUnitInfo)hro);
        }
        this._entryEffectCommon(ctx, billID);
    }

    protected String getEffectFunction() {
        return "com.kingdee.shr.preentry.app.PreEntryEffectFunction";
    }

    protected void updateBillState(Context ctx, BOSUuid billID, HRBillStateEnum state) throws BOSException, EASBizException {
        if (billID == null || state == null) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("billState"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("approveType"));
        selector.add(new SelectorItemInfo("auditor"));
        selector.add(new SelectorItemInfo("talent.id"));
        selector.add(new SelectorItemInfo("talent.fileState"));
        selector.add(new SelectorItemInfo("talent.name"));
        if (this.exists(ctx, (IObjectPK)new ObjectUuidPK(billID))) {
            PreEntryInfo preEntry = this.getPreEntryInfo(ctx, (IObjectPK)new ObjectUuidPK(billID), selector);
            preEntry.setBillState(state);
            if (state.equals((Object)HRBillStateEnum.SAVED) || state.equals((Object)HRBillStateEnum.SUBMITED)) {
                preEntry.setBizDate(null);
            } else {
                preEntry.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
            }
            if (ApproveTypeEnum.DIRECT.equals((Object)preEntry.getApproveType())) {
                preEntry.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            PreEntryPersonInfo talent = preEntry.getTalent();
            if (!preEntry.isIsSSC()) {
                switch (state.getValue()) {
                    case 0: {
                        talent.setFileState(FileStateEnum.TempStorage);
                        break;
                    }
                    case 1: {
                        talent.setFileState(FileStateEnum.Auditing);
                        break;
                    }
                    case 2: {
                        talent.setFileState(FileStateEnum.Auditing);
                        break;
                    }
                    case 3: {
                        talent.setFileState(FileStateEnum.Approved);
                        break;
                    }
                    case 4: {
                        talent.setFileState(FileStateEnum.Submitted);
                    }
                }
            } else {
                switch (state.getValue()) {
                    case 0: {
                        talent.setFileState(FileStateEnum.TempStorage);
                        break;
                    }
                    case 1: {
                        talent.setFileState(FileStateEnum.Submitted);
                        break;
                    }
                    case 2: {
                        talent.setFileState(FileStateEnum.Submitted);
                        break;
                    }
                    case 3: {
                        talent.setFileState(FileStateEnum.Approved);
                        break;
                    }
                    case 4: {
                        talent.setFileState(FileStateEnum.Submitted);
                    }
                }
            }
            this.updatePartial(ctx, preEntry, selector);
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("fileState"));
            PreEntryPersonFactory.getLocalInstance(ctx).updatePartial(talent, selector);
        }
    }

    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditEnd(ctx, billID);
        if (this.exists(ctx, (IObjectPK)new ObjectUuidPK(billID))) {
            PreEntryInfo preEntry = this.getPreEntryInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
            preEntry.setIsLatest(false);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isLatest"));
            PreEntryFactory.getLocalInstance(ctx).updatePartial(preEntry, selector);
            if (preEntry.isIsSendLogin()) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("method", "logOffTSPUser");
                param.put("preEntryInfo", preEntry);
                try {
                    OSFAppUtil.callService((Context)ctx, (String)"shrCallTSPService", param);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
    }

    protected void _abortBizBill(Context ctx, String billId) throws EASBizException, BOSException {
        super._abortBizBill(ctx, billId);
        try {
            PreEntryUtil.setNoSendNoticeMessageInRecords(ctx, billId);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error("_abortBizBill>>>setNoSendNoticeMessageInRecords>>>BOSException>>>:\n" + (Object)((Object)e));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.error("_abortBizBill>>>setNoSendNoticeMessageInRecords>>>EASBizException>>>:\n" + (Object)((Object)e));
        }
    }

    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._untiCheckBizBill(ctx, billId);
        try {
            PreEntryUtil.setNoSendNoticeMessageInRecords(ctx, billId);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error("_untiCheckBizBill>>>setNoSendNoticeMessageInRecords>>>BOSException>>>:\n" + (Object)((Object)e));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.error("_untiCheckBizBill>>>setNoSendNoticeMessageInRecords>>>EASBizException>>>:\n" + (Object)((Object)e));
        }
    }

    protected void _passUnaudit(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return;
        }
        String billID = billId.toString();
        PreEntryInfo preEntryInfo = this.getPreEntryInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
        Date now = new Date();
        Date effectDate = preEntryInfo.getPreEnterDate();
        if (effectDate != null) {
            if (now.after(effectDate)) {
                this.processAlreadyEffectUnAudit(ctx, preEntryInfo);
            } else {
                this.processUnEffectUnAudit(ctx, billID);
            }
        }
        this.processUnAuidtCommon(ctx, billID);
    }

    public void processAlreadyEffectUnAudit(Context ctx, HRBillBaseInfo model) throws EASBizException, BOSException {
        PreEntryInfo preEntryInfo = (PreEntryInfo)model;
        Date now = new Date();
        Date effectDate = preEntryInfo.getPreEnterDate();
        if (effectDate != null && !now.after(effectDate)) {
            this.dropJobProcess(ctx, "'" + model.getId().toString() + "'");
        }
        this.clearProcInstBizInfo(ctx, model);
    }

    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        return "'" + PreEntryFactory.getLocalInstance(ctx).getPreEntryInfo(pk).getId().toString() + "'";
    }

    private void dropJobProcess(Context ctx, String billEntryIdStr) throws EASBizException, BOSException {
        block8: {
            BillEntryJobProcessCollection bejpCol = BillEntryJobProcessFactory.getLocalInstance((Context)ctx).getBillEntryJobProcessCollection("where billEntryId in (" + billEntryIdStr + ")");
            StringBuffer jobProcessIdStr = new StringBuffer();
            int size = bejpCol.size();
            for (int i = 0; i < size; ++i) {
                BillEntryJobProcessInfo bejpInfo = bejpCol.get(i);
                jobProcessIdStr.append("'");
                jobProcessIdStr.append(bejpInfo.getJobProcessId());
                if (i == size - 1) {
                    jobProcessIdStr.append("'");
                    continue;
                }
                jobProcessIdStr.append("',");
            }
            if (jobProcessIdStr == null || jobProcessIdStr.length() == 0) {
                return;
            }
            IJobService jobService = JobServiceFactory.getLocalInstance((Context)ctx);
            String sql = "SELECT FID FROM T_JOB_Trigger WHERE FJobDefID in (" + jobProcessIdStr + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    rs.beforeFirst();
                    while (rs.next()) {
                        String triggerId = rs.getString(1);
                        jobService.disableTrigger(triggerId);
                    }
                    break block8;
                }
                throw new HRAffairException(HRAffairException.TRY_LATER_TIME);
            }
            catch (HRAffairException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void processUnAuidtCommon(Context ctx, String billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, BOSUuid.read((String)billID), HRBillStateEnum.SAVED);
        boolean isRollBackShowMultiApproveInfo = false;
        String paramNum = "IS_ROLLBACK_AFTER_SHOW_MULTIAPPROVEINFO";
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        HROrgUnitInfo hrOrgUnitIfo = model.getHrOrgUnit();
        String hrOrgUnitId = hrOrgUnitIfo.getId() == null ? null : hrOrgUnitIfo.getId().toString();
        isRollBackShowMultiApproveInfo = HRParamUtil.getParamOfHR((Context)ctx, (String)paramNum, (String)hrOrgUnitId);
        if (!isRollBackShowMultiApproveInfo) {
            MultiApproveFactory.getLocalInstance((Context)ctx).delete("WHERE billId = '" + billID + "'");
        }
    }

    protected void _check(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._check(ctx, pk, model);
    }

    protected void checkHRBillWorkFlowIsEdit(Context ctx, HRBillBaseInfo info, HRBillStateEnum oldBillState) throws BOSException, EASBizException {
        PreEntryInfo preEntry = (PreEntryInfo)info;
        if (preEntry.isIsSSC()) {
            PreEntryPersonInfo entryPersonInfo = preEntry.getTalent();
            PreEntryPersonInfo oldPersonValue = PreEntryPersonFactory.getLocalInstance(ctx).getPreEntryPersonInfo((IObjectPK)new ObjectUuidPK(entryPersonInfo.getId()));
            FileStateEnum oldfileState = oldPersonValue.getFileState();
            if (FileStateEnum.Submitted.equals((Object)oldfileState) || FileStateEnum.Approved.equals((Object)oldfileState) || FileStateEnum.Auditing.equals((Object)oldfileState) || FileStateEnum.Reject.equals((Object)oldfileState)) {
                if (preEntry.getId() != null) {
                    boolean jobCanEdit = ActivityProcessExecuteFacadeFactory.getLocalInstance((Context)ctx).checkCanEdit(preEntry.getId().toString());
                    if (jobCanEdit) {
                        return;
                    }
                    throw new PreentryException(PreentryException.PREENTRY_FILESTATE_CANNOT_EDIT, new Object[]{oldfileState.getAlias()});
                }
                throw new PreentryException(PreentryException.PREENTRY_FILESTATE_CANNOT_EDIT, new Object[]{oldfileState.getAlias()});
            }
        } else {
            super.checkHRBillWorkFlowIsEdit(ctx, info, oldBillState);
        }
    }

    @Override
    protected void _updateModify(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
        try {
            PEPersonContactInfo pecontact;
            PreEntryInfo preEntry = (PreEntryInfo)model;
            PreEntryInfo preEntryInfo = PreEntryFactory.getLocalInstance(ctx).getPreEntryInfo(pk);
            ObjectUuidPK preEntryPersonpk = new ObjectUuidPK(preEntryInfo.getTalent().getId());
            PreEntryPersonInfo preEntryPersonInfo = PreEntryPersonFactory.getLocalInstance(ctx).getPreEntryPersonInfo((IObjectPK)preEntryPersonpk);
            PreEntryPersonInfo talent = (PreEntryPersonInfo)model.get("talent");
            preEntryPersonInfo.setName(preEntry.getName());
            preEntryPersonInfo.setIdCardNO(talent.getIdCardNO());
            preEntryPersonInfo.setPassportNO(talent.getPassportNO());
            preEntryPersonInfo.setGender(talent.getGender());
            preEntryPersonInfo.setBirthday(talent.getBirthday());
            preEntryPersonInfo.setAge(talent.getAge());
            if (preEntryPersonInfo.getPerson() == null || preEntryPersonInfo.getPerson().getId() == null) {
                PersonInfo person = new PersonInfo();
                String personId = BOSUuid.create((BOSObjectType)person.getBOSType()).toString();
                person.setId(BOSUuid.read((String)personId));
                preEntryPersonInfo.setPerson(person);
            }
            PreEntryPersonFactory.getLocalInstance(ctx).update((IObjectPK)preEntryPersonpk, preEntryPersonInfo);
            preEntryInfo.setName(preEntry.getName());
            preEntryInfo.setPosition(preEntry.getPosition());
            preEntryInfo.setCellPhone(preEntry.getCellPhone());
            preEntryInfo.setNCell(preEntry.getNCell());
            preEntryInfo.setGlobalRoaming(preEntry.getGlobalRoaming());
            preEntryInfo.setEmail(preEntry.getEmail());
            preEntryInfo.setAdminOrg(preEntry.getAdminOrg());
            preEntryInfo.setHrOrgUnit(preEntry.getHrOrgUnit());
            preEntryInfo.setPreEnterDate(preEntry.getPreEnterDate());
            preEntryInfo.setEntryType(preEntry.getEntryType());
            preEntryInfo.setRemark(preEntry.getRemark());
            preEntryInfo.setIsSendLogin(preEntry.isIsSendLogin());
            PreEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(preEntryInfo.getId()), preEntryInfo);
            String cellPhone = preEntry.getCellPhone();
            String email = preEntry.getEmail();
            PEPersonContactCollection pecontactCol = PEPersonContactFactory.getLocalInstance(ctx).getPEPersonContactCollection("where talent.id = '" + preEntryInfo.getTalent().getId().toString() + "'");
            if (pecontactCol.size() > 0) {
                pecontact = pecontactCol.get(0);
                pecontact.setMobile(cellPhone);
                pecontact.setEmail(email);
                pecontact.setNCell(preEntry.getNCell());
                pecontact.setGlobalRoaming(preEntry.getGlobalRoaming());
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("mobile"));
                sic.add(new SelectorItemInfo("email"));
                sic.add(new SelectorItemInfo("nCell"));
                sic.add(new SelectorItemInfo("globalRoaming"));
                PEPersonContactFactory.getLocalInstance(ctx).updatePartial(pecontact, sic);
            } else {
                pecontact = new PEPersonContactInfo();
                pecontact.setMobile(cellPhone);
                pecontact.setEmail(email);
                pecontact.setTalent(preEntryPersonInfo);
                PEPersonContactFactory.getLocalInstance(ctx).addnew(pecontact);
            }
            IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "updateRecByPreService");
            HashMap<String, String> billParam = new HashMap<String, String>();
            billParam.put("preEntryId", pk.toString());
            imsf.process(ctx, billParam);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IPreEntryPerson iPreEntryPerson = PreEntryPersonFactory.getLocalInstance(ctx);
        IPreEntry iPreEntry = PreEntryFactory.getLocalInstance(ctx);
        IPreMessageRecord iPreMessage = PreMessageRecordFactory.getLocalInstance(ctx);
        IPreEntryBizDiary iPreEntryBizDiary = PreEntryBizDiaryFactory.getLocalInstance(ctx);
        String preEntryId = pk.toString();
        PreEntryInfo preEntryInfo = iPreEntry.getPreEntryInfo("where id='" + preEntryId + "' ");
        iPreEntryPerson.delete("where id='" + preEntryInfo.getTalent().getId().toString() + "'");
        iPreMessage.delete("where preEntry.id = '" + preEntryId + "'");
        iPreEntryBizDiary.delete("where preEntryRec.id = '" + preEntryId + "'");
        HashMap<String, Object> osfparam = new HashMap<String, Object>();
        osfparam.put("preEntryId", preEntryId);
        osfparam.put("oper", 3);
        OSFAppUtil.callService((Context)ctx, (String)"changeOfferStateService", osfparam);
        PreEntryPageDataSetCollection preEntryPageDataSetCollection = PreEntryPageDataSetFactory.getLocalInstance(ctx).getPreEntryPageDataSetCollection("where id <> 'iQe+EQg0KkS0ce1Heb4VxpbhrwM='");
        int count = preEntryPageDataSetCollection.size();
        for (int i = 0; i < count; ++i) {
            String relateEntityName;
            StructureConfigInfo entityStructureConfigInfo;
            String entityName;
            PreEntryPageDataSetInfo preEntryPageDataSetInfo = preEntryPageDataSetCollection.get(i);
            StructureConfigInfo entityInfoSet = preEntryPageDataSetInfo.getEntityInfoSet();
            if (entityInfoSet == null || PreEntryControllerBean.isEmpty(entityName = (entityStructureConfigInfo = StructureConfigFactory.getLocalInstance((Context)ctx).getStructureConfigInfo((IObjectPK)new ObjectUuidPK(entityInfoSet.getId()))).getEntityName()) || (relateEntityName = preEntryPageDataSetInfo.getRelateEntityName()) == null) continue;
            try {
                ICoreBase entityBizInterface = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                entityBizInterface.delete("where talent='" + preEntryInfo.getTalent().getId().toString() + "'");
                continue;
            }
            catch (IllegalStateException e) {
                throw new PreentryException(PreentryException.ENTITYNAME_ERROR, new Object[]{preEntryPageDataSetInfo.getName()});
            }
        }
        super._delete(ctx, pk);
    }

    private static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    protected void _checkNumDup(Context ctx, HRBillBaseInfo info) throws BOSException, EASBizException {
        if (super._exists(ctx, "where number = '" + info.getNumber() + "'")) {
            String alias = "";
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(info.getBOSType());
            alias = entityInfo.getAlias();
            throw new PreentryException(PreentryException.EXIST_MODIFY, new Object[]{info.getString("number")});
        }
    }

    private boolean isTelChange(PreEntryInfo oldPreEntry, PreEntryInfo preEntity) {
        boolean isChange = false;
        isChange = preEntity.getNCell() != null && oldPreEntry.getNCell() != null ? !preEntity.getNCell().equals(oldPreEntry.getNCell()) : preEntity.getNCell() != oldPreEntry.getNCell();
        if (!isChange) {
            isChange = preEntity.getEmail() != null && oldPreEntry.getEmail() != null ? !preEntity.getEmail().equals(oldPreEntry.getEmail()) : preEntity.getEmail() != oldPreEntry.getEmail();
        }
        return isChange;
    }

    @Deprecated
    protected void setCustomFieldValue(Context ctx, PreEntryPersonInfo talentInfo, PreEntryPersonInfo info, PreEntryInfo preEntryInfo) throws EASBizException {
        String entityName = "com.kingdee.shr.preentry.app.PreEntryPerson";
        if (info == null || talentInfo == null) {
            return;
        }
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection collection = entityInfo.getInheritedNoDuplicatedProperties();
        LinkedHashMap<String, PropertyInfo> entityProperties = new LinkedHashMap<String, PropertyInfo>();
        PropertyInfo propertyInfo = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            propertyInfo = collection.get(i);
            entityProperties.put(propertyInfo.getName(), propertyInfo);
        }
        List filedList = (List)preEntryInfo.get("fildList");
        for (Map.Entry entry : entityProperties.entrySet()) {
            String key = (String)entry.getKey();
            PropertyInfo proValue = (PropertyInfo)entry.getValue();
            if (!proValue.isConfigured() || filedList == null || !filedList.contains("talent." + key)) continue;
            talentInfo.put(key, info.get(key));
        }
    }

    protected void setTalentFieldValue(Context ctx, PreEntryPersonInfo talentInfo, PreEntryPersonInfo info, PreEntryInfo preEntity) throws EASBizException {
        if (info == null || talentInfo == null || preEntity == null) {
            return;
        }
        String entityName = "com.kingdee.shr.preentry.app.PreEntryPerson";
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        List filedList = (List)preEntity.get("fildList");
        if (null != filedList) {
            for (int i = 0; i < filedList.size(); ++i) {
                String filed = (String)filedList.get(i);
                if (filed == null || !filed.startsWith("talent.") || "id".equalsIgnoreCase(filed = filed.substring("talent.".length())) || "fileState".equalsIgnoreCase(filed) || "person".equalsIgnoreCase(filed)) continue;
                PropertyInfo property = entityInfo.getPropertyByName(filed);
                if (property instanceof OwnPropertyInfo && ((OwnPropertyInfo)property).isMultilingual()) {
                    MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)info, (String)filed, (IObjectValue)talentInfo, (String)filed);
                    continue;
                }
                talentInfo.put(filed, info.get(filed));
            }
        }
    }

    protected void checkCredentialsType(Context ctx, PreEntryInfo entryInfo) throws EASBizException, BOSException {
        String excludePreEntryBillID;
        PreEntryPersonInfo preEntryPerson = entryInfo.getTalent();
        String credentialsNO = preEntryPerson.getPassportNO();
        String string = excludePreEntryBillID = entryInfo.getId() == null ? "" : entryInfo.getId().toString();
        if (!StringUtils.isEmpty((String)credentialsNO)) {
            SHREmpCheckCredentialsTypeUtil.checkCredentialsTypeNOExist((Context)ctx, (String)credentialsNO, (String)excludePreEntryBillID, null, null, null);
        }
    }

    public int calculateAge(Date birthday) {
        Date birthDate = birthday;
        Date endDate = DateTimeUtils.truncateDate((Date)new Date());
        int yearValue = DateTimeUtils.getYear((Date)endDate) - DateTimeUtils.getYear((Date)birthDate);
        int tempValue = 0;
        int birthMonth = DateTimeUtils.getMonth((Date)birthDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int birthDay = DateTimeUtils.getDay((Date)birthDate);
        int endDay = DateTimeUtils.getDay((Date)endDate);
        tempValue = endMonth < birthMonth ? -1 : (endMonth > birthMonth ? 0 : (endDay < birthDay ? -1 : 0));
        int result = yearValue + tempValue;
        return result;
    }

    protected void checkJobLevelGradeRange(Context ctx, PreEntryInfo billInfo) throws EASBizException, BOSException {
        boolean isRelatePositionJobRange = HRParamUtil.isRelatePositionJobRange((Context)ctx);
        JobLevelInfo jobLevel = billInfo.getJobLevel();
        JobGradeInfo jobGrade = billInfo.getJobGrade();
        if (jobLevel != null) {
            jobLevel = JobLevelFactory.getLocalInstance((Context)ctx).getJobLevelInfo((IObjectPK)new ObjectUuidPK(jobLevel.getId()));
        }
        if (jobGrade != null) {
            jobGrade = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(jobGrade.getId()));
        }
        if (isRelatePositionJobRange) {
            PositionInfo posInfo = billInfo.getPosition();
            if (posInfo == null || posInfo.getId() == null) {
                return;
            }
            EmpPostRankUtil.checkJobLevelGradeRangeInPosition((Context)ctx, (JobLevelInfo)jobLevel, (JobGradeInfo)jobGrade, (String)posInfo.getId().toString());
        } else {
            if (billInfo.getHrOrgUnit() == null || billInfo.getHrOrgUnit().getId() == null) {
                return;
            }
            String hrOrgId = billInfo.getHrOrgUnit().getId().toString();
            EmpPostRankUtil.checkJobLevelGradeRangeInHrOrg((Context)ctx, (JobLevelInfo)jobLevel, (JobGradeInfo)jobGrade, (String)hrOrgId);
        }
    }
}

