/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.preentry.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.CheckInState;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.preentry.IPreEntryPerson;
import com.kingdee.shr.preentry.IPreSendMsgRecords;
import com.kingdee.shr.preentry.PreEntryCollection;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.shr.preentry.PreEntryPersonCollection;
import com.kingdee.shr.preentry.PreEntryPersonFactory;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.shr.preentry.PreSendMsgRecordsFactory;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreEntryUtil {
    public static final Logger logger = LoggerFactory.getLogger(PreEntryUtil.class);
    public static final String CACHE_TYPE = "shr.preentryCache";
    public static final String CACHE_KEY_UPDATE_PREENTRY_NUM = "updatingPreentryNum";
    public static final String CACHE_VAL_UPDATING = "updating";

    public static PreEntryInfo setPrePersonEnrolled(Context ctx, String enrollEntryId) throws BOSException, EASBizException {
        PreEntryCollection coll = PreEntryFactory.getLocalInstance(ctx).getPreEntryCollection("select checkInState where personBillId = '" + enrollEntryId + "'");
        if (coll.size() > 0) {
            PreEntryInfo preEntryInfo = coll.get(0);
            preEntryInfo.setCheckInState(CheckInState.HAS_CHECKED_IN);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("checkInState"));
            PreEntryFactory.getLocalInstance(ctx).updatePartial(preEntryInfo, selectors);
            return preEntryInfo;
        }
        return null;
    }

    public static PreEntryInfo setPrePersonUnenrolled(Context ctx, String enrollEntryId) throws BOSException, EASBizException {
        PreEntryCollection coll = PreEntryFactory.getLocalInstance(ctx).getPreEntryCollection("select checkInState where personBillId = '" + enrollEntryId + "'");
        if (coll.size() > 0) {
            PreEntryInfo preEntryInfo = coll.get(0);
            preEntryInfo.setCheckInState(CheckInState.NOT_CHECKED_IN);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("checkInState"));
            PreEntryFactory.getLocalInstance(ctx).updatePartial(preEntryInfo, selectors);
            return preEntryInfo;
        }
        return null;
    }

    public static void updatePreEntryWhileDeleteEnrollBill(Context ctx, String enrollBillId) throws BOSException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("personBillId"));
        StringBuilder sql = new StringBuilder("update T_HR_PreEntry set FPersonBillId = null, ").append("FIsGenerateEntryBill = 0,");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo != null && userInfo.getId() != null) {
            sql.append("FLastUpdateUserId = '").append(userInfo.getId().toString()).append("',");
        }
        sql.append("FLastUpdateTime = ").append(HRUtilExtend.getDateStringWithMinuteTs((Date)new Date())).append(" where FPersonBillId in (").append("select Fid from T_HR_EmpEnrollBizBillEntry where FBillID = '").append(enrollBillId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void updatePreEntryWhileDeleteEnrollEntry(Context ctx, String enrollEntryId) throws EASBizException, BOSException {
        PreEntryCollection coll = PreEntryFactory.getLocalInstance(ctx).getPreEntryCollection("select personBillId,isGenerateEntryBill where personBillID = '" + enrollEntryId + "'");
        if (coll.size() > 0) {
            PreEntryInfo preEntry = coll.get(0);
            preEntry.setIsGenerateEntryBill(false);
            preEntry.setPersonBillId(null);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("personBillId"));
            selectors.add(new SelectorItemInfo("isGenerateEntryBill"));
            PreEntryFactory.getLocalInstance(ctx).updatePartial(preEntry, selectors);
        }
    }

    public static void updatePreEntryBillField(Context ctx, String preEntryID, String enrollEntryId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)preEntryID)) {
            return;
        }
        PreEntryCollection coll = PreEntryFactory.getLocalInstance(ctx).getPreEntryCollection("select personBillId,isGenerateEntryBill where id = '" + preEntryID + "'");
        if (coll.size() > 0) {
            PreEntryInfo preEntry = coll.get(0);
            preEntry.setIsGenerateEntryBill(true);
            preEntry.setPersonBillId(enrollEntryId);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("personBillId"));
            selectors.add(new SelectorItemInfo("isGenerateEntryBill"));
            PreEntryFactory.getLocalInstance(ctx).updatePartial(preEntry, selectors);
        }
    }

    public static PreEntryInfo getPreEntryInfo(Context ctx, String preEntryID) throws BOSException {
        PreEntryCollection coll = PreEntryFactory.getLocalInstance(ctx).getPreEntryCollection("select *,talent.* where id = '" + preEntryID + "'");
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public static void setNoSendNoticeMessageInRecords(Context ctx, String billId) throws BOSException, EASBizException {
        IPreSendMsgRecords recordsInstance = PreSendMsgRecordsFactory.getLocalInstance(ctx);
        if (recordsInstance.exists("select id where bill='" + billId + "'")) {
            String updateSql = "update t_hr_presendmsgrecords set FNoticeIsSend= {0},FMessageIsSend= {1},FLastUpdateUserId= {2},FLastUpdateTime = {3} where FBillId= {4}";
            String lastUpdateUserID = "'" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "'";
            String curDateTs = HRUtilExtend.getDateStringWithMinuteTs((Date)new Date());
            String billIdStr = "'" + billId.toString() + "'";
            updateSql = MessageFormat.format(updateSql, 0, 0, lastUpdateUserID, curDateTs, billIdStr);
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    public static void clearPreentryPersonRealPerson(Context ctx, String enrollPersonId) throws BOSException, EASBizException {
        IPreEntryPerson iPreEntryPerson = PreEntryPersonFactory.getLocalInstance(ctx);
        PreEntryPersonCollection coll = iPreEntryPerson.getPreEntryPersonCollection("select realPersonId where realPersonId = '" + enrollPersonId + "' ");
        logger.error("PreEntryUtil.clearPreentryPersonRealPerson coll.size() : " + coll.size());
        if (coll.size() > 0) {
            PreEntryPersonInfo info = coll.get(0);
            info.put("isFromEmp", Boolean.TRUE);
            info.setRealPersonId(null);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("realPersonId"));
            logger.error("PreEntryUtil.clearPreentryPersonRealPerson before info : " + info);
            iPreEntryPerson.updatePartial(info, selectors);
            logger.error("PreEntryUtil.clearPreentryPersonRealPerson after info : " + info);
        }
    }
}

