/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.socialSecurity.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SqlUtil;
import com.kingdee.shr.socialSecurity.SocPayInfo;
import com.kingdee.shr.socialSecurity.app.AbstractSocPayControllerBean;
import com.kingdee.shr.socialSecurity.app.SocPayPropertyCollection;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import org.apache.log4j.Logger;

public class SocPayControllerBean
extends AbstractSocPayControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.socialSecurity.app.SocPayControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            SocPayInfo socPayInfo = null;
            socPayInfo = (SocPayInfo)model;
            this.beforeSave(ctx, socPayInfo);
            if (socPayInfo.getId() != null) {
                return super._save(ctx, (IObjectValue)socPayInfo);
            }
            return super._addnew(ctx, (IObjectValue)socPayInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
    }

    protected void _checkNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNumberBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    public String getCurrentUserAdminRangeSqlAndCalOrgInUserAdminRang(Context ctx, String permItemId) {
        String userID = HRFilterUtils.getCurrentUserId((Context)ctx);
        return this.getUserAdminRangeSqlAndCalOrgInUserAdminRang(ctx, userID, permItemId);
    }

    public String getUserAdminRangeSqlAndCalOrgInUserAdminRang(Context ctx, String userID, String permItemId) {
        String orgRangeSql = HRFilterUtils.getUserAdminRangeSql((Context)ctx, (String)userID, (String)permItemId);
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FPersonID from T_HR_EmpOrgRelation where FAdminOrgID in (");
        sql.append(orgRangeSql);
        sql.append(") or ");
        sql.append(" FPersonID in (select FPersonID from T_HR_SCmpCalOrg  where FCluOrgID in (" + orgRangeSql + "))");
        return sql.toString();
    }

    public boolean isNullOrEmpty(Object ... objs) {
        boolean flag = false;
        for (Object o : objs) {
            if (o != null && !StringUtils.isEmpty((String)String.valueOf(o))) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo baseInfo = (CoreBaseInfo)model;
        if (!CmpStrUtil.isNullOrEmpty((Object[])new Object[]{baseInfo.get("isImport")})) {
            SocPayInfo tempSocPayInfo = (SocPayInfo)model;
            try {
                this.beforeSave(ctx, tempSocPayInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super._update(ctx, pk, model);
    }

    private void beforeSave(Context ctx, SocPayInfo socPayInfo) throws Exception {
        this.setOtherProps(socPayInfo);
    }

    private void setOtherProps(SocPayInfo socPayInfo) throws Exception {
        String[] personTotalProps = SocPayPropertyCollection.personTotalProps;
        socPayInfo.setPersonalTotal(SocPayPropertyCollection.getTotal(personTotalProps, socPayInfo));
        String[] unitTotalProps = SocPayPropertyCollection.unitTotalProps;
        socPayInfo.setUnitTotal(SocPayPropertyCollection.getTotal(unitTotalProps, socPayInfo));
        String[] socPersonTotalProps = SocPayPropertyCollection.socPersonTotalProps;
        socPayInfo.setSocPersonTotal(SocPayPropertyCollection.getTotal(socPersonTotalProps, socPayInfo));
        String[] socUnitTotalProps = SocPayPropertyCollection.socUnitTotalProps;
        socPayInfo.setSocUnitTotal(SocPayPropertyCollection.getTotal(socUnitTotalProps, socPayInfo));
        socPayInfo.setReceivableTotal(socPayInfo.getPersonalTotal().add(socPayInfo.getUnitTotal()));
    }

    private void setPersonInfoProps(Context ctx, SocPayInfo socPayInfo) throws Exception {
        FilterInfo filter = new FilterInfo();
        Date nowDate = DateTimeUtils.truncateDate((Date)new Date());
        filter.getFilterItems().add(new FilterItemInfo("T_HR_EmpOrgRelation.FEFFDT", (Object)nowDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("T_HR_EmpOrgRelation.FLEFFDT", (Object)nowDate, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("T_HR_SSocEmpSocFiles.FEffectDay", (Object)nowDate, CompareType.LESS_EQUALS));
        StringBuilder sql = new StringBuilder();
        sql.append(" select top 1 T_HR_SSocEmpSocFiles.FPersonID personID,T_HR_SSocEmpSocFiles.FSocAccount socAccount");
        sql.append(" ,T_HR_SSocEmpSocFiles.FHouseFundAccount houseFundAccount,T_HR_EmpOrgRelation.FAdminOrgID adminOrgID");
        sql.append(" ,T_BD_Person.FIDCardNO idCardNO");
        sql.append(" from T_HR_SSocEmpSocFiles");
        sql.append(" left join T_HR_EmpOrgRelation on T_HR_EmpOrgRelation.FPersonID = T_HR_SSocEmpSocFiles.FPersonID and FAssignType = 1");
        sql.append(" left join T_BD_Person on T_BD_Person.FID = T_HR_SSocEmpSocFiles.FPersonID");
        sql.append(" where ");
        sql.append(filter.toSql());
        sql.append(" and T_HR_SSocEmpSocFiles.FPersonID in (");
        sql.append(this.getCurrentUserAdminRangeSqlAndCalOrgInUserAdminRang(ctx));
        sql.append(")");
        sql.append(" and ( T_HR_SSocEmpSocFiles.FSocAccount = '" + socPayInfo.getSocAccount() + "'");
        sql.append(" or T_HR_SSocEmpSocFiles.FHouseFundAccount = '" + socPayInfo.getFundAccount() + "'");
        sql.append(" or T_BD_Person.FIDCardNO ='" + socPayInfo.getIdCard() + "')");
        IRowSet executeQuery = SqlUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (executeQuery.next()) {
            String personid = executeQuery.getString("personID");
            String idCardNO = executeQuery.getString("idCardNO");
            String socAccount = executeQuery.getString("socAccount");
            String houseFundAccount = executeQuery.getString("houseFundAccount");
            String adminOrgID = executeQuery.getString("adminOrgID");
            if (socPayInfo.getPerson() == null) {
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)personid));
                socPayInfo.setPerson(person);
            }
            if (socPayInfo.getAdminOrg() == null) {
                AdminOrgUnitInfo admin = new AdminOrgUnitInfo();
                admin.setId(BOSUuid.read((String)adminOrgID));
                socPayInfo.setAdminOrg(admin);
            }
            if (StringUtils.isEmpty((String)socPayInfo.getIdCard())) {
                socPayInfo.setIdCard(idCardNO);
            }
            if (StringUtils.isEmpty((String)socPayInfo.getSocAccount())) {
                socPayInfo.setSocAccount(socAccount);
            }
            if (!StringUtils.isEmpty((String)socPayInfo.getFundAccount())) continue;
            socPayInfo.setFundAccount(houseFundAccount);
        }
    }

    public String getCurrentUserAdminRangeSqlAndCalOrgInUserAdminRang(Context ctx) {
        String userID = HRFilterUtils.getCurrentUserId((Context)ctx);
        return this.getUserAdminRangeSqlAndCalOrgInUserAdminRang(ctx, userID);
    }

    public String getUserAdminRangeSqlAndCalOrgInUserAdminRang(Context ctx, String userID) {
        String orgRangeSql = HRFilterUtils.getUserAdminRangeSql((Context)ctx, (String)userID, (String)"93ae78e4-c7c8-45f3-8267-ce5ecdb3df7bPERMITEM");
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FPersonID from T_HR_EmpOrgRelation where FAdminOrgID in (");
        sql.append(orgRangeSql);
        sql.append(") or ");
        sql.append(" FPersonID in (select FPersonID from T_HR_SCmpCalOrg  where FCluOrgID in (" + orgRangeSql + "))");
        return sql.toString();
    }
}

