/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service.classloader;

import com.kingdee.bos.bsf.service.classloader.ComponentLibScanHelper;
import com.kingdee.bos.bsf.service.classloader.CreateClassPathJar;
import com.kingdee.bos.bsf.service.classloader.LibPackeInfo;
import com.kingdee.bos.bsf.service.classloader.PackageGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class SHRMSFClassLoader
extends ClassLoader {
    private final Logger logger = Logger.getLogger(SHRMSFClassLoader.class);
    protected Hashtable<String, File> packageCache = new Hashtable();
    protected Hashtable<String, JarFile> jarFileCache = new Hashtable();
    protected Properties packageToJarMap = new Properties();
    protected Properties platePackageToJarMap = new Properties();
    protected Hashtable<String, Class<?>> classCache = new Hashtable();
    protected ClassLoader currentClassLoader;
    protected ClassLoader parentClassLoader;

    public SHRMSFClassLoader(ClassLoader loader) {
        super(loader);
        this.parentClassLoader = loader;
        long t1 = System.currentTimeMillis();
        this.init();
        this.logger.debug((Object)"KDSHRClassLoader --------------------- register successful!");
        long t2 = System.currentTimeMillis();
        this.logger.debug((Object)("KDSHRClassLoader init --------------------- cost :" + (t2 - t1)));
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    public ClassLoader getCurrentClassLoader() {
        return this.currentClassLoader;
    }

    public void setCurrentClassLoader(ClassLoader currentClassLoader) {
        this.currentClassLoader = currentClassLoader;
    }

    private void init() {
        ComponentLibScanHelper helper = new ComponentLibScanHelper();
        String shrPath = helper.scan();
        this.packageToJarMap = (Properties)this.platePackageToJarMap.clone();
        LibPackeInfo libPackInfo = PackageGenerator.libToPackage(shrPath, this.packageToJarMap);
        this.packageCache.putAll(libPackInfo.getPackageCache());
        this.jarFileCache.putAll(libPackInfo.getJarFileCache());
    }

    private String getDefaultPath() {
        return CreateClassPathJar.generateClassPath(FilenameUtils.normalize((String)System.getProperty("EAS_HOME")));
    }

    public void reloadLib() {
        ComponentLibScanHelper helper = new ComponentLibScanHelper();
        String shrPath = helper.scan();
        this.packageToJarMap = (Properties)this.platePackageToJarMap.clone();
        LibPackeInfo libPackInfo = PackageGenerator.libToPackage(this.getDefaultPath(), this.packageToJarMap);
        libPackInfo = PackageGenerator.libToPackage(shrPath, this.packageToJarMap);
        this.packageCache.putAll(libPackInfo.getPackageCache());
        this.jarFileCache.putAll(libPackInfo.getJarFileCache());
    }

    @Override
    public Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        if (className == null) {
            this.logger.error((Object)("Illegal argument: className = [" + className + "].return null."));
            return null;
        }
        c = this.smartLoadClass(className);
        if (c != null) {
            this.logger.debug((Object)("[CL_DEBUG] Class[" + className + "] was loaded in shrmsfclassloader!"));
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        this.logger.debug((Object)("[CL_WARN]  Class[" + className + "] not found in shrmsfclassloader!"));
        throw new ClassNotFoundException("Class[" + className + "] not found in shrmsfclassloader!");
    }

    private void log(String log) {
        this.logger.debug((Object)log);
    }

    private Class<?> smartLoadClass(String className) {
        Class<?> c = this.findLoadedClass(className);
        if (c != null) {
            this.logger.debug((Object)("[CL_DEBUG] Class[" + className + "] is already loaded!"));
            return c;
        }
        c = this.classCache.get(className);
        if (c != null) {
            this.logger.debug((Object)("[CL_DEBUG] Class[" + className + "] was loaded from shrmsfclassloader's cache!"));
            return c;
        }
        this.logger.debug((Object)("[CL_DEBUG] Class[" + className + "] is not loaded yet, try to load it from parent ..."));
        try {
            c = this.getParent().loadClass(className);
        }
        catch (ClassNotFoundException cnfex) {
            this.logger.debug((Object)("[CL_DEBUG] Class[" + className + "] is not found in parent classloader!"));
        }
        catch (NoClassDefFoundError e) {
            this.logger.debug((Object)("[CL_DEBUG] Class[" + className + "] is not found in parent classloader!"));
        }
        if (c != null) {
            this.logger.debug((Object)("[CL_DEBUG] Class[" + className + "] was loaded from parent classloader!"));
            this.classCache.put(className, c);
            return c;
        }
        String clsName = className.replace('.', '/') + ".class";
        this.logger.debug((Object)("[CL_DEBUG] Class[" + className + "] is not found in classes directory, try to load it from jars ..."));
        c = (Class<?>)this.loadFromJarList(className, clsName);
        if (c != null) {
            this.log("[CL_DEBUG] Class[" + className + "] was loaded from jar[" + c.getProtectionDomain().getCodeSource() + "]!");
            this.classCache.put(className, c);
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object loadFromJarList(String className, String resName) {
        String packageName = resName;
        if (resName.indexOf(47) > 0) {
            packageName = resName.substring(0, resName.lastIndexOf(47));
        }
        this.log("[CL_DEBUG] Begin check package [" + packageName + "] .....");
        String libList = this.packageToJarMap.getProperty(packageName, "");
        if (libList.length() <= 0) {
            return null;
        }
        String[] libs = libList.split(";");
        for (int i = 0; i < libs.length; ++i) {
            try {
                File fileUrl = this.packageCache.get(libs[i]);
                if (fileUrl == null) {
                    this.logger.error((Object)("[CL_DEBUG] package not found[" + libs[i] + "] ..."));
                }
                if (fileUrl == null) continue;
                Object res = null;
                String jarFilePath = fileUrl.getCanonicalPath();
                if (fileUrl.getName().endsWith(".zip") || fileUrl.getName().endsWith(".jar")) {
                    ZipEntry clsEntry;
                    JarFile jarFile;
                    block30: {
                        jarFile = this.jarFileCache.get(libs[i]);
                        if (jarFile == null) {
                            try {
                                jarFile = new JarFile(fileUrl);
                                this.jarFileCache.put(libs[i], jarFile);
                            }
                            catch (ZipException e) {
                                this.log("[CL_ERR]   Error in opening zip file[" + libs[i] + "], download again!");
                                if (fileUrl.delete()) {
                                    jarFile = new JarFile(fileUrl);
                                    break block30;
                                }
                                this.logger.error((Object)("[CL_ERR]   Error in delete zip file[" + libs[i] + "]!"));
                                throw new RuntimeException("Class can load from jarfile[" + libs[i] + "], is not a jar file!", e);
                            }
                            finally {
                                if (jarFile != null) {
                                    jarFile.close();
                                }
                            }
                        }
                    }
                    if ((clsEntry = jarFile.getEntry(resName)) == null) {
                        this.log("[CL_TRACE] Resource[" + resName + "] not found jar[" + jarFilePath + "]!");
                    } else if (className != null) {
                        InputStream clsInputStream = jarFile.getInputStream(clsEntry);
                        Manifest manifest = jarFile.getManifest();
                        res = manifest == null ? null : this.defindClassFromFile(className, clsInputStream, jarFilePath);
                    } else {
                        res = new URL("jar:file:" + jarFilePath + "!/" + resName);
                    }
                } else {
                    FileInputStream fis;
                    if (fileUrl.isDirectory()) {
                        fis = null;
                        try {
                            File classFile = new File(fileUrl.getAbsolutePath() + "/" + resName);
                            if (!classFile.exists()) continue;
                            fis = new FileInputStream(classFile);
                            res = this.defindClassFromFile(className, fis, jarFilePath);
                        }
                        finally {
                            if (fis != null) {
                                ((InputStream)fis).close();
                            }
                        }
                    }
                    fis = null;
                    try {
                        fis = new FileInputStream(fileUrl);
                        res = this.defindClassFromFile(className, fis, jarFilePath);
                    }
                    finally {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                }
                if (res == null) continue;
                this.log("[CL_INFO]  Resource[" + resName + "] has loaded from jar[" + jarFilePath + "]!");
                return res;
            }
            catch (Throwable e) {
                this.log("[CL_ERR]   Load resource[" + resName + "] from jars error[" + e.getMessage() + "]!");
            }
        }
        return null;
    }

    private Object defindClassFromFile(String className, InputStream clsInputStream, String jarFilePath) throws IOException {
        try {
            byte[] resBytes = this.readBytesFromInputStream(clsInputStream);
            clsInputStream.close();
            this.definePackage(className);
            Class<?> c = this.findLoadedClass(className);
            if (c != null) {
                this.log("loade reload findloadedClass sucess  ");
                return c;
            }
            CodeSource cs = new CodeSource(new URL("file", "", jarFilePath), (Certificate[])null);
            Permissions pc = new Permissions();
            ((PermissionCollection)pc).add(new AllPermission());
            ProtectionDomain pd = new ProtectionDomain(cs, pc);
            return this.defineClass(className, resBytes, 0, resBytes.length, pd);
        }
        catch (ClassFormatError e) {
            Class<?> c = this.findLoadedClass(className);
            if (c != null) {
                this.log("loade class " + className + " error reload sucess ,origin cause:" + e.getCause());
                return c;
            }
            this.log("loade class " + className + " error reload faild ,origin cause:" + e.getCause());
            try {
                Thread.sleep(100L);
                c = this.findLoadedClass(className);
                if (c != null) {
                    this.log("loade class " + className + " error reload sucess ,origin cause:" + e.getCause());
                    return c;
                }
                this.log("loade class " + className + " error reload faild ,origin cause:" + e.getCause());
            }
            catch (InterruptedException e1) {
                this.log("loade class " + className + " error reload faild ,origin cause:" + e1.getCause());
                Thread.currentThread().interrupt();
            }
            this.log("[CL_ERR]   Error in define class[" + className + e.getCause());
        }
        catch (Exception e) {
            Class<?> c = this.findLoadedClass(className);
            if (c != null) {
                this.log("loade class " + className + " error reload sucess ,origin cause:" + e.getCause());
                return c;
            }
            this.log("loade class " + className + " error reload faild ,origin cause:" + e.getCause());
            this.log("[CL_ERR]   Error in define class[" + className + e.getCause());
        }
        return null;
    }

    public byte[] readBytesFromInputStream(InputStream input) throws IOException {
        int j;
        int l = 0;
        byte[] resBytes = new byte[1024];
        while ((j = input.read(resBytes, l, resBytes.length - l)) != -1) {
            if ((l += j) < resBytes.length) continue;
            byte[] abyte1 = new byte[l * 2];
            System.arraycopy(resBytes, 0, abyte1, 0, l);
            resBytes = abyte1;
        }
        if (l != resBytes.length) {
            byte[] abyte2 = new byte[l];
            System.arraycopy(resBytes, 0, abyte2, 0, l);
            resBytes = abyte2;
        }
        return resBytes;
    }

    protected void definePackage(String className) {
        int lastDot = className.lastIndexOf(46);
        String pkName = className;
        if (lastDot != -1) {
            pkName = className.substring(0, lastDot);
        }
        if (this.getPackage(pkName) != null) {
            return;
        }
    }

    public void reset() {
        this.clearOldEnviroment();
        this.reloadLib();
    }

    public void clearOldEnviroment() {
        this.closeFile();
        this.packageCache = new Hashtable();
        this.jarFileCache = new Hashtable();
        this.packageToJarMap = new Properties();
        this.classCache = new Hashtable();
    }

    private void closeFile() {
        for (Map.Entry<String, JarFile> entry : this.jarFileCache.entrySet()) {
            JarFile file = this.jarFileCache.get(entry.getKey());
            this.closeFile(file);
        }
    }

    private void closeFile(JarFile file) {
        if (file != null) {
            try {
                file.close();
            }
            catch (IOException e) {
                this.logger.error((Object)("close file error " + file.getName()));
            }
        }
    }
}

