/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.SystemConfigSolutionInfo;
import com.kingdee.shr.base.syssetting.app.cache.SystemSHRCache;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class WorkPlatformUtil {
    private static Logger logger = Logger.getLogger(WorkPlatformUtil.class);
    public static final String SELF_WORKPLATFORM_NEWID = "c4hkTtMYlEaHaNi3Hw6xDkRLkh4=";
    public static final String MANAGER_WORKPLATFORM_NEWID = "b99HHtUia0WF85yZ9M/Cc0RLkh4=";
    public static final String SELF_WORKPLATFORM_OLDID = "Qz9UfhLqB0+vmMJ4+80EykRLkh4=";
    public static final String MANAGER_WORKPLATFORM_OLDID = "kWqB8qBRX06QlYpf+SanikRLkh4=";
    public static final String PROFESSIONAL_WORKPLATFORM_ID = "Lq05UWZSH0SmJU3sr2GJokRLkh4=";
    public static final String SELF_WORKPLATFORM_NEWUIPK = "shr.perself.homepage.new";
    public static final String SELF_WORKPLATFORM_OLDUIPK = "shr.perself.homepage";
    public static final String MANAGER_WORKPLATFORM_NEWUIPK = "shr.manager.homepage.new";
    public static final String MANAGER_WORKPLATFORM_OLDUIPK = "shr.manager.homepage";
    public static final String MY_WORKPLATFORM_UIPK = "shr.myworkplatform.homepage";
    public static final String SELF_WORKPLATFORM_NEWURL = "/shr/dynamic.do?uipk=shr.perself.homepage.new&billId=urc82BrSRtOcJIdAv8TcjLLHsrA%3D&inFrame=true&blank=true";
    public static final String SELF_WORKPLATFORM_OLDURL = "/shr/perSelf.do";
    public static final String MANAGER_WORKPLATFORM_NEWURL = "/shr/dynamic.do?uipk=shr.manager.homepage.new&billId=kFSKs4dqSxOJsBfFwxA%2B4rLHsrA%3D&inFrame=true&blank=true";
    public static final String MANAGER_WORKPLATFORM_OLDURL = "/shr/manager.do";

    public static String getMyWorkPlatformIdFilterSql(Context ctx, boolean isOracleDB) throws EASBizException, BOSException {
        String permissionSql = PermissionFactory.getLocalInstance((Context)ctx).getFunctionPermissionsByMenu();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("WorkPlatformControllerBean._getMyWorkPlatform permissionSql:{0}", permissionSql));
        }
        StringBuilder unionSql = new StringBuilder();
        unionSql.append(WorkPlatformUtil.getMyWorkPlatformIdSql(permissionSql, isOracleDB));
        unionSql.append(" UNION ALL ");
        unionSql.append(WorkPlatformUtil.getNewMyWorkPlatformIdSql(permissionSql));
        return unionSql.toString();
    }

    public static String getMyWorkPlatformIdSql(String permissionSql, boolean isOracleDB) {
        StringBuilder sql = new StringBuilder();
        if (isOracleDB) {
            sql.append("SELECT DISTINCT Category.FWorkPlatformID  FROM T_BS_ServiceCategory Category WHERE FID IN ").append("(SELECT DISTINCT Service.FCategoryID  FROM T_BS_Service Service WHERE (FPermissionID IN (").append(permissionSql).append(")").append("OR (FPermissionID IS NULL)) ").append("AND FState = 1)");
        } else {
            sql.append("SELECT DISTINCT Category.FWorkPlatformID  FROM T_BS_ServiceCategory Category WHERE FID IN ");
            sql.append("(SELECT DISTINCT Service.FCategoryID  FROM T_BS_Service Service WHERE FPermissionID IN (").append(permissionSql).append(")").append("AND FState = 1");
            sql.append(" UNION ALL ");
            sql.append("SELECT DISTINCT Service.FCategoryID  FROM T_BS_Service Service WHERE FPermissionID IS NULL AND FState = 1)");
        }
        return sql.toString();
    }

    public static String getNewMyWorkPlatformIdSql(String permissionSql) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t0.fid FROM t_bd_workplatform t0 inner join t_pm_permitemurl t1 ").append("on ('/dynamic.do?method=initalize#uri='||t0.FUIPK) = t1.FURL AND t0.fisnew = 1 ").append("where t1.fparentid in (").append(permissionSql).append(")");
        return sql.toString();
    }

    public static String getNewMyWorkPlatformUipkSql(String permissionSql) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t0.fuipk FROM t_bd_workplatform t0 inner join t_pm_permitemurl t1 ").append("on ('/dynamic.do?method=initalize#uri='||t0.FUIPK) = t1.FURL AND t0.fisnew = 1 ").append("where t1.fparentid in (").append(permissionSql).append(")");
        return sql.toString();
    }

    public static String getWorkPlatformByUipkSQL(String uipk) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT Category.FWorkPlatformID FROM T_BS_ServiceCategory Category WHERE FID IN ");
        sql.append("(");
        sql.append(" SELECT DISTINCT Service.FCategoryID FROM T_BS_Service Service WHERE FID in (").append(WorkPlatformUtil.getUrlTypeServiceSql(uipk)).append(") ");
        sql.append(" UNION ALL ");
        sql.append(" SELECT DISTINCT Service.FCategoryID FROM T_BS_Service Service WHERE ");
        sql.append(" FURLTYPE = '").append("view").append("' and FURLVALUE= '").append(uipk).append("'");
        sql.append(")");
        return sql.toString();
    }

    public static String getUrlTypeServiceSql(String uipk) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT fid FROM (");
        sql.append(" SELECT case when CHARINDEX('&amp;',t) >0 then SUBSTRING(t,0,CHARINDEX('&amp;',t)-1)");
        sql.append(" when CHARINDEX('&',t) >0 then SUBSTRING(t,0,CHARINDEX('&',t)-1) ");
        sql.append(" else t end t,FURLVALUE,fid FROM ( ");
        sql.append(" SELECT case when  CHARINDEX('&amp;uipk=',FURLVALUE) >0 then SUBSTRING(FURLVALUE,CHARINDEX('&amp;uipk=',FURLVALUE)+10,LEN(FURLVALUE)) ");
        sql.append(" when CHARINDEX('&uipk=',FURLVALUE) >0 then SUBSTRING(FURLVALUE,CHARINDEX('&uipk=',FURLVALUE)+6,LEN(FURLVALUE)) ");
        sql.append(" when CHARINDEX('?uipk=',FURLVALUE) >0 then SUBSTRING(FURLVALUE,CHARINDEX('?uipk=',FURLVALUE)+6,LEN(FURLVALUE)) ");
        sql.append(" else FURLVALUE end t,FURLVALUE,FID   FROM t_bs_service where FURLTYPE ='").append("url").append("' ");
        sql.append(" ) temp0 ");
        sql.append(" ) temp1 where t= '").append(uipk).append("'");
        return sql.toString();
    }

    public static boolean isShowOldWorkbench(Context ctx) throws EASBizException, BOSException {
        HashMap map;
        boolean isShowOldWorkbench = false;
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("config", "");
        SystemConfigSolutionInfo configInfo = SystemSHRCache.getSystemConfigSolutionInfo((Context)ctx);
        if (null != configInfo && !StringUtils.isEmpty((String)configInfo.getConfig()) && null != (map = JSONUtils.convertJsonToObject(ctx, configInfo.getConfig())).get("isShowOldWorkbench")) {
            isShowOldWorkbench = Boolean.valueOf((String)map.get("isShowOldWorkbench"));
        }
        return isShowOldWorkbench;
    }

    public static IObjectPK getOld2NewTransPk(String sourceID) {
        ObjectUuidPK pk = null;
        if (SELF_WORKPLATFORM_OLDID.equals(sourceID)) {
            pk = new ObjectUuidPK(SELF_WORKPLATFORM_NEWID);
        } else if (MANAGER_WORKPLATFORM_OLDID.equals(sourceID)) {
            pk = new ObjectUuidPK(MANAGER_WORKPLATFORM_NEWID);
        }
        return pk;
    }

    public static IObjectPK getNew2OldTransPk(String sourceID) {
        ObjectUuidPK pk = null;
        if (SELF_WORKPLATFORM_NEWID.equals(sourceID)) {
            pk = new ObjectUuidPK(SELF_WORKPLATFORM_OLDID);
        } else if (MANAGER_WORKPLATFORM_NEWID.equals(sourceID)) {
            pk = new ObjectUuidPK(MANAGER_WORKPLATFORM_OLDID);
        }
        return pk;
    }

    public static String getOldDefaultWorkplatform(Context ctx) throws BOSException {
        String sql = "SELECT top 1 '/shr'||furl  as url FROM T_BD_WorkPlatform where fisnew = 0 order by findex ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                return rs.getString("url");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static boolean isNewWorkpaltform(Context ctx, String uipk) throws BOSException {
        String sql = "SELECT FIsNew FROM T_BD_WorkPlatform where fuipk = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{uipk});
        try {
            if (rs.next()) {
                return rs.getBoolean("FIsNew");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

