/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.common.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SHREnumUtil {
    public static final String INTENUM = "IntEnum";
    public static final String DOUBLEENUM = "DoubleEnum";
    public static final String FLOATENUM = "FloatEnum";
    public static final String LONGENUM = "LongEnum";
    public static final String STRINGENUM = "StringEnum";
    public static final String DYNAMICENUM = "DynamicEnum";

    public static String getEnumStr(String enumsource) {
        Map<String, String> convert = SHREnumUtil.getEnumMap(enumsource);
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : convert.entrySet()) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append((Object)entry.getKey()).append(":").append((Object)entry.getValue());
        }
        return sb.toString();
    }

    public static Map<String, String> getEnumMap(String enumsource) {
        if (!StringUtils.isEmpty((String)enumsource)) {
            HashMap<String, String> converter = new HashMap<String, String>();
            try {
                List enumList = MetaDataUtil.getEnumList((String)enumsource);
                for (int i = 0; i < enumList.size(); ++i) {
                    Enum objEnum = (Enum)enumList.get(i);
                    Object value = null;
                    value = objEnum instanceof StringEnum ? ((StringEnum)objEnum).getValue() : (objEnum instanceof DynamicEnum ? ((DynamicEnum)objEnum).getValue() : (objEnum instanceof LongEnum ? Long.valueOf(((LongEnum)objEnum).getValue()) : (objEnum instanceof IntEnum ? Integer.valueOf(((IntEnum)objEnum).getValue()) : (objEnum instanceof FloatEnum ? Float.valueOf(((FloatEnum)objEnum).getValue()) : (objEnum instanceof DoubleEnum ? Double.valueOf(((DoubleEnum)objEnum).getValue()) : objEnum.getName())))));
                    if (value == null) continue;
                    converter.put(String.valueOf(value), objEnum.getAlias());
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            return converter;
        }
        return null;
    }

    public static List<Map<String, String>> getEnumList(String enumsource) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            List enumList = MetaDataUtil.getEnumList((String)enumsource);
            for (int i = 0; i < enumList.size(); ++i) {
                HashMap<String, String> converter = new HashMap<String, String>();
                Enum objEnum = (Enum)enumList.get(i);
                Object value = null;
                value = objEnum instanceof StringEnum ? ((StringEnum)objEnum).getValue() : (objEnum instanceof DynamicEnum ? ((DynamicEnum)objEnum).getValue() : (objEnum instanceof LongEnum ? Long.valueOf(((LongEnum)objEnum).getValue()) : (objEnum instanceof IntEnum ? Integer.valueOf(((IntEnum)objEnum).getValue()) : (objEnum instanceof FloatEnum ? Float.valueOf(((FloatEnum)objEnum).getValue()) : (objEnum instanceof DoubleEnum ? Double.valueOf(((DoubleEnum)objEnum).getValue()) : objEnum.getName())))));
                if (value != null) {
                    converter.put(String.valueOf(value), objEnum.getAlias());
                }
                list.add(converter);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String getEnumByOwnProperty(OwnPropertyInfo fld) {
        if (null == fld) {
            return null;
        }
        DataType dataType = fld.getDataType();
        BizEnumValueType type = null;
        if (DataType.ENUM.equals((Object)dataType)) {
            if (fld.isConfigured()) {
                BizEnumInfo enumInfo = fld.getEnumType(MDHostType.RUNTIME);
                type = enumInfo.getDataType();
            } else {
                if (null == fld.getEnumType()) {
                    return dataType.toString();
                }
                type = fld.getEnumType().getDataType();
            }
            String v = SHREnumUtil.getEnumType(type);
            if (StringUtils.isEmpty((String)v)) {
                return v;
            }
        }
        return dataType.toString();
    }

    private static String getEnumType(BizEnumValueType type) {
        if (BizEnumValueType.INTEGER.getName().equals(type.getName())) {
            return INTENUM;
        }
        if (BizEnumValueType.STRING.getName().equals(type.getName())) {
            return STRINGENUM;
        }
        if (BizEnumValueType.FLOAT.getName().equals(type.getName())) {
            return FLOATENUM;
        }
        if (BizEnumValueType.LONG.getName().equals(type.getName())) {
            return LONGENUM;
        }
        if (BizEnumValueType.DOUBLE.getName().equals(type.getName())) {
            return DOUBLEENUM;
        }
        return null;
    }

    public static String getBizEnumByEnumsource(Context ctx, String enumsource) {
        if (StringUtils.isEmpty((String)enumsource)) {
            return null;
        }
        BizEnumInfo bei = null;
        bei = null == ctx ? MetaDataLoaderFactory.getRemoteMetaDataLoader().getEnum((IMetaDataPK)MetaDataPK.create((String)enumsource)) : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEnum((IMetaDataPK)MetaDataPK.create((String)enumsource));
        if (bei != null) {
            return SHREnumUtil.getEnumType(bei.getDataType());
        }
        return null;
    }

    public static BizEnumInfo getBizEnumInfoByOwnProperty(OwnPropertyInfo fld) {
        if (null == fld) {
            return null;
        }
        DataType dataType = fld.getDataType();
        BizEnumInfo enumInfo = null;
        if (DataType.ENUM.equals((Object)dataType)) {
            enumInfo = fld.isConfigured() ? fld.getEnumType(MDHostType.RUNTIME) : fld.getEnumType();
        }
        return enumInfo;
    }

    public static boolean isEnum(String type) {
        if (StringUtils.isEmpty((String)type)) {
            return false;
        }
        if (STRINGENUM.equalsIgnoreCase(type)) {
            return true;
        }
        if (INTENUM.equalsIgnoreCase(type)) {
            return true;
        }
        if (LONGENUM.equalsIgnoreCase(type)) {
            return true;
        }
        if (FLOATENUM.equalsIgnoreCase(type)) {
            return true;
        }
        if (DOUBLEENUM.equalsIgnoreCase(type)) {
            return true;
        }
        return DYNAMICENUM.equalsIgnoreCase(type);
    }
}

