/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.AppointPositionEnum;
import com.kingdee.shr.base.syssetting.FieldSchemeMaintenanceEntryFactory;
import com.kingdee.shr.base.syssetting.FieldSchemeMaintenanceEntryInfo;
import com.kingdee.shr.base.syssetting.FieldSchemeMaintenanceFactory;
import com.kingdee.shr.base.syssetting.FieldSchemeMaintenanceInfo;
import com.kingdee.shr.base.syssetting.FieldSchemeRecordFactory;
import com.kingdee.shr.base.syssetting.IFieldSchemeMaintenance;
import com.kingdee.shr.base.syssetting.IFieldSchemeMaintenanceEntry;
import com.kingdee.shr.base.syssetting.IFieldSchemeRecord;
import com.kingdee.shr.base.syssetting.IUIViewExt;
import com.kingdee.shr.base.syssetting.IUIViewTree;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.UIViewExtFactory;
import com.kingdee.shr.base.syssetting.UIViewTreeFactory;
import com.kingdee.shr.base.syssetting.UIViewTreeInfo;
import com.kingdee.shr.base.syssetting.app.AbstractFieldSchemeMaintenanceControllerBean;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.scheme.FieldSchemeMaintenanceHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FieldSchemeMaintenanceControllerBean
extends AbstractFieldSchemeMaintenanceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.FieldSchemeMaintenanceControllerBean");
    private final String TRUE_SCHEME = "true";

    @Override
    protected void _batchMaintainFieldToViewAction(Context ctx, IObjectCollection uIViewExtCollection, IObjectCollection fieldSchemeRecordCollection, String schemeId) throws BOSException, EASBizException {
        IUIViewExt iuiViewExt = UIViewExtFactory.getLocalInstance(ctx);
        IObjectPK[] iObjectPKS = iuiViewExt.saveBatchData((CoreBaseCollection)uIViewExtCollection);
        this.saveBatchMaintainFieldRecord(schemeId, ctx, fieldSchemeRecordCollection);
    }

    @Override
    protected String _batchUpdateViewAndRecord(Context ctx, IObjectCollection collectionRollBack, IObjectCollection baseCollection) throws BOSException, EASBizException {
        IObjectPK[] iObjectPKS = null;
        IUIViewExt iuiViewExt = UIViewExtFactory.getLocalInstance(ctx);
        IFieldSchemeRecord iFieldSchemeRecord = FieldSchemeRecordFactory.getLocalInstance(ctx);
        IObjectPK[] pks = iuiViewExt.updateBatchData((CoreBaseCollection)baseCollection);
        if (pks != null && pks.length > 0) {
            iObjectPKS = iFieldSchemeRecord.updateBatchData((CoreBaseCollection)collectionRollBack);
        }
        if (iObjectPKS != null) {
            return "success";
        }
        return null;
    }

    @Override
    protected String _saveOrUpdateFieldScheme(Context ctx, String model) throws BOSException, EASBizException {
        JSONObject json = JSONObject.parseObject((String)model);
        String billId = null;
        if (json.get((Object)"billId") != null) {
            billId = json.get((Object)"billId").toString();
        }
        IFieldSchemeMaintenance localInstance = FieldSchemeMaintenanceFactory.getLocalInstance(ctx);
        IFieldSchemeMaintenanceEntry localInstanceExt = FieldSchemeMaintenanceEntryFactory.getLocalInstance(ctx);
        IUIViewTree iuiViewTree = UIViewTreeFactory.getLocalInstance(ctx);
        FieldSchemeMaintenanceInfo info = new FieldSchemeMaintenanceInfo();
        String modelStr = json.getString("model");
        info.setModel(modelStr);
        EntityObjectInfo entityObjectInfo = MetaDataUtil.getEntityObjectByEntityName((String)modelStr);
        info.setModelName(entityObjectInfo.getName());
        String schemeAlias = json.getString("schemeAlias");
        if (schemeAlias == null || schemeAlias.length() <= 0) {
            throw new SyssettinException(SyssettinException.SCHEME_NAME_NOT_NULL);
        }
        if (schemeAlias.length() > 128) {
            throw new SyssettinException(SyssettinException.SCHEME_NAME_MAX_FIELD);
        }
        info.setSchemeAlias(json.getString("schemeAlias"));
        String tree = json.getString("tree");
        UIViewTreeInfo uiViewTreeInfo = iuiViewTree.getUIViewTreeInfo((IObjectPK)new ObjectUuidPK(tree));
        info.setTree(uiViewTreeInfo);
        if (StringUtils.isEmpty((String)billId)) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("model", (Object)json.getString("model"), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            int count = localInstance.getCount(viewInfo);
            if (count >= 50) {
                throw new SyssettinException(SyssettinException.MODEL_COUNT);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("schemeAlias", (Object)json.getString("schemeAlias"), CompareType.EQUALS));
            IObjectPK save = null;
            if (localInstance.exists(filter)) {
                throw new SyssettinException(SyssettinException.SCHEME_REPEAT);
            }
            save = localInstance.save((CoreBaseInfo)info);
            billId = save.toString();
            if (null == save) {
                throw new SyssettinException(SyssettinException.SAVE_FAIL);
            }
        } else {
            info.setId(BOSUuid.read((String)billId));
            localInstance.update((IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)info);
        }
        FilterInfo exFilter = new FilterInfo();
        exFilter.getFilterItems().add(new FilterItemInfo("parent", (Object)billId, CompareType.EQUALS));
        localInstanceExt.delete(exFilter);
        CoreBaseCollection collection = new CoreBaseCollection();
        List parse = (List)JSONArray.parse((String)json.getString("scheme_info"));
        List<FieldSchemeMaintenanceEntryInfo> extInfos = new ArrayList<FieldSchemeMaintenanceEntryInfo>();
        for (int i = 0; i < parse.size(); ++i) {
            FieldSchemeMaintenanceEntryInfo infoExt = new FieldSchemeMaintenanceEntryInfo();
            JSONObject jsonObject = new JSONObject((Map)parse.get(i));
            infoExt.setAlias(jsonObject.getString("name"));
            infoExt.setVsible(!"true".equals(jsonObject.getString("isHidden")));
            infoExt.setReadonly("true".equals(jsonObject.getString("readonly")));
            infoExt.setName(jsonObject.getString("field"));
            String dataType = jsonObject.getString("dataType");
            infoExt.setDataType(dataType);
            infoExt.setRequired("true".equals(jsonObject.getString("isRequired")));
            infoExt.setAppoint(jsonObject.getString("appoint"));
            infoExt.setIndex(Integer.parseInt(jsonObject.get((Object)"index").toString()));
            if (jsonObject.get((Object)"appointPosition") != null && jsonObject.get((Object)"appointPosition").toString().length() > 0) {
                infoExt.setAppointPosition(AppointPositionEnum.getEnum(Integer.parseInt(jsonObject.get((Object)"appointPosition").toString())));
            }
            info.setId(BOSUuid.read((String)billId));
            infoExt.setParent(info);
            extInfos.add(infoExt);
            collection.add((CoreBaseInfo)infoExt);
        }
        if ((extInfos = FieldSchemeMaintenanceHelper.extInfoListSort(extInfos)).size() > 0) {
            int size = extInfos.size();
            for (int i = 0; i < size; ++i) {
                FieldSchemeMaintenanceEntryInfo extInfo = extInfos.get(i);
                String appoint = extInfo.getAppoint();
                if (appoint == null) continue;
                for (int j = i + 1; j < size; ++j) {
                    FieldSchemeMaintenanceEntryInfo schemeMaintenanceExtInfo = extInfos.get(j);
                    String name = schemeMaintenanceExtInfo.getName();
                    if (!appoint.equals(name)) continue;
                    throw new SyssettinException(SyssettinException.APPOINT_FIELD);
                }
            }
        }
        IObjectPK[] iObjectPKS = localInstanceExt.saveBatchData(collection);
        json.put("id", (Object)billId);
        return json.toJSONString();
    }

    @Override
    protected String _batchDeleteScheme(Context ctx, String billIds) throws BOSException, EASBizException {
        String[] billIdList = billIds.split(",");
        IObjectPK[] iObjectPKS = new IObjectPK[billIdList.length];
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < billIdList.length; ++i) {
            iObjectPKS[i] = new ObjectUuidPK(billIdList[i]);
            set.add(billIdList[i]);
        }
        IFieldSchemeMaintenance iFieldSchemeMaintenance = FieldSchemeMaintenanceFactory.getLocalInstance(ctx);
        iFieldSchemeMaintenance.deleteBatchData(iObjectPKS);
        IFieldSchemeMaintenanceEntry iFieldSchemeMaintenanceEntry = FieldSchemeMaintenanceEntryFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent", set, CompareType.INCLUDE));
        IObjectPK[] delete = iFieldSchemeMaintenanceEntry.delete(filterInfo);
        if (delete != null && delete.length > 0) {
            return billIds;
        }
        return null;
    }

    private void saveBatchMaintainFieldRecord(String schemeId, Context context, IObjectCollection collectionUpdate) throws BOSException, EASBizException {
        IFieldSchemeRecord iFieldSchemeRecord = FieldSchemeRecordFactory.getLocalInstance(context);
        FilterInfo recordFilter = new FilterInfo();
        recordFilter.getFilterItems().add(new FilterItemInfo("scheme", (Object)schemeId, CompareType.EQUALS));
        IObjectPK[] delete = iFieldSchemeRecord.delete(recordFilter);
        IObjectPK[] iObjectPKS = iFieldSchemeRecord.saveBatchData((CoreBaseCollection)collectionUpdate);
        logger.info((Object)("FieldSchemeMaintenanceControllerBean.saveBatchMaintainFieldRecord:" + iObjectPKS.length));
    }
}

