/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.app.AbstractMSFServiceOutLogControllerBean;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Map;
import org.apache.log4j.Logger;

public class MSFServiceOutLogControllerBean
extends AbstractMSFServiceOutLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.MSFServiceOutLogControllerBean");

    @Override
    protected IObjectPK _writeInputLog(Context ctx, Map logData) throws BOSException {
        String sql = "INSERT INTO T_BD_MSFServiceOutLog ( FServiceName, FServiceAlias,FServiceClass,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID ,FInputXml,FClientIP, FClientName ,FUserNumber,FUserName,FStatus) values( ?, ?,?,?,?,?,?,?,? ,?, ? ,?,?,?,?)";
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        Timestamp time = new Timestamp(System.currentTimeMillis());
        String id = BOSUuid.create((BOSObjectType)this.getBOSType()).toString();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        Object[] param = new Object[]{(String)logData.get("FServiceName"), (String)logData.get("FServiceAlias"), (String)logData.get("FServiceClass"), userInfo.getId().toString(), time, userInfo.getId().toString(), time, HRFilterUtils.getCurrentCUID(ctx), id, (String)logData.get("FInputXml"), MSFServiceOutLogControllerBean.getClientIp(ctx), MSFServiceOutLogControllerBean.getClientName(ctx), userInfo.getNumber(), userInfo.getName(), 0};
        DBUtil.execute((Context)ctx, (String)sql, (Object[])param);
        return pk;
    }

    private static String getClientIp(Context ctx) {
        String obj = ctx.getClientHostIP();
        if (StringUtils.isEmpty((String)obj)) {
            obj = (String)ctx.get((Object)"ClientIP");
        }
        if (StringUtils.isEmpty((String)obj) || "0.0.0.0".equals(obj)) {
            obj = "127.0.0.1";
        }
        return obj;
    }

    private static String getClientName(Context ctx) {
        Object obj = ctx.getClientHostName();
        if (obj == null) {
            obj = ctx.get((Object)"ClientName");
        }
        if (obj == null || obj.toString().isEmpty()) {
            obj = MSFServiceOutLogControllerBean.getClientIp(ctx);
        }
        return obj == null ? "" : obj.toString();
    }

    @Override
    protected void _wirteOutputLog(Context ctx, Map logData) throws BOSException {
        String sql = "UPDATE T_BD_MSFServiceOutLog SET  FStatus=?,FOutXml=?,FLastUpdateUserID=?,FLastUpdateTime=? WHERE FID =?";
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        Timestamp time = new Timestamp(System.currentTimeMillis());
        Object[] param = new Object[]{(Integer)logData.get("FStatus"), (String)logData.get("FOutXml"), userInfo.getId().toString(), time, (String)logData.get("FID")};
        DBUtil.execute((Context)ctx, (String)sql, (Object[])param);
    }

    @Override
    protected void _clearLog(Context ctx, int days) throws BOSException, EASBizException {
        if (days <= 0) {
            return;
        }
        LocalDate currentDate = LocalDate.now();
        LocalDate beforDate = currentDate.minusDays(days);
        LocalDateTime localDateTime = beforDate.atStartOfDay();
        java.util.Date date = java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        this._clearLogByDate(ctx, date);
    }

    @Override
    protected void _clearLogByDate(Context ctx, java.util.Date clearDate) throws BOSException, EASBizException {
        if (null == clearDate) {
            return;
        }
        String sql = "DELETE FROM T_BD_MSFSERVICEOUTLOG WHERE FCREATETIME <= ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Date(clearDate.getTime())});
    }
}

