/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.DesktopItemCollection;
import com.kingdee.shr.base.syssetting.DesktopItemFactory;
import com.kingdee.shr.base.syssetting.HRMenuPermHelper;
import com.kingdee.shr.base.syssetting.IconTypeEnum;
import com.kingdee.shr.base.syssetting.ServiceBizException;
import com.kingdee.shr.base.syssetting.ServiceCategoryFactory;
import com.kingdee.shr.base.syssetting.ServiceCollection;
import com.kingdee.shr.base.syssetting.ServiceInfo;
import com.kingdee.shr.base.syssetting.ServiceSubCategoryFactory;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.URLTypeEnum;
import com.kingdee.shr.base.syssetting.app.AbstractServiceControllerBean;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.service.ServiceUtil;
import com.kingdee.shr.base.syssetting.util.SystemContextUtil;
import com.kingdee.shr.base.syssetting.util.WorkPlatformUtil;
import com.kingdee.shr.dataplatform.PageConfigCollection;
import com.kingdee.shr.dataplatform.PageConfigFactory;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class ServiceControllerBean
extends AbstractServiceControllerBean {
    private static final long serialVersionUID = 6758759643880621873L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.ServiceControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ServiceInfo serviceInfo = (ServiceInfo)model;
        this.verifyData(ctx, serviceInfo);
        IObjectPK pk = super._addnew(ctx, model);
        HRMenuPermHelper.removeServiceCache(ctx, "allServiceCollection");
        return pk;
    }

    private void verifyData(Context ctx, ServiceInfo serviceInfo) throws BOSException, EASBizException {
        if (URLTypeEnum.VIEW.equals((Object)serviceInfo.getUrlType()) && serviceInfo.getUrlValue().startsWith("/dynamic.do?uipk=")) {
            throw new SyssettinException(SyssettinException.URL_UIPK_ERROR);
        }
    }

    private void syncIndexOfOtherService(Context ctx, IObjectValue model, IObjectPK pk) throws BOSException, EASBizException {
        ServiceInfo serviceInfo = (ServiceInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("select id,index where id<>'").append(pk).append("' and index=").append(serviceInfo.getIndex()).append(" and category.id='").append(serviceInfo.getCategory().getId()).append("'");
        if (this.exists(ctx, sql.toString())) {
            sql = new StringBuffer();
            sql.append("select id,index where id<>'").append(pk).append("' and index>=").append(serviceInfo.getIndex()).append(" and category.id='").append(serviceInfo.getCategory().getId()).append("'");
            ServiceCollection coll = this.getServiceCollection(ctx, sql.toString());
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            Object[] param = null;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                param = new Object[]{coll.get(i).getIndex() + 1, coll.get(i).getId().toString()};
                paramList.add(param);
            }
            String updateSql = "update T_BS_Service set findex=? where fid=?";
            DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
        }
        HRMenuPermHelper.removeServiceCache(ctx, "allServiceCollection");
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ServiceInfo serviceInfo = (ServiceInfo)model;
        this.verifyData(ctx, serviceInfo);
        super._update(ctx, pk, model);
        HRMenuPermHelper.removeServiceCache(ctx, "allServiceCollection");
    }

    private void syncFieldOfService(Context ctx, ServiceInfo serviceInfo) throws BOSException, ServiceBizException {
        String content = serviceInfo.getContent();
        SAXBuilder builder = new SAXBuilder();
        try {
            String indexVal;
            Element indexElement;
            Document doc = builder.build((InputStream)new ByteArrayInputStream(content.getBytes()));
            Element servicesRoot = doc.getRootElement();
            if (servicesRoot == null || !"service".equals(servicesRoot.getName())) {
                throw new ServiceBizException(ServiceBizException.SERVICE_CANTNULL);
            }
            Element serviceElement = this.doWithServiceBaseInfo(serviceInfo, servicesRoot);
            this.doWithRole(serviceInfo, serviceElement);
            this.doWithCategorys(ctx, serviceInfo, serviceElement);
            Element permissionElement = XMLUtil.getElement(serviceElement, "permission");
            if (permissionElement != null) {
                String permItemName = permissionElement.getAttributeValue("name");
                String sql = "select *  where name ='" + permItemName + "'";
                PermItemCollection permColl = PermItemFactory.getLocalInstance((Context)ctx).getPermItemCollection(sql);
                if (permColl.size() > 0) {
                    serviceInfo.setPermission(permColl.get(0));
                }
            }
            Element urlElement = XMLUtil.getElement(serviceElement, "url");
            String urlType = urlElement.getAttributeValue("type");
            serviceInfo.setUrlType(URLTypeEnum.getEnum(urlType));
            String urlValue = urlElement.getAttributeValue("value");
            serviceInfo.setUrlValue(urlValue);
            Element descElement = XMLUtil.getElement(serviceElement, "desc");
            serviceInfo.setDescription(descElement.getText());
            Element iconElement = XMLUtil.getElement(serviceElement, "icon");
            if (iconElement != null) {
                String iconType = iconElement.getAttributeValue("type");
                serviceInfo.setIconType(IconTypeEnum.getEnum(iconType));
                String iconName = iconElement.getAttributeValue("name");
                serviceInfo.setIconName(iconName);
            }
            if ((indexElement = XMLUtil.getElement(serviceElement, "index")) != null && !StringUtils.isEmpty((String)(indexVal = indexElement.getAttributeValue("value")))) {
                serviceInfo.setIndex(Integer.parseInt(indexVal));
            }
        }
        catch (JDOMException e) {
            throw new ServiceBizException(ServiceBizException.ERROR_CHECKSERVICEDESCRIPTION);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        HRMenuPermHelper.removeServiceCache(ctx, "allServiceCollection");
    }

    private Element doWithServiceBaseInfo(ServiceInfo serviceInfo, Element serviceElement) throws ServiceBizException {
        String name = serviceElement.getAttributeValue("name");
        if (StringUtils.isEmpty((String)name)) {
            throw new ServiceBizException(ServiceBizException.SERVICE_NAME_CANTNULL);
        }
        serviceInfo.setName(name);
        String alias = serviceElement.getAttributeValue("alias");
        if (StringUtils.isEmpty((String)alias)) {
            throw new ServiceBizException(ServiceBizException.SERVICE_ALIAS_CANTNULL);
        }
        serviceInfo.setAlias(alias);
        String type = serviceElement.getAttributeValue("type");
        if (StringUtils.isEmpty((String)type)) {
            throw new ServiceBizException(ServiceBizException.SERVICE_TYPE_CANTNULL);
        }
        serviceInfo.setType(type);
        return serviceElement;
    }

    private void doWithRole(ServiceInfo serviceInfo, Element serviceElement) {
        Element rolesElement = XMLUtil.getElement(serviceElement, "roles");
        if (rolesElement != null) {
            List roleList = rolesElement.getChildren();
            int size = roleList.size();
            for (int i = 0; i < size; ++i) {
                Element roleElement = (Element)roleList.get(i);
                if ("bus".equals(roleElement.getAttributeValue("type"))) {
                    serviceInfo.setBusRoles(roleElement.getAttributeValue("alias"));
                }
                if (!"sys".equals(roleElement.getAttributeValue("type"))) continue;
                serviceInfo.setSysRoles(roleElement.getAttributeValue("alias"));
            }
        }
    }

    private void doWithCategorys(Context ctx, ServiceInfo serviceInfo, Element serviceElement) throws BOSException {
        Element categorysElement = XMLUtil.getElement(serviceElement, "categorys");
        if (categorysElement != null) {
            List cateList = categorysElement.getChildren();
            int size = cateList.size();
            for (int i = 0; i < size; ++i) {
                AbstractObjectCollection cateColl;
                FilterInfo filter;
                EntityViewInfo viewInfo;
                String cateNumber;
                Element cate = (Element)cateList.get(i);
                if (StringUtils.isEmpty((String)cate.getAttributeValue("parent"))) {
                    cateNumber = cate.getAttributeValue("number");
                    viewInfo = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)cateNumber));
                    viewInfo.setFilter(filter);
                    cateColl = ServiceCategoryFactory.getLocalInstance(ctx).getServiceCategoryCollection(viewInfo);
                    if (cateColl.size() > 0) {
                        serviceInfo.setCategory(cateColl.get(0));
                    } else {
                        serviceInfo.setCategory(null);
                    }
                }
                if (StringUtils.isEmpty((String)cate.getAttributeValue("parent"))) continue;
                cateNumber = cate.getAttributeValue("number");
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)cateNumber));
                viewInfo.setFilter(filter);
                cateColl = ServiceSubCategoryFactory.getLocalInstance(ctx).getServiceSubCategoryCollection(viewInfo);
                if (cateColl.size() <= 0) continue;
                serviceInfo.setSubCategory(cateColl.get(0));
            }
        }
    }

    @Override
    protected ServiceCollection _getMyMenuItems(Context ctx) throws BOSException, EASBizException {
        return this.getMenuItems(ctx, false);
    }

    private ServiceCollection getMenuItems(Context ctx, Boolean isAll) throws BOSException, EASBizException {
        long begin = System.currentTimeMillis();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("alias"));
        sic.add(new SelectorItemInfo("urlValue"));
        sic.add(new SelectorItemInfo("urlType"));
        sic.add(new SelectorItemInfo("iconType"));
        sic.add(new SelectorItemInfo("iconName"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("category.id"));
        sic.add(new SelectorItemInfo("category.index"));
        sic.add(new SelectorItemInfo("category.name"));
        sic.add(new SelectorItemInfo("category.number"));
        sic.add(new SelectorItemInfo("category.iconName"));
        sic.add(new SelectorItemInfo("category.iconType"));
        sic.add(new SelectorItemInfo("category.workPlatform.id"));
        sic.add(new SelectorItemInfo("category.workPlatform.name"));
        sic.add(new SelectorItemInfo("category.workPlatform.number"));
        sic.add(new SelectorItemInfo("category.workPlatform.index"));
        sic.add(new SelectorItemInfo("category.workPlatform.url"));
        sic.add(new SelectorItemInfo("category.workPlatform.uipk"));
        sic.add(new SelectorItemInfo("category.workPlatform.isNew"));
        sic.add(new SelectorItemInfo("subCategory.index"));
        sic.add(new SelectorItemInfo("subCategory.name"));
        sic.add(new SelectorItemInfo("subCategory.number"));
        entityViewInfo.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("category.index"));
        sorter.add(new SorterItemInfo("subCategory.index"));
        sorter.add(new SorterItemInfo("index"));
        entityViewInfo.setSorter(sorter);
        String permissionSql = PermissionFactory.getLocalInstance((Context)ctx).getFunctionPermissionsByMenu();
        String emptyPermissionSql = "select fid from t_bs_service where fpermissionid = ''";
        boolean isOracleDB = SystemContextUtil.isOracleDB(ctx);
        FilterInfo filter = new FilterInfo();
        if (isAll.booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        } else if (isOracleDB) {
            filter.getFilterItems().add(new FilterItemInfo("permission", null));
            filter.getFilterItems().add(new FilterItemInfo("permission", (Object)permissionSql, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)emptyPermissionSql, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
            filter.setMaskString("(#0 or #1 or #2) and #3");
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT FID FROM T_BS_SERVICE WHERE FPERMISSIONID IS NULL");
            sb.append(" UNION ALL ");
            sb.append("SELECT FID FROM T_BS_SERVICE WHERE FPERMISSIONID = ''");
            sb.append(" UNION ALL ");
            sb.append("SELECT FID FROM T_BS_SERVICE WHERE FPERMISSIONID IN(").append(permissionSql).append(")");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        }
        entityViewInfo.setFilter(filter);
        ServiceCollection userService = this.getServiceCollection(ctx, entityViewInfo);
        boolean isShowOldWorkbench = WorkPlatformUtil.isShowOldWorkbench(ctx);
        if (null != userService && !userService.isEmpty()) {
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            DesktopItemCollection deskTopItemColl = DesktopItemFactory.getLocalInstance(ctx).getDesktopItemCollection("select name,service.id where user.id = '" + userId + "'");
            HashSet<String> deskTopServiceIdSet = new HashSet<String>();
            if (null != deskTopItemColl && !deskTopItemColl.isEmpty()) {
                int total = deskTopItemColl.size();
                for (int i = 0; i < total; ++i) {
                    if (null == deskTopItemColl.get(i).getService() || null == deskTopItemColl.get(i).getService().getId()) continue;
                    deskTopServiceIdSet.add(deskTopItemColl.get(i).getService().getId().toString());
                }
            }
            PageConfigCollection coll = PageConfigFactory.getLocalInstance((Context)ctx).getPageConfigCollection("select uipk");
            HashSet<String> uipkSet = new HashSet<String>();
            if (null != coll && !coll.isEmpty()) {
                int total = coll.size();
                for (int i = 0; i < total; ++i) {
                    uipkSet.add(coll.get(i).getUipk());
                }
                ServiceCollection newServiceCollection = new ServiceCollection();
                int total2 = userService.size();
                for (int i = 0; i < total2; ++i) {
                    ServiceInfo model = userService.get(i);
                    if (deskTopServiceIdSet.contains(model.getId().toString())) {
                        model.put("isDeskTopItem", true);
                    } else {
                        model.put("isDeskTopItem", false);
                    }
                    if (null != model.getCategory() && null != model.getCategory().getWorkPlatform() && "kWqB8qBRX06QlYpf+SanikRLkh4=".equals(model.getCategory().getWorkPlatform().getId().toString())) {
                        String uipk = ServiceUtil.getUipk(model.getUrlValue());
                        if (isShowOldWorkbench) {
                            if (uipkSet.contains(uipk)) continue;
                            newServiceCollection.add(model);
                            continue;
                        }
                        if (!uipkSet.contains(uipk)) continue;
                        newServiceCollection.add(model);
                        continue;
                    }
                    newServiceCollection.add(model);
                }
                return newServiceCollection;
            }
        }
        long end = System.currentTimeMillis();
        logger.error((Object)("ServiceControllerBean _getMyMenuItems cost:" + (end - begin)));
        return userService;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.vaildate(ctx, String.valueOf(pk));
        ServiceInfo model = this.getServiceInfo(ctx, pk);
        if (StateEnum.ENABLE.equals((Object)model.getState())) {
            throw new SyssettinException(SyssettinException.DISABLE_BEFORE_DELETE, new Object[]{model.getAlias()});
        }
        super._delete(ctx, pk);
        HRMenuPermHelper.removeServiceCache(ctx, "allServiceCollection");
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IObjectPK[] pks = super._delete(ctx, filter);
        HRMenuPermHelper.removeServiceCache(ctx, "allServiceCollection");
        return pks;
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectPK[] pks = super._delete(ctx, oql);
        HRMenuPermHelper.removeServiceCache(ctx, "allServiceCollection");
        return pks;
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._delete(ctx, arrayPK);
        HRMenuPermHelper.removeServiceCache(ctx, "allServiceCollection");
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        this.vaildate(ctx, id);
        this.setServiceState(ctx, id, StateEnum.ENABLE);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        this.vaildate(ctx, id);
        this.setServiceState(ctx, id, StateEnum.DISABLE);
    }

    private void setServiceState(Context ctx, String id, StateEnum state) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setId(BOSUuid.read((String)id));
        serviceInfo.setState(state);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        this._updatePartial(ctx, (IObjectValue)serviceInfo, sic);
        HRMenuPermHelper.removeServiceCache(ctx, "allServiceCollection");
    }

    @Override
    protected ServiceCollection _getMyProfessionMenuItems(Context ctx) throws BOSException, EASBizException {
        long begin = System.currentTimeMillis();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("alias"));
        sic.add(new SelectorItemInfo("urlValue"));
        sic.add(new SelectorItemInfo("urlType"));
        sic.add(new SelectorItemInfo("iconType"));
        sic.add(new SelectorItemInfo("iconName"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("category.index"));
        sic.add(new SelectorItemInfo("category.name"));
        sic.add(new SelectorItemInfo("category.number"));
        sic.add(new SelectorItemInfo("category.iconName"));
        sic.add(new SelectorItemInfo("category.iconType"));
        sic.add(new SelectorItemInfo("subCategory.index"));
        sic.add(new SelectorItemInfo("subCategory.name"));
        sic.add(new SelectorItemInfo("subCategory.number"));
        entityViewInfo.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("category.index"));
        sorter.add(new SorterItemInfo("subCategory.index"));
        sorter.add(new SorterItemInfo("index"));
        entityViewInfo.setSorter(sorter);
        String permissionSql = PermissionFactory.getLocalInstance((Context)ctx).getFunctionPermissionsByMenu();
        boolean isOracleDB = SystemContextUtil.isOracleDB(ctx);
        FilterInfo filter = new FilterInfo();
        if (isOracleDB) {
            filter.getFilterItems().add(new FilterItemInfo("permission", null));
            filter.getFilterItems().add(new FilterItemInfo("permission", (Object)permissionSql, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("category.workPlatform.id", (Object)"Lq05UWZSH0SmJU3sr2GJokRLkh4=", CompareType.EQUALS));
            filter.setMaskString("(#0 or #1) and #2 and #3");
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT FID FROM T_BS_SERVICE WHERE FPERMISSIONID IS NULL");
            sb.append(" UNION ALL ");
            sb.append("SELECT FID FROM T_BS_SERVICE WHERE FPERMISSIONID = ''");
            sb.append(" UNION ALL ");
            sb.append("SELECT FID FROM T_BS_SERVICE WHERE FPERMISSIONID IN(").append(permissionSql).append(")");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("category.workPlatform.id", (Object)"Lq05UWZSH0SmJU3sr2GJokRLkh4=", CompareType.EQUALS));
        }
        entityViewInfo.setFilter(filter);
        ServiceCollection userService = this.getServiceCollection(ctx, entityViewInfo);
        long end = System.currentTimeMillis();
        logger.error((Object)("ServiceControllerBean _getMyProfessionMenuItems cost:" + (end - begin)));
        return userService;
    }

    private void vaildate(Context ctx, String id) throws EASBizException, BOSException {
        String[] ids;
        for (String id0 : ids = new String[]{"aP096K9UR6q3Sr+fOYp0OPI9KRA=", "pVyHUji3Q0OFXkS+OEKg7vI9KRA=", "skNN8NY5Qzu6775UqzIpt/I9KRA="}) {
            ObjectUuidPK pk;
            if (!id0.equals(id) || !this.exists(ctx, (IObjectPK)(pk = new ObjectUuidPK(id)))) continue;
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("alias"));
            ServiceInfo model = this.getServiceInfo(ctx, (IObjectPK)pk, selector);
            throw new SyssettinException(SyssettinException.NOT_SUPPORTED_OPERATION, new Object[]{model.getAlias()});
        }
    }

    @Override
    protected ServiceCollection _getAllMenuItems(Context ctx, Map params) throws BOSException, EASBizException {
        return this.getMenuItems(ctx, true);
    }
}

