/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.MailUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.AbstractWorkFlowFacadeControllerBean;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WorkFlowFacadeControllerBean
extends AbstractWorkFlowFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.WorkFlowFacadeControllerBean");
    private static final String SERVER_RES = "com.kingdee.shr.base.syssetting.SuspendedWorkflowResourse";

    @Override
    protected void _handelSuspendWF(Context ctx) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        String l = LocaleUtils.getShortCode(ctx);
        sb.append("SELECT PROCINST.FPROCINSTID AS FPROCINSTID, ");
        sb.append("PROCINST.FPARENTPROCINSTID AS FPARENTPROCINSTID,");
        sb.append("PROCINST.FPROCDEFNAME_").append(l).append(" AS FPROCDEFNAME,");
        sb.append("(SELECT TOP 1 FACTDEFNAME_").append(l).append(" FROM T_WFR_ActInst ACTINST WHERE ACTINST.FPROCINSTID=PROCINST.FPROCINSTID) AS FACTDEFNAME,");
        sb.append("PROCINST.FCODE AS FCODE, ");
        sb.append("PROCINST.FLASTSTATETIME AS FLASTSTATETIME,");
        sb.append("PROCINST.FINITIATORNAME_").append(l).append(" AS FINITIATORNAME, ");
        sb.append("PROCINST.FINITIATORID AS FINITIATORID ");
        sb.append("FROM T_WFR_ProcInst AS PROCINST ");
        sb.append("WHERE (PROCINST.FPROCDEFTYPE = 'NORMAL' OR PROCINST.FPROCDEFTYPE = 'MICRO') ");
        sb.append("AND FSTATE ='open.not_running.suspended' ");
        sb.append("AND FLASTSTATETIME >(SELECT FLastRunTime FROM T_SHR_JobProcessLog WHERE FJobName='handelSuspendWF') ");
        sb.append("AND FPROCDEFID in ( select FPROCDEFID from T_WFR_ProcDef where FPACKAGENAME like '%com.kingdee.eas.hr%') ");
        sb.append("ORDER BY FLASTSTATETIME DESC ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rowSet.size() == 0) {
                DbUtil.execute((Context)ctx, (String)"UPDATE T_SHR_JobProcessLog SET FLastRunTime=GETDATE() WHERE FJobName='handelSuspendWF' ");
                return;
            }
            this.sendMail(ctx, rowSet);
            DbUtil.execute((Context)ctx, (String)"UPDATE T_SHR_JobProcessLog SET FLastRunTime=GETDATE() WHERE FJobName='handelSuspendWF' ");
        }
        catch (Exception e) {
            logger.info((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void sendMail(Context ctx, IRowSet rowSet) throws Exception {
        Locale local = ctx.getOriginLocale();
        StringBuffer mailBody = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        mailBody.append(ResourceBase.getString((String)SERVER_RES, (String)"dear_user", (Locale)local));
        mailBody.append("\uff1a<br>");
        mailBody.append("&nbsp;&nbsp;").append(ResourceBase.getString((String)SERVER_RES, (String)"hello", (Locale)local)).append(",");
        mailBody.append(new SimpleDateFormat(ResourceBase.getString((String)SERVER_RES, (String)"mail_body1", (Locale)local)).format(new Date()));
        mailBody.append(ResourceBase.getString((String)SERVER_RES, (String)"mail_body2", (Locale)local)).append("<br><br>");
        mailBody.append("<table width='800' border='1' cellspacing='0' cellpadding='0' style='margin:0px auto;background-color: #E8F2FF; border:1px #D4E7FF;'>");
        mailBody.append("<tr><th>").append(ResourceBase.getString((String)SERVER_RES, (String)"workflow_number", (Locale)local));
        mailBody.append("</th><th>").append(ResourceBase.getString((String)SERVER_RES, (String)"workflow_name", (Locale)local));
        mailBody.append("</th><th>").append(ResourceBase.getString((String)SERVER_RES, (String)"activity_name", (Locale)local));
        mailBody.append("</th><th>").append(ResourceBase.getString((String)SERVER_RES, (String)"initiator_name", (Locale)local));
        mailBody.append("</th><th>").append(ResourceBase.getString((String)SERVER_RES, (String)"suspended_time", (Locale)local));
        mailBody.append("</th></tr>");
        while (rowSet.next()) {
            mailBody.append("<tr><td>").append(rowSet.getString("FCODE")).append("</td><td>");
            mailBody.append(rowSet.getString("FPROCDEFNAME")).append("</td><td>");
            mailBody.append(this.getActName(ctx, rowSet.getString("FPROCINSTID"))).append("</td><td>");
            mailBody.append(rowSet.getString("FINITIATORNAME")).append("</td><td>");
            mailBody.append(dateFormat.format(rowSet.getTimestamp("FLASTSTATETIME"))).append("</td><td></tr>");
        }
        mailBody.append("</table>");
        MailUtil mailUtil = MailUtil.getInstance((Context)ctx);
        mailUtil.sendHtmlMail(null, this.getAdminEmail(ctx), ResourceBase.getString((String)SERVER_RES, (String)"mail_title", (Locale)local), mailBody.toString());
    }

    private String getActName(Context ctx, String procInstID) throws BOSException, SQLException {
        String l = LocaleUtils.getShortCode(ctx);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)("SELECT TOP 1 FACTDEFNAME_" + l + " FROM T_WFR_ActInst ACTINST WHERE ACTINST.FPROCINSTID=? ORDER BY ACTINST.FLASTSTATETIME DESC"), (Object[])new Object[]{procInstID});
        if (result.next()) {
            return result.getString("FACTDEFNAME_" + l);
        }
        return "";
    }

    private String getAdminEmail(Context ctx) throws BOSException, SQLException {
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)"select fadminaddress from T_HR_MailServerSet");
        if (result.next()) {
            return result.getString("fadminaddress");
        }
        throw new BOSException(ResourceBase.getString((String)SERVER_RES, (String)"admin_mail_null", (Locale)ctx.getOriginLocale()));
    }
}

