/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.filter;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.shr.base.syssetting.util.DateUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public final class TimeFilterParserHelper {
    public static final String FILTERITEM_COMPARETYPE_TODAY = "today";
    public static final String FILTERITEM_COMPARETYPE_GREATER_TODAY = "greater_today";
    public static final String FILTERITEM_COMPARETYPE_LESSER_TODAY = "lesser_today";
    public static final String FILTERITEM_COMPARETYPE_THE_MONTH = "the_month";
    public static final String FILTERITEM_GREATER_THE_MONTH = "greater_the_month";
    public static final String FILTERITEM_COMPARETYPE_LAST_NATURAL_MONTH = "last_natural_month";
    public static final String FILTERITEM_COMPARETYPE_NEXT_MONTH = "next_month";
    public static final String FILTERITEM_COMPARETYPE_THIS_YEAR = "this_year";
    public static final String FILTERITEM_KEY_TIMESTAMPSTARTSTR = "00:00:00";
    public static final String FILTERITEM_KEY_TIMESTAMPENDSTR = "23:59:59";
    public static final String SPACE = " ";
    public static final String DATETIMEFORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATEFORMAT = "yyyy-MM-dd";
    public static final String DATEFORMATYMDHM = "yyyy-MM-dd HH:mm";

    public static FilterInfo buildTimestampFilterItemInfo(String compareField, Object compareValue, String compareType, CompareType compareType0, String queryCtrl, String dataType, Map datetimeOptionsMap) {
        String startDateString = "";
        String endDateString = "";
        boolean queryByTimeCtr = "time".equalsIgnoreCase(queryCtrl);
        boolean isRemoveDay = TimeFilterParserHelper.isRemoveDay(datetimeOptionsMap);
        boolean isRemoveSeconds = TimeFilterParserHelper.isRemoveSeconds(datetimeOptionsMap);
        String formatPattern = TimeFilterParserHelper.getRunTimeFormatPatternByDataType(dataType, datetimeOptionsMap);
        if (FILTERITEM_COMPARETYPE_TODAY.equalsIgnoreCase(compareType) || FILTERITEM_COMPARETYPE_THE_MONTH.equalsIgnoreCase(compareType) || FILTERITEM_COMPARETYPE_GREATER_TODAY.equalsIgnoreCase(compareType) || FILTERITEM_COMPARETYPE_LESSER_TODAY.equals(compareType) || FILTERITEM_COMPARETYPE_LAST_NATURAL_MONTH.equalsIgnoreCase(compareType) || FILTERITEM_GREATER_THE_MONTH.equalsIgnoreCase(compareType) || FILTERITEM_COMPARETYPE_NEXT_MONTH.equalsIgnoreCase(compareType) || FILTERITEM_COMPARETYPE_THIS_YEAR.equalsIgnoreCase(compareType)) {
            Date d0 = new Date();
            int year = DateTimeUtils.getYear((Date)d0);
            int month = DateTimeUtils.getMonth((Date)d0);
            int day = DateTimeUtils.getDay((Date)d0);
            Calendar begin = Calendar.getInstance();
            Calendar end = Calendar.getInstance();
            compareValue = DateTimeUtils.truncateDate((Date)d0);
            if (FILTERITEM_COMPARETYPE_TODAY.equalsIgnoreCase(compareType)) {
                begin.set(year, month - 1, day, 0, 0, 0);
                end.set(year, month - 1, day, 23, 59, 59);
                compareType0 = CompareType.EQUALS;
                startDateString = DateUtils.getCustomDateString(begin.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPSTARTSTR;
                endDateString = DateUtils.getCustomDateString(end.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
            } else if (FILTERITEM_COMPARETYPE_GREATER_TODAY.equalsIgnoreCase(compareType)) {
                begin.set(year, month - 1, day, 0, 0, 0);
                end.set(year, month - 1, day, 23, 59, 59);
                compareType0 = CompareType.GREATER;
                startDateString = DateUtils.getCustomDateString(begin.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPSTARTSTR;
                endDateString = DateUtils.getCustomDateString(end.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
            } else if (FILTERITEM_COMPARETYPE_LESSER_TODAY.equalsIgnoreCase(compareType)) {
                begin.set(year, month - 1, day, 0, 0, 0);
                end.set(year, month - 1, day, 23, 59, 59);
                compareType0 = CompareType.LESS;
                startDateString = DateUtils.getCustomDateString(begin.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPSTARTSTR;
                endDateString = DateUtils.getCustomDateString(end.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
            } else if (FILTERITEM_COMPARETYPE_THE_MONTH.equalsIgnoreCase(compareType)) {
                begin.set(year, month - 1, 1, 0, 0, 0);
                end.set(year, month - 1, DateTimeUtils.daysOfMonth((int)year, (int)month), 23, 59, 59);
                startDateString = DateUtils.getCustomDateString(begin.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPSTARTSTR;
                endDateString = DateUtils.getCustomDateString(end.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
                compareType0 = CompareType.EQUALS;
            } else if (FILTERITEM_GREATER_THE_MONTH.equalsIgnoreCase(compareType)) {
                begin.set(year, month - 1, 1, 0, 0, 0);
                end.set(year, month - 1, DateTimeUtils.daysOfMonth((int)year, (int)month), 23, 59, 59);
                startDateString = DateUtils.getCustomDateString(begin.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPSTARTSTR;
                endDateString = DateUtils.getCustomDateString(end.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
                compareType0 = CompareType.GREATER;
            } else if (FILTERITEM_COMPARETYPE_LAST_NATURAL_MONTH.equalsIgnoreCase(compareType)) {
                int preMonth = month - 2;
                int daysOfMonth = month - 1;
                if (month == 1) {
                    preMonth = 11;
                    --year;
                    daysOfMonth = 12;
                }
                begin.set(year, preMonth, 1, 0, 0, 0);
                end.set(year, preMonth, DateTimeUtils.daysOfMonth((int)year, (int)daysOfMonth), 23, 59, 59);
                startDateString = DateUtils.getCustomDateString(begin.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPSTARTSTR;
                endDateString = DateUtils.getCustomDateString(end.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
                compareType0 = CompareType.EQUALS;
            } else if (FILTERITEM_COMPARETYPE_NEXT_MONTH.equalsIgnoreCase(compareType)) {
                int nextMonth = month + 1;
                if (month == 12) {
                    nextMonth = 1;
                    ++year;
                    month = 0;
                }
                begin.set(year, month, 1, 0, 0, 0);
                end.set(year, month, DateTimeUtils.daysOfMonth((int)year, (int)nextMonth), 23, 59, 59);
                startDateString = DateUtils.getCustomDateString(begin.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPSTARTSTR;
                endDateString = DateUtils.getCustomDateString(end.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
                compareType0 = CompareType.EQUALS;
            } else if (FILTERITEM_COMPARETYPE_THIS_YEAR.equalsIgnoreCase(compareType)) {
                begin.set(year, 0, 1, 0, 0, 0);
                end.set(year, 11, 31, 23, 59, 59);
                startDateString = DateUtils.getCustomDateString(begin.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPSTARTSTR;
                endDateString = DateUtils.getCustomDateString(end.getTime(), formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
                compareType0 = CompareType.EQUALS;
            }
        } else if (queryByTimeCtr) {
            compareValue = TimeFilterParserHelper.parseValueToDateTime(compareValue, formatPattern);
            endDateString = startDateString = DateUtils.getCustomDateString((Date)compareValue, formatPattern);
        } else if ("Timestamp".equalsIgnoreCase(dataType)) {
            compareValue = TimeFilterParserHelper.parseValueToDateTime(compareValue, formatPattern);
            startDateString = DateUtils.getCustomDateString((Date)compareValue, formatPattern).toString();
            endDateString = DateUtils.getCustomDateString((Date)compareValue, formatPattern).toString();
            if (isRemoveSeconds) {
                endDateString = endDateString.substring(0, endDateString.lastIndexOf(":")) + ":59";
            }
        } else if ("Date".equalsIgnoreCase(dataType)) {
            compareValue = TimeFilterParserHelper.parseValueToDateTime(compareValue, formatPattern);
            startDateString = DateUtils.getCustomDateString((Date)compareValue, formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPSTARTSTR;
            endDateString = DateUtils.getCustomDateString((Date)compareValue, formatPattern) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
        }
        FilterInfo filterInfo = null;
        if (CompareType.EQUALS.equals((Object)compareType0)) {
            filterInfo = queryByTimeCtr && startDateString.equals(endDateString) ? TimeFilterParserHelper.assembleTimestampRealEqualFilterInfo(compareField, startDateString, endDateString, formatPattern) : TimeFilterParserHelper.assembleTimestampEqualFilterInfo(compareField, startDateString, endDateString, formatPattern);
        } else if (CompareType.NOTEQUALS.equals((Object)compareType0)) {
            filterInfo = queryByTimeCtr && startDateString.equals(endDateString) ? TimeFilterParserHelper.assembleTimestampRealNotEqualFilterInfo(compareField, startDateString, endDateString, formatPattern) : TimeFilterParserHelper.assembleTimestampNotEqualFilterInfo(compareField, startDateString, endDateString, formatPattern);
            filterInfo = TimeFilterParserHelper.assembleTimestampNotEqualFilterInfo(compareField, startDateString, endDateString, formatPattern);
        } else if (CompareType.GREATER.equals((Object)compareType0)) {
            filterInfo = TimeFilterParserHelper.assembleTimestampGreaterFilterInfo(compareField, startDateString, endDateString, formatPattern);
        } else if (CompareType.GREATER_EQUALS.equals((Object)compareType0)) {
            filterInfo = TimeFilterParserHelper.assembleTimestampGreaterEqualFilterInfo(compareField, startDateString, endDateString, formatPattern);
        } else if (CompareType.LESS.equals((Object)compareType0)) {
            filterInfo = TimeFilterParserHelper.assembleTimestampLessFilterInfo(compareField, startDateString, endDateString, formatPattern);
        } else if (CompareType.LESS_EQUALS.equals((Object)compareType0)) {
            filterInfo = TimeFilterParserHelper.assembleTimestampLessEqualFilterInfo(compareField, startDateString, endDateString, formatPattern);
        }
        return filterInfo;
    }

    private static String getRunTimeFormatPatternByDataType(String dataType, Map datetimeOptionsMap) {
        String formatPattern = "";
        if (null != datetimeOptionsMap) {
            formatPattern = TimeFilterParserHelper.getFormatPatternByDataType(dataType, datetimeOptionsMap);
        }
        if (StringUtils.isEmpty((String)formatPattern)) {
            if ("Timestamp".equalsIgnoreCase(dataType)) {
                formatPattern = DATETIMEFORMAT;
            } else if ("Date".equalsIgnoreCase(dataType)) {
                formatPattern = DATEFORMAT;
            }
        }
        return formatPattern;
    }

    private static Boolean isRemoveSeconds(Map datetimeOptionsMap) {
        if (null == datetimeOptionsMap) {
            return false;
        }
        Object isRemoveSecondsStr = datetimeOptionsMap.get("isRemoveSeconds");
        return Boolean.valueOf(String.valueOf(isRemoveSecondsStr));
    }

    private static Boolean isRemoveDay(Map datetimeOptionsMap) {
        if (null == datetimeOptionsMap) {
            return false;
        }
        Object isRemoveDayStr = datetimeOptionsMap.get("isRemoveDay");
        return Boolean.valueOf(String.valueOf(isRemoveDayStr));
    }

    private static String getFormatPatternByDataType(String dataType, Map datetimeOptionsMap) {
        String formatPattern = "";
        if (null == datetimeOptionsMap) {
            return formatPattern;
        }
        Map systemDataPattern = null;
        Object utcDataObj = datetimeOptionsMap.get("utcData");
        if (null == utcDataObj) {
            return formatPattern;
        }
        Map utcDataMap = null;
        Map utcServerMap = null;
        if (utcDataObj instanceof Map) {
            utcDataMap = (Map)utcDataObj;
            Object utcServerObj = utcDataMap.get("utcServer");
            if (null == utcServerObj) {
                return formatPattern;
            }
            if (utcServerObj instanceof Map) {
                utcServerMap = (Map)utcServerObj;
                Object patternObj = utcServerMap.get("pattern");
                if (null == patternObj) {
                    return formatPattern;
                }
                if (patternObj instanceof Map) {
                    systemDataPattern = (Map)patternObj;
                }
            }
        }
        if (null != systemDataPattern) {
            for (String key : systemDataPattern.keySet()) {
                if (!dataType.equalsIgnoreCase(key)) continue;
                formatPattern = (String)systemDataPattern.get(key);
            }
        }
        return formatPattern;
    }

    public static FilterInfo assembleTimestampRealEqualFilterInfo(String compareField, String startDateString, String endDateString, String formatPattern) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)TimeFilterParserHelper.parseValueToDateTime(endDateString, formatPattern), CompareType.EQUALS));
        return filterInfo;
    }

    public static FilterInfo assembleTimestampRealNotEqualFilterInfo(String compareField, String startDateString, String endDateString, String formatPattern) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)TimeFilterParserHelper.parseValueToDateTime(endDateString, formatPattern), CompareType.NOTEQUALS));
        return filterInfo;
    }

    private static FilterInfo assembleTimestampEqualFilterInfo(String compareField, String startDateString, String endDateString, String formatPattern) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)TimeFilterParserHelper.parseValueToDateTime(startDateString), CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)TimeFilterParserHelper.parseValueToDateTime(endDateString), CompareType.LESS_EQUALS));
        filterInfo.setMaskString("(#0 AND #1)");
        return filterInfo;
    }

    public static FilterInfo assembleTimestampNotEqualFilterInfo(String compareField, String startDateString, String endDateString, String formatPattern) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)TimeFilterParserHelper.parseValueToDateTime(startDateString), CompareType.LESS));
        filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)TimeFilterParserHelper.parseValueToDateTime(endDateString), CompareType.GREATER));
        filterInfo.setMaskString("(#0 OR #1)");
        return filterInfo;
    }

    public static FilterInfo assembleTimestampGreaterFilterInfo(String compareField, String startDateString, String endDateString, String formatPattern) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)TimeFilterParserHelper.parseValueToDateTime(endDateString), CompareType.GREATER));
        filterInfo.setMaskString("(#0)");
        return filterInfo;
    }

    public static FilterInfo assembleTimestampGreaterEqualFilterInfo(String compareField, String startDateString, String endDateString, String formatPattern) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)TimeFilterParserHelper.parseValueToDateTime(startDateString), CompareType.GREATER_EQUALS));
        filterInfo.setMaskString("(#0)");
        return filterInfo;
    }

    public static FilterInfo assembleTimestampLessFilterInfo(String compareField, String startDateString, String endDateString, String formatPattern) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)TimeFilterParserHelper.parseValueToDateTime(startDateString), CompareType.LESS));
        filterInfo.setMaskString("(#0)");
        return filterInfo;
    }

    public static FilterInfo assembleTimestampLessEqualFilterInfo(String compareField, String startDateString, String endDateString, String formatPattern) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)TimeFilterParserHelper.parseValueToDateTime(endDateString), CompareType.LESS_EQUALS));
        filterInfo.setMaskString("(#0)");
        return filterInfo;
    }

    private static Date parseValueToDate(Object compareValue) {
        try {
            return DateTimeUtils.parseDate((String)compareValue.toString(), (String)DATEFORMAT);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Date parseValueToDateTime(Object compareValue) {
        return TimeFilterParserHelper.parseValueToDateTime(compareValue, DATETIMEFORMAT);
    }

    private static Date parseValueToDateTime(Object compareValue, String fmt) {
        try {
            boolean isDaylight = DateUtils.isDaylight(compareValue.toString());
            if (isDaylight) {
                fmt = DATEFORMAT;
            }
            return DateTimeUtils.parseDate((String)compareValue.toString(), (String)fmt);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

