/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.notice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NoticeObserver {
    private static final Logger logger = Logger.getLogger(NoticeObserver.class);
    private static Set<String> osfService = new HashSet<String>();
    private static NoticeObserver instance = null;

    private NoticeObserver(Context ctx) {
        this.registerService("adviseOutSystemService");
        this.registerService("synchSHRDataToEASService");
        String sql = "select fserviceid,fservicename from t_bs_customObserver";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                if (StringUtils.isEmpty((String)rs.getString("fservicename"))) continue;
                this.registerService(rs.getString("fservicename"));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static NoticeObserver getInstance(Context ctx) {
        if (instance == null) {
            instance = new NoticeObserver(ctx);
        }
        return instance;
    }

    public void sendNotice(Context ctx, HashMap param) throws BOSException {
        if (osfService.isEmpty()) {
            return;
        }
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance(ctx);
        for (String osfServiceName : osfService) {
            try {
                long begin = System.currentTimeMillis();
                osfServiceFacade.processService(osfServiceName, param);
                long end = System.currentTimeMillis();
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)MessageFormat.format("NoticeObserver sendNotice call osf:{0},cost:{1} ms {2} s", osfServiceName, end - begin, (double)(end - begin) / 1000.0));
            }
            catch (Exception e) {
                logger.error((Object)("OSF(" + osfServiceName + ") is disable!"), (Throwable)e);
            }
        }
    }

    public synchronized void registerService(String osfServiceName) {
        osfService.add(osfServiceName);
    }

    public synchronized void removeService(String osfServiceName) {
        osfService.remove(osfServiceName);
    }

    public synchronized void clear() {
        osfService.clear();
    }
}

