/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.upgrade;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.DynamicListSettingCollection;
import com.kingdee.shr.base.syssetting.DynamicListSettingInfo;
import com.kingdee.shr.base.syssetting.ListFilterSolutionCollection;
import com.kingdee.shr.base.syssetting.ListFilterSolutionInfo;
import com.kingdee.shr.base.syssetting.ListQuerySchemeTypeEnum;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.upgrade.AbstractListFilterSchemeUpgrader;
import com.kingdee.shr.base.syssetting.app.upgrade.DynamicListSchemeHelper;
import com.kingdee.shr.base.syssetting.app.upgrade.SchemeUpgradeUtils;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DynamicListFilterSchemeUpgrader
extends AbstractListFilterSchemeUpgrader {
    @Override
    public ListFilterSolutionCollection assembleSystemSchemeModel(Context ctx) {
        ListFilterSolutionCollection listFilterSolutionCollection = new ListFilterSolutionCollection();
        try {
            DynamicListSettingCollection coll = DynamicListSchemeHelper.getDynamicListSettingCollection(ctx);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                ListFilterSolutionInfo listFilterSolutionInfo = new ListFilterSolutionInfo();
                DynamicListSettingInfo info = coll.get(i);
                listFilterSolutionInfo.setName(info.getName());
                if (info.isIsDefault()) {
                    listFilterSolutionInfo.setIsDefault(Boolean.TRUE);
                } else {
                    listFilterSolutionInfo.setIsDefault(Boolean.FALSE);
                }
                if (info.getOwner() == null) {
                    listFilterSolutionInfo.setOwner(null);
                } else {
                    listFilterSolutionInfo.setOwner(info.getOwner());
                }
                if (!StringUtils.isEmpty((String)info.getCategory())) {
                    listFilterSolutionInfo.setCategory(info.getCategory());
                }
                UIViewInfo uiview = info.getUiview();
                listFilterSolutionInfo.setUiview(uiview);
                if (ListQuerySchemeTypeEnum.SYSTEM.getName().equals(info.getType().getName())) {
                    listFilterSolutionInfo.setType(ListQuerySchemeTypeEnum.SYSTEM);
                } else if (ListQuerySchemeTypeEnum.USER.getName().equals(info.getType().getName())) {
                    listFilterSolutionInfo.setType(ListQuerySchemeTypeEnum.USER);
                }
                if (null != info && null != info.getId()) {
                    listFilterSolutionInfo.setSrcID(info.getId().toString());
                }
                listFilterSolutionInfo.setState(info.getState());
                listFilterSolutionInfo.setInner(info.isInner());
                Timestamp time = SchemeUpgradeUtils.getTime();
                listFilterSolutionInfo.setCreateTime(time);
                listFilterSolutionInfo.setLastUpdateTime(time);
                HashMap configMap = JSONUtils.convertJsonToObject(ctx, info.getConfig());
                String configStr = JSONUtils.convertObjectToJson(ctx, configMap.get("filter"));
                if ("[[]]".equals(configStr)) continue;
                String scheme = listFilterSolutionInfo.getUiview().getModel();
                Map<String, Object> filterItemMapingItem = this.assembleFilterItemMapingItem(ctx, scheme, configStr);
                Map<String, Map<String, ?>> fastFilterMap = DynamicListFilterSchemeUpgrader.assembleTargetFilterSchemeModelMap(ctx, filterItemMapingItem);
                Map<String, ?> supportSingleViewItem = fastFilterMap.get("fastFilterItem");
                List supportSingleView = null;
                Object supportSingleViewObj = configMap.get("supportSingleView");
                if (supportSingleViewObj instanceof List) {
                    Map<Object, Object> itemMap = null;
                    supportSingleView = (List)supportSingleViewObj;
                    for (Map item : supportSingleView) {
                        String key = (String)item.get("key");
                        String value = String.valueOf(item.get("value"));
                        itemMap = new HashMap();
                        if ("EMPORGRELATION".equalsIgnoreCase(key)) {
                            itemMap = this.assembleMainOfficeFastfilterItemMap(value);
                            supportSingleViewItem.put(key + ".assignType", itemMap);
                        }
                        if (!"PERSONDEGREE".equalsIgnoreCase(key)) continue;
                        itemMap = this.assembleHighestPersonDegreeFastfilterItemMap(value);
                        supportSingleViewItem.put(key + ".isHighest", itemMap);
                    }
                }
                String filterString = JSONUtils.convertObjectToJson(ctx, fastFilterMap);
                listFilterSolutionInfo.setConfig(filterString);
                listFilterSolutionCollection.add(listFilterSolutionInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listFilterSolutionCollection;
    }

    private Map<String, String> assembleMainOfficeFastfilterItemMap(String value) {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        if ("true".equalsIgnoreCase(value)) {
            itemMap.put("values", "1");
        } else if ("false".equalsIgnoreCase(value)) {
            itemMap.put("values", "0");
        }
        itemMap.put("dataType", "enum");
        itemMap.put("enumSource", "com.kingdee.eas.hr.base.AssignTypeEnum");
        return itemMap;
    }

    private Map<String, String> assembleHighestPersonDegreeFastfilterItemMap(String value) {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        if ("true".equalsIgnoreCase(value)) {
            itemMap.put("values", "1");
        } else if ("false".equalsIgnoreCase(value)) {
            itemMap.put("values", "0");
        }
        itemMap.put("dataType", "boolean");
        itemMap.put("enumSource", "");
        return itemMap;
    }

    private Map<String, Object> assembleFilterItemMapingItem(Context ctx, String scheme, String filterString) {
        List filterList = (List)JSONUtils.convertJsonToObject(ctx, filterString, List.class);
        int index = 1;
        String prefix = "t";
        HashMap<String, Object> filterItemMapingWrap = new HashMap<String, Object>();
        TreeMap<String, Map> filterItemMaping = new TreeMap<String, Map>();
        filterItemMapingWrap.put("filterItemMaping", filterItemMaping);
        StringBuffer conditionBuffer = new StringBuffer();
        int size = filterList.size();
        for (int i = 0; i < size; ++i) {
            List filterItemList = (List)filterList.get(i);
            int size0 = filterItemList.size();
            for (int j = 0; j < size0; ++j) {
                String tn = prefix + index;
                Map filterItem = (Map)filterItemList.get(j);
                String alias = filterItem.get("alias").toString();
                String name = filterItem.get("name").toString();
                this.processEnumContionKeyMap(ctx, scheme, filterItem, name);
                filterItem.put("alias", alias.replace("\"", ""));
                filterItemMaping.put(tn, filterItem);
                ++index;
                if (j == size0 - 1) {
                    conditionBuffer.append(tn);
                    continue;
                }
                conditionBuffer.append(tn).append(" and ");
            }
            if (i == size - 1) continue;
            conditionBuffer.append(" or ");
        }
        filterItemMapingWrap.put("condition", conditionBuffer.toString());
        return filterItemMapingWrap;
    }

    private void processEnumContionKeyMap(Context ctx, String scheme, Map<String, Object> filterItem, String name) {
        QueryConfigFieldInfo queryConfigFieldInfo = DynamicListSchemeHelper.getQueryConfigFieldInfo(ctx, scheme, name);
        if (null != queryConfigFieldInfo) {
            String id = queryConfigFieldInfo.getId().toString();
            StructureConfigColumnsInfo info = queryConfigFieldInfo.getFactField();
            String dataType = info.getDataType();
            String enumSource = info.getEnumSource();
            HashMap<String, String> conditionKeyMap = new HashMap<String, String>();
            conditionKeyMap.put("id", id);
            conditionKeyMap.put("uipk", null);
            conditionKeyMap.put("enumSource", enumSource);
            conditionKeyMap.put("type", dataType);
            conditionKeyMap.put("name", queryConfigFieldInfo.getAlias());
            conditionKeyMap.put("field", queryConfigFieldInfo.getFactField().getNumber());
            filterItem.put("condition_key", conditionKeyMap);
        }
    }

    private static Map<String, Map<String, ?>> assembleTargetFilterSchemeModelMap(Context ctx, Map<String, Object> filterItemMapingItem) {
        HashMap targetMap = new HashMap();
        HashMap fastFilterItemMap = new HashMap();
        HashMap<String, Object> advancedFilter = new HashMap<String, Object>();
        Map filterItemMapingItem0 = (Map)filterItemMapingItem.get("filterItemMaping");
        advancedFilter.put("filterItemMaping", filterItemMapingItem0);
        Object condition = filterItemMapingItem.get("condition");
        advancedFilter.put("condition", condition);
        targetMap.put("advancedFilter", advancedFilter);
        targetMap.put("fastFilterItem", fastFilterItemMap);
        return targetMap;
    }

    @Override
    public ListFilterSolutionCollection assembleUserSchemeModel(Context ctx) {
        return null;
    }
}

