/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.upgrade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.DynamicListSettingCollection;
import com.kingdee.shr.base.syssetting.DynamicListSettingInfo;
import com.kingdee.shr.base.syssetting.IListSetSolution;
import com.kingdee.shr.base.syssetting.ListQuerySchemeTypeEnum;
import com.kingdee.shr.base.syssetting.ListSetSolutionCollection;
import com.kingdee.shr.base.syssetting.ListSetSolutionFactory;
import com.kingdee.shr.base.syssetting.ListSetSolutionInfo;
import com.kingdee.shr.base.syssetting.app.upgrade.AbstractSchemeUpgrader;
import com.kingdee.shr.base.syssetting.app.upgrade.DynamicListSchemeHelper;
import com.kingdee.shr.base.syssetting.app.upgrade.SchemeUpgradeUtils;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DynamicListSetSchemeUpgrader
extends AbstractSchemeUpgrader {
    private static Logger logger = Logger.getLogger(DynamicListSetSchemeUpgrader.class);
    private static final String SORTER = "sorter";
    private static final String LOCKCOLUMN = "lockColumn";
    private static final String COLUMNS = "columns";

    @Override
    public List<Map<String, Object>> update(Context ctx) throws Exception {
        return this.doUpdate(ctx);
    }

    private List<Map<String, Object>> doUpdate(Context ctx) throws BOSException, EASBizException {
        DynamicListSettingCollection coll = DynamicListSchemeHelper.getDynamicListSettingCollection(ctx);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ListSetSolutionCollection listSetSolutionCollection = new ListSetSolutionCollection();
        StringBuffer errorInfo = new StringBuffer();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            ListSetSolutionInfo listSetSolutionInfo = new ListSetSolutionInfo();
            DynamicListSettingInfo info = coll.get(i);
            listSetSolutionInfo.setName(info.getName());
            if (info.isIsDefault()) {
                listSetSolutionInfo.setIsDefault(Boolean.TRUE);
            } else {
                listSetSolutionInfo.setIsDefault(Boolean.FALSE);
            }
            if (info.getOwner() == null) {
                listSetSolutionInfo.setOwner(null);
            } else {
                listSetSolutionInfo.setOwner(info.getOwner());
            }
            listSetSolutionInfo.setUiview(info.getUiview());
            if (ListQuerySchemeTypeEnum.SYSTEM.getName().equals(info.getType().getName())) {
                listSetSolutionInfo.setType(ListQuerySchemeTypeEnum.SYSTEM);
            } else if (ListQuerySchemeTypeEnum.USER.getName().equals(info.getType().getName())) {
                listSetSolutionInfo.setType(ListQuerySchemeTypeEnum.USER);
            }
            String category = info.getCategory();
            if (!StringUtils.isEmpty((String)category)) {
                listSetSolutionInfo.setCategory(category);
            }
            listSetSolutionInfo.setState(info.getState());
            listSetSolutionInfo.setInner(info.isInner());
            Timestamp time = SchemeUpgradeUtils.getTime();
            listSetSolutionInfo.setCreateTime(time);
            listSetSolutionInfo.setLastUpdateTime(time);
            if (null != info && null != info.getId()) {
                listSetSolutionInfo.setSrcID(info.getId().toString());
            }
            try {
                HashMap configMap = JSONUtils.convertJsonToObject(ctx, info.getConfig());
                HashMap map = new HashMap();
                map.put(SORTER, configMap.get(SORTER));
                map.put(COLUMNS, configMap.get(COLUMNS));
                map.put(LOCKCOLUMN, configMap.get(LOCKCOLUMN));
                String filterString = JSONUtils.convertObjectToJson(ctx, map);
                listSetSolutionInfo.setConfig(filterString);
                listSetSolutionCollection.add(listSetSolutionInfo);
                continue;
            }
            catch (Exception e) {
                if (i > 0) {
                    errorInfo.append(",");
                }
                list.add(this.generateNotHandlerMap(info, SHRSysSettingResourceUtil.getResource("upgrade_error", ctx, e.getMessage()), SHRSysSettingResourceUtil.getResource("add_byself", ctx)));
                errorInfo.append(info.getId().toString());
            }
        }
        if (!StringUtils.isEmpty((String)errorInfo.toString())) {
            logger.error((Object)("DynamicListSettingInfo leavel up error ids:" + errorInfo.toString()));
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        IListSetSolution localInstance = ListSetSolutionFactory.getLocalInstance(ctx);
        Set<String> sourceIdSet = this.getSourceSchemeIdSet(ctx);
        int size2 = listSetSolutionCollection.size();
        for (int i = 0; i < size2; ++i) {
            ListSetSolutionInfo item = listSetSolutionCollection.get(i);
            boolean isExist = this.isExistSourceScheme(sourceIdSet, item.getSrcID(), list);
            if (!isExist) {
                colls.add((CoreBaseInfo)item);
                continue;
            }
            list.add(this.generateNotHandlerMap(item, SHRSysSettingResourceUtil.getResource("solution_exist", ctx) + "," + SHRSysSettingResourceUtil.getResource("do_not_upgrade", ctx), SHRSysSettingResourceUtil.getResource("do_not_upgrade", ctx)));
        }
        if (colls.size() > 0) {
            localInstance.saveBatchData(colls);
        }
        return list;
    }

    @Override
    public ICoreBase getBizInterface(Context ctx) throws BOSException {
        return ListSetSolutionFactory.getLocalInstance(ctx);
    }
}

