/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.MethodInfo;
import com.kingdee.bos.bsf.service.OSFResponse;
import com.kingdee.bos.bsf.service.ParameterInfo;
import com.kingdee.bos.bsf.service.PermType;
import com.kingdee.bos.bsf.service.PermissionInfo;
import com.kingdee.bos.bsf.service.ResExpData;
import com.kingdee.bos.bsf.service.ServiceInfo;
import com.kingdee.bos.bsf.service.SubParameterInfo;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.api.service.SHRFunctionPermissionService;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.MSFServiceOutLogFactory;
import com.kingdee.shr.base.syssetting.ServiceBizException;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.app.cache.PermItemURLCache;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.secrity.AESUtils;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.util.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MsfServiceUtil {
    private static Logger logger = Logger.getLogger(MsfServiceUtil.class);

    private MsfServiceUtil() {
    }

    public static Object processService(Context ctx, ServiceInfo serviceInfo, Map<String, Object> param) throws EASBizException, BOSException {
        HashMap<String, Object> cleanParam = new HashMap<String, Object>();
        String reqMethod = "process";
        MethodInfo methodInfo = null;
        Object result = null;
        IObjectPK logPk = null;
        Object logResult = null;
        int logStatus = 1;
        try {
            if (0 == serviceInfo.getState()) {
                throw new ServiceBizException(ServiceBizException.SERVICE_STATE_UNENABLE);
            }
            if (2 == serviceInfo.getState()) {
                throw new ServiceBizException(ServiceBizException.SERVICE_STATE_DISABLE);
            }
            methodInfo = MsfServiceUtil.getMethodInfo(reqMethod, serviceInfo);
            MsfServiceUtil.inputHandler(ctx, serviceInfo, methodInfo, cleanParam, param);
            logPk = MsfServiceUtil.addOutInputLog(ctx, serviceInfo, cleanParam, reqMethod);
            IHRMsfService msfService = MsfServiceUtil.getIHRMsfService(ctx, serviceInfo, param);
            MsfServiceUtil.checkFunctionPermission(ctx, methodInfo, serviceInfo, cleanParam);
            if (!"process".equals(reqMethod)) {
                throw new ServiceBizException(ServiceBizException.METHOD_NOT_FOUND, new Object[]{reqMethod});
            }
            result = msfService.process(ctx, cleanParam);
            if (cleanParam.containsKey("_biz_error_code_")) {
                param.put("_biz_error_code_", cleanParam.get("_biz_error_code_"));
                param.put("_biz_error_msg_", cleanParam.get("_biz_error_msg_"));
                logStatus = 0;
                logResult = cleanParam.get("_biz_error_code_") + ":" + cleanParam.get("_biz_error_msg_");
            }
            logResult = result;
        }
        catch (NullPointerException e) {
            logResult = MsfServiceUtil.getExceptionStackErrorMessage(e);
            logStatus = 0;
            MsfServiceUtil.addOutOutputLog(ctx, logPk, logResult, logStatus, serviceInfo);
            throw new BOSException((Throwable)e);
        }
        catch (ClassCastException e) {
            MsfServiceUtil.addOutOutputLog(ctx, logPk, logResult, logStatus, serviceInfo);
            logResult = MsfServiceUtil.getExceptionStackErrorMessage(e);
            logStatus = 0;
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            logResult = MsfServiceUtil.getExceptionStackErrorMessage((Exception)((Object)e));
            logStatus = 0;
            MsfServiceUtil.addOutOutputLog(ctx, logPk, logResult, logStatus, serviceInfo);
            throw e;
        }
        catch (Exception e) {
            logResult = MsfServiceUtil.getExceptionStackErrorMessage(e);
            logStatus = 0;
            MsfServiceUtil.addOutOutputLog(ctx, logPk, logResult, logStatus, serviceInfo);
            if (e.getClass().getName().endsWith("WafBizException")) {
                throw new SyssettinException(SyssettinException.CUSTOM_EXCEPTION, new Object[]{e.getMessage()});
            }
            throw new BOSException((Throwable)e);
        }
        MsfServiceUtil.addOutOutputLog(ctx, logPk, logResult, logStatus, serviceInfo);
        return result;
    }

    private static boolean isOpenLog(Context ctx) {
        try {
            return Boolean.parseBoolean(ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"OPEN_SHR_OUT_API_LOG", null, (boolean)false));
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return true;
    }

    public static boolean isFormat(Context ctx, ServiceInfo serviceInfo) {
        if (MsfServiceUtil.isSHRAPIFormt(ctx)) {
            if (null == serviceInfo) {
                return true;
            }
            return serviceInfo.isResFormat();
        }
        return false;
    }

    private static boolean isSHRAPIFormt(Context ctx) {
        try {
            return Boolean.parseBoolean(ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"SHR_API_FORMAT_RESPONSE", null, (boolean)false));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return false;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean isSHRAPIInnerAndOuterCheck(Context ctx) {
        try {
            return Boolean.parseBoolean(ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"SHR_API_INER_OUT_CHECK", null, (boolean)false));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return false;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void addOutOutputLog(Context ctx, IObjectPK logPk, Object logResult, int logStatus, ServiceInfo serviceInfo) {
        if (!MsfServiceUtil.isOpenLog(ctx)) {
            return;
        }
        if (null != serviceInfo && serviceInfo.isLogEnable() && null != logPk) {
            try {
                HashMap<String, Object> logData = new HashMap<String, Object>();
                logData.put("FStatus", logStatus);
                if (null == logResult) {
                    logData.put("FOutXml", "");
                } else {
                    try {
                        logData.put("FOutXml", JSONUtils.convertObjectToJson(ctx, logResult));
                    }
                    catch (Exception e) {
                        logData.put("FOutXml", String.valueOf(logResult));
                    }
                }
                logData.put("FID", logPk.toString());
                MSFServiceOutLogFactory.getLocalInstance(ctx).wirteOutputLog(logData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String getExceptionStackErrorMessage(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private static IObjectPK addOutInputLog(Context ctx, ServiceInfo serviceInfo, Map<String, Object> param, String reqMethod) {
        if (!MsfServiceUtil.isOpenLog(ctx)) {
            return null;
        }
        if (null != serviceInfo && serviceInfo.isLogEnable()) {
            try {
                HashMap<String, String> logData = new HashMap<String, String>();
                logData.put("FServiceName", serviceInfo.getServiceName());
                logData.put("FServiceAlias", serviceInfo.getDescription());
                logData.put("FServiceClass", serviceInfo.getServiceClassName());
                HashMap<String, Object> inputParam = new HashMap<String, Object>();
                if (null != param && !param.isEmpty()) {
                    inputParam.putAll(param);
                    if (inputParam.containsKey("HttpServletRequest")) {
                        inputParam.remove("HttpServletRequest");
                    }
                    if (inputParam.containsKey("HttpServletResponse")) {
                        inputParam.remove("HttpServletResponse");
                    }
                    if (inputParam.containsKey("_session_")) {
                        inputParam.remove("_session_");
                    }
                    if (inputParam.containsKey("req_header_referer")) {
                        inputParam.remove("req_header_referer");
                    }
                }
                logData.put("FInputXml", JSONUtils.convertObjectToJson(ctx, inputParam));
                return MSFServiceOutLogFactory.getLocalInstance(ctx).writeInputLog(logData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static IHRMsfService getIHRMsfService(Context ctx, ServiceInfo serviceInfo, Map<String, Object> param) throws BOSException {
        try {
            return (IHRMsfService)ServiceLocator.getInstance().createService(ctx, serviceInfo.getServiceName(), serviceInfo.getServiceClassName(), serviceInfo.getServiceInterfaceName());
        }
        catch (Exception e) {
            e.printStackTrace();
            if (null != param) {
                throw new BOSException("cannot load service ,serviceName=" + serviceInfo.getServiceName() + " serviceClassName=" + serviceInfo.getServiceClassName() + " param is :" + param.toString());
            }
            throw new BOSException("cannot load service ,serviceName=" + serviceInfo.getServiceName() + " serviceClassName=" + serviceInfo.getServiceClassName() + " param is null");
        }
    }

    public static MethodInfo getMethodInfo(String reqMethod, ServiceInfo serviceInfo) throws EASBizException {
        for (MethodInfo m : serviceInfo.getMethod()) {
            if (!reqMethod.equals(m.getName())) continue;
            return m;
        }
        throw new ServiceBizException(ServiceBizException.SERVICE_METHOD_NOT_FOUND, new Object[]{serviceInfo.getServiceName(), reqMethod});
    }

    private static Object getPermParam(PermType pt, Map<String, Object> cleanParam) {
        String type = pt.getType();
        if ("value".equals(type.trim())) {
            return pt.getValue();
        }
        return cleanParam.get(pt.getValue());
    }

    public static String encode(String sourceValue, String secretKey) throws Exception {
        return AESUtils.cbcEncrypt(sourceValue, secretKey);
    }

    public static void setExtData(OSFResponse result, String encryptKey) throws Exception {
        ResExpData extData = new ResExpData();
        result.set_e_x_t_d_(extData);
        if (!StringUtils.isEmpty((String)encryptKey)) {
            extData.set_d_k_(AESUtils.generateKey(16));
            extData.set_e_s_k_(AESUtils.cbcEncrypt(encryptKey, extData.get_d_k_()));
        }
    }

    public static String decode(String encodeValue, String secretKey) throws Exception {
        return AESUtils.cbcDecrypt(encodeValue, secretKey);
    }

    private static Object getValue(Context ctx, SubParameterInfo sp, Map<String, Object> param, String secretKey) throws Exception {
        String type = sp.getType();
        Object value = param.get(sp.getName());
        if (value == null) {
            value = sp.getValue();
        }
        if (value == null) {
            return null;
        }
        if ("java.lang.String".equalsIgnoreCase(type.trim()) || "String".equalsIgnoreCase(type.trim())) {
            if (value instanceof Map || value instanceof List) {
                return JSONUtils.convertObjectToJson(ctx, value);
            }
            return value.toString();
        }
        if ("java.lang.Integer".equalsIgnoreCase(type.trim())) {
            return new BigDecimal(value.toString()).intValue();
        }
        if (value.getClass().getName().equals(type.trim())) {
            return value;
        }
        try {
            Class<?> clazz = Class.forName(type.toString());
            Object obj = JSONUtils.convertJsonToObject(ctx, value.toString(), clazz);
            return obj;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String getBindPermItemIdValue(MethodInfo mi, Map<String, Object> param) {
        String bindPermValue = "";
        if (null != mi && null != mi.getParameters() && !mi.getParameters().isEmpty()) {
            block0: for (ParameterInfo p : mi.getParameters()) {
                if (!"param".equals(p.getName())) continue;
                if (param == null) break;
                if (null == p.getSubparameters() || p.getSubparameters().isEmpty()) continue;
                for (SubParameterInfo sp : p.getSubparameters()) {
                    if (!"permItemId".equalsIgnoreCase(sp.getName())) continue;
                    bindPermValue = sp.getBindPermValue();
                    continue block0;
                }
            }
        }
        return bindPermValue;
    }

    public static void checkOuterAndInnerOsfPermission(Context ctx, String serviceName, ServiceInfo serviceInfo, boolean isOuterCall) throws EASBizException {
        if (null == serviceInfo) {
            throw new ServiceBizException(ServiceBizException.SERVICE_NOT_FOUND, new Object[]{serviceName});
        }
        if (!MsfServiceUtil.isSHRAPIInnerAndOuterCheck(ctx)) {
            return;
        }
        if (!serviceInfo.isOuterOsf() && isOuterCall) {
            throw new ServiceBizException(ServiceBizException.OUTER_CALL_LOCAL_ERROR);
        }
    }

    private static void checkFunctionPermission(Context ctx, MethodInfo methodInfo, ServiceInfo serviceInfo, Map<String, Object> cleanParam) throws BOSException, EASBizException {
        PermissionInfo pi;
        if (null != methodInfo && "process".equals(methodInfo.getName()) && null != methodInfo.getPermission() && null != methodInfo.getPermission().getPermType() && !methodInfo.getPermission().getPermType().isEmpty()) {
            for (PermType pt : methodInfo.getPermission().getPermType()) {
                String name = pt.getName();
                HashMap<String, Object> permParam = MsfServiceUtil.getPermParam(pt, cleanParam);
                if ("personRangeCheck".equals(name)) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("userID", permParam);
                    params.put("permItemId", cleanParam.get("permItemId"));
                    permParam = params;
                }
                boolean hasPermission = false;
                hasPermission = ctx != null ? MSFServiceFacadeFactory.getLocalInstance(ctx).checkPermission(name, permParam) : MSFServiceFacadeFactory.getRemoteInstance().checkPermission(name, permParam);
                if (hasPermission) continue;
                throw new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION);
            }
        } else if (null != methodInfo && null != methodInfo.getPermission() && (pi = methodInfo.getPermission()).isValidateFun()) {
            String url = MessageFormat.format("/dynamic.do?method={0}#uri=OSF", serviceInfo.getServiceName());
            PermItemInfo p = PermItemURLCache.getPermItemInfoByURL(ctx, url);
            if (null == p) {
                throw new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION);
            }
            SHRFunctionPermissionService.checkCurrnetUserFunctionPermission((Context)ctx, (PermItemInfo)p);
            cleanParam.put("permItemId", cleanParam.get("permItemId"));
        }
    }

    private static void inputHandler(Context ctx, ServiceInfo serviceInfo, MethodInfo methodInfo, Map<String, Object> cleanParam, Map<String, Object> param) throws EASBizException {
        if (null != methodInfo && null != methodInfo.getParameters() && !methodInfo.getParameters().isEmpty()) {
            for (ParameterInfo p : methodInfo.getParameters()) {
                if (!"param".equals(p.getName())) continue;
                if (param == null) break;
                List<SubParameterInfo> sp = p.getSubparameters();
                try {
                    if (null == sp || sp.isEmpty()) continue;
                    StringBuilder sb = new StringBuilder();
                    for (SubParameterInfo spp : sp) {
                        if (spp.isRequired() && (!param.containsKey(spp.getName()) || StringUtils.isEmpty((String)String.valueOf(param.get(spp.getName()))))) {
                            sb.append(spp.getName()).append(",");
                        }
                        cleanParam.put(spp.getName(), MsfServiceUtil.getValue(ctx, spp, param, serviceInfo.getEncryptKey()));
                    }
                    String msg = sb.toString();
                    if (StringUtils.isEmpty((String)msg)) continue;
                    msg = msg.substring(0, msg.length() - 1);
                    throw new ServiceBizException(ServiceBizException.SERVICE_PARAM_REQUIRED_MISS, new Object[]{msg});
                }
                catch (ServiceBizException e) {
                    throw e;
                }
                catch (Exception e2) {
                    throw new SyssettinException(SyssettinException.PARAMNOTVALID);
                }
            }
        }
        if ("process".equals(methodInfo.getName())) {
            String bindPermIdValue;
            Object permItemIdParamObj;
            cleanParam.put("req_header_referer", param.get("req_header_referer"));
            if (param != null) {
                if (param.containsKey("HttpServletRequest")) {
                    cleanParam.put("HttpServletRequest", param.get("HttpServletRequest"));
                }
                if (param.containsKey("HttpServletResponse")) {
                    cleanParam.put("HttpServletResponse", param.get("HttpServletResponse"));
                }
                if (param.containsKey("_session_")) {
                    cleanParam.put("_session_", param.get("_session_"));
                }
            }
            if ((null == (permItemIdParamObj = cleanParam.get("permItemId")) || StringUtils.isEmpty((String)permItemIdParamObj.toString())) && !StringUtils.isEmpty((String)(bindPermIdValue = MsfServiceUtil.getBindPermItemIdValue(methodInfo, cleanParam)))) {
                logger.info((Object)("[ service name " + serviceInfo.getServiceName() + ", has config  bindPermIdValue , bindPermIdValue is " + bindPermIdValue + "]"));
                cleanParam.put("permItemId", bindPermIdValue);
            }
        }
    }

    public static void setErrorCodeAndMessage(OSFResponse res, Exception e, ServiceInfo serviceInfo, Map<String, Object> param) {
        res.setErrMsg(e.getMessage());
        res.setErrCode(1);
        res.set_e_x_t_d_(new ResExpData());
        if (e instanceof EASBizException) {
            if (e instanceof ServiceBizException) {
                ServiceBizException se = (ServiceBizException)((Object)e);
                if (ServiceBizException.SERVICE_NOT_FOUND.getCode().equals(se.getSubCode())) {
                    res.setErrCode(4004);
                } else if (ServiceBizException.LOCAL_CALL_OUTER_ERROR.getCode().equals(se.getSubCode()) || ServiceBizException.OUTER_CALL_LOCAL_ERROR.getCode().equals(se.getSubCode())) {
                    res.setErrCode(4003);
                    res.setErrMsg(se.getMessage() + new ServiceBizException(ServiceBizException.SERVICE_TYPE_COMPARE_ERROR).getMessage());
                } else if (ServiceBizException.SERVICE_STATE_UNENABLE.getCode().equals(se.getSubCode())) {
                    res.setErrCode(4001);
                } else if (ServiceBizException.SERVICE_STATE_DISABLE.getCode().equals(se.getSubCode())) {
                    res.setErrCode(4002);
                } else if (ServiceBizException.SERVICE_PARAM_REQUIRED_MISS.getCode().equals(se.getSubCode())) {
                    res.setErrCode(4005);
                }
            } else if (e instanceof SyssettinException) {
                SyssettinException se = (SyssettinException)((Object)e);
                if (SyssettinException.PARAMNOTVALID.getCode().equals(se.getSubCode())) {
                    res.setErrCode(4005);
                }
            } else if (e instanceof ShrPermissionException) {
                ShrPermissionException spe = (ShrPermissionException)e;
                if (ShrPermissionException.NO_FUNCTION_PERMISSION.getCode().equals(spe.getSubCode())) {
                    res.setErrCode(6000);
                } else if (ShrPermissionException.NO_DATA_PERMISSION.getCode().equals(spe.getSubCode())) {
                    res.setErrCode(6001);
                }
            } else if (e instanceof PermissionException) {
                res.setErrCode(6000);
            }
        } else {
            res.setErrCode(5000);
            String msg = MsfServiceUtil.checkParamMsg(serviceInfo, param);
            if (StringUtils.isEmpty((String)msg)) {
                res.setErrMsg(new ServiceBizException(ServiceBizException.SERVICE_INNER_ERROR).getMessage());
            } else {
                res.setErrMsg(new ServiceBizException(ServiceBizException.SERVICE_INNER_ERROR).getMessage() + msg);
            }
        }
        res.setBizCode(String.valueOf(res.getErrCode()));
    }

    private static String checkParamMsg(ServiceInfo serviceInfo, Map<String, Object> param) {
        if (null == serviceInfo) {
            return null;
        }
        try {
            MethodInfo methodInfo = MsfServiceUtil.getMethodInfo("process", serviceInfo);
            if (null != methodInfo && null != methodInfo.getParameters() && !methodInfo.getParameters().isEmpty()) {
                for (ParameterInfo p : methodInfo.getParameters()) {
                    String msg0;
                    if (!"param".equals(p.getName())) continue;
                    List<SubParameterInfo> sp = p.getSubparameters();
                    int paramIndex = 0;
                    int paramValueIndex = 0;
                    StringBuilder sb = new StringBuilder();
                    if (null != sp && !sp.isEmpty()) {
                        for (SubParameterInfo spp : sp) {
                            ++paramIndex;
                            if (null == param) {
                                sb.append(spp.getName()).append(",");
                                continue;
                            }
                            if (!param.containsKey(spp.getName())) {
                                sb.append(spp.getName()).append(",");
                                continue;
                            }
                            ++paramValueIndex;
                        }
                    }
                    if (StringUtils.isEmpty((String)(msg0 = sb.toString()))) continue;
                    msg0 = msg0.substring(0, msg0.length() - 1);
                    return new ServiceBizException(ServiceBizException.SERVICE_PARAM_CHECK_MSG, new Object[]{String.valueOf(paramIndex), String.valueOf(paramValueIndex), msg0}).getMessage();
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return null;
    }
}

