/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.FieldRuleFactory;
import com.kingdee.shr.base.syssetting.FieldRuleInfo;
import com.kingdee.shr.base.syssetting.IFieldRule;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.dataplatform.variable.VariableServiceFactory;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRuleUtils {
    private static Logger logger = LoggerFactory.getLogger(FieldRuleUtils.class);
    private static String regexFormat = "\\b{0}\\(([^)]*)\\)";

    private FieldRuleUtils() {
    }

    public static String getFieldRuleIDByUipk(Context ctx, String uipk) throws BOSException, EASBizException {
        String oql = "select id where uiview.uipk = '" + uipk + "'";
        FieldRuleInfo fieldRuleInfo = null;
        IFieldRule iFieldRule = FieldRuleFactory.getLocalInstance(ctx);
        if (iFieldRule.exists(oql)) {
            fieldRuleInfo = iFieldRule.getFieldRuleInfo(oql);
        }
        return null != fieldRuleInfo ? fieldRuleInfo.getId().toString() : "";
    }

    public static Object getVariableValue(Context ctx, String variableName) {
        try {
            return VariableServiceFactory.getSystemVariableResult((Context)ctx, (String)variableName, new HashMap());
        }
        catch (BOSException | EASBizException e) {
            logger.error("GetVariableValue error, variableName : {}", (Object)variableName);
            e.printStackTrace();
            return null;
        }
    }

    public static Object getVariableValue(Context ctx, String variableName, String text) {
        Object result = null;
        try {
            if (StringUtils.isEmpty((String)text)) {
                return FieldRuleUtils.getVariableValue(ctx, variableName);
            }
            String regex = MessageFormat.format(regexFormat, variableName);
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(text);
            HashMap<String, String[]> param = new HashMap<String, String[]>();
            if (matcher.find()) {
                String parameters = matcher.group(1);
                String[] runParamValues = parameters.split(",");
                param.put("variableFunctionParams", runParamValues);
                result = VariableServiceFactory.getSystemVariableResult((Context)ctx, (String)variableName, param);
            } else {
                result = FieldRuleUtils.getVariableValue(ctx, variableName);
            }
        }
        catch (BOSException | EASBizException e) {
            logger.error("GetVariableValue error, variableName : {}, text : {}", (Object)variableName, (Object)text);
            e.printStackTrace();
        }
        return result;
    }

    public static String getLocalValue(Context ctx, Object value) {
        if (null == value) {
            return null;
        }
        try {
            if (value instanceof Map) {
                Map map = (Map)value;
                String alias = (String)map.get(ctx.getLocale().toString());
                if (StringUtils.isEmpty((String)alias)) {
                    alias = (String)map.get("l2");
                }
                return alias;
            }
            if (value instanceof Boolean) {
                if (Boolean.TRUE.equals(value)) {
                    return "true";
                }
                return "false";
            }
            return String.valueOf(value);
        }
        catch (Exception e) {
            logger.error("GetLocalValue error , value : {}", value);
            e.printStackTrace();
            return null;
        }
    }

    public static Boolean getBooleanFieldValue(Object value) {
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        Boolean v = Boolean.FALSE;
        try {
            if (!StringUtils.isEmpty((String)((String)value)) && ("1".equals(value) || "true".equals(value))) {
                v = Boolean.TRUE;
            }
        }
        catch (Exception e) {
            logger.error("GetBooleanFieldValue error , value : {}", value);
            e.printStackTrace();
        }
        return v;
    }

    public static Object getNumberFieldValue(String dataTypeName, Object value) {
        try {
            if (value instanceof String) {
                if (StringUtils.isEmpty((String)((String)value))) {
                    return null;
                }
                if (DataType.SHORT.toString().equalsIgnoreCase(dataTypeName)) {
                    return Short.valueOf((String)value);
                }
                if (DataType.INTEGER.toString().equalsIgnoreCase(dataTypeName)) {
                    return Integer.valueOf((String)value);
                }
                if (DataType.LONG.toString().equalsIgnoreCase(dataTypeName)) {
                    return Long.valueOf((String)value);
                }
                if (DataType.FLOAT.toString().equalsIgnoreCase(dataTypeName)) {
                    return Float.valueOf((String)value);
                }
                if (DataType.DOUBLE.toString().equalsIgnoreCase(dataTypeName)) {
                    return Double.valueOf((String)value);
                }
                if (DataType.DECIMAL.toString().equalsIgnoreCase(dataTypeName)) {
                    return new BigDecimal((String)value);
                }
            }
            return value;
        }
        catch (Exception e) {
            logger.error("GetNumberFieldValue error , dataTypeName : {} , value : {}", (Object)dataTypeName, value);
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDateFieldValue(Object value) {
        try {
            if (value instanceof String) {
                return DateTimeUtils.parseDate((String)((String)value));
            }
            return (Date)value;
        }
        catch (Exception e) {
            logger.error("GetDateFieldValue error , value : {}", value);
            e.printStackTrace();
            return null;
        }
    }

    public static CoreBaseInfo getF7FieldValue(Context ctx, Object defaultValue, String entityNmae, String submitFormat) {
        String billid = "";
        try {
            if (defaultValue instanceof Map) {
                Map map = (Map)defaultValue;
                billid = (String)map.get("v");
                if (BOSUuid.isValid((String)billid, (boolean)true)) {
                    return FieldRuleUtils.getValue(ctx, billid, entityNmae);
                }
            } else {
                if (defaultValue instanceof String && BOSUuid.isValid((String)((String)defaultValue), (boolean)true)) {
                    billid = (String)defaultValue;
                    return FieldRuleUtils.getValue(ctx, billid, entityNmae);
                }
                if (defaultValue instanceof IObjectValue) {
                    return (CoreBaseInfo)defaultValue;
                }
                String defaultValueType = null;
                if (null != defaultValue) {
                    defaultValueType = defaultValue.getClass().getName();
                }
                logger.error("FieldRule fetF7FieldValue Error : defaultValueType[{}]", (Object)defaultValueType);
            }
        }
        catch (Exception e) {
            logger.error("GetF7FieldValue error, entityName : {}, value : {}", (Object)entityNmae, (Object)billid);
            e.printStackTrace();
        }
        return null;
    }

    public static Object getEnumFieldValue(String enumSource, Object value) {
        try {
            if (value instanceof Enum) {
                return value;
            }
            if (!StringUtils.isEmpty((String)enumSource) && null != value) {
                return MetaDataUtil.findEnumByValue(enumSource, value);
            }
            return value;
        }
        catch (Exception e) {
            logger.error("GetEnumFieldValue error, value : {}", value);
            e.printStackTrace();
            return null;
        }
    }

    public static Boolean isNumberType(String dataTypeName) {
        return DataType.SHORT.toString().equalsIgnoreCase(dataTypeName) || DataType.INTEGER.toString().equalsIgnoreCase(dataTypeName) || DataType.LONG.toString().equalsIgnoreCase(dataTypeName) || DataType.FLOAT.toString().equalsIgnoreCase(dataTypeName) || DataType.DOUBLE.toString().equalsIgnoreCase(dataTypeName) || DataType.DECIMAL.toString().equalsIgnoreCase(dataTypeName);
    }

    public static void setDefaultValue(Map<String, Object> editGridFieldValue, Map<String, Object> groupFieldValue, IObjectValue coreBaseInfo) {
        HashMap<String, List<Object>> dynamicComposeFiledRuntimeClassMapping = new HashMap<String, List<Object>>();
        if (null != groupFieldValue) {
            for (Map.Entry<String, Object> entry : groupFieldValue.entrySet()) {
                String field = entry.getKey();
                if (field.contains(".")) {
                    FieldRuleUtils.setEntrysValue(entry.getKey(), entry.getValue(), dynamicComposeFiledRuntimeClassMapping, coreBaseInfo);
                    continue;
                }
                coreBaseInfo.put(entry.getKey(), entry.getValue());
            }
        }
        if (null != editGridFieldValue) {
            for (Map.Entry<String, Object> entry : editGridFieldValue.entrySet()) {
                FieldRuleUtils.setEntrysValue(entry.getKey(), entry.getValue(), dynamicComposeFiledRuntimeClassMapping, coreBaseInfo);
            }
        }
    }

    private static void setEntrysValue(String field, Object value, Map<String, List<Object>> dynamicComposeFiledRuntimeClassMapping, IObjectValue coreBaseInfo) {
        String entryKey = field.split("\\.")[0];
        String entryField = field.split("\\.")[1];
        Object coll = coreBaseInfo.get(entryKey);
        if (coll instanceof IObjectCollection) {
            FieldRuleUtils.setComposeFiledDefaultFieldValue((IObjectCollection)coll, coreBaseInfo, dynamicComposeFiledRuntimeClassMapping, entryKey, entryField, value);
        }
    }

    private static IObjectValue setComposeFiledDefaultFieldValue(IObjectCollection coll, IObjectValue coreBaseInfo, Map<String, List<Object>> dynamicRuntimeClassMapping, String entrysKey, String entrysField, Object defaultValue) {
        Class<?> collectionClass = null;
        Class<?> infoClass = null;
        Method addMethod = null;
        Method putMethod = null;
        List<Object> list = null;
        Object collInstance = null;
        Object infoInstance = null;
        try {
            if (null != dynamicRuntimeClassMapping.get(entrysKey)) {
                list = dynamicRuntimeClassMapping.get(entrysKey);
                FieldRuleUtils.dynamicSetEntrysFiledDefaultValue(list, coll, coreBaseInfo, entrysKey, entrysField, defaultValue);
            } else {
                String collectionClassName = coll.getClass().getName();
                String infoClasName = collectionClassName.substring(0, collectionClassName.lastIndexOf("Collection")) + "Info";
                collectionClass = Class.forName(collectionClassName);
                infoClass = Class.forName(infoClasName);
                addMethod = collectionClass.getMethod("add", infoClass);
                putMethod = infoClass.getMethod("put", String.class, Object.class);
                collInstance = collectionClass.newInstance();
                infoInstance = infoClass.newInstance();
                list = new ArrayList<Object>();
                list.add(addMethod);
                list.add(putMethod);
                list.add(collInstance);
                list.add(infoInstance);
                dynamicRuntimeClassMapping.put(entrysKey, list);
                FieldRuleUtils.dynamicSetEntrysFiledDefaultValue(list, coll, coreBaseInfo, entrysKey, entrysField, defaultValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return coreBaseInfo;
    }

    private static void dynamicSetEntrysFiledDefaultValue(List<Object> list, IObjectCollection coll, IObjectValue coreBaseInfo, String entryKey, String entrysField, Object defaultValue) {
        try {
            Method addMethod = (Method)list.get(0);
            Method putMethod = (Method)list.get(1);
            Object collInstance = list.get(2);
            Object infoInstance = list.get(3);
            if (coll.isEmpty()) {
                addMethod.invoke(collInstance, infoInstance);
                coreBaseInfo.put(entryKey, collInstance);
            } else {
                infoInstance = coll.getObject(0);
            }
            putMethod.invoke(infoInstance, entrysField, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static CoreBaseInfo getValue(Context ctx, String modelID, String entityNmae) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        ICoreBase model = BaseMetaDataUtil.getBizInterface(ctx, entityNmae);
        return null != model ? model.getValue((IObjectPK)new ObjectUuidPK(modelID), sic) : null;
    }
}

