/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.formula.parse;

import com.kingdee.shr.base.syssetting.fieldrule.formula.ParserException;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.KeyWord;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Source;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.StringReader;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Token;

public class Lexer {
    public Source source = null;
    KeyWord _keywords;
    private StringReader _reader;
    private int _col = 1;
    private int _line = 1;
    private int _ptr;
    private boolean _skipComment = true;

    public Lexer(KeyWord keyword, StringReader _reader) {
        this._keywords = keyword;
        this._reader = _reader;
    }

    public Lexer(StringReader reader) {
        this._ptr = reader._ptr;
        this._keywords = KeyWord.instance();
        this._reader = reader;
    }

    public Lexer(Source source) {
        this(source.getText());
        this.source = source;
    }

    public Lexer(String text) {
        this(text, true);
    }

    public Lexer(String text, boolean skipComment) {
        this._skipComment = skipComment;
        if (text == null) {
            throw new IllegalArgumentException("text");
        }
        this._keywords = KeyWord.instance();
        this._reader = new StringReader(text);
    }

    public Token next() throws ParserException {
        Token t = this.next0();
        if (t != null) {
            t.source = this.source;
        }
        return t;
    }

    private Token next0() throws ParserException {
        StringBuffer space = new StringBuffer();
        while (!this._reader.eos()) {
            String text;
            char ch = this._reader.next();
            if (Character.isWhitespace(ch)) {
                ++this._col;
                if (ch == '\n') {
                    ++this._line;
                    this._col = 1;
                }
                space.append(ch);
                continue;
            }
            this._ptr = this._reader._ptr;
            if (ch == '\'') {
                if (this._reader.eos()) {
                    throw (ParserException)new ParserException("unexpected end of string/file.", Token.EOFToken, "the script is half-baked, can't be the end of file/string here.").setInfoId("UNEXPECTED_END").addArg(this._line + ":" + this._col);
                }
                String charstr = new String(new char[]{this.readChar()});
                return new Token(charstr, 7, this._line, this._col, this._ptr, space.toString());
            }
            if (ch == '\"') {
                String text2 = this.readString();
                return new Token(text2, 6, this._line, this._col, this._ptr, space.toString());
            }
            if (Character.isLetter(ch) || this.isAllowedChar(ch) || ch == '_' || ch == '#') {
                int x = this._col;
                int y = this._line;
                text = this.readIdent(ch);
                if (this._keywords.isKeyWord(text)) {
                    return new Token(text, 3, y, x, this._ptr, space.toString());
                }
                return new Token(text, 1, y, x, this._ptr, space.toString());
            }
            if (ch == '?') {
                ++this._col;
                return new Token("?", 5, this._line, this._col, this._ptr, space.toString());
            }
            if (Character.isDigit(ch)) {
                Token token = this.readDigit(ch, this._col);
                token.space = space.toString();
                return token;
            }
            if (ch == '/' && this._reader.peek() == '/') {
                int _line0 = this._line++;
                int _col0 = ++this._col;
                this._reader.skip();
                text = this.readlineComment();
                this._col = 1;
                if (this._skipComment) continue;
                return new Token(text, 0, _line0, _col0, this._ptr);
            }
            if (ch == '/' && this._reader.peek() == '*') {
                this._reader.skip();
                int line0 = this._line;
                int col0 = ++this._col;
                StringBuffer comment = new StringBuffer();
                while (true) {
                    if ((ch = this._reader.next()) == '\n') {
                        ++this._line;
                        this._col = 1;
                    } else {
                        ++this._col;
                    }
                    if (ch == '*' && this._reader.peek() == '/') {
                        ++this._col;
                        break;
                    }
                    comment.append(ch);
                }
                this._reader.skip();
                if (this._skipComment) continue;
                return new Token(comment.toString(), 14, line0, col0, this._ptr, space.toString());
            }
            Token token = this.readOperator(ch);
            if (token != null) {
                token.space = space.toString();
                return token;
            }
            token = this.readPunctuation(ch);
            if (token != null) {
                token.space = space.toString();
                return token;
            }
            if (ch == '$') {
                ch = this._reader.peek();
                ++this._col;
                if (Character.isDigit(ch)) {
                    token = this.readDigit(ch, this._col);
                    token.space = space.toString();
                    return token;
                }
            }
            throw (ParserException)new ParserException("ILLEGAL_TOKEN", ch, "Expected character is '$'", this._line, this._col).setInfoId("ILLEGAL_TOKEN").addArg(this._line + ":" + this._col).addArg(ch + "").addArg("['$']");
        }
        return new Token("", 12, this._line, this._col, this._ptr, space.toString());
    }

    private final String readIdent(char c) throws ParserException {
        StringBuffer s = new StringBuffer();
        s.append(c);
        ++this._col;
        while (!this._reader.eos()) {
            c = this._reader.next();
            if (!Character.isLetterOrDigit(c) && !this.isAllowedChar(c) && c != '_' && c != '#') {
                this._reader.unget();
                break;
            }
            s.append(c);
            ++this._col;
        }
        return s.toString();
    }

    private final Token readDigit(char ch, int x) throws ParserException {
        char nextChar;
        int y = this._line;
        ++this._col;
        boolean isdouble = false;
        StringBuffer text = new StringBuffer();
        text.append(ch);
        boolean hexFlag = false;
        if (ch == '0' && this._reader.peek() == 'x') {
            text.append(this._reader.next());
            hexFlag = true;
        }
        while ((nextChar = this._reader.peek()) >= '0' && nextChar <= '9' || hexFlag && nextChar >= 'A' && nextChar <= 'F' || hexFlag && nextChar >= 'a' && nextChar <= 'f') {
            text.append(this._reader.next());
            ++this._col;
        }
        if (this._reader.peek() == '.') {
            isdouble = true;
            text.append(this._reader.next());
            ++this._col;
            while (Character.isDigit(this._reader.peek())) {
                text.append(this._reader.next());
                ++this._col;
            }
        } else {
            if (this._reader.peek() == 'L' || this._reader.peek() == 'l') {
                this._reader.skip();
                return new Token(text.toString(), 15, y, x, this._ptr);
            }
            if (this._reader.peek() == 'F' || this._reader.peek() == 'f') {
                this._reader.skip();
                return new Token(text.toString(), 9, y, x, this._ptr);
            }
            if (this._reader.peek() == 'D' || this._reader.peek() == 'd') {
                this._reader.skip();
                return new Token(text.toString(), 10, y, x, this._ptr);
            }
            if (this._reader.peek() == 'B' || this._reader.peek() == 'b') {
                this._reader.skip();
                return new Token(text.toString(), 11, y, x, this._ptr);
            }
        }
        if (isdouble) {
            if (this._reader.peek() == 'E') {
                text.append('E');
                this._reader.skip();
                ++this._col;
                if (this._reader.peek() == '+' || this._reader.peek() == '-') {
                    text.append(this._reader.next());
                    ++this._col;
                }
                while (Character.isDigit(this._reader.peek())) {
                    text.append(this._reader.next());
                    ++this._col;
                }
            }
            if (this._reader.peek() == 'F' || this._reader.peek() == 'f') {
                this._reader.skip();
                return new Token(text.toString(), 9, y, x, this._ptr);
            }
            if (this._reader.peek() == 'D' || this._reader.peek() == 'd') {
                this._reader.skip();
                return new Token(text.toString(), 10, y, x, this._ptr);
            }
            if (this._reader.peek() == 'B' || this._reader.peek() == 'b') {
                this._reader.skip();
                return new Token(text.toString(), 11, y, x, this._ptr);
            }
            return new Token(text.toString(), 10, y, x, this._ptr);
        }
        return new Token(text.toString(), 8, y, x, this._ptr);
    }

    private final char readChar() throws ParserException {
        char ch = this._reader.next();
        if (ch == '\\') {
            char nextChar = this._reader.lookup(0);
            if (nextChar == '\\') {
                ch = '\\';
            } else if (nextChar == '\"') {
                ch = '\"';
            } else if (nextChar == 't') {
                ch = '\t';
            } else if (nextChar == 'r') {
                ch = '\r';
            } else if (nextChar == 'n') {
                ch = '\n';
            } else {
                throw (ParserException)new ParserException("ILLEGAL_TOKEN", ch, "Expected on of characters in('\\', '\"', 't', 'r', 'n'", this._line, this._col).setInfoId("ILLEGAL_TOKEN").addArg(this._line + ":" + this._col).addArg(ch + "").addArg("['\\', '\"', 't', 'r', 'n']");
            }
            this._col = 1;
            this._reader.skip();
        }
        this._reader.skip();
        return ch;
    }

    private final String readString() throws ParserException {
        char ch = '\u0000';
        StringBuffer text = new StringBuffer();
        while (!this._reader.eos()) {
            char c = this._reader.next();
            ch = c;
            if (c == '\"') {
                return text.toString();
            }
            ++this._col;
            if (ch == '\\') {
                char nextChar = this._reader.lookup(0);
                if (nextChar == '\\') {
                    text.append('\\');
                } else if (nextChar == '\"') {
                    text.append('\"');
                } else if (nextChar == 't') {
                    text.append('\t');
                } else if (nextChar == 'r') {
                    text.append('\r');
                } else if (nextChar == 'n') {
                    text.append('\n');
                } else {
                    throw (ParserException)new ParserException("ILLEGAL_TOKEN", ch, "Expected on of characters in('\\', '\"', 't', 'r', 'n'", this._line, this._col).setInfoId("ILLEGAL_TOKEN").addArg(this._line + ":" + this._col).addArg(ch + "").addArg("['\\', '\"', 't', 'r', 'n']");
                }
                this._col = 1;
                this._reader.skip();
                continue;
            }
            text.append(ch);
        }
        if (ch != '\"') {
            throw (ParserException)new ParserException("STRING_UNCLOSED", ch, "Expected one of characters in('\"'", this._line, this._col).setInfoId("STRING_UNCLOSED").addArg(this._line + ":" + this._col).addArg(ch + "");
        }
        return text.toString();
    }

    private final String readlineComment() throws ParserException {
        if (this._reader.eos()) {
            return "";
        }
        StringBuffer comment = new StringBuffer();
        char ch = this._reader.next();
        while (ch != '\n' && !this._reader.eos()) {
            comment.append(ch);
            ch = this._reader.next();
        }
        return comment.toString();
    }

    private final Token readOperator(char ch) throws ParserException {
        int x = this._col++;
        int y = this._line;
        switch (ch) {
            case '+': {
                if (this._reader.eos()) {
                    return new Token("+", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '+': {
                        ++this._col;
                        return new Token("++", 4, y, x);
                    }
                    case '=': {
                        ++this._col;
                        return new Token("+=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("+", 4, y, x, this._ptr);
            }
            case '-': {
                if (this._reader.eos()) {
                    return new Token("-", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '-': {
                        ++this._col;
                        return new Token("--", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token("-=", 4, y, x);
                    }
                    case '>': {
                        ++this._col;
                        throw (ParserException)new ParserException("ILLEGAL_TOKEN", ch, "Unknow token '->', expected token is '--' or '-='", this._line, this._col).setInfoId("ILLEGAL_TOKEN").addArg(this._line + ":" + this._col).addArg("->").addArg("['--', '-=']");
                    }
                }
                this._reader.unget();
                char peek = this._reader.peek();
                if (this._col > 0 && peek >= '0' && peek <= '9') {
                    char p;
                    int i = -2;
                    if (i + this._reader._ptr < 0) {
                        i = this._reader._ptr * -1;
                    }
                    while (Character.isWhitespace(p = this._reader.lookup(i)) && this._col + --i > 1) {
                    }
                    if (p == ',' || p == '(' || this.isOperator(p)) {
                        return this.readDigit('-', this._col - 1);
                    }
                    return new Token("-", 4, y, x, this._ptr);
                }
                return new Token("-", 4, y, x, this._ptr);
            }
            case '*': {
                if (this._reader.eos()) {
                    return new Token("*", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("*=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("*", 4, y, x, this._ptr);
            }
            case '/': {
                if (this._reader.eos()) {
                    return new Token("/", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("/=", 4, y, x, this._ptr);
                    }
                    case '*': {
                        throw (ParserException)new ParserException("ILLEGAL_TOKEN", ch, "Unknow token '/*', expected token is '*='", this._line, this._col).setInfoId("ILLEGAL_TOKEN").addArg(this._line + ":" + this._col).addArg("/*").addArg("*=");
                    }
                }
                this._reader.unget();
                return new Token("/", 4, y, x, this._ptr);
            }
            case '%': {
                if (this._reader.eos()) {
                    return new Token("%", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("%=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("%", 4, y, x, this._ptr);
            }
            case '&': {
                if (this._reader.eos()) {
                    return new Token("&", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '&': {
                        ++this._col;
                        return new Token("&&", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token("&=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("&", 4, y, x, this._ptr);
            }
            case '|': {
                if (this._reader.eos()) {
                    return new Token("|", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '|': {
                        ++this._col;
                        return new Token("||", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token("|=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("|", 4, y, x, this._ptr);
            }
            case '^': {
                if (this._reader.eos()) {
                    return new Token("^", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("^=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("^", 4, y, x, this._ptr);
            }
            case '!': {
                if (this._reader.eos()) {
                    return new Token("!", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("!=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("!", 4, y, x, this._ptr);
            }
            case '~': {
                return new Token("~", 4, y, x, this._ptr);
            }
            case '=': {
                if (this._reader.eos()) {
                    return new Token("=", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("==", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("=", 4, y, x, this._ptr);
            }
            case '<': {
                if (this._reader.eos()) {
                    return new Token("<", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '<': {
                        switch (this._reader.next()) {
                            case '=': {
                                this._col += 2;
                                return new Token("<<=", 4, y, x, this._ptr);
                            }
                        }
                        ++this._col;
                        this._reader.unget();
                        return new Token("<<", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token("<=", 4, y, x, this._ptr);
                    }
                    case '>': {
                        ++this._col;
                        return new Token("<>", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("<", 4, y, x, this._ptr);
            }
            case '>': {
                if (this._reader.eos()) {
                    return new Token(">", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '>': {
                        switch (this._reader.next()) {
                            case '=': {
                                this._col += 2;
                                return new Token(">>=", 4, y, x, this._ptr);
                            }
                            case '>': {
                                this._col += 2;
                                if (!this._reader.eos() && this._reader.peek() == '=') {
                                    ++this._col;
                                    this._reader.skip();
                                    return new Token(">>>=", 4, y, x, this._ptr);
                                }
                                return new Token(">>>", 4, y, x, this._ptr);
                            }
                        }
                        ++this._col;
                        this._reader.unget();
                        return new Token(">>", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token(">=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token(">", 4, y, x, this._ptr);
            }
        }
        --this._col;
        return null;
    }

    private final Token readPunctuation(char ch) throws ParserException {
        int x = this._col++;
        int y = this._line;
        switch (ch) {
            case ';': {
                return new Token(";", 5, y, x, this._ptr);
            }
            case ':': {
                return new Token(":", 5, y, x, this._ptr);
            }
            case ',': {
                return new Token(",", 5, y, x, this._ptr);
            }
            case '.': {
                if (Character.isDigit(this._reader.peek())) {
                    this._reader.unget();
                    this._col -= 2;
                    return this.readDigit('0', this._col + 1);
                }
                return new Token(".", 5, y, x, this._ptr);
            }
            case ')': {
                return new Token(")", 5, y, x, this._ptr);
            }
            case '(': {
                return new Token("(", 5, y, x, this._ptr);
            }
            case ']': {
                return new Token("]", 5, y, x, this._ptr);
            }
            case '[': {
                return new Token("[", 5, y, x, this._ptr);
            }
            case '}': {
                return new Token("}", 5, y, x, this._ptr);
            }
            case '{': {
                return new Token("{", 5, y, x, this._ptr);
            }
        }
        --this._col;
        return null;
    }

    private final boolean isOperator(char c) {
        switch (c) {
            case '!': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private final boolean isAllowedChar(char c) {
        switch (c) {
            case '\uff08': 
            case '\uff09': {
                return true;
            }
        }
        return false;
    }
}

