/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.base.syssetting.util.VerifierUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonVerifierService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger(CommonVerifierService.class);

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String verifierType = (String)param.get("verifierType");
        String verifyContent = (String)param.get("verifyContent");
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        String emailRule = VerifierUtil.getVerifierEmailRule();
        String cellPhoneRule = VerifierUtil.getverifierCellphoneRule(ctx);
        HashMap<String, String> ruleMap = new HashMap<String, String>();
        ruleMap.put("emailRule", emailRule);
        ruleMap.put("cellPhoneRule", cellPhoneRule);
        infoMap.put("rule", ruleMap);
        if (verifyContent == null) {
            infoMap.put("result", false);
            infoMap.put("reason", SHRSysSettingResourceUtil.getResource("validate_not_null", ctx));
            return infoMap;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)verifierType, (CharSequence)"isCellPhone")) {
            infoMap.put("result", VerifierUtil.verifierCellphone(ctx, verifyContent));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)verifierType, (CharSequence)"isEmail")) {
            boolean result = VerifierUtil.verifierEmail(ctx, verifyContent);
            logger.error("verifierEmail result =" + result);
            infoMap.put("result", result);
        } else {
            infoMap.put("result", false);
            infoMap.put("reason", SHRSysSettingResourceUtil.getResource("no_such_validate_type", ctx));
        }
        return infoMap;
    }
}

