/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.BaseDataChangeType;
import com.kingdee.shr.base.syssetting.BaseInfoChangeFactory;
import com.kingdee.shr.base.syssetting.BaseInfoChangeInfo;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.base.syssetting.BaseItemRelationHRCollection;
import com.kingdee.shr.base.syssetting.BaseItemRelationHRInfo;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.BasicItemStateEnum;
import com.kingdee.shr.base.syssetting.DisatributeState;
import com.kingdee.shr.base.syssetting.HandleState;
import com.kingdee.shr.base.syssetting.IBaseItemRelationHR;
import com.kingdee.shr.base.syssetting.SHRBaseItemInfo;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.UsePolicy;
import com.kingdee.shr.base.syssetting.api.bean.BaseItemParam;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.DataValueTranslatorUtil;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingHrOrgUnitUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBaseItemUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBasicItemUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BaseItemRelationHRUtil {
    private static Logger logger = Logger.getLogger(BaseItemRelationHRUtil.class);

    public static void checkEntityNameValid(Context ctx, String entityName) throws EASBizException {
        if (StringUtils.isEmpty((String)entityName)) {
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{SHRSysSettingResourceUtil.getResource("entity_name_is_null", ctx)});
        }
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, entityName);
        if (null == entityObjectInfo) {
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{SHRSysSettingResourceUtil.getResource("entity_name_is_null", ctx, entityName)});
        }
        if (!BaseItemRelationHRUtil.isSHRBaseItemRelationHR(entityObjectInfo.getBaseEntity())) {
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{SHRSysSettingResourceUtil.getResource("not_extends", ctx, entityName)});
        }
    }

    public static boolean isSHRBaseItemRelationHR(EntityObjectInfo superEntity) {
        return BaseMetaDataUtil.isInheritBaseClass(superEntity, "com.kingdee.shr.base.syssetting.app.BaseItemRelationHR");
    }

    public static BaseItemRelationHRInfo generateBaseItemRelationHRInfo(Context ctx, String shrBaseItemId, String hrOrgUnitId, DisatributeState state, boolean isComUse, BaseDataChangeType changeType, String index) throws EASBizException, BOSException {
        return BaseItemRelationHRUtil.generateBaseItemRelationHRInfo(shrBaseItemId, SysSettingHrOrgUnitUtil.getHrOrgUnitInfo(ctx, hrOrgUnitId), state, isComUse, changeType, index);
    }

    public static BaseItemRelationHRInfo generateBaseItemRelationHRInfo(String shrBaseItemId, HROrgUnitInfo hrOrgUnitInfo, DisatributeState state, boolean isComUse, BaseDataChangeType changeType, String index) throws EASBizException, BOSException {
        BaseItemRelationHRInfo info = new BaseItemRelationHRInfo();
        info.setBaseInfoId(shrBaseItemId);
        info.setHrOrgUse(hrOrgUnitInfo);
        info.setState(state);
        info.setIsComUse(isComUse);
        info.setChangeType(changeType);
        info.setBosTypeId(BaseMetaDataUtil.getBOSObjectTypeById(shrBaseItemId).toString());
        info.setIsDefaultValue(Boolean.FALSE);
        if (StringUtils.isEmpty((String)index)) {
            info.setIndex("0");
        } else {
            info.setIndex(index);
        }
        return info;
    }

    private static void checkBaseIdAndHrIdIsNull(String shrBaseItemId, String hrorgUnitId) throws EASBizException {
        if (StringUtils.isEmpty((String)shrBaseItemId) || StringUtils.isEmpty((String)hrorgUnitId)) {
            throw new BaseItemException(BaseItemException.ID_BOTH_NULL);
        }
    }

    public static void checkInfoIsNull(String shrbaseItemId, String hrorgUnitId, int state) throws EASBizException {
        BaseItemRelationHRUtil.checkBaseIdAndHrIdIsNull(shrbaseItemId, hrorgUnitId);
        DisatributeState isatributeState = (DisatributeState)EnumUtils.getEnum(DisatributeState.class, (int)state);
        if (null == isatributeState) {
            throw new BaseItemException(BaseItemException.STATE_ILLEGAL);
        }
    }

    public static IObjectPK[] listToArray(List<IObjectPK> baseInfoORGRefPKs) {
        if (null == baseInfoORGRefPKs) {
            return null;
        }
        IObjectPK[] pks = new IObjectPK[baseInfoORGRefPKs.size()];
        return baseInfoORGRefPKs.toArray(pks);
    }

    public static void arrayToList(IObjectPK[] pks, List<IObjectPK> list) {
        for (IObjectPK pk : pks) {
            list.add(pk);
        }
    }

    public static IObjectPK[] batchAddBaseInfoAndHRBURef(Context ctx, IObjectPK[] baseInfoChangePKs) throws EASBizException, BOSException {
        ArrayList<IObjectPK> resultList = new ArrayList<IObjectPK>();
        int total = baseInfoChangePKs.length;
        for (int i = 0; i < total; ++i) {
            IObjectPK[] pks = BaseItemRelationHRUtil.addBaseInfoAndHRBURef(ctx, baseInfoChangePKs[i]);
            BaseItemRelationHRUtil.arrayToList(pks, resultList);
        }
        return BaseItemRelationHRUtil.listToArray(resultList);
    }

    public static IObjectPK[] addBaseInfoAndHRBURef(Context ctx, IObjectPK baseInfoChangePK) throws EASBizException, BOSException {
        BaseInfoChangeInfo baseInfoChangeInfo = BaseInfoChangeFactory.getLocalInstance(ctx).getBaseInfoChangeInfo(baseInfoChangePK);
        List<IObjectPK> baseInfoORGRefPKs = null;
        SHRBaseItemInfo shrBaseItemInfo = SysSettingSHRBaseItemUtil.getSHRBaseItemInfo(ctx, baseInfoChangeInfo.getBaseInfoId());
        if (null == shrBaseItemInfo) {
            return null;
        }
        if (!BaseItemStateEnum.NEW.equals((Object)shrBaseItemInfo.getState()) && BaseDataChangeType.HRORG.equals((Object)baseInfoChangeInfo.getChangeType())) {
            HROrgUnitCollection coll = BaseItemRelationHRUtil.getHROrgUnitCollection(ctx, baseInfoChangeInfo);
            if (null != coll && coll.size() > 0) {
                baseInfoORGRefPKs = BaseItemRelationHRUtil._addNewBaseItemRelationHRInfo(ctx, coll, shrBaseItemInfo, BaseDataChangeType.HRORG);
            }
        } else if (!BaseItemStateEnum.NEW.equals((Object)shrBaseItemInfo.getState()) && BaseDataChangeType.HRORGGROUP.equals((Object)baseInfoChangeInfo.getChangeType())) {
            baseInfoORGRefPKs = BaseItemRelationHRUtil.dealHrOrgUnitGroupType(ctx, baseInfoChangeInfo, shrBaseItemInfo);
        } else if (!BaseItemStateEnum.NEW.equals((Object)shrBaseItemInfo.getState()) && BaseDataChangeType.USER.equals((Object)baseInfoChangeInfo.getChangeType())) {
            baseInfoORGRefPKs = BaseItemRelationHRUtil.dealUserType(ctx, baseInfoChangeInfo, shrBaseItemInfo);
        }
        BaseItemRelationHRUtil._updateBaseInfoChangeInfoState(ctx, baseInfoChangePK);
        return BaseItemRelationHRUtil.listToArray(baseInfoORGRefPKs);
    }

    private static void _updateBaseInfoChangeInfoState(Context ctx, IObjectPK baseInfoChangePK) throws EASBizException, BOSException {
        BaseInfoChangeInfo info = new BaseInfoChangeInfo();
        info.setId(BOSUuid.read((String)baseInfoChangePK.toString()));
        info.setState(HandleState.DONE);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        BaseInfoChangeFactory.getLocalInstance(ctx).updatePartial(info, sic);
    }

    private static List<IObjectPK> _addNewBaseItemRelationHRInfo(Context ctx, HROrgUnitCollection coll, SHRBaseItemInfo baseItemInfo, BaseDataChangeType changType) throws EASBizException, BOSException {
        ArrayList<IObjectPK> baseInfoORGRefPKs = null;
        if (null != coll && coll.size() > 0) {
            baseInfoORGRefPKs = new ArrayList<IObjectPK>();
            DisatributeState state = null;
            if (BaseItemStateEnum.ENABLE.equals((Object)baseItemInfo.getState())) {
                state = DisatributeState.DONE;
            } else if (BaseItemStateEnum.DISABLE.equals((Object)baseItemInfo.getState())) {
                state = DisatributeState.UNDONE;
            }
            ICoreBase iCoreBase = BaseMetaDataUtil.getBizInterface(ctx, SysSettingSHRBasicItemUtil.getSHRBasicItemInfoById(ctx, baseItemInfo.getShrBasicItem().getId().toString()).getRelationHREntity());
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                HROrgUnitInfo hrOrgUnitInfo = coll.get(i);
                baseInfoORGRefPKs.add(iCoreBase.save((CoreBaseInfo)BaseItemRelationHRUtil.generateBaseItemRelationHRInfo(baseItemInfo.getId().toString(), hrOrgUnitInfo, state, Boolean.TRUE, changType, null)));
            }
        }
        return baseInfoORGRefPKs;
    }

    private static List<IObjectPK> dealHrOrgUnitGroupType(Context ctx, BaseInfoChangeInfo baseInfoChangeInfo, SHRBaseItemInfo shrBaseItemInfo) {
        List<IObjectPK> baseInfoORGRefPKs = null;
        return baseInfoORGRefPKs;
    }

    private static List<IObjectPK> dealUserType(Context ctx, BaseInfoChangeInfo baseInfoChangeInfo, SHRBaseItemInfo shrBaseItemInfo) {
        List<IObjectPK> baseInfoORGRefPKs = null;
        return baseInfoORGRefPKs;
    }

    private static HROrgUnitCollection getHROrgUnitCollection(Context ctx, BaseInfoChangeInfo baseInfoChangeInfo) throws EASBizException, BOSException {
        HROrgUnitCollection coll = null;
        if (UsePolicy.GLOBALLY_SHARED.equals((Object)baseInfoChangeInfo.getUsePolicy())) {
            coll = SysSettingHrOrgUnitUtil.queryHROrgUnitCollection(ctx, baseInfoChangeInfo.getUsePolicy(), null);
        } else if (UsePolicy.DOWN_SHARED.equals((Object)baseInfoChangeInfo.getUsePolicy())) {
            HashSet<String> hrOrgUnitIds = new HashSet<String>();
            hrOrgUnitIds.add(baseInfoChangeInfo.getHrOrgUnit().getId().toString());
            SysSettingHrOrgUnitUtil.getHrOrgUnitSets(ctx, baseInfoChangeInfo.getHrOrgUnit().getId().toString(), hrOrgUnitIds, Boolean.TRUE);
            coll = SysSettingHrOrgUnitUtil.queryHROrgUnitCollection(ctx, baseInfoChangeInfo.getUsePolicy(), hrOrgUnitIds);
        } else if (UsePolicy.DISTRIBUTION_SHARED.equals((Object)baseInfoChangeInfo.getUsePolicy())) {
            coll = new HROrgUnitCollection();
            coll.add(SysSettingHrOrgUnitUtil.getHrOrgUnitInfo(ctx, baseInfoChangeInfo.getHrOrgUnit().getId().toString()));
        }
        return coll;
    }

    public static IObjectPK[] updateBaseInfoAndHRBURef(Context ctx, IObjectPK baseInfoChangePK) throws EASBizException, BOSException {
        BaseInfoChangeInfo baseInfoChangeInfo = BaseInfoChangeFactory.getLocalInstance(ctx).getBaseInfoChangeInfo(baseInfoChangePK);
        IObjectPK[] pks = null;
        SHRBaseItemInfo shrBaseItemInfo = SysSettingSHRBaseItemUtil.getSHRBaseItemInfo(ctx, baseInfoChangeInfo.getBaseInfoId());
        if (null == shrBaseItemInfo) {
            return null;
        }
        if (!BaseItemStateEnum.NEW.equals((Object)shrBaseItemInfo.getState()) && BaseDataChangeType.HRORG.equals((Object)baseInfoChangeInfo.getChangeType())) {
            if (UsePolicy.GLOBALLY_SHARED.equals((Object)baseInfoChangeInfo.getUsePolicy()) && UsePolicy.DOWN_SHARED.equals((Object)shrBaseItemInfo.getUsePolicy())) {
                pks = BaseItemRelationHRUtil.fromGloballySharedToDownShared(ctx, shrBaseItemInfo);
            } else if (UsePolicy.GLOBALLY_SHARED.equals((Object)baseInfoChangeInfo.getUsePolicy()) && UsePolicy.DISTRIBUTION_SHARED.equals((Object)shrBaseItemInfo.getUsePolicy())) {
                pks = BaseItemRelationHRUtil.fromGloballySharedToDistributionShared(ctx, shrBaseItemInfo);
            } else if (UsePolicy.DOWN_SHARED.equals((Object)baseInfoChangeInfo.getUsePolicy()) && UsePolicy.GLOBALLY_SHARED.equals((Object)shrBaseItemInfo.getUsePolicy())) {
                pks = BaseItemRelationHRUtil.fromDownSharedToGloballyShared(ctx, shrBaseItemInfo);
            } else if (UsePolicy.DOWN_SHARED.equals((Object)baseInfoChangeInfo.getUsePolicy()) && UsePolicy.DISTRIBUTION_SHARED.equals((Object)shrBaseItemInfo.getUsePolicy())) {
                pks = BaseItemRelationHRUtil.fromDownSharedToDistributionShared(ctx, shrBaseItemInfo);
            } else if (UsePolicy.DISTRIBUTION_SHARED.equals((Object)baseInfoChangeInfo.getUsePolicy()) && UsePolicy.GLOBALLY_SHARED.equals((Object)shrBaseItemInfo.getUsePolicy())) {
                pks = BaseItemRelationHRUtil.fromDistributionSharedToGloballyShared(ctx, shrBaseItemInfo);
            } else if (UsePolicy.DISTRIBUTION_SHARED.equals((Object)baseInfoChangeInfo.getUsePolicy()) && UsePolicy.DOWN_SHARED.equals((Object)shrBaseItemInfo.getUsePolicy())) {
                pks = BaseItemRelationHRUtil.fromDistributionSharedToDownShared(ctx, shrBaseItemInfo);
            }
        } else if (!BaseItemStateEnum.NEW.equals((Object)shrBaseItemInfo.getState()) && BaseDataChangeType.HRORGGROUP.equals((Object)baseInfoChangeInfo.getChangeType()) || BaseItemStateEnum.NEW.equals((Object)shrBaseItemInfo.getState()) || BaseDataChangeType.USER.equals((Object)baseInfoChangeInfo.getChangeType())) {
            // empty if block
        }
        BaseItemRelationHRUtil._updateBaseInfoChangeInfoState(ctx, baseInfoChangePK);
        return pks;
    }

    private static IObjectPK[] fromGloballySharedToDownShared(Context ctx, SHRBaseItemInfo baseInfo) throws BOSException, EASBizException {
        HashSet<String> hrOrgUnitIds = new HashSet<String>();
        hrOrgUnitIds.add(baseInfo.getHrOrgUnit().getId().toString());
        SysSettingHrOrgUnitUtil.getHrOrgUnitSets(ctx, baseInfo.getHrOrgUnit().getId().toString(), hrOrgUnitIds, Boolean.TRUE);
        BaseItemRelationHRUtil.disableAllBaseInfoByBaseInfoId(ctx, baseInfo);
        return BaseItemRelationHRUtil.batchDealState(ctx, baseInfo, hrOrgUnitIds, DisatributeState.DONE, false);
    }

    private static IObjectPK[] fromGloballySharedToDistributionShared(Context ctx, SHRBaseItemInfo baseInfo) throws BOSException, EASBizException {
        HashSet<String> hrOrgUnitIds = new HashSet<String>();
        SysSettingHrOrgUnitUtil.getHrOrgUnitsExcuteById(ctx, baseInfo.getHrOrgUnit().getId().toString(), hrOrgUnitIds);
        return BaseItemRelationHRUtil.batchDealState(ctx, baseInfo, hrOrgUnitIds, DisatributeState.UNDONE, false);
    }

    private static IObjectPK[] fromDownSharedToGloballyShared(Context ctx, SHRBaseItemInfo baseInfo) throws BOSException, EASBizException {
        HashSet<String> hrOrgUnitIds = new HashSet<String>();
        SysSettingHrOrgUnitUtil.getAllHrOrgUnits(ctx, hrOrgUnitIds);
        return BaseItemRelationHRUtil.batchDealState(ctx, baseInfo, hrOrgUnitIds, DisatributeState.DONE, true);
    }

    private static IObjectPK[] fromDownSharedToDistributionShared(Context ctx, SHRBaseItemInfo baseInfo) throws BOSException, EASBizException {
        HashSet<String> hrOrgUnitIds = new HashSet<String>();
        SysSettingHrOrgUnitUtil.getHrOrgUnitsExcuteById(ctx, baseInfo.getHrOrgUnit().getId().toString(), hrOrgUnitIds);
        return BaseItemRelationHRUtil.batchDealState(ctx, baseInfo, hrOrgUnitIds, DisatributeState.UNDONE, false);
    }

    private static IObjectPK[] fromDistributionSharedToGloballyShared(Context ctx, SHRBaseItemInfo baseInfo) throws BOSException, EASBizException {
        HashSet<String> hrOrgUnitIds = new HashSet<String>();
        SysSettingHrOrgUnitUtil.getAllHrOrgUnits(ctx, hrOrgUnitIds);
        return BaseItemRelationHRUtil.batchDealState(ctx, baseInfo, hrOrgUnitIds, DisatributeState.DONE, true);
    }

    private static IObjectPK[] fromDistributionSharedToDownShared(Context ctx, SHRBaseItemInfo baseInfo) throws BOSException, EASBizException {
        HashSet<String> hrOrgUnitIds = new HashSet<String>();
        hrOrgUnitIds.add(baseInfo.getHrOrgUnit().getId().toString());
        SysSettingHrOrgUnitUtil.getHrOrgUnitSets(ctx, baseInfo.getHrOrgUnit().getId().toString(), hrOrgUnitIds, Boolean.TRUE);
        BaseItemRelationHRUtil.disableAllBaseInfoByBaseInfoId(ctx, baseInfo);
        return BaseItemRelationHRUtil.batchDealState(ctx, baseInfo, hrOrgUnitIds, DisatributeState.DONE, true);
    }

    private static void disableAllBaseInfoByBaseInfoId(Context ctx, SHRBaseItemInfo baseInfo) throws BOSException, EASBizException {
        EntityObjectInfo info = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, SysSettingSHRBasicItemUtil.getSHRBasicItemInfoFromDBById(ctx, baseInfo.getShrBasicItem().getId().toString()).getRelationHREntity());
        if (null != info && null != info.getTable()) {
            DbUtil.execute((Context)ctx, (String)("update " + info.getTable().getName() + " set FState = " + 200 + " where FBaseInfoId = '" + baseInfo.getId().toString() + "'"));
        }
    }

    private static IObjectPK[] batchDealState(Context ctx, SHRBaseItemInfo baseItemInfo, Set<String> hrOrgUnitIds, DisatributeState state, boolean isNeedAddNew) throws BOSException, EASBizException {
        IBaseItemRelationHR iBaseItemRelationHR = (IBaseItemRelationHR)BaseMetaDataUtil.getBizInterface(ctx, SysSettingSHRBasicItemUtil.getSHRBasicItemInfoFromDBById(ctx, baseItemInfo.getShrBasicItem().getId().toString()).getRelationHREntity());
        ArrayList<IObjectPK> baseInfoORGRefPKs = new ArrayList<IObjectPK>();
        for (String hrOrgUnitId : hrOrgUnitIds) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("baseInfoId", (Object)baseItemInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUse.id", (Object)hrOrgUnitId, CompareType.EQUALS));
            if (iBaseItemRelationHR.exists(filter)) {
                BaseItemRelationHRInfo model = iBaseItemRelationHR.getBaseItemRelationHRInfo("where baseInfoId = '" + baseItemInfo.getId().toString() + "' and hrOrgUse.id = '" + hrOrgUnitId + "'");
                if (DisatributeState.DONE.equals((Object)state)) {
                    iBaseItemRelationHR.enable(model.getId().toString());
                } else if (DisatributeState.UNDONE.equals((Object)state)) {
                    iBaseItemRelationHR.disable(model.getId().toString());
                }
                baseInfoORGRefPKs.add((IObjectPK)new ObjectUuidPK(model.getId()));
                continue;
            }
            if (!isNeedAddNew) continue;
            baseInfoORGRefPKs.add(BaseItemRelationHRUtil.saveBaseInfoAndHRBURef(ctx, iBaseItemRelationHR, baseItemInfo.getId().toString(), hrOrgUnitId, state.getValue()));
        }
        return BaseItemRelationHRUtil.listToArray(baseInfoORGRefPKs);
    }

    private static IObjectPK saveBaseInfoAndHRBURef(Context ctx, IBaseItemRelationHR iBaseItemRelationHR, String shrBaseItemId, String hrOrgUnitId, int state) throws EASBizException, BOSException {
        BaseItemRelationHRUtil.checkInfoIsNull(shrBaseItemId, hrOrgUnitId, state);
        return iBaseItemRelationHR.saveByBaseIdAndHRBUId(shrBaseItemId, hrOrgUnitId, state);
    }

    public static IObjectPK saveBaseInfoAndHRBURef(Context ctx, String shrBaseItemId, String hrOrgUnitId, int state) throws EASBizException, BOSException {
        IBaseItemRelationHR iBaseItemRelationHR = BaseItemRelationHRUtil.getIBaseItemRelationHR(ctx, shrBaseItemId);
        return iBaseItemRelationHR.saveByBaseIdAndHRBUId(shrBaseItemId, hrOrgUnitId, state);
    }

    public static IBaseItemRelationHR getIBaseItemRelationHR(Context ctx, String shrBaseItemId) throws EASBizException, BOSException {
        SHRBaseItemInfo baseItemInfo = SysSettingSHRBaseItemUtil.getSHRBaseItemInfo(ctx, shrBaseItemId);
        return BaseItemRelationHRUtil.getIBaseItemRelationHR(ctx, baseItemInfo);
    }

    public static IBaseItemRelationHR getIBaseItemRelationHR(Context ctx, SHRBaseItemInfo baseItemInfo) throws EASBizException, BOSException {
        return BaseItemRelationHRUtil.getIBaseItemRelationHR(ctx, SysSettingSHRBasicItemUtil.getSHRBasicItemInfoFromDBById(ctx, baseItemInfo.getShrBasicItem().getId().toString()));
    }

    public static IBaseItemRelationHR getIBaseItemRelationHR(Context ctx, SHRBasicItemInfo model) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)model.getRelationHREntity()) || !BaseItemRelationHRUtil.isSHRBaseItemRelationHR(BaseMetaDataUtil.getEntityObjectByEntityName(ctx, model.getRelationHREntity()).getBaseEntity())) {
            throw new BaseItemException(BaseItemException.ENTITY_RELATION_ERROR, new Object[]{model.getEntityName(), model.getName()});
        }
        return (IBaseItemRelationHR)BaseMetaDataUtil.getBizInterface(ctx, model.getRelationHREntity());
    }

    public static IBaseItemRelationHR getIBaseItemRelationHRByEntityName(Context ctx, String entityName) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)entityName) || !BaseItemRelationHRUtil.isSHRBaseItemRelationHR(BaseMetaDataUtil.getEntityObjectByEntityName(ctx, entityName).getBaseEntity())) {
            throw new BaseItemException(BaseItemException.BASEITEM_RELATION_ERROR);
        }
        return (IBaseItemRelationHR)BaseMetaDataUtil.getBizInterface(ctx, entityName);
    }

    public static void enableBaseInfoAndHRBURef(Context ctx, IObjectPK baseInfoChangePK) throws EASBizException, BOSException {
        BaseItemRelationHRUtil.doStateByPK(ctx, baseInfoChangePK, DisatributeState.DONE);
    }

    public static void disableBaseInfoAndHRBURef(Context ctx, IObjectPK baseInfoChangePK) throws EASBizException, BOSException {
        BaseItemRelationHRUtil.doStateByPK(ctx, baseInfoChangePK, DisatributeState.UNDONE);
    }

    private static void doStateByPK(Context ctx, IObjectPK baseInfoChangePK, DisatributeState state) throws EASBizException, BOSException {
        BaseInfoChangeInfo baseInfoChangeInfo = BaseInfoChangeFactory.getLocalInstance(ctx).getBaseInfoChangeInfo(baseInfoChangePK);
        SHRBaseItemInfo shrBaseItemInfo = SysSettingSHRBaseItemUtil.getSHRBaseItemInfo(ctx, baseInfoChangeInfo.getBaseInfoId());
        if (null == shrBaseItemInfo) {
            return;
        }
        IBaseItemRelationHR iBaseItemRelationHR = BaseItemRelationHRUtil.getIBaseItemRelationHR(ctx, shrBaseItemInfo.getId().toString());
        if (!BaseItemStateEnum.NEW.equals((Object)shrBaseItemInfo.getState()) && BaseDataChangeType.HRORG.equals((Object)baseInfoChangeInfo.getChangeType())) {
            HROrgUnitCollection coll = null;
            if (DisatributeState.UNDONE.equals((Object)state)) {
                iBaseItemRelationHR.disableByBaseItemId(shrBaseItemInfo.getId().toString());
            } else {
                coll = BaseItemRelationHRUtil.getHROrgUnitCollection(ctx, baseInfoChangeInfo);
                if (null != coll && coll.size() > 0) {
                    int total = coll.size();
                    for (int i = 0; i < total; ++i) {
                        HROrgUnitInfo hrOrgUnitInfo = coll.get(i);
                        iBaseItemRelationHR.enable(shrBaseItemInfo.getId().toString(), hrOrgUnitInfo.getId().toString());
                    }
                }
            }
        } else if (!BaseItemStateEnum.NEW.equals((Object)shrBaseItemInfo.getState()) && BaseDataChangeType.HRORGGROUP.equals((Object)baseInfoChangeInfo.getChangeType()) || BaseItemStateEnum.NEW.equals((Object)shrBaseItemInfo.getState()) || BaseDataChangeType.USER.equals((Object)baseInfoChangeInfo.getChangeType())) {
            // empty if block
        }
        BaseItemRelationHRUtil._updateBaseInfoChangeInfoState(ctx, baseInfoChangePK);
    }

    public static HROrgUnitCollection getHROrgUnitCollectionByBaseItem(Context ctx, BaseInfoChangeInfo baseInfoChangeInfo, SHRBaseItemInfo shrBaseItemInfo) throws BOSException, EASBizException {
        EntityObjectInfo metaDataInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, SysSettingSHRBasicItemUtil.getSHRBasicItemInfoFromDBById(ctx, shrBaseItemInfo.getShrBasicItem().getId().toString()).getRelationHREntity());
        HROrgUnitCollection coll = new HROrgUnitCollection();
        if (null != metaDataInfo && null != metaDataInfo.getTable()) {
            String sql = " select fid, FHrOrgUseId from " + metaDataInfo.getTable().getName() + " where FBaseInfoId = '" + baseInfoChangeInfo.getBaseInfoId() + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (rs.next()) {
                    HROrgUnitInfo info = new HROrgUnitInfo();
                    info.setId(BOSUuid.read((String)rs.getString("FHrOrgUseId")));
                    coll.add(info);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return coll;
    }

    public static IObjectPK[] deleteBaseInfoAndHRBURef(Context ctx, IObjectPK baseInfoChangePK) throws EASBizException, BOSException {
        BaseInfoChangeInfo baseInfoChangeInfo = BaseInfoChangeFactory.getLocalInstance(ctx).getBaseInfoChangeInfo(baseInfoChangePK);
        SHRBaseItemInfo shrBaseItemInfo = SysSettingSHRBaseItemUtil.getSHRBaseItemInfo(ctx, baseInfoChangeInfo.getBaseInfoId());
        if (null == shrBaseItemInfo) {
            return null;
        }
        ArrayList<IObjectPK> baseInfoORGRefPKs = new ArrayList<IObjectPK>();
        BaseItemRelationHRCollection coll = BaseItemRelationHRUtil.getBaseItemRelationHRCollection(ctx, shrBaseItemInfo);
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                BaseItemRelationHRInfo model = coll.get(i);
                ObjectUuidPK p = new ObjectUuidPK(model.getId());
                baseInfoORGRefPKs.add((IObjectPK)p);
            }
        }
        BaseItemRelationHRUtil.deleteOrgRefByBaseItem(ctx, shrBaseItemInfo);
        IObjectPK[] pks = BaseItemRelationHRUtil.listToArray(baseInfoORGRefPKs);
        BaseItemRelationHRUtil._updateBaseInfoChangeInfoState(ctx, baseInfoChangePK);
        return pks;
    }

    public static BaseItemRelationHRCollection getBaseItemRelationHRCollection(Context ctx, SHRBaseItemInfo shrBaseItemInfo) throws BOSException, EASBizException {
        IBaseItemRelationHR iBaseItemRelationHR = BaseItemRelationHRUtil.getIBaseItemRelationHR(ctx, shrBaseItemInfo);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseInfoId", (Object)shrBaseItemInfo.getId().toString(), CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(sic);
        return iBaseItemRelationHR.getBaseItemRelationHRCollection(view);
    }

    private static void deleteOrgRefByBaseItem(Context ctx, SHRBaseItemInfo shrBaseItemInfo) throws BOSException, EASBizException {
        EntityObjectInfo metaDataInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, SysSettingSHRBasicItemUtil.getSHRBasicItemInfoFromDBById(ctx, shrBaseItemInfo.getShrBasicItem().getId().toString()).getRelationHREntity());
        if (null != metaDataInfo && null != metaDataInfo.getTable()) {
            String deleteOrgRefSql = "delete from " + metaDataInfo.getTable().getName() + " where FBaseInfoId = '" + shrBaseItemInfo.getId().toString() + "' ";
            DbUtil.execute((Context)ctx, (String)deleteOrgRefSql);
        }
    }

    public static IObjectPK[] batchUpdateBaseInfoAndHRBURef(Context ctx, IObjectPK[] baseInfoChangePKs) throws EASBizException, BOSException {
        ArrayList<IObjectPK> resultList = new ArrayList<IObjectPK>();
        int total = baseInfoChangePKs.length;
        for (int i = 0; i < total; ++i) {
            IObjectPK[] pks = BaseItemRelationHRUtil.updateBaseInfoAndHRBURef(ctx, baseInfoChangePKs[i]);
            BaseItemRelationHRUtil.arrayToList(pks, resultList);
        }
        return BaseItemRelationHRUtil.listToArray(resultList);
    }

    public static void batchEnableBaseInfoAndHRBURef(Context ctx, IObjectPK[] baseInfoChangePKs) throws EASBizException, BOSException {
        BaseItemRelationHRUtil.doStateBatchByPK(ctx, baseInfoChangePKs, DisatributeState.DONE);
    }

    public static void batchDisableBaseInfoAndHRBURef(Context ctx, IObjectPK[] baseInfoChangePKs) throws EASBizException, BOSException {
        BaseItemRelationHRUtil.doStateBatchByPK(ctx, baseInfoChangePKs, DisatributeState.UNDONE);
    }

    private static void doStateBatchByPK(Context ctx, IObjectPK[] baseInfoChangePKs, DisatributeState state) throws EASBizException, BOSException {
        int total = baseInfoChangePKs.length;
        for (int i = 0; i < total; ++i) {
            BaseItemRelationHRUtil.doStateByPK(ctx, baseInfoChangePKs[i], state);
        }
    }

    public static IObjectPK[] batchDeleteBaseInfoAndHRBURef(Context ctx, IObjectPK[] baseInfoChangePKs) throws EASBizException, BOSException {
        ArrayList<IObjectPK> resultList = new ArrayList<IObjectPK>();
        int total = baseInfoChangePKs.length;
        for (int i = 0; i < total; ++i) {
            IObjectPK[] pks = BaseItemRelationHRUtil.deleteBaseInfoAndHRBURef(ctx, baseInfoChangePKs[i]);
            BaseItemRelationHRUtil.arrayToList(pks, resultList);
        }
        return BaseItemRelationHRUtil.listToArray(resultList);
    }

    public static int queryUseCount(Context ctx, BaseItemParam param) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)param.getEntityName()) && StringUtils.isEmpty((String)param.getRealEntityName())) {
            throw new BaseItemException(BaseItemException.NAME_BOTH_NULL);
        }
        SHRBasicItemInfo info = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, param.getEntityName());
        if (null == info && null == (info = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, param.getRealEntityName()))) {
            throw new BaseItemException(BaseItemException.BASEITEM_NOT_EXIST);
        }
        if (StringUtils.isEmpty((String)param.getEntityName())) {
            param.setEntityName(info.getEntityName());
        }
        IRowSet rs = null;
        int count = 0;
        String sql = BaseItemRelationHRUtil.getAvailableRelationCountSql(ctx, param);
        if (StringUtils.isEmpty((String)sql)) {
            return count;
        }
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                count = rs.getInt("ct");
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            e.printStackTrace();
            return 0;
        }
        return count;
    }

    public static String getAvailableRelationCountSql(Context ctx, BaseItemParam param) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) ct from (").append(BaseItemRelationHRUtil.getAvailableRelationBaseSql(ctx, param, Boolean.FALSE)).append(") temp ");
        return sql.toString();
    }

    public static String getAvailableRelationBaseSql(Context ctx, BaseItemParam param, boolean isForFastFilter) throws EASBizException, BOSException {
        StringBuffer sb;
        DataTableInfo dataTableInfo;
        String realEntityName = null;
        String shrEntityName = null;
        String mappingFiled = null;
        String mappingTalble = null;
        String shrMappingTable = null;
        String shrRelationTable = null;
        boolean isFromEas = false;
        EntityObjectInfo entityObjectInfo = null;
        SHRBasicItemInfo info = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, param.getEntityName());
        if (null == info) {
            throw new BaseItemException(BaseItemException.ENTITY_NOT_BASEITEM, new Object[]{param.getEntityName()});
        }
        if (isForFastFilter) {
            realEntityName = info.getRealEntityName();
            shrEntityName = info.getEntityName();
            if (!StringUtils.isEmpty((String)realEntityName) && !StringUtils.isEmpty((String)shrEntityName)) {
                EntityObjectInfo realEntityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, realEntityName);
                entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, shrEntityName);
                if (null == realEntityObjectInfo) {
                    logger.error((Object)("Entity not found according to entityname: " + realEntityObjectInfo));
                    return null;
                }
                DataTableInfo realDataTableInfo = realEntityObjectInfo.getTable();
                if (null == realDataTableInfo) {
                    logger.error((Object)("Table not found according to entityname: " + realEntityObjectInfo));
                    return null;
                }
                if (null == entityObjectInfo) {
                    logger.error((Object)("Entity not found according to entityname: " + entityObjectInfo));
                    return null;
                }
                DataTableInfo shrDataTableInfo = entityObjectInfo.getTable();
                if (null == shrDataTableInfo) {
                    logger.error((Object)("Table not found according to entityname: " + entityObjectInfo));
                    return null;
                }
                PropertyCollection propertyColl = entityObjectInfo.getProperties();
                int total = propertyColl.size();
                for (int i = 0; i < total; ++i) {
                    RelationshipInfo relationshipInfo;
                    EntityObjectInfo supplierEntity;
                    PropertyInfo propertyInfo = propertyColl.get(i);
                    if (!(propertyInfo instanceof LinkPropertyInfo) || !(supplierEntity = (relationshipInfo = ((LinkPropertyInfo)propertyInfo).getRelationship()).getSupplierObject()).getFullName().equals(realEntityObjectInfo.getFullName())) continue;
                    mappingFiled = propertyInfo.getMappingField().getName();
                    break;
                }
                isFromEas = true;
                mappingTalble = realDataTableInfo.getName();
                shrMappingTable = shrDataTableInfo.getName();
            } else {
                entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, shrEntityName);
                if (null == entityObjectInfo) {
                    logger.error((Object)("Entity not found according to entityname: " + param.getEntityName()));
                    return null;
                }
                dataTableInfo = entityObjectInfo.getTable();
                if (null == dataTableInfo) {
                    logger.error((Object)("Table not found according to entityname: " + param.getEntityName()));
                    return null;
                }
                shrMappingTable = dataTableInfo.getName();
            }
        } else {
            entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, param.getEntityName());
            if (null == entityObjectInfo) {
                logger.error((Object)("Entity not found according to entityname: " + param.getEntityName()));
                return null;
            }
            dataTableInfo = entityObjectInfo.getTable();
            if (null == dataTableInfo) {
                logger.error((Object)("Table not found according to entityname: " + param.getEntityName()));
                return null;
            }
            shrMappingTable = dataTableInfo.getName();
        }
        if (StringUtils.isEmpty((String)info.getRelationHREntity())) {
            logger.error((Object)"BaseItem and bizOrg usable relationship entity are not maintained!");
            return null;
        }
        EntityObjectInfo relationHREntity = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, info.getRelationHREntity());
        if (null == relationHREntity || null == relationHREntity.getTable()) {
            logger.error((Object)("Table or entity not found according to entityname: " + relationHREntity));
            return null;
        }
        shrRelationTable = relationHREntity.getTable().getName();
        StringBuffer sql = new StringBuffer();
        String userId = HRFilterUtils.getCurrentUserId(ctx);
        sql.append("SELECT");
        if (isForFastFilter) {
            if (!param.isRespBaseItemId() && isFromEas) {
                sql.append(" distinct easItem.fid");
            } else {
                sql.append(" distinct relation.fbaseinfoid");
            }
        } else {
            sql.append(" relation.fid");
        }
        sql.append(" FROM ").append(shrRelationTable).append(" relation");
        sql.append(" inner join ").append(shrMappingTable).append(" baseItem on relation.FBaseInfoId = baseItem.FID");
        if (isForFastFilter && isFromEas) {
            sql.append(" inner join ").append(mappingTalble).append(" easItem on baseItem.").append(mappingFiled).append(" = easItem.FID");
        }
        if (!StringUtils.isEmpty((String)param.getHrOrgUnitIds())) {
            String[] hrOrgIds = param.getHrOrgUnitIds().replace("\"", "").split(",");
            sb = new StringBuffer();
            sb.append("(");
            sb.append(DataValueTranslatorUtil.stringArray2String(hrOrgIds));
            sb.append(")");
            sql.append(" and relation.FHrOrgUseId in ").append(sb.toString());
        } else if (param.isPermItemRelationHR()) {
            Set hrOrgRangeIdSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)userId, (String)param.getPermItemId());
            if ("fffffff0-ffff-efff-e215-0000001dbd49PERMITEM".equals(param.getPermItemId()) && hrOrgRangeIdSet.isEmpty()) {
                hrOrgRangeIdSet.add("00000000-0000-0000-0000-000000000000CCE7AED4");
            }
            if (!param.isShowSealUpHrOrg()) {
                Set<String> hrOrgSealUpIdSet = SysSettingHrOrgUnitUtil.getSealUpHrOrg(ctx);
                SysSettingHrOrgUnitUtil.removeSealUpHrOrgId(hrOrgRangeIdSet, hrOrgSealUpIdSet);
            }
            String orgRange = DataValueTranslatorUtil.hashSet2String(hrOrgRangeIdSet);
            sql.append(" and relation.FHrOrgUseId in (").append(orgRange).append(") ");
        }
        if (!StringUtils.isEmpty((String)param.getRelationStates())) {
            String[] states = param.getRelationStates().split(",");
            sb = new StringBuffer();
            sb.append("(");
            sb.append(DataValueTranslatorUtil.stringArray2Number(states));
            sb.append(")");
            sql.append(" and relation.FState in ").append(sb.toString());
        }
        if (!StringUtils.isEmpty((String)param.getMoreFilter())) {
            sql.append(" and (").append(param.getMoreFilter()).append(") ");
        }
        return sql.toString();
    }

    public static void generateBaseItemToRelation(Context ctx, SHRBasicItemInfo info) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)info.getEntityName())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + ") EntityMetadata'name (entityName) is null! Not to upgrade usable relationship !"));
            return;
        }
        if (StringUtils.isEmpty((String)info.getRelationHREntity())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + ") EntityMetadata (" + info.getEntityName() + ") corresponding usable entity metadata name(relationHREntity) is null! Not to upgrade usable relationship !"));
            return;
        }
        EntityObjectInfo baseItemEntity = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, info.getEntityName());
        if (!SysSettingSHRBaseItemUtil.isSHRBaseItem(baseItemEntity.getBaseEntity())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + " ) EntityMetadata (" + info.getEntityName() + ") do not extends (" + "com.kingdee.shr.base.syssetting.app.SHRBaseItem" + ")! Not to upgrade usable relationship !"));
            return;
        }
        EntityObjectInfo baseItemRelationEntity = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, info.getRelationHREntity());
        if (!BaseItemRelationHRUtil.isSHRBaseItemRelationHR(baseItemRelationEntity.getBaseEntity())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + ") usable relationship entity metadata (" + info.getRelationHREntity() + ") do not extends (" + "com.kingdee.shr.base.syssetting.app.BaseItemRelationHR" + ")! Not to upgrade usable relationship ! "));
            return;
        }
        String baseItemTableName = baseItemEntity.getTable().getName();
        String baseItemRelationTableName = baseItemRelationEntity.getTable().getName();
        DbUtil.execute((Context)ctx, (String)BaseItemRelationHRUtil.getGloballyShareBatchGenerateSql(baseItemTableName, baseItemEntity.getType().toString(), baseItemRelationTableName, baseItemRelationEntity.getType().toString()));
        DbUtil.execute((Context)ctx, (String)BaseItemRelationHRUtil.getDownShareBatchGenerateSql(baseItemTableName, baseItemEntity.getType().toString(), baseItemRelationTableName, baseItemRelationEntity.getType().toString()));
        DbUtil.execute((Context)ctx, (String)BaseItemRelationHRUtil.getDistributeShareBatchGenerateSql(baseItemTableName, baseItemEntity.getType().toString(), baseItemRelationTableName, baseItemRelationEntity.getType().toString()));
    }

    public static void updateRelationEnableByHrOrgUnitId(Context ctx, SHRBasicItemInfo info, String hrOrgUnitId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)info.getEntityName())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + ") entity metadata name (entityName) is null! Not to upgrade usable relationship !"));
            return;
        }
        if (StringUtils.isEmpty((String)info.getRelationHREntity())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + ") entity metadata (" + info.getEntityName() + ") corresponding usable entity metadata name(relationHREntity) is null ! Not to upgrade usable relationship !"));
            return;
        }
        EntityObjectInfo baseItemEntity = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, info.getEntityName());
        if (!SysSettingSHRBaseItemUtil.isSHRBaseItem(baseItemEntity.getBaseEntity())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + " ) entity metadata (" + info.getEntityName() + ") do not extends (" + "com.kingdee.shr.base.syssetting.app.SHRBaseItem" + ")! Not to upgrade usable relationship !"));
            return;
        }
        EntityObjectInfo baseItemRelationEntity = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, info.getRelationHREntity());
        if (!BaseItemRelationHRUtil.isSHRBaseItemRelationHR(baseItemRelationEntity.getBaseEntity())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + ") usable relationship entity metadata (" + info.getRelationHREntity() + ") do not extends (" + "com.kingdee.shr.base.syssetting.app.BaseItemRelationHR" + ")!Not to upgrade usable relationship ! "));
            return;
        }
        String baseItemRelationTableName = baseItemRelationEntity.getTable().getName();
        StringBuffer s0 = new StringBuffer();
        s0.append("update ").append(baseItemRelationTableName).append(" set FSTATE  = ").append(100).append(" where FHRORGUSEID = '").append(hrOrgUnitId).append("' and FSTATE = ").append(200);
        DbUtil.execute((Context)ctx, (String)s0.toString());
    }

    public static void updateRelationDisableByHrOrgUnitId(Context ctx, SHRBasicItemInfo info, String hrOrgUnitId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)info.getEntityName())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + ") entity metadata name (entityName) is null! Not to upgrade usable relationship !"));
            return;
        }
        if (StringUtils.isEmpty((String)info.getRelationHREntity())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + ") entity metadata (" + info.getEntityName() + ") corresponding usable entity metadata name(relationHREntity) is null ! Not to upgrade usable relationship !"));
            return;
        }
        EntityObjectInfo baseItemEntity = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, info.getEntityName());
        if (!SysSettingSHRBaseItemUtil.isSHRBaseItem(baseItemEntity.getBaseEntity())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + " ) entity metadata (" + info.getEntityName() + ") do not extends (" + "com.kingdee.shr.base.syssetting.app.SHRBaseItem" + ")! Not to upgrade usable relationship !"));
            return;
        }
        EntityObjectInfo baseItemRelationEntity = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, info.getRelationHREntity());
        if (!BaseItemRelationHRUtil.isSHRBaseItemRelationHR(baseItemRelationEntity.getBaseEntity())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + ") usable relationship entity metadata (" + info.getRelationHREntity() + ") do not extends (" + "com.kingdee.shr.base.syssetting.app.BaseItemRelationHR" + ")!Not to upgrade usable relationship ! "));
            return;
        }
        String baseItemRelationTableName = baseItemRelationEntity.getTable().getName();
        StringBuffer s0 = new StringBuffer();
        s0.append("update ").append(baseItemRelationTableName).append(" set FSTATE  = ").append(200).append(" where FHRORGUSEID = '").append(hrOrgUnitId).append("' and FSTATE = ").append(100);
        DbUtil.execute((Context)ctx, (String)s0.toString());
    }

    public static void updateRelation(Context ctx, SHRBasicItemInfo info, BasicItemStateEnum state) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)info.getEntityName())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + ") entity metadata name (entityName) is null! Not to upgrade usable relationship !"));
            return;
        }
        if (StringUtils.isEmpty((String)info.getRelationHREntity())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + ") entity metadata (" + info.getEntityName() + ") corresponding usable entity metadata name(relationHREntity) is null ! Not to upgrade usable relationship !"));
            return;
        }
        EntityObjectInfo baseItemEntity = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, info.getEntityName());
        if (!SysSettingSHRBaseItemUtil.isSHRBaseItem(baseItemEntity.getBaseEntity())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + " ) entity metadata (" + info.getEntityName() + ") do not extends (" + "com.kingdee.shr.base.syssetting.app.SHRBaseItem" + ")! Not to upgrade usable relationship !"));
            return;
        }
        EntityObjectInfo baseItemRelationEntity = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, info.getRelationHREntity());
        if (!BaseItemRelationHRUtil.isSHRBaseItemRelationHR(baseItemRelationEntity.getBaseEntity())) {
            logger.error((Object)("BaseItemRelationHRUtil.generateBaseItemToRelation baseitem ( " + info.getName() + ") usable relationship entity metadata (" + info.getRelationHREntity() + ") do not extends (" + "com.kingdee.shr.base.syssetting.app.BaseItemRelationHR" + ")!Not to upgrade usable relationship ! "));
            return;
        }
        String baseItemRelationTableName = baseItemRelationEntity.getTable().getName();
        StringBuffer s0 = new StringBuffer();
        if (BasicItemStateEnum.ENABLE.equals((Object)state)) {
            s0.append("update ").append(baseItemRelationTableName).append(" set FSTATE  = ").append(100).append(" ,FLastUpdateUserID = '").append(ctx.getCaller().toString()).append("'").append(" ,FLastUpdateTime = now()").append(" where FSTATE = ").append(200);
        } else {
            s0.append("update ").append(baseItemRelationTableName).append(" set FSTATE  = ").append(200).append(" ,FLastUpdateUserID = '").append(ctx.getCaller().toString()).append("'").append(" ,FLastUpdateTime = now()").append(" where FSTATE = ").append(100);
        }
        DbUtil.execute((Context)ctx, (String)s0.toString());
    }

    private static String getGloballyShareBatchGenerateSql(String baseItemTableName, String baseItemBosType, String baseItemRelationTableName, String baseItemRelationBosType) {
        StringBuffer sb = new StringBuffer();
        sb.append(BaseItemRelationHRUtil.getBaseItemRelationHRInsertSql(baseItemRelationTableName));
        sb.append(" SELECT 0 FIsDefaultValue,baseItem.fid FBaseInfoId, hr.fid FHrOrgUseId, 1 FIsComUse,'0' FIndex,").append(100).append(" FState, ").append(100).append(" FChangeType,");
        sb.append(" '").append(baseItemBosType).append("' FBosTypeId,baseItem.FCreatorID FCreatorID,now() FCreateTime,baseItem.FLastUpdateUserID FLastUpdateUserID,now() FLastUpdateTime,baseItem.FControlUnitID FControlUnitID,");
        sb.append(" newbosid('").append(baseItemRelationBosType).append("') fid");
        sb.append(" FROM ").append(baseItemTableName).append(" baseItem ");
        sb.append(" inner join t_org_hro hr on 1=1 ");
        sb.append(" where baseItem.fstate = ").append(1).append(" and baseItem.fusepolicy = ").append(100).append(" and hr.FISSEALUP = 0");
        sb.append(" and not exists(SELECT 1 FROM ").append(baseItemRelationTableName).append(" relation where relation.FBaseInfoId = baseItem.fid and relation.FHrOrgUseId = hr.fid)");
        return sb.toString();
    }

    public static String getBaseItemRelationHRInsertSql(String baseItemRelationTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(baseItemRelationTableName);
        sb.append(" (FIsDefaultValue, FBaseInfoId, FHrOrgUseId, FIsComUse, FIndex, FState, FChangeType, FBosTypeId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FID)");
        return sb.toString();
    }

    private static String getDownShareBatchGenerateSql(String baseItemTableName, String baseItemBosType, String baseItemRelationTableName, String baseItemRelationBosType) {
        StringBuffer sb = new StringBuffer();
        sb.append(BaseItemRelationHRUtil.getBaseItemRelationHRInsertSql(baseItemRelationTableName));
        sb.append(" SELECT 0 FIsDefaultValue,baseItem.fid FBaseInfoId, hr.fid FHrOrgUseId, 1 FIsComUse,'0' FIndex,").append(100).append(" FState, ").append(100).append(" FChangeType,");
        sb.append(" '").append(baseItemBosType).append("' FBosTypeId,baseItem.FCreatorID FCreatorID,now() FCreateTime,baseItem.FLastUpdateUserID FLastUpdateUserID,now() FLastUpdateTime,baseItem.FControlUnitID FControlUnitID,");
        sb.append(" newbosid('").append(baseItemRelationBosType).append("') fid");
        sb.append(" FROM ").append(baseItemTableName).append(" baseItem ");
        sb.append(" inner join t_org_hro hr on 1=1 ");
        sb.append(" where baseItem.fstate = ").append(1).append(" and baseItem.fusepolicy = ").append(200).append(" and hr.FISSEALUP = 0");
        sb.append(" and not exists(SELECT 1 FROM ").append(baseItemRelationTableName).append(" relation where relation.FBaseInfoId = baseItem.fid and relation.FHrOrgUseId = hr.fid)");
        sb.append(" and hr.flongNumber like (SELECT hr1.flongNumber||'%' FROM t_org_hro hr1 where hr1.fid = baseItem.fhrorgunitid and hr1.FISSEALUP = 0)");
        return sb.toString();
    }

    private static String getDistributeShareBatchGenerateSql(String baseItemTableName, String baseItemBosType, String baseItemRelationTableName, String baseItemRelationBosType) {
        StringBuffer sb = new StringBuffer();
        sb.append(BaseItemRelationHRUtil.getBaseItemRelationHRInsertSql(baseItemRelationTableName));
        sb.append(" SELECT 0 FIsDefaultValue,baseItem.fid FBaseInfoId, hr.fid FHrOrgUseId, 1 FIsComUse,'0' FIndex, ").append(100).append(" FState, ").append(100).append(" FChangeType,");
        sb.append(" '").append(baseItemBosType).append("' FBosTypeId,baseItem.FCreatorID FCreatorID,now() FCreateTime,baseItem.FLastUpdateUserID FLastUpdateUserID,now() FLastUpdateTime,baseItem.FControlUnitID FControlUnitID,");
        sb.append(" newbosid('").append(baseItemRelationBosType).append("') fid");
        sb.append(" FROM ").append(baseItemTableName).append(" baseItem ");
        sb.append(" inner join t_org_hro hr on baseItem.fhrorgunitid=hr.fid ");
        sb.append(" where baseItem.fstate = ").append(1).append(" and baseItem.fusepolicy = ").append(300).append(" and hr.FISSEALUP = 0");
        sb.append(" and not exists(SELECT 1 FROM ").append(baseItemRelationTableName).append(" relation where relation.FBaseInfoId = baseItem.fid and relation.FHrOrgUseId = hr.fid)");
        return sb.toString();
    }
}

