/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util.custom;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.DynamicStateManager;
import com.kingdee.bos.dao.xml.impl.IProxyStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.ExtendedTableCollection;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.ep.util.EPUtils;
import com.kingdee.shr.base.syssetting.util.custom.SHRUictColumnInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class SHRUictUtils {
    private static Logger logger = Logger.getLogger((String)SHRUictUtils.class.getName());
    public static final String strNull = "null";
    public static final String empty = "";

    public static IBriefViewTreeNode getBaseDataNode(IBriefViewTreeNode root) {
        SHRUictUtils.removeNotBaseDataNode(root);
        return root;
    }

    private static void removeNotBaseDataNode(IBriefViewTreeNode node) {
        IBriefViewTreeNode child = null;
        if (node.getChildCount() > 0) {
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                child = (IBriefViewTreeNode)node.getChildAt(i);
                SHRUictUtils.removeNotBaseDataNode(child);
                if (child.getChildCount() != 0) continue;
                if (child.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
                    node.remove((MutableTreeNode)child);
                    continue;
                }
                MetaDataBriefInfo mdInfo = child.getMetaDataObjectBriefInfo();
                BizUnitInfo info = SHRUictUtils.loadBizUnit(mdInfo.getMetaDataPK());
                if (info == null || "BaseData".equalsIgnoreCase(info.getBizType().getName())) continue;
                node.remove((MutableTreeNode)child);
            }
        }
    }

    public static BizUnitInfo loadBizUnit(IMetaDataPK pk) {
        BizUnitInfo bizUnit = null;
        if (pk != null) {
            try {
                BizUnitInfo biz = (BizUnitInfo)SHRUictUtils.loadMD(MetaDataTypeList.BIZUNIT, pk);
                return biz;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return bizUnit;
    }

    public static BizUnitInfo loadBizUnit(IMetaDataPK pk, Project depend) {
        BizUnitInfo bizUnit = null;
        if (pk != null) {
            try {
                BizUnitInfo biz = (BizUnitInfo)SHRUictUtils.loadMD(MetaDataTypeList.BIZUNIT, pk, depend);
                return biz;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return bizUnit;
    }

    public static EntityObjectInfo loadEntity(IMetaDataPK pk, Project depend) {
        EntityObjectInfo entity = (EntityObjectInfo)SHRUictUtils.loadMD(MetaDataTypeList.ENTITY, pk, depend);
        return entity;
    }

    public static BizEnumInfo loadBizEnum(IMetaDataPK pk, Project depend) {
        BizEnumInfo bizEnum = (BizEnumInfo)SHRUictUtils.loadMD(MetaDataTypeList.BIZENUM, pk, depend);
        return bizEnum;
    }

    public static FunctionObjectInfo loadFunction(IMetaDataPK pk, Project depend) {
        FunctionObjectInfo fun = (FunctionObjectInfo)SHRUictUtils.loadMD(MetaDataTypeList.FUNCTION, pk, depend);
        return fun;
    }

    public static QueryInfo loadQuery(IMetaDataPK pk, Project depend) {
        QueryInfo query = (QueryInfo)SHRUictUtils.loadMD(MetaDataTypeList.BASEQUERY, pk, depend);
        SHRUictUtils.checkQuery(query);
        return query;
    }

    private static void checkQuery(QueryInfo query) {
        if (query instanceof JoinQueryInfo) {
            int i;
            JoinQueryInfo queryInfo = (JoinQueryInfo)query;
            JoinCollection joins = queryInfo.getJoins();
            SubObjectCollection subObjs = queryInfo.getSubObjects();
            HashMap rightMap = new HashMap();
            HashMap leftMap = new HashMap();
            if (joins.size() <= 1) {
                return;
            }
            for (i = 0; i < joins.size(); ++i) {
                JoinInfo join = joins.get(i);
                if (join != null && join.getLeftObject() != null) {
                    rightMap.put(join.getLeftObject().getName().toLowerCase(), null);
                }
                if (join == null || join.getRightObject() == null) continue;
                rightMap.put(join.getRightObject().getName().toLowerCase(), null);
            }
            for (i = 0; i < subObjs.size(); ++i) {
                SubObjectInfo sub = subObjs.get(i);
                if (leftMap.containsKey(sub.getName().toLowerCase()) || rightMap.containsKey(sub.getName().toLowerCase())) continue;
                subObjs.remove(sub);
            }
        }
    }

    public static UIObjectInfo loadUI(IMetaDataPK pk, Project depend) {
        UIObjectInfo ui = (UIObjectInfo)SHRUictUtils.loadMD(MetaDataTypeList.UIOBJECT, pk, depend);
        return ui;
    }

    public static WebUIObjectInfo loadWebUI(IMetaDataPK pk, Project depend) {
        WebUIObjectInfo ui = (WebUIObjectInfo)SHRUictUtils.loadMD(MetaDataTypeList.WEBUIOBJECT, pk, depend);
        return ui;
    }

    public static FacadeInfo loadFacade(IMetaDataPK pk, Project depend) {
        FacadeInfo fi = (FacadeInfo)SHRUictUtils.loadMD(MetaDataTypeList.FACADE, pk, depend);
        return fi;
    }

    public static PermissionInfo loadPermission(IMetaDataPK pk, Project depend) {
        PermissionInfo pi = (PermissionInfo)SHRUictUtils.loadMD(MetaDataTypeList.PERMISSION, pk, depend);
        return pi;
    }

    public static IObjectValue loadMD(BOSObjectType type, IMetaDataPK pk, Project depend) {
        MetadataUtils.clearCache((BOSObjectType)type);
        return MetadataUtils.loadMD((BOSObjectType)type, (IMetaDataPK)pk, (Project)depend);
    }

    public static EntityObjectInfo loadEntity(IMetaDataPK pk) {
        EntityObjectInfo entity = (EntityObjectInfo)SHRUictUtils.loadMD(MetaDataTypeList.ENTITY, pk);
        return entity;
    }

    public static BizEnumInfo loadBizEnum(IMetaDataPK pk) {
        BizEnumInfo bizEnum = (BizEnumInfo)SHRUictUtils.loadMD(MetaDataTypeList.BIZENUM, pk);
        return bizEnum;
    }

    public static FunctionObjectInfo loadFunction(IMetaDataPK pk) {
        FunctionObjectInfo fun = (FunctionObjectInfo)SHRUictUtils.loadMD(MetaDataTypeList.FUNCTION, pk);
        return fun;
    }

    public static QueryInfo loadQuery(IMetaDataPK pk) {
        QueryInfo query = (QueryInfo)SHRUictUtils.loadMD(MetaDataTypeList.BASEQUERY, pk);
        return query;
    }

    public static UIObjectInfo loadUI(IMetaDataPK pk) {
        UIObjectInfo ui = (UIObjectInfo)SHRUictUtils.loadMD(MetaDataTypeList.UIOBJECT, pk);
        return ui;
    }

    public static WebUIObjectInfo loadWebUI(IMetaDataPK pk) {
        WebUIObjectInfo ui = (WebUIObjectInfo)SHRUictUtils.loadMD(MetaDataTypeList.WEBUIOBJECT, pk);
        return ui;
    }

    public static FacadeInfo loadFacade(IMetaDataPK pk) {
        FacadeInfo fi = (FacadeInfo)SHRUictUtils.loadMD(MetaDataTypeList.FACADE, pk);
        return fi;
    }

    public static PermissionInfo loadPermission(IMetaDataPK pk) {
        PermissionInfo pi = (PermissionInfo)SHRUictUtils.loadMD(MetaDataTypeList.PERMISSION, pk);
        return pi;
    }

    public static IObjectValue loadMD(BOSObjectType type, IMetaDataPK pk) {
        MetadataUtils.clearCache((BOSObjectType)type);
        return MetadataUtils.loadMD((BOSObjectType)type, (IMetaDataPK)pk);
    }

    public static EntityObjectInfo loadMD(Context ctx, BOSObjectType type) {
        if (type != null) {
            try {
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                return loader.loadMetameta(type);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    private static void befroeSave(AbstractMetaDataValue metadata) {
        if (metadata instanceof UIObjectInfo) {
            ComponentCollection toolBars = ((UIObjectInfo)metadata).getToolbarsPanel().getComponents();
            for (int i = 0; i < toolBars.size(); ++i) {
                ComponentInfo toolBar = toolBars.get(i);
                toolBar.setParent(null);
            }
        }
    }

    private static void befroeSave(AbstractMetaDataValue[] metadata) {
        for (int i = 0; i < metadata.length; ++i) {
            SHRUictUtils.befroeSave(metadata[i]);
        }
    }

    public static void saveMetadata(Context ctx, AbstractMetaDataValue metadata, String customizedSchemeID, Project depend) throws Exception {
        SHRUictUtils.befroeSave(metadata);
        IMetadataStore mdstore = MetadataStoreFactory.getMetadataStore((Context)ctx);
        Project[] projects = new Project[]{};
        if (depend != null && depend.getDepend() != null && depend.getDepend().size() != 0) {
            projects = new Project[depend.getDepend().size()];
            projects = depend.getDepend().toArray(projects);
        }
        mdstore.saveMetadata(metadata, customizedSchemeID, projects);
    }

    public static void deleteMetadata(Context ctx, Project depend, IMetaDataPK pk, BOSObjectType type) {
        IMetadataStore mdstore = MetadataStoreFactory.getMetadataStore((Context)ctx);
        try {
            mdstore.deleteMetadata(depend, pk, type);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static String getXml(Context ctx, Project depend, IMetaDataPK pk, BOSObjectType type) {
        IMetadataStore mdstore = MetadataStoreFactory.getMetadataStore((Context)ctx);
        String xml = empty;
        try {
            xml = mdstore.getXml(depend, pk, type);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return xml;
    }

    public static void saveMetadata(Context ctx, AbstractMetaDataValue[] mds, String customizedSchemeID, Project depend) throws Exception {
        SHRUictUtils.befroeSave(mds);
        IMetadataStore mdstore = MetadataStoreFactory.getMetadataStore((Context)ctx);
        Project[] projects = new Project[]{};
        if (depend != null && depend.getDepend() != null && depend.getDepend().size() != 0) {
            projects = new Project[depend.getDepend().size()];
            projects = depend.getDepend().toArray(projects);
        }
        mdstore.saveMetadata(mds, customizedSchemeID, projects);
    }

    public static List getConfigureColumnCollection(DataTableInfo table) {
        ColumnInfo column;
        if (table == null) {
            logger.warn((Object)"DataTableInfo is null,can not get the ColumnCollection");
            return null;
        }
        ArrayList<SHRUictColumnInfo> configure = new ArrayList<SHRUictColumnInfo>();
        ColumnCollection col = table.getColumns();
        int num = 0;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            column = col.get(i);
            if (!column.isConfigured()) continue;
            configure.add(new SHRUictColumnInfo(column, false));
            ++num;
        }
        logger.info((Object)("This table has been reserved " + num + " fields"));
        ExtendedTableInfo extTable = SHRUictUtils.getConfigureExtendedTable(table);
        if (extTable != null) {
            col = extTable.getColumns();
            num = 0;
            int size2 = col.size();
            for (int j = 0; j < size2; ++j) {
                column = col.get(j);
                if (!column.isConfigured()) continue;
                configure.add(new SHRUictColumnInfo(column, true));
                ++num;
            }
            logger.info((Object)("This extended table has reserved " + num + " fields"));
        }
        return configure;
    }

    public static ExtendedTableInfo getConfigureExtendedTable(DataTableInfo table) {
        if (table == null) {
            logger.warn((Object)"DataTableInfo is null");
            return null;
        }
        ExtendedTableCollection tableCol = table.getExtendedTables();
        ExtendedTableInfo extTable = null;
        int size = tableCol.size();
        for (int i = 0; i < size; ++i) {
            extTable = tableCol.get(i);
            String isConfigure = extTable.getExtendedProperty("isConfigureExtendedTable");
            if (!"true".equals(isConfigure)) continue;
            return extTable;
        }
        logger.info((Object)"no extended table that reserved fields found");
        return null;
    }

    public static List getCanUseColumnCollection(EntityObjectInfo entity, BizDataTypeEnum type) {
        if (entity == null) {
            logger.warn((Object)"EntityObjectInfo is null,can not get the ColumnCollection");
            return null;
        }
        List col = SHRUictUtils.getConfigureColumnCollection(entity.getTable());
        if (col == null) {
            return null;
        }
        return SHRUictUtils.getCanUseColumnCollection(entity, col, type);
    }

    public static List getCanUseColumnCollection(EntityObjectInfo entity, List col, BizDataTypeEnum type) {
        if (entity == null || col == null) {
            logger.warn((Object)"EntityObjectInfo or ColumnCollection is null,can not get the ColumnCollection");
            return null;
        }
        ArrayList<SHRUictColumnInfo> canUse = new ArrayList<SHRUictColumnInfo>();
        PropertyCollection pCol = entity.getProperties();
        boolean isUse = false;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            SHRUictColumnInfo uci = (SHRUictColumnInfo)col.get(i);
            isUse = false;
            int size2 = pCol.size();
            for (int j = 0; j < size2; ++j) {
                com.kingdee.bos.metadata.entity.PropertyInfo pInfo = pCol.get(j);
                if (("F" + StringUtils.headCharUpperCase((String)pInfo.getName())).equalsIgnoreCase(uci.getColumn().getName())) {
                    isUse = true;
                    break;
                }
                if (!("CF" + StringUtils.headCharUpperCase((String)pInfo.getName())).equalsIgnoreCase(uci.getColumn().getName())) continue;
                isUse = true;
                break;
            }
            if (isUse || !SHRUictUtils.isCorrectType(uci.getColumn(), type)) continue;
            canUse.add(uci);
        }
        return canUse;
    }

    private static boolean isCorrectType(ColumnInfo column, BizDataTypeEnum type) {
        if (column == null) {
            return false;
        }
        if (type == null) {
            return true;
        }
        if (BizDataTypeEnum.STRING.equals((Object)type) || BizDataTypeEnum.NOTE.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.NVARCHAR);
        }
        if (BizDataTypeEnum.INTEGER.equals((Object)type) || BizDataTypeEnum.BOOLEAN.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.INT);
        }
        if (BizDataTypeEnum.DECIMAL.equals((Object)type) || BizDataTypeEnum.AMOUNT.equals((Object)type) || BizDataTypeEnum.PRICE.equals((Object)type) || BizDataTypeEnum.QUANTITY.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.NUMERIC);
        }
        if (BizDataTypeEnum.DATE.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.DATETIME);
        }
        if (BizDataTypeEnum.OBJECT.equals((Object)type) || BizDataTypeEnum.ENUM.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.VARCHAR);
        }
        return false;
    }

    public static String delFirstF(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        if (str.indexOf("F") == 0 && str.length() > 1) {
            return str.substring(1, str.length());
        }
        if (str.indexOf("CF") == 0 && str.length() > 2) {
            return str.substring(2, str.length());
        }
        return null;
    }

    public static final String getObjectString(Object obj) {
        if (obj == null) {
            return empty;
        }
        String str = String.valueOf(obj).trim();
        if (str.equals(strNull) || str.length() == 0) {
            str = empty;
        }
        return str;
    }

    public static final HashMap getEaslocaleFromKDMultiLangBox(KDMultiLangBox mlb) {
        HashMap<String, String> ps = new HashMap<String, String>();
        int z = mlb.getItemCount();
        for (int i = 0; i < z; ++i) {
            MultiLangItem mli = (MultiLangItem)mlb.getItemAt(i);
            String key = LangUtil.makeLang((Locale)mli.getLang().getLocale());
            String val = (String)mli.getData();
            ps.put(key, val);
        }
        return ps;
    }

    public static boolean isEmptyMD(AbstractMDValue amd) {
        if (amd == null) {
            return true;
        }
        IStateManager sm = amd.getStateManager();
        if (sm == null) {
            return true;
        }
        if (sm instanceof IProxyStateManager) {
            sm = ((IProxyStateManager)sm).getNoProxyDelegate();
        }
        return sm instanceof DynamicStateManager && ((DynamicStateManager)sm).isNull();
    }

    public static void updateProject() throws BOSException {
        try {
            EPUtils.clearCache();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getAlias(ComponentInfo roundInfo) {
        if (SHRUictUtils.isIgnore(roundInfo)) {
            return roundInfo.getName();
        }
        PropertyInfo property = null;
        String alias = null;
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(roundInfo.getClassType())) {
            alias = StringUtils.isEmpty((String)roundInfo.getAlias()) ? roundInfo.getName() : roundInfo.getAlias();
        } else if ("com.kingdee.bos.ctrl.swing.KDLabel".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDWorkButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDRadioButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDCheckBox".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDMenu".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDMenuItem".equals(roundInfo.getClassType())) {
            property = roundInfo.getPropertyByName("text");
        } else if ("com.kingdee.bos.ctrl.swing.KDContainer".equals(roundInfo.getClassType())) {
            property = roundInfo.getPropertyByName("title");
        } else if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(roundInfo.getClassType())) {
            property = roundInfo.getPropertyByName("boundLabelText");
        } else {
            if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTextField".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDFormattedTextField".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDComboBox".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDDatePicker".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea".equals(roundInfo.getClassType())) {
                ComponentInfo parent = roundInfo.getParent();
                return SHRUictUtils.getAlias(parent);
            }
            property = "com.kingdee.bos.ctrl.web.LabelContainer".equals(roundInfo.getClassType()) ? roundInfo.getPropertyByName("caption") : roundInfo.getPropertyByName("text");
        }
        if (property != null) {
            alias = property.getValue();
        }
        if (alias == null) {
            alias = roundInfo.getName();
        }
        return alias;
    }

    private static boolean isIgnore(ComponentInfo component) {
        if (component != null) {
            if (("com.kingdee.bos.ctrl.swing.KDTextArea".equalsIgnoreCase(component.getClassType()) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea".equalsIgnoreCase(component.getClassType())) && component.getParent() != null && "com.kingdee.bos.ctrl.swing.KDScrollPane".equalsIgnoreCase(component.getParent().getClassType())) {
                return true;
            }
            if (component.getParent() != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(component.getParent().getClassType())) {
                return false;
            }
        }
        return false;
    }
}

