/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util.custom;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfo;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfoConverter;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.util.custom.SHRCopyCreator;
import com.kingdee.util.StringUtils;

public class SHRUnitNodeCreator {
    private SHRCopyCreator copyCreator = null;
    private CustomizedUnitNodeInfo unitNode = null;
    private CustomizedUnitInfo parent = null;
    private CustomizedUnitInfo unitInfo = null;
    private String templateNumber;
    private Context ctx = null;

    public SHRUnitNodeCreator(Context ctx, SHRCopyCreator copyCreator, CustomizedUnitInfo unitInfo, CustomizedUnitInfo parent) {
        this.copyCreator = copyCreator;
        this.unitInfo = unitInfo;
        this.parent = parent;
        if (unitInfo != null) {
            this.unitNode = CustomizedUnitNodeInfoConverter.converter2Object((String)unitInfo.getCustomizedUnitObject());
        }
        this.ctx = ctx;
    }

    public CustomizedUnitNodeInfo create() throws Exception {
        if (this.copyCreator == null) {
            return this.unitNode;
        }
        BizUnitInfo bizUnit = this.copyCreator.getCreatedBizUnit();
        if (this.unitNode == null && bizUnit != null) {
            this.unitNode = new CustomizedUnitNodeInfo();
            this.unitNode.setPackagePK(bizUnit.getPackage());
            this.unitNode.setName(bizUnit.getName());
            this.unitNode.setAlias(bizUnit.getAlias());
            this.unitNode.setCustomizedType("bizunit");
            this.unitNode.setType("2");
            this.unitNode.setUiType(String.valueOf(this.copyCreator.getTemplateInfo().getUiType()));
            this.unitNode.setTemplateNumber(this.templateNumber);
        } else if (this.unitNode == null) {
            return this.unitNode;
        }
        this.buildNodeContent();
        String xml = CustomizedUnitNodeInfoConverter.coverter2xml((CustomizedUnitNodeInfo)this.unitNode);
        ICustomizedUnit bizInterface = CustomizedUnitFactory.getLocalInstance((Context)this.ctx);
        if (this.unitInfo != null) {
            this.unitInfo.setCustomizedUnitObject(xml);
            ObjectUuidPK cpk = new ObjectUuidPK(this.unitInfo.getId());
            bizInterface.update((IObjectPK)cpk, (CoreBaseInfo)this.unitInfo);
        } else {
            CustomizedUnitInfo dataObj = new CustomizedUnitInfo();
            dataObj.setId(BOSUuid.create((BOSObjectType)dataObj.getBOSType()));
            dataObj.setNumber(dataObj.getId().toString());
            dataObj.setName(this.unitNode.getName());
            dataObj.setDisplayName(StringUtils.isEmpty((String)this.unitNode.getAlias()) ? this.unitNode.getName() : this.unitNode.getAlias());
            dataObj.setNodeType(NodeTypeEnum.CUSTOMIZED_UNIT);
            dataObj.setCustomizedUnitObject(xml);
            dataObj.setIsLeaf(true);
            dataObj.setLevel(this.parent.getLevel() + 1);
            dataObj.setParent(this.parent);
            dataObj.setCustomizedSchemeID(this.copyCreator.getCustomizedSchemedID());
            bizInterface.addnew((CoreBaseInfo)dataObj);
        }
        return this.unitNode;
    }

    private void buildNodeContent() {
        AbstractMetaDataValue[] mds = this.copyCreator.getCreatedMetaDatas();
        CustomizedUnitNodeInfo.MetaDataInfo md = null;
        for (int i = 0; i < mds.length; ++i) {
            md = new CustomizedUnitNodeInfo.MetaDataInfo(mds[i].getRealPackage(), mds[i].getRealName(), mds[i].getAlias());
            if (mds[i] instanceof EntityObjectInfo) {
                this.unitNode.getEntity().add(md);
                continue;
            }
            if (mds[i] instanceof JoinQueryInfo) {
                this.unitNode.getQuery().add(md);
                continue;
            }
            if (mds[i] instanceof UIObjectInfo) {
                if (this.isInheritedFromClass((UIObjectInfo)mds[i], "com.kingdee.eas.framework.client.ListUI")) {
                    this.unitNode.getUi().getListui().add(md);
                    continue;
                }
                if (this.isInheritedFromClass((UIObjectInfo)mds[i], "com.kingdee.eas.framework.client.EditUI")) {
                    this.unitNode.getUi().getEditui().add(md);
                    if (((UIObjectInfo)mds[i]).getRuleSet() == null) continue;
                    RuleSetInfo ruleSet = ((UIObjectInfo)mds[i]).getRuleSet();
                    md = new CustomizedUnitNodeInfo.MetaDataInfo(ruleSet.getRealPackage(), ruleSet.getRealName(), ruleSet.getAlias());
                    this.unitNode.getRuleSet().add(md);
                    continue;
                }
                if (!this.isInheritedFromClass((UIObjectInfo)mds[i], "com.kingdee.eas.framework.client.CoreUI")) continue;
                this.unitNode.getUi().getOtherui().add(md);
                continue;
            }
            if (mds[i] instanceof WebUIObjectInfo) {
                if (this.isInheritedFromFullName((WebUIObjectInfo)mds[i], "com.kingdee.eas.framework.web.ListUI")) {
                    this.unitNode.getWebUi().getListui().add(md);
                    continue;
                }
                if (!this.isInheritedFromFullName((WebUIObjectInfo)mds[i], "com.kingdee.eas.framework.web.EditUI")) continue;
                this.unitNode.getWebUi().getEditui().add(md);
                continue;
            }
            if (!(mds[i] instanceof FunctionObjectInfo)) continue;
            this.unitNode.getFunction().add(md);
        }
    }

    private boolean isInheritedFromClass(UIObjectInfo ui, String className) {
        for (UIObjectInfo tmp = ui; tmp != null; tmp = tmp.getParent()) {
            if (!className.equals(tmp.getFullName())) continue;
            return true;
        }
        return false;
    }

    private boolean isInheritedFromFullName(WebUIObjectInfo ui, String fullname) {
        for (WebUIObjectInfo tmp = ui; tmp != null; tmp = tmp.getParent()) {
            if (!fullname.equals(tmp.getRealFullName())) continue;
            return true;
        }
        return false;
    }

    public String getTemplateNumber() {
        return this.templateNumber;
    }

    public void setTemplateNumber(String templateNumber) {
        this.templateNumber = templateNumber;
    }
}

