/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.osf.parsing;

import com.kingdee.bos.util.XMLParser;
import com.kingdee.shr.osf.parsing.ConfigurationParseException;
import com.kingdee.shr.osf.parsing.ParserContext;
import com.kingdee.shr.osf.parsing.ResourceNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class XmlFileReader {
    private static Logger logger = Logger.getLogger(XmlFileReader.class);

    public Element read(ParserContext parserContext) throws ConfigurationParseException {
        Element root = null;
        String resource = parserContext.getAbsoluteResourceLocation();
        InputStream is = null;
        try {
            is = this.readFile(parserContext, parserContext.isClassPath());
            if (is == null) {
                throw new ResourceNotFoundException("failed to read source file : " + resource);
            }
            root = XMLParser.parseXML((InputStream)is).getRootElement();
        }
        catch (JDOMException e) {
            throw new ConfigurationParseException(e);
        }
        catch (IOException e) {
            throw new ConfigurationParseException(e);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return root;
    }

    private InputStream readFile(ParserContext parserContext, boolean isClassPath) {
        String resource = parserContext.getAbsoluteResourceLocation();
        try {
            if (!isClassPath) {
                return new FileInputStream(resource);
            }
            return this.getClassLoader(parserContext).getResourceAsStream(resource);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException("resource file not found : " + resource);
        }
    }

    private ClassLoader getClassLoader(ParserContext parserContext) {
        if (parserContext.getResourceClassLoader() != null) {
            return parserContext.getResourceClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    public Element read(String xmlString) {
        InputStream is = this.getInputStreamFromString(xmlString);
        try {
            return XMLParser.parseXML((InputStream)is).getRootElement();
        }
        catch (JDOMException e) {
            throw new ConfigurationParseException(e);
        }
        catch (IOException e) {
            throw new ConfigurationParseException(e);
        }
    }

    private InputStream getInputStreamFromString(String str) {
        return new ByteArrayInputStream(str.getBytes());
    }
}

