/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.message.common;

import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.message.common.config.CommonConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class KDDiskAttachment
extends KDMessageAttachment {
    private String filePath;

    public KDDiskAttachment(String filePath) {
        int index;
        this.filePath = filePath;
        File file = new File(filePath);
        if (file.exists()) {
            this.size = (int)file.length();
        }
        if ((index = filePath.lastIndexOf(File.separatorChar)) != -1 && index < filePath.length() - 1) {
            this.name = filePath.substring(index + 1);
        }
    }

    public static KDMessageAttachment getAttachment(String fileName, String msgId) {
        String filePath = CommonConfig.DEFAULT_DIR + msgId + "-" + fileName;
        KDDiskAttachment attachment = new KDDiskAttachment(filePath);
        ((KDMessageAttachment)attachment).setName(fileName);
        return attachment;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        File file = new File(this.filePath);
        return (int)file.length();
    }

    public void setSize(int size) {
        this.size = size;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) throws IOException {
        if (data == null) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(this.filePath);
        fos.write(data);
        fos.flush();
        fos.close();
        this.size = data.length;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void destroy() {
        File tempFile = new File(this.filePath);
        if (tempFile.exists()) {
            tempFile.delete();
        }
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.filePath);
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.filePath);
    }
}

