/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IMultiOrgsClientCache;
import com.kingdee.eas.basedata.org.MultiOrgsClientCacheImplUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.LowTimer;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;

public class MultiOrgsClientCacheImpl
implements IMultiOrgsClientCache {
    private String ouId;
    private String orgCacheDir;
    private HashMap orgCacheFiles;

    @Override
    public void setOrgUnitID(String ouId) throws Exception {
        this.ouId = ouId;
        this.orgCacheDir = MultiOrgsClientCacheImplUtil.getOrgCacheDir(ouId);
        this.orgCacheFiles = new HashMap();
        List orgTypeList = OrgType.getEnumList();
        for (int i = 0; i < orgTypeList.size(); ++i) {
            OrgType curOrgType = (OrgType)((Object)orgTypeList.get(i));
            this.orgCacheFiles.put(curOrgType.getValue() + "", MultiOrgsClientCacheImplUtil.getOrgCacheFile(this.orgCacheDir, curOrgType));
        }
    }

    @Override
    public boolean isMultiOrgsExisted() throws Exception {
        return MultiOrgsClientCacheImplUtil.isFileObjExistedByPathStr(this.orgCacheDir);
    }

    @Override
    public void storeMultiOrgs(HashMap map) throws Exception {
        LowTimer lt = new LowTimer();
        MultiOrgsClientCacheImplUtil.makeDirByPathStr(this.orgCacheDir);
        List orgTypeList = OrgType.getEnumList();
        for (int i = 0; i < orgTypeList.size(); ++i) {
            OrgType curOrgType = (OrgType)((Object)orgTypeList.get(i));
            OrgUnitInfo curOrg = (OrgUnitInfo)map.get((Object)curOrgType);
            this.storeAnOrg(curOrg, curOrgType);
        }
        FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)map.get("CurOU");
        this.storeAnOrg(ouInfo, OrgType.NONE);
        SysUtil.logTimeCost((String)"[SERIALIZING MULTI-ORGS] ", (LowTimer)lt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeAnOrg(OrgUnitInfo unitInfo, OrgType orgType) throws Exception {
        String orgCacheFile = this.orgCacheFiles.get(orgType.getValue() + "").toString();
        ObjectOutputStream oos = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(orgCacheFile);
            oos = new ObjectOutputStream(fileOutputStream);
            oos.writeObject(unitInfo);
        }
        finally {
            if (oos != null) {
                oos.flush();
                oos.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    @Override
    public void loadMultiOrgs() throws Exception {
        LowTimer lt = new LowTimer();
        List orgTypeList = OrgType.getEnumList();
        HashMap<Object, OrgUnitInfo> map = new HashMap<Object, OrgUnitInfo>();
        for (int i = 0; i < orgTypeList.size(); ++i) {
            OrgType curOrgType = (OrgType)((Object)orgTypeList.get(i));
            OrgUnitInfo curOrg = (OrgUnitInfo)this.loadAnOrg(curOrgType);
            SysContext.getSysContext().setCurrentOrgUnit(curOrgType, curOrg);
            map.put((Object)curOrgType, curOrg);
        }
        FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)this.loadAnOrg(OrgType.NONE);
        ObjectUuidPK pk = new ObjectUuidPK(ouInfo.getId().toString());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)pk, sic);
        if (unitInfo.getLastUpdateTime().compareTo(ouInfo.getLastUpdateTime()) > 0) {
            throw new Exception("The cached OrgUnit have been updated, so should be deprecated!");
        }
        OrgUnitInfo fiInfo = (OrgUnitInfo)this.loadAnOrg(OrgType.Company);
        if (fiInfo != null) {
            SysContext.getSysContext().setProperty((Object)"CompanyInfo", (Object)fiInfo);
            SysContext.getSysContext().setProperty((Object)"CurCompanyId", (Object)fiInfo.getId().toString());
        }
        map.put("CompanyInfo", fiInfo);
        map.put("CurOU", ouInfo);
        ContextManagerFactory.getRemoteInstance().setContext(map);
        SysUtil.logTimeCost((String)"[UNSERIALIZING MULTI-ORGS] ", (LowTimer)lt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadAnOrg(OrgType orgType) throws Exception {
        String orgCacheFile = this.orgCacheFiles.get(orgType.getValue() + "").toString();
        try (ObjectInputStream ois = null;){
            ois = new ObjectInputStream(new FileInputStream(orgCacheFile));
            Object object = ois.readObject();
            return object;
        }
    }

    @Override
    public void clearMultiOrgs() throws Exception {
        MultiOrgsClientCacheImplUtil.dropDirByPathStr(this.orgCacheDir);
    }
}

